/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import jsbugs.DialogList;
import jsbugs.DialogVersionHeader;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.InterpHdr;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.exception.StackError;

public class DialogSelectVersion
extends JDialog {
    private final SBdb db;
    DefaultListModel model = new DefaultListModel();
    List<InterpHdr> selection = null;
    List<Well> project = null;
    private ButtonGroup buttonGroupVersion;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonShowWells;
    private JList jListVersion;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonAll;
    private JRadioButton jRadioButtonWells;
    private JScrollPane jScrollPane1;

    public DialogSelectVersion(Frame parent, boolean modal, SBdb db, boolean singleSelection, Iterator<Well> wellIterator) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.project = new LinkedList<Well>();
        while (wellIterator.hasNext()) {
            this.project.add(wellIterator.next());
        }
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.init(singleSelection);
    }

    public DialogSelectVersion(Dialog parent, boolean modal, SBdb db, List<Well> wells) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.project = wells;
        this.initComponents();
        this.init(true);
    }

    public DialogSelectVersion(Frame parent, boolean modal, SBdb db, List<Well> wells) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.project = wells;
        this.initComponents();
        this.init(true);
    }

    private void init(boolean singleSelection) throws SQLException {
        if (this.project != null && this.project.size() > 0) {
            this.jRadioButtonWells.setSelected(true);
        } else {
            this.jRadioButtonWells.setEnabled(false);
            this.jRadioButtonAll.setSelected(true);
        }
        this.loadList();
        if (singleSelection) {
            this.jListVersion.setSelectionMode(0);
        }
        this.setTitle("Version : Select");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        InterpHdr.setDisplayDefault(true);
    }

    private void loadList() throws SQLException {
        this.model.clear();
        if (this.jRadioButtonAll.isSelected()) {
            List<InterpHdr> interps = this.db.getInterps();
            Iterator<InterpHdr> iterator = interps.iterator();
            while (iterator.hasNext()) {
                InterpHdr o;
                InterpHdr interp = o = iterator.next();
                this.model.addElement(interp);
            }
        } else {
            try {
                LinkedList<InterpHdr> list = new LinkedList<InterpHdr>();
                for (Well well : this.project) {
                    if (well instanceof WsWell && ((WsWell)well).getLink() != null) {
                        well = ((WsWell)well).getLink();
                    }
                    well.loadInterps();
                    Iterator<WellInterp> iit = well.getInterpIterator();
                    while (iit.hasNext()) {
                        WellInterp wellInterp = iit.next();
                        if (list.contains(wellInterp.getHeader())) continue;
                        list.add(wellInterp.getHeader());
                    }
                }
                Collections.sort(list);
                for (InterpHdr interp : list) {
                    if (this.model.contains(interp)) continue;
                    if (interp.getInterpID() == 0) {
                        this.model.add(0, interp);
                        continue;
                    }
                    this.model.addElement(interp);
                }
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error", (Throwable)e);
                this.db.doRollback();
            }
        }
        this.jButtonAdd.setEnabled(this.jRadioButtonAll.isSelected());
        this.jButtonEdit.setEnabled(this.jRadioButtonAll.isSelected());
    }

    private void initComponents() {
        this.buttonGroupVersion = new ButtonGroup();
        this.jButtonShowWells = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListVersion = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonAll = new JRadioButton();
        this.jRadioButtonWells = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(370, 300));
        this.setModal(true);
        this.jButtonShowWells.setText("<html>Show wells<br> & templates...</html>");
        this.jButtonShowWells.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowWells.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowWellsActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete...");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.setToolTipText("(only enabled when all versions are showing)");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add... ");
        this.jButtonAdd.setToolTipText("(only enabled when all versions are showing)");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jListVersion.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListVersion.setModel(this.model);
        this.jListVersion.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListVersionMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListVersion);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Restrict display", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupVersion.add(this.jRadioButtonAll);
        this.jRadioButtonAll.setText("All versions");
        this.jRadioButtonAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonAllActionPerformed(evt);
            }
        });
        this.buttonGroupVersion.add(this.jRadioButtonWells);
        this.jRadioButtonWells.setText("Selected well(s) only");
        this.jRadioButtonWells.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectVersion this$0;
            {
                DialogSelectVersion dialogSelectVersion = this$0;
                Objects.requireNonNull(dialogSelectVersion);
                this.this$0 = dialogSelectVersion;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonWellsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonAll).addPreferredGap(1).add((Component)this.jRadioButtonWells).addContainerGap(50, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonAll).add((Component)this.jRadioButtonWells)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 252, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE)).add((Component)this.jButtonEdit, -1, 85, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, 85, Short.MAX_VALUE).add((Component)this.jButtonDelete, -2, 85, Short.MAX_VALUE).add((Component)this.jButtonShowWells)).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonOK, this.jButtonShowWells}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonShowWells, -2, -1, -2).addPreferredGap(0, 91, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 296, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        InterpHdr interp = (InterpHdr)this.jListVersion.getSelectedValue();
        if (interp == null) {
            JOptionPane.showMessageDialog(this, "No version selected", this.getTitle(), 2);
            return;
        }
        try {
            if (interp.getInterpID() == 0) {
                JOptionPane.showMessageDialog(this, "You can't delete the Default Version.", this.getTitle(), 2);
                return;
            }
            if (interp.getDatabase() == null || !interp.getDatabase().isConnected()) {
                JOptionPane.showMessageDialog(this, "You can't delete a workspace version, use Remove Selected Version tab in Organiser instead.", this.getTitle(), 2);
                return;
            }
            List wellList = interp.findWells();
            String msg = "No well/outcrop data for version '" + String.valueOf(interp) + "'. Continue to delete?";
            if (wellList.size() > 0) {
                msg = "Warning: Version is used for data in " + wellList.size() + " well/outcrops.\nDo you want to delete version and ALL these data?";
            }
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            if (this.db.canDeleteInterp(interp.getInterpID())) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.db.deleteInterp(interp.getInterpID());
                this.model.removeElement(interp);
                this.jListVersion.repaint();
                this.db.commit();
                if (wellList.size() > 0) {
                    JOptionPane.showMessageDialog(this, "Version: " + String.valueOf(interp) + " deleted.", this.getTitle(), 2);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Can't delete the selected version as it is being used in one or more charts.\r\n" + this.db.interpChartUsageMessage(interp.getInterpID()), "Can't delete selected version", 2);
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jListVersionMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonShowWellsActionPerformed(ActionEvent evt) {
        InterpHdr interp = (InterpHdr)this.jListVersion.getSelectedValue();
        if (interp == null) {
            JOptionPane.showMessageDialog(this, "No version selected", this.getTitle(), 2);
            return;
        }
        if (interp.getDatabase() == null || !interp.getDatabase().isConnected()) {
            JOptionPane.showMessageDialog(this, "You can't perform this operation on the workspace version.", this.getTitle(), 2);
            return;
        }
        try {
            List wellList = interp.findWells();
            List charts = interp.findChartComponents();
            wellList.addAll(charts);
            DialogList.displayListDialog(this, "Wells : " + interp.toString(), new UserPrefsHelper(this.db), wellList, null);
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        InterpHdr interp = (InterpHdr)this.jListVersion.getSelectedValue();
        if (interp == null) {
            JOptionPane.showMessageDialog(this, "No version selected", this.getTitle(), 2);
            return;
        }
        if (interp.getDatabase() == null || !interp.getDatabase().isConnected()) {
            JOptionPane.showMessageDialog(this, "You can't perform this operation on the workspace version.", this.getTitle(), 2);
            return;
        }
        if (interp.getInterpID() == 0 && (this.db.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You must be a super-user to edit the Default Version", "Edit Default Version", 2);
            return;
        }
        try {
            DialogVersionHeader dialog = new DialogVersionHeader((JDialog)this, true, this.db, interp);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.loadList();
                this.jListVersion.setSelectedValue(dialog.interpHdr, true);
            }
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error", (Throwable)e);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Object[] rows = this.jListVersion.getSelectedValues();
        if (rows.length == 0) {
            JOptionPane.showMessageDialog(this, "No version selected", this.getTitle(), 2);
            return;
        }
        this.selection = new LinkedList<InterpHdr>();
        for (Object row : rows) {
            this.selection.add((InterpHdr)row);
        }
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogVersionHeader dialog = new DialogVersionHeader((JDialog)this, true, this.db, (InterpHdr)null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.loadList();
                this.jListVersion.setSelectedValue(dialog.interpHdr, true);
            }
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        InterpHdr.setDisplayDefault(false);
        super.dispose();
    }

    private void jRadioButtonWellsActionPerformed(ActionEvent evt) {
        try {
            this.loadList();
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error", (Throwable)e);
        }
    }

    private void jRadioButtonAllActionPerformed(ActionEvent evt) {
        try {
            this.loadList();
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error", (Throwable)e);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtouseversions.html");
    }

    public List<InterpHdr> getSelection() {
        return this.selection;
    }
}

