/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.InternalFrameGroup;
import jsbugs.JPanelGroups;
import jsbugs.list.RestrictableProjectListCellRenderer;
import jsbugs.util.UserPrefsHelper;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.project.Project;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogSet
extends SBDialog {
    private final SBdb sbdb;
    private final FrameTaxaDB parent;
    private final DefaultListModel setGroupModel = new DefaultListModel();
    private final DefaultListModel availGroupModel = new DefaultListModel();
    private final DefaultComboBoxModel projModel = new DefaultComboBoxModel();
    private static final int NAME_LEN = 30;
    TxGroupSet set;
    private boolean loading = false;
    private boolean moving = false;
    private JButton jButtonCancel;
    private JButton jButtonDown;
    private JButton jButtonHelp;
    private JButton jButtonMoveIn;
    private JButton jButtonMoveOut;
    private JButton jButtonOK;
    private JButton jButtonShowGroup;
    private JButton jButtonUp;
    private JCheckBox jCheckBoxIsOrdered;
    private JComboBox jComboBoxProject;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JList jListAvailGroups;
    private JList jListSetGroups;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneAvail;
    private JScrollPane jScrollPaneSet;
    private JSeparator jSeparator1;
    private JTextArea jTextAreaDescr;
    private JTextField jTextFieldName;

    public DialogSet(FrameTaxaDB parent, boolean modal, SBdb sbdb, TxGroupSet set) throws SQLException, SBException {
        super((Frame)parent, modal);
        int projID;
        this.parent = parent;
        this.sbdb = sbdb;
        this.set = set;
        this.initComponents();
        this.jComboBoxProject.addItem("Global");
        try {
            sbdb.loadProjectCombo(this.projModel, false);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, sbdb);
        }
        int n = projID = set != null ? set.getProjID() : parent.getProjID();
        if (projID > 0) {
            this.jComboBoxProject.setSelectedItem((Object)sbdb.getProject(projID));
        } else {
            this.jComboBoxProject.setSelectedIndex(0);
        }
        this.init();
    }

    public DialogSet(Dialog parent, boolean modal, SBdb sbdb, String name, String descrip, int projID, boolean ordered, List<TxGroup> groups) throws SQLException, SBException {
        super((Window)parent, modal);
        this.sbdb = sbdb;
        this.set = null;
        this.parent = null;
        this.initComponents();
        this.jTextFieldName.setText(name);
        this.jTextAreaDescr.setText(descrip);
        this.jCheckBoxIsOrdered.setSelected(ordered);
        if (projID > 0) {
            this.jComboBoxProject.addItem(sbdb.getProject(projID));
        } else {
            this.jComboBoxProject.addItem("Global");
        }
        this.jComboBoxProject.setSelectedIndex(0);
        for (TxGroup group : groups) {
            this.setGroupModel.addElement(group);
        }
        this.init();
    }

    private void init() throws SQLException {
        this.jListAvailGroups.setCellRenderer(new RestrictableProjectListCellRenderer());
        this.jListSetGroups.setCellRenderer(new RestrictableProjectListCellRenderer());
        if (this.set != null) {
            this.setTitle("Group Set : Edit : " + this.set.getName());
            this.jTextFieldName.setText(this.set.getName());
            List<TxGroup> groups = this.set.getGroups();
            if (!this.set.isOrdered()) {
                Collections.sort(groups, new JPanelGroups.TxGroupComparator());
            }
            for (TxGroup group : groups) {
                this.setGroupModel.addElement(group);
            }
            this.jCheckBoxIsOrdered.setSelected(this.set.isOrdered());
            this.enableMove();
            if (!this.set.canWrite(this.sbdb, null)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText(this.set.getDeniedReason(this.sbdb, "group set", false));
            }
            this.jTextAreaDescr.setText(this.set.getDescr());
        } else {
            this.setTitle("Group Set : Add");
            if (!SBRestrictable.canWrite(this.sbdb)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
            }
        }
        this.checkProjectCombo();
        this.fillAvailGroups();
        this.jComboBoxProject.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (this.this$0.moving || this.this$0.loading) {
                    return;
                }
                if (ie.getStateChange() == 1) {
                    try {
                        this.this$0.fillAvailGroups();
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error", sql, this.this$0.sbdb);
                    }
                }
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.parent == null) {
            this.jButtonShowGroup.setVisible(false);
        }
    }

    private void enableMove() {
        this.jButtonDown.setEnabled(this.jCheckBoxIsOrdered.isSelected());
        this.jButtonUp.setEnabled(this.jCheckBoxIsOrdered.isSelected());
    }

    private void fillAvailGroups() throws SQLException {
        Project project = this.jComboBoxProject.getSelectedItem() instanceof Project ? (Project)((Object)this.jComboBoxProject.getSelectedItem()) : null;
        LinkedList<TxGroup> availGroups = new LinkedList<TxGroup>(this.sbdb.getTxGroups(project != null ? project.getID() : 0, true));
        for (int i = 0; i < this.setGroupModel.getSize(); ++i) {
            availGroups.remove((TxGroup)this.setGroupModel.getElementAt(i));
        }
        Collections.sort(availGroups, new JPanelGroups.TxGroupComparator());
        this.availGroupModel.clear();
        for (TxGroup group : availGroups) {
            this.availGroupModel.addElement(group);
        }
    }

    private void checkProjectCombo() throws SQLException {
        Object o;
        TxGroup group;
        Object currentProject = this.jComboBoxProject.getSelectedItem();
        int restrictedProjID = 0;
        Object[] objectArray = this.setGroupModel.toArray();
        int n = objectArray.length;
        for (int i = 0; i < n && (restrictedProjID = Math.max(restrictedProjID, (group = (TxGroup)(o = objectArray[i])).getProjID())) <= 0; ++i) {
        }
        if (restrictedProjID > 0) {
            ArrayList toRemove = new ArrayList();
            for (int i = 0; i < this.projModel.getSize(); ++i) {
                Object obj = this.projModel.getElementAt(i);
                if (obj instanceof Project && ((Project)((Object)this.projModel.getElementAt(i))).getID() == restrictedProjID) continue;
                toRemove.add(this.projModel.getElementAt(i));
            }
            for (Object o2 : toRemove) {
                this.projModel.removeElement(o2);
            }
        } else if (this.projModel.getSize() - 1 < this.sbdb.getnProjects()) {
            this.loading = true;
            this.projModel.removeAllElements();
            this.jComboBoxProject.addItem("Global");
            this.sbdb.loadProjectCombo(this.projModel, false);
            this.loading = false;
        }
        this.jComboBoxProject.setSelectedItem(currentProject);
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jTextFieldName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jCheckBoxIsOrdered = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescr = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPaneSet = new JScrollPane();
        this.jListSetGroups = new JList();
        this.jButtonMoveIn = new JButton();
        this.jButtonMoveOut = new JButton();
        this.jButtonShowGroup = new JButton();
        this.jScrollPaneAvail = new JScrollPane();
        this.jListAvailGroups = new JList();
        this.jLabel3 = new JLabel();
        this.jButtonUp = new JButton();
        this.jButtonDown = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 250));
        this.setModal(true);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Name:");
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projModel);
        this.jLabel4.setText("Project:");
        this.jCheckBoxIsOrdered.setText("Ordered");
        this.jCheckBoxIsOrdered.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxIsOrderedActionPerformed(evt);
            }
        });
        this.jTextAreaDescr.setColumns(20);
        this.jTextAreaDescr.setLineWrap(true);
        this.jTextAreaDescr.setRows(2);
        this.jTextAreaDescr.setWrapStyleWord(true);
        this.jTextAreaDescr.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextAreaDescrKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaDescr);
        this.jLabel5.setText("Description:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel4).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldName).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jComboBoxProject, -2, 191, -2).addPreferredGap(0, 155, Short.MAX_VALUE).add((Component)this.jCheckBoxIsOrdered)).add((Component)this.jScrollPane1)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldName, -2, -1, -2)).add(3, 3, 3).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jComboBoxProject, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.jCheckBoxIsOrdered)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel5).add((Component)this.jScrollPane1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel2.setForeground(new Color(51, 102, 204));
        this.jLabel2.setText("Groups in set:");
        this.jListSetGroups.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSetGroups.setModel(this.setGroupModel);
        this.jListSetGroups.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListSetGroupsMouseClicked(evt);
            }
        });
        this.jScrollPaneSet.setViewportView(this.jListSetGroups);
        this.jButtonMoveIn.setText("<");
        this.jButtonMoveIn.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveInActionPerformed(evt);
            }
        });
        this.jButtonMoveOut.setText(">");
        this.jButtonMoveOut.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveOutActionPerformed(evt);
            }
        });
        this.jButtonShowGroup.setText("Show...");
        this.jButtonShowGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowGroupActionPerformed(evt);
            }
        });
        this.jListAvailGroups.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListAvailGroups.setModel(this.availGroupModel);
        this.jListAvailGroups.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListAvailGroupsMouseClicked(evt);
            }
        });
        this.jScrollPaneAvail.setViewportView(this.jListAvailGroups);
        this.jLabel3.setForeground(new Color(51, 102, 204));
        this.jLabel3.setText("Available groups:");
        this.jButtonUp.setText("Move up");
        this.jButtonUp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUpActionPerformed(evt);
            }
        });
        this.jButtonDown.setText("Move down");
        this.jButtonDown.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonDown.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSet this$0;
            {
                DialogSet dialogSet = this$0;
                Objects.requireNonNull(dialogSet);
                this.this$0 = dialogSet;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDownActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jScrollPaneSet, -2, 0, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonMoveOut, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveIn, -2, 71, -2).add(2, (Component)this.jButtonShowGroup, -1, 75, Short.MAX_VALUE)).add((Component)this.jButtonUp, -2, 75, -2).add((Component)this.jButtonDown)).add(6, 6, 6).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jScrollPaneAvail, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.linkSize(new Component[]{this.jButtonDown, this.jButtonMoveIn, this.jButtonMoveOut, this.jButtonShowGroup, this.jButtonUp}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonMoveIn).addPreferredGap(0).add((Component)this.jButtonMoveOut).addPreferredGap(0).add((Component)this.jButtonShowGroup).add(15, 15, 15).add((Component)this.jButtonUp).addPreferredGap(0).add((Component)this.jButtonDown).add(0, 79, Short.MAX_VALUE)).add((Component)this.jScrollPaneAvail).add((Component)this.jScrollPaneSet)).add(15, 15, 15)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jPanel1, -2, -1, -2)).add(2, (Component)this.jSeparator1)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add(18, 18, 18).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jSeparator1, -2, 11, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String name = this.jTextFieldName.getText().trim();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No set name entered.", this.getTitle(), 2);
            return;
        }
        if (this.setGroupModel.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No groups selected.", this.getTitle(), 2);
            return;
        }
        try {
            List<Taxon> list;
            int projID = this.jComboBoxProject.getSelectedItem() instanceof Project ? ((Project)((Object)this.jComboBoxProject.getSelectedItem())).getID() : 0;
            TxGroupSet newSet = this.sbdb.getTxGroupSet(name, projID > 0 ? Integer.valueOf(projID) : null);
            if (newSet != null) {
                if (this.set == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "A set with that name already exists", this.getTitle(), 2);
                    return;
                }
                if (this.set.getID() != newSet.getID()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "A set with the new name already exists", this.getTitle(), 2);
                    return;
                }
            }
            LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
            Enumeration e = this.setGroupModel.elements();
            while (e.hasMoreElements()) {
                TxGroup g = (TxGroup)e.nextElement();
                if (g.getProjID() != projID && g.getProjID() > 0) {
                    throw new SBException("Attempt to add group in wrong project: " + g.getName());
                }
                groups.add(g);
            }
            String descr = this.jTextAreaDescr.getText().trim();
            if (descr.isEmpty()) {
                descr = null;
            }
            if (!(list = TxGroupSet.findDuplicateTaxa(this.sbdb, groups)).isEmpty()) {
                Object[] buttons = new String[]{"List duplicates", "Save anyway", "Cancel"};
                int opt = JOptionPane.showOptionDialog((Component)((Object)this), "There are taxa which are in more than one group in this set.", "Duplicates", -1, -1, null, buttons, buttons[0]);
                if (opt == -1 || opt == 2) {
                    return;
                }
                if (opt == 0) {
                    DialogList.displayListDialog((JDialog)((Object)this), "Duplicate species", new UserPrefsHelper(this.sbdb), list, null);
                    return;
                }
            }
            if (this.set == null) {
                this.set = this.sbdb.addTxGroupSet(name, descr, projID, groups, this.jCheckBoxIsOrdered.isSelected());
            } else {
                int opt;
                if (!(groups.containsAll(this.set.getGroups()) && this.set.getGroups().containsAll(groups) || this.parent.parent.getChartManager().checkDeleteTxGroupSet(this.set.getID()) || (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "This group set is used in charts. Are you sure you want to update it?", this.getTitle(), 0)) == 0)) {
                    return;
                }
                if (this.set.getProjID() != projID && projID > 0 && !this.parent.parent.getChartManager().checkTxGroupSetProjChange(this.set.getID(), projID)) {
                    String origProj = this.sbdb.getProject(this.set.getProjID()).getName();
                    JOptionPane.showMessageDialog((Component)((Object)this), "You cannot change the project becuase this set is used in '" + origProj + "' chart panels.", this.getTitle(), 2);
                    return;
                }
                this.set.update(name, projID, groups, this.jCheckBoxIsOrdered.isSelected(), descr);
                this.set.notifyObservers();
            }
            this.sbdb.commit();
            this.setOK();
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonMoveInActionPerformed(ActionEvent evt) {
        this.move(true);
    }

    private void jButtonMoveOutActionPerformed(ActionEvent evt) {
        this.move(false);
    }

    private void move(boolean in) {
        DefaultListModel[] models;
        DefaultListModel[] defaultListModelArray;
        Object[] selection;
        JList from = in ? this.jListAvailGroups : this.jListSetGroups;
        DefaultListModel fromModel = in ? this.availGroupModel : this.setGroupModel;
        JList to = in ? this.jListSetGroups : this.jListAvailGroups;
        DefaultListModel toModel = in ? this.setGroupModel : this.availGroupModel;
        this.moving = true;
        for (Object o : selection = from.getSelectedValues()) {
            fromModel.removeElement(o);
            toModel.addElement(o);
        }
        if (this.jCheckBoxIsOrdered.isSelected()) {
            DefaultListModel[] defaultListModelArray2 = new DefaultListModel[1];
            defaultListModelArray = defaultListModelArray2;
            defaultListModelArray2[0] = this.availGroupModel;
        } else {
            DefaultListModel[] defaultListModelArray3 = new DefaultListModel[2];
            defaultListModelArray3[0] = this.availGroupModel;
            defaultListModelArray = defaultListModelArray3;
            defaultListModelArray3[1] = this.setGroupModel;
        }
        for (DefaultListModel model : models = defaultListModelArray) {
            Object[] arr = model.toArray();
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
            Collections.sort(list, new JPanelGroups.TxGroupComparator());
            if (list.equals(Arrays.asList(arr))) continue;
            model.removeAllElements();
            for (Object e : list) {
                model.addElement(e);
            }
        }
        from.clearSelection();
        to.clearSelection();
        int[] scrollIndices = new int[selection.length];
        for (int i = 0; i < scrollIndices.length; ++i) {
            scrollIndices[i] = toModel.indexOf(selection[i]);
        }
        to.setSelectedIndices(scrollIndices);
        to.repaint();
        from.repaint();
        try {
            this.checkProjectCombo();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        this.moving = false;
    }

    private void moveSetPanel(boolean up) {
        if (this.jListSetGroups.getSelectedIndices().length != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one group to move", this.getTitle(), 2);
            return;
        }
        int index = this.jListSetGroups.getSelectedIndex();
        if (up && index == 0 || !up && index == this.setGroupModel.size() - 1) {
            this.getToolkit().beep();
            return;
        }
        TxGroup group = (TxGroup)this.setGroupModel.remove(index);
        this.setGroupModel.add(up ? index - 1 : index + 1, group);
        this.jListSetGroups.setSelectedValue(group, true);
        this.jListSetGroups.repaint();
    }

    private void jListSetGroupsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowGroupActionPerformed(null);
        }
    }

    private void jListAvailGroupsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonMoveInActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogset.html");
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonShowGroupActionPerformed(ActionEvent evt) {
        Object[] selection;
        for (Object o : selection = this.jListSetGroups.getSelectedValues()) {
            TxGroup group = (TxGroup)o;
            try {
                InternalFrameGroup frame = this.parent.getGroupFrame(group);
                if (frame != null) {
                    frame.setIcon(false);
                    frame.setVisible(true);
                    frame.setLocation(50, 50);
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.parent.createInternalFrameGroup(group);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jCheckBoxIsOrderedActionPerformed(ActionEvent evt) {
        this.enableMove();
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        this.moveSetPanel(true);
    }

    private void jButtonDownActionPerformed(ActionEvent evt) {
        this.moveSetPanel(false);
    }

    private void jTextAreaDescrKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaDescr, (int)255, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }
}

