/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.Situation;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.DialogOccurrence;
import model3.SBdb;
import model3.Smpdtl;
import model3.TaxonOcc;
import model3.Well;
import util.SBException;

public class DialogSetRwCv
extends JDialog {
    List<TaxonOcc> occs;
    Well well;
    Smpdtl smpdtl;
    SBdb db;
    boolean isOK = false;
    private static final Logger LOGGER = Logger.getLogger(DialogSetRwCv.class.getName());
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabelNOccs;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonCvLower;
    private JRadioButton jRadioButtonCvLowerClear;
    private JRadioButton jRadioButtonCvSingle;
    private JRadioButton jRadioButtonCvSingleClear;
    private JRadioButton jRadioButtonRwHigher;
    private JRadioButton jRadioButtonRwHigherClear;
    private JRadioButton jRadioButtonRwSingle;
    private JRadioButton jRadioButtonRwSingleClear;
    private JRadioButton jRadioButtonTr;

    public DialogSetRwCv(Frame parent, boolean modal, SBdb db, List<TaxonOcc> occs, Well well, Smpdtl smpdtl) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.occs = occs;
        this.well = well;
        this.smpdtl = smpdtl;
        this.init();
    }

    private void init() {
        this.jLabelNOccs.setText("" + this.occs.size());
        this.setTitle("Edit Reworked/Caved");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabelNOccs = new JLabel();
        this.jLabel1 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonRwHigher = new JRadioButton();
        this.jRadioButtonRwSingle = new JRadioButton();
        this.jRadioButtonCvLower = new JRadioButton();
        this.jRadioButtonCvSingle = new JRadioButton();
        this.jRadioButtonRwHigherClear = new JRadioButton();
        this.jRadioButtonRwSingleClear = new JRadioButton();
        this.jRadioButtonCvLowerClear = new JRadioButton();
        this.jRadioButtonCvSingleClear = new JRadioButton();
        this.jRadioButtonTr = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.jLabelNOccs.setFont(new Font("Tahoma", 1, 11));
        this.jLabelNOccs.setText("10");
        this.jLabel1.setText("occurrence(s) selected");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSetRwCv this$0;
            {
                DialogSetRwCv dialogSetRwCv = this$0;
                Objects.requireNonNull(dialogSetRwCv);
                this.this$0 = dialogSetRwCv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSetRwCv this$0;
            {
                DialogSetRwCv dialogSetRwCv = this$0;
                Objects.requireNonNull(dialogSetRwCv);
                this.this$0 = dialogSetRwCv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Select one of the following edit options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButtonRwHigher);
        this.jRadioButtonRwHigher.setText("<html>change this and all <strong>higher</strong> occurrences of taxa to <strong>Reworked</strong></html>");
        this.buttonGroup1.add(this.jRadioButtonRwSingle);
        this.jRadioButtonRwSingle.setText("<html>change occurrences of taxa to <strong>Reworked</strong> in this sample only</html>");
        this.buttonGroup1.add(this.jRadioButtonCvLower);
        this.jRadioButtonCvLower.setText("<html>change this and all <strong>lower</strong> occurrences (in CU) of taxa to <strong>Caved</strong></html>");
        this.buttonGroup1.add(this.jRadioButtonCvSingle);
        this.jRadioButtonCvSingle.setText("<html>change occurrences of taxa to <strong>Caved</strong> in this sample only</html>");
        this.buttonGroup1.add(this.jRadioButtonRwHigherClear);
        this.jRadioButtonRwHigherClear.setText("<html>clear this and all <strong>higher</strong> occurrences of taxa from <strong>Reworked</strong></html>");
        this.buttonGroup1.add(this.jRadioButtonRwSingleClear);
        this.jRadioButtonRwSingleClear.setText("<html>clear occurrences of taxa from <strong>Reworked</strong> in this sample only</html>");
        this.buttonGroup1.add(this.jRadioButtonCvLowerClear);
        this.jRadioButtonCvLowerClear.setText("<html>clear this and all <strong>lower</strong> occurrences (in CU) of taxa from <strong>Caved</strong></html>");
        this.buttonGroup1.add(this.jRadioButtonCvSingleClear);
        this.jRadioButtonCvSingleClear.setText("<html>clear occurrences of taxa from <strong>Caved</strong> in this sample only</html>");
        this.buttonGroup1.add(this.jRadioButtonTr);
        this.jRadioButtonTr.setText("<html>set all selected occurrences to <b>Transported</b></html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioButtonRwHigher, -2, -1, -2).addComponent(this.jRadioButtonRwSingle, -2, -1, -2).addComponent(this.jRadioButtonCvSingle, -2, -1, -2).addComponent(this.jRadioButtonCvLower, -2, -1, -2).addComponent(this.jRadioButtonRwHigherClear, -2, -1, -2).addComponent(this.jRadioButtonRwSingleClear, -2, -1, -2).addComponent(this.jRadioButtonCvLowerClear).addComponent(this.jRadioButtonCvSingleClear, -2, -1, -2).addComponent(this.jRadioButtonTr)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonRwHigher, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonRwHigherClear, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jRadioButtonRwSingle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonRwSingleClear, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jRadioButtonCvLower, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonCvLowerClear, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jRadioButtonCvSingle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonCvSingleClear, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.jRadioButtonTr, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabelNOccs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 323, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNOccs).addComponent(this.jLabel1)).addGap(18, 18, 18).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "no option selected", this.getTitle(), 2);
        }
        boolean extend = false;
        boolean isSet = false;
        boolean setRw = false;
        boolean setCv = false;
        boolean setTr = false;
        if (this.jRadioButtonRwHigher.isSelected()) {
            extend = true;
            isSet = true;
            setRw = true;
            setTr = false;
        } else if (this.jRadioButtonRwHigherClear.isSelected()) {
            extend = true;
            isSet = false;
            setRw = true;
            setTr = false;
        } else if (this.jRadioButtonRwSingle.isSelected()) {
            extend = false;
            isSet = true;
            setRw = true;
            setTr = false;
        } else if (this.jRadioButtonRwSingleClear.isSelected()) {
            extend = false;
            isSet = false;
            setRw = true;
            setTr = false;
        } else if (this.jRadioButtonCvLower.isSelected()) {
            extend = true;
            isSet = true;
            setCv = true;
            setTr = false;
        } else if (this.jRadioButtonCvLowerClear.isSelected()) {
            extend = true;
            isSet = false;
            setCv = true;
            setTr = false;
        } else if (this.jRadioButtonCvSingle.isSelected()) {
            extend = false;
            isSet = true;
            setCv = true;
            setTr = false;
        } else if (this.jRadioButtonCvSingleClear.isSelected()) {
            extend = false;
            isSet = false;
            setCv = true;
            setTr = false;
        } else if (this.jRadioButtonTr.isSelected()) {
            extend = false;
            isSet = false;
            setCv = false;
            setTr = true;
        }
        try {
            int nRw = 0;
            int nCv = 0;
            int nTr = 0;
            for (TaxonOcc fss : this.occs) {
                if (setRw) {
                    nRw += DialogOccurrence.doRwUpdate(fss, this.well, this.smpdtl, isSet, true, !extend);
                }
                if (setCv) {
                    nCv += DialogOccurrence.doCvUpdate(fss, this.well, this.smpdtl, isSet, true, !extend);
                }
                if (!setTr || fss.getSituation() == Situation.TR) continue;
                this.smpdtl.updateOcc(this.well.getWellID(), fss, Situation.TR, fss.getQuestionable(), fss.getSpecType(), fss.isMarker(), fss.getCoarse(), fss.getMedium(), fss.getFine(), fss.getSubAbund(), fss.getPreservation(), fss.getColour(), fss.getComment(), fss.getImageSetID());
                ++nTr;
            }
            this.db.commit();
            if (setRw) {
                JOptionPane.showMessageDialog(this, nRw + " Rw record(s) updated.", "Reworking", 1);
            }
            if (setCv) {
                JOptionPane.showMessageDialog(this, nCv + " Cv record(s) updated.", "Caving", 1);
            }
            if (setTr) {
                JOptionPane.showMessageDialog(this, nTr + " Tr record(s) updated.", "Tranportation", 1);
            }
            this.isOK = true;
            this.dispose();
        }
        catch (IOException | SQLException | SBException e) {
            this.db.doRollback();
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

