/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.AbstractTableModel;
import jsbugs.DialogSourceMatches;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.Source;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsOptionToggle;

public class DialogSource
extends SBDialog {
    private final TableModelSource model = new TableModelSource();
    private final SBdb db;
    public Source selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonMatches;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableSource;
    private JToggleButton jToggleButton1;

    public DialogSource(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super((Window)parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogSource(JFrame parent, boolean modal, SBdb db) throws SQLException {
        super((Frame)parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Data Source : Select");
        this.model.setupTable(this.jTableSource, Source.getSources(this.db));
        this.getRootPane().setDefaultButton(this.jButtonOK);
        ((SbugsOptionToggle)this.jToggleButton1).addComponents(false, new JComponent[]{this.jButtonAdd, this.jButtonEdit, this.jSeparator1, this.jButtonDelete, this.jButtonMatches});
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableSource = new JTable();
        this.jButtonMatches = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jToggleButton1 = new SbugsOptionToggle();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jTableSource.setModel(this.model);
        this.jTableSource.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSource this$0;
            {
                DialogSource dialogSource = this$0;
                Objects.requireNonNull(dialogSource);
                this.this$0 = dialogSource;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableSourceMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSource);
        this.jButtonMatches.setText("Matches...");
        this.jButtonMatches.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonMatches.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSource this$0;
            {
                DialogSource dialogSource = this$0;
                Objects.requireNonNull(dialogSource);
                this.this$0 = dialogSource;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchesActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSource this$0;
            {
                DialogSource dialogSource = this$0;
                Objects.requireNonNull(dialogSource);
                this.this$0 = dialogSource;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSource this$0;
            {
                DialogSource dialogSource = this$0;
                Objects.requireNonNull(dialogSource);
                this.this$0 = dialogSource;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSource this$0;
            {
                DialogSource dialogSource = this$0;
                Objects.requireNonNull(dialogSource);
                this.this$0 = dialogSource;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jToggleButton1.setText(">");
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSource this$0;
            {
                DialogSource dialogSource = this$0;
                Objects.requireNonNull(dialogSource);
                this.this$0 = dialogSource;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSource this$0;
            {
                DialogSource dialogSource = this$0;
                Objects.requireNonNull(dialogSource);
                this.this$0 = dialogSource;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 308, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonMatches, -2, 100, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToggleButton1, -2, 40, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jScrollPane1, -1, 270, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToggleButton1).addPreferredGap(0).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonMatches).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 2);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableSource.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row", this.getTitle(), 2);
            return;
        }
        this.selection = this.model.sources.get(this.jTableSource.getSelectedRow());
        this.setOK();
    }

    private void addSource() {
        String abr = JOptionPane.showInputDialog((Component)((Object)this), "Enter new Abbreviation: ", "Add Data Source", 3);
        if (abr == null) {
            return;
        }
        abr = abr.toUpperCase().trim();
        Iterator<Source> it = this.model.sources.iterator();
        while (it.hasNext()) {
            if (!it.next().getID().equals(abr)) continue;
            JOptionPane.showMessageDialog((Component)((Object)this), "Already exists", this.getTitle(), 2);
            return;
        }
        String name = JOptionPane.showInputDialog((Component)((Object)this), "Enter a description: ", "Add Data Source", 3);
        if (name == null) {
            return;
        }
        try {
            Source source = new Source(this.db, abr, name);
            int index = 0;
            while (it.hasNext() && it.next().getID().compareTo(abr) >= 0) {
                ++index;
            }
            this.model.sources.add(index, source);
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonMatchesActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableSource.getSelectedRowCount() != 1) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select one row", this.getTitle(), 2);
                return;
            }
            int row = this.jTableSource.getSelectedRow();
            this.selection = this.model.sources.get(row);
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogSourceMatches dialog = new DialogSourceMatches((JDialog)((Object)this), true, this.db, this.selection);
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, (Component)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableSource.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select source(s) to delete", this.getTitle(), 2);
            return;
        }
        LinkedList<Source> deleted = new LinkedList<Source>();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int[] toDelete = this.jTableSource.getSelectedRows();
            for (int i = 0; i < toDelete.length; ++i) {
                Source source = this.model.sources.get(toDelete[i]);
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Really delete: " + source.getID() + "?\n(" + source.getNEnvs(this.db) + " environment matches and " + source.getnTxload(this.db) + " taxon matches)", this.getTitle(), 1, 3);
                if (opt == 0) {
                    source.delete(this.db);
                    deleted.add(source);
                    continue;
                }
                if (opt != 2 && opt != -1) continue;
                this.db.doRollback();
                this.model.sources.addAll(deleted);
                return;
            }
            this.model.sources.removeAll(deleted);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            this.model.sources.addAll(deleted);
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.jTableSource.clearSelection();
            this.model.fireTableDataChanged();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTableSourceMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.addSource();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        this.editSource();
    }

    private void editSource() {
        if (this.jTableSource.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row", this.getTitle(), 2);
            return;
        }
        int row = this.jTableSource.getSelectedRow();
        this.selection = this.model.sources.get(row);
        Object name = JOptionPane.showInputDialog((Component)((Object)this), "Enter a description: ", "Edit Data Source", 1, null, null, this.selection.getName());
        if (name == null) {
            return;
        }
        try {
            this.selection.setName(this.db, name.toString());
            this.db.commit();
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private static class TableModelSource
    extends AbstractTableModel {
        static String[] colTitles = new String[]{"ID", "Name"};
        static int[] colWidths = new int[]{20, 70};
        static final int COL_ID = 0;
        static final int COL_NAME = 1;
        List<Source> sources = null;

        private TableModelSource() {
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.sources == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return this.sources.get(row).getID();
                }
                case 1: {
                    return this.sources.get(row).getName();
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            if (this.sources == null) {
                return 0;
            }
            return this.sources.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                default: 
            }
            return String.class;
        }

        void setupTable(JTable jTable, List<Source> sources) {
            SB.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < colTitles.length; ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            }
            this.sources = sources;
        }
    }
}

