/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class DialogTable
extends SBDialog {
    private final boolean OKCancel;
    private JButton jButtonClose;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTable;

    public DialogTable(Frame parent, boolean modal, AbstractTableModel model, String dialogTitle, boolean OKCancel) {
        super(parent, modal);
        this.initComponents();
        this.jTable.setModel(model);
        this.OKCancel = OKCancel;
        this.init(dialogTitle);
    }

    public DialogTable(Dialog parent, boolean modal, AbstractTableModel model, String dialogTitle, boolean OKCancel) {
        super((Window)parent, modal);
        this.initComponents();
        this.jTable.setModel(model);
        this.OKCancel = OKCancel;
        this.init(dialogTitle);
    }

    private void init(String dialogTitle) {
        if (this.OKCancel) {
            this.jButtonClose.setText("Cancel");
        } else {
            this.jButtonOK.setVisible(false);
        }
        this.setTitle(dialogTitle);
        this.jTable.setRowSorter(new TableRowSorter<TableModel>(this.jTable.getModel()));
        new ColumnSortResetHandler(this.jTable).attach();
    }

    public JTable getTable() {
        return this.jTable;
    }

    public int getSelectedRow() {
        return this.jTable.convertRowIndexToModel(this.jTable.getSelectedRow());
    }

    public void setSelectedRow(int modelIndex) {
        int sorterIndex = this.jTable.convertRowIndexToView(modelIndex);
        this.getTable().setRowSelectionInterval(sorterIndex, sorterIndex);
        for (int i = 0; i < 5 && sorterIndex >= 5 && ++sorterIndex < this.jTable.getModel().getRowCount(); ++i) {
        }
        this.getTable().scrollRectToVisible(this.getTable().getCellRect(sorterIndex, 0, true));
    }

    public int[] getSelectedRows() {
        int[] sorted = new int[this.jTable.getSelectedRowCount()];
        int[] selected = this.jTable.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            sorted[i] = this.jTable.convertRowIndexToModel(selected[i]);
        }
        return sorted;
    }

    public void registerPopupMenu(final JPopupMenu popupMenu) {
        this.jTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogTable this$0;
            {
                DialogTable dialogTable = this$0;
                Objects.requireNonNull(dialogTable);
                this.this$0 = dialogTable;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.popup(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.popup(evt);
            }

            private void popup(MouseEvent evt) {
                this.selectRows(evt);
                if (evt.isPopupTrigger() && this.this$0.jTable.getSelectedRowCount() > 0) {
                    popupMenu.show(this.this$0.jTable, evt.getX(), evt.getY());
                }
            }

            private void selectRows(MouseEvent evt) {
                int row = this.this$0.jTable.rowAtPoint(evt.getPoint());
                if (row < 0) {
                    return;
                }
                boolean rowIsSelected = false;
                for (int selected : this.this$0.jTable.getSelectedRows()) {
                    if (selected != row) continue;
                    rowIsSelected = true;
                    break;
                }
                if (!rowIsSelected) {
                    this.this$0.jTable.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogTable this$0;
            {
                DialogTable dialogTable = this$0;
                Objects.requireNonNull(dialogTable);
                this.this$0 = dialogTable;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTable this$0;
            {
                DialogTable dialogTable = this$0;
                Objects.requireNonNull(dialogTable);
                this.this$0 = dialogTable;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTable this$0;
            {
                DialogTable dialogTable = this$0;
                Objects.requireNonNull(dialogTable);
                this.this$0 = dialogTable;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 544, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 325, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.OKCancel && this.jTable.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row", this.getTitle(), 2);
            return;
        }
        this.setOK();
    }

    private void jTableMouseClicked(MouseEvent evt) {
        if (!this.OKCancel) {
            return;
        }
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }
}

