/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import jsbugs.FrameJsbugs;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogTaxonCode
extends JDialog {
    static String[] columnHeaders = new String[]{"Dictionary", "Numeric Code"};
    static int[] columnWidths = new int[]{100, 100};
    private final Taxon taxon;
    private final SBdb db;
    private final TableModelTaxonCode model = new TableModelTaxonCode(this);
    private JButton jButtonAddDict;
    private JButton jButtonCancel;
    private JButton jButtonDeleteDict;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableCode;

    public DialogTaxonCode(Frame parent, boolean modal, SBdb db, Taxon taxon) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.taxon = taxon;
        this.db = db;
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Numeric Codes : " + this.taxon.toString(false));
        SB.setTableHeaderBold((JTable)this.jTableCode);
        for (int i = 0; i < columnHeaders.length; ++i) {
            this.jTableCode.getColumnModel().getColumn(i).setHeaderValue(columnHeaders[i]);
            this.jTableCode.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        this.jTableCode.setSelectionMode(0);
        HashMap<Integer, String> dicts = this.db.getSIPMDicts();
        Set<Map.Entry<Integer, String>> set = dicts.entrySet();
        for (Map.Entry<Integer, String> entry : set) {
            RowItem row = new RowItem();
            row.ccode = entry.getKey();
            row.dictionary = entry.getValue();
            row.code = this.taxon.getSipmCode(row.ccode);
            this.model.rows.add(row);
        }
        this.model.fireTableDataChanged();
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonAddDict.setEnabled(false);
            this.jButtonDeleteDict.setEnabled(false);
            this.jButtonOK.setEnabled(false);
            this.getRootPane().setDefaultButton(this.jButtonOK);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
        } else {
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCode = new JTable();
        this.jButtonAddDict = new JButton();
        this.jButtonDeleteDict = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 200));
        this.jTableCode.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCode);
        this.jButtonAddDict.setText("Add dictionary...");
        this.jButtonAddDict.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCode this$0;
            {
                DialogTaxonCode dialogTaxonCode = this$0;
                Objects.requireNonNull(dialogTaxonCode);
                this.this$0 = dialogTaxonCode;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddDictActionPerformed(evt);
            }
        });
        this.jButtonDeleteDict.setText("Delete dictionary...");
        this.jButtonDeleteDict.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonDeleteDict.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCode this$0;
            {
                DialogTaxonCode dialogTaxonCode = this$0;
                Objects.requireNonNull(dialogTaxonCode);
                this.this$0 = dialogTaxonCode;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteDictActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCode this$0;
            {
                DialogTaxonCode dialogTaxonCode = this$0;
                Objects.requireNonNull(dialogTaxonCode);
                this.this$0 = dialogTaxonCode;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCode this$0;
            {
                DialogTaxonCode dialogTaxonCode = this$0;
                Objects.requireNonNull(dialogTaxonCode);
                this.this$0 = dialogTaxonCode;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonCode this$0;
            {
                DialogTaxonCode dialogTaxonCode = this$0;
                Objects.requireNonNull(dialogTaxonCode);
                this.this$0 = dialogTaxonCode;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 272, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAddDict, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDeleteDict, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 167, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAddDict).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDeleteDict).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtaxoncode.html");
    }

    private void jButtonAddDictActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInputDialog(this, (Object)"Name of new Dictionary: ");
        if (name == null || name.length() == 0) {
            return;
        }
        for (RowItem row : this.model.rows) {
            if (!row.dictionary.equalsIgnoreCase(name)) continue;
            JOptionPane.showMessageDialog(this, "Dictionary already exists", this.getTitle(), 2);
            return;
        }
        try {
            RowItem row = new RowItem();
            row.ccode = this.db.addSipmDict(name);
            this.db.commit();
            row.dictionary = name;
            this.model.rows.add(row);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException ex) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error adding numeric code dictionary", (Exception)ex, this.db);
        }
    }

    private void jButtonDeleteDictActionPerformed(ActionEvent evt) {
        if (this.jTableCode.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row from the table", this.getTitle(), 2);
            return;
        }
        RowItem row = this.model.rows.get(this.jTableCode.getSelectedRow());
        try {
            int opt;
            int nEntries = this.db.getSipmDictEntryCount(row.ccode);
            if (nEntries > 0 && (opt = JOptionPane.showConfirmDialog(this, "Warning: this dictionary contains codes for: " + nEntries + " taxa. Are you sure you want to delete it?", this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.db.deleteSipmDict(row.ccode);
            this.db.commit();
            this.model.rows.remove(row);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBPermissionException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableCode.isEditing()) {
            this.jTableCode.getCellEditor().stopCellEditing();
        }
        try {
            for (RowItem row : this.model.rows) {
                try {
                    this.taxon.storeSipmCode(row.ccode, row.code);
                }
                catch (SBException sbe) {
                    if (sbe.getMessage().startsWith("SIPM code is not unique")) {
                        String msg = "Code for '" + row.dictionary + "' dictionary is not unique.\nSpecify a different code.";
                        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                        this.db.doRollback();
                        return;
                    }
                    throw sbe;
                }
            }
            this.db.commit();
            this.dispose();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "Permission Error", 2);
        }
        catch (SQLException | SBException ex) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error updating codes", (Exception)ex, this.db);
        }
    }

    private class TableModelTaxonCode
    extends AbstractTableModel {
        static final int COL_DICT = 0;
        static final int COL_CODE = 1;
        List<RowItem> rows;
        final /* synthetic */ DialogTaxonCode this$0;

        private TableModelTaxonCode(DialogTaxonCode dialogTaxonCode) {
            DialogTaxonCode dialogTaxonCode2 = dialogTaxonCode;
            Objects.requireNonNull(dialogTaxonCode2);
            this.this$0 = dialogTaxonCode2;
            this.rows = new LinkedList<RowItem>();
        }

        @Override
        public int getColumnCount() {
            return columnHeaders.length;
        }

        @Override
        public int getRowCount() {
            if (this.rows == null) {
                return 0;
            }
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.rows == null) {
                return "";
            }
            try {
                switch (col) {
                    default: {
                        return "";
                    }
                    case 0: {
                        return this.rows.get((int)row).dictionary;
                    }
                    case 1: 
                }
                return this.rows.get((int)row).code;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            try {
                switch (col) {
                    default: {
                        return;
                    }
                    case 1: 
                }
                this.rows.get((int)row).code = o == null ? null : (Integer)o;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Class getColumnClass(int col) {
            switch (col) {
                default: {
                    return String.class;
                }
                case 1: 
            }
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int r, int col) {
            switch (col) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
    }

    private static class RowItem {
        int ccode;
        String dictionary;
        Integer code;

        private RowItem() {
        }
    }
}

