/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.validation.FieldLengthProperties;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import org.jdesktop.layout.GroupLayout;

public class DialogTaxonNotes
extends SBDialog {
    private static final int NOTE_LEN = FieldLengthProperties.getFieldLength(Taxon.class, (String)"notes", (int)500);
    private static final int REF_LEN = FieldLengthProperties.getFieldLength(Taxon.class, (String)"references", (int)500);
    private static final int URL_LEN = FieldLengthProperties.getFieldLength(Taxon.class, (String)"url", (int)500);
    private final Taxon taxon;
    private final TaxonService taxonService;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaNotes;
    private JTextArea jTextAreaRefs;
    private JTextField jTextFieldTaxonName;
    private JTextField jTextFieldURL;

    public DialogTaxonNotes(Frame parent, boolean modal, TaxonService taxonService, Taxon taxon) {
        super(parent, modal);
        this.taxon = taxon;
        this.taxonService = taxonService;
        this.initComponents();
        this.init();
    }

    private void init() {
        String url;
        String refs;
        this.setTitle("References and Notes");
        this.jTextFieldTaxonName.setText(this.taxon.toString(true));
        String notes = this.taxon.getNotes();
        if (notes != null) {
            this.jTextAreaNotes.setText(notes);
        }
        if ((refs = this.taxon.getReference()) != null) {
            this.jTextAreaRefs.setText(refs);
        }
        if ((url = this.taxon.getUrl()) != null) {
            this.jTextFieldURL.setText(url);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jTextFieldTaxonName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaRefs = TextFieldUtils.buildLimitedLengthTextArea(REF_LEN);
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaNotes = TextFieldUtils.buildLimitedLengthTextArea(NOTE_LEN);
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldURL = TextFieldUtils.buildLimitedLengthTextField(URL_LEN);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 400));
        this.jTextFieldTaxonName.setEditable(false);
        this.jTextFieldTaxonName.setBackground(new Color(255, 255, 204));
        this.jTextAreaRefs.setColumns(20);
        this.jTextAreaRefs.setFont(this.jTextAreaRefs.getFont());
        this.jTextAreaRefs.setLineWrap(true);
        this.jTextAreaRefs.setRows(4);
        this.jTextAreaRefs.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTextAreaRefs);
        this.jTextAreaNotes.setColumns(20);
        this.jTextAreaNotes.setFont(this.jTextAreaNotes.getFont());
        this.jTextAreaNotes.setLineWrap(true);
        this.jTextAreaNotes.setRows(3);
        this.jTextAreaNotes.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.jTextAreaNotes);
        this.jLabel1.setText("References:");
        this.jLabel2.setText("Notes:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonNotes this$0;
            {
                DialogTaxonNotes dialogTaxonNotes = this$0;
                Objects.requireNonNull(dialogTaxonNotes);
                this.this$0 = dialogTaxonNotes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonNotes this$0;
            {
                DialogTaxonNotes dialogTaxonNotes = this$0;
                Objects.requireNonNull(dialogTaxonNotes);
                this.this$0 = dialogTaxonNotes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonNotes this$0;
            {
                DialogTaxonNotes dialogTaxonNotes = this$0;
                Objects.requireNonNull(dialogTaxonNotes);
                this.this$0 = dialogTaxonNotes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel3.setText("URL:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 380, Short.MAX_VALUE).add((Component)this.jTextFieldTaxonName, -1, 380, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).add(5, 5, 5).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldURL)).add((Component)this.jScrollPane2, -1, 380, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldTaxonName, -2, -1, -2).add(17, 17, 17).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 91, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldURL, -2, -1, -2)).addPreferredGap(1).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 81, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 2);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Taxon t = new Taxon(this.taxon.getSpecID());
        Taxon.copyFields((Taxon)t, (Taxon)this.taxon);
        t.setReference(this.jTextAreaRefs.getText().trim());
        t.setUrl(this.jTextFieldURL.getText().trim());
        t.setNotes(this.jTextAreaNotes.getText().trim());
        try {
            this.taxonService.updateTaxon(t.getSpecID(), t);
            Taxon.copyFields((Taxon)this.taxon, (Taxon)t);
            this.setOK();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError("Error updating taxon", ex, (Component)((Object)this));
            this.dispose();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogtaxonnotes.html");
    }
}

