/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model3.InterpHdr;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogVersionHeader
extends JDialog {
    static final int ANYLEN = 5;
    static final int DATELEN = 8;
    static final int DESCRIPLEN = 80;
    InterpHdr interpHdr = null;
    SBdb db;
    boolean isOK = false;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JTextField jTextFieldCreated;
    private JTextField jTextFieldCreatedBy;
    private JTextField jTextFieldDescription;

    public DialogVersionHeader(Frame parent, boolean modal, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogVersionHeader(JDialog parent, boolean modal, SBdb db, InterpHdr interpHdr) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        this.interpHdr = interpHdr;
        this.initComponents();
        this.init();
    }

    public DialogVersionHeader(JDialog parent, boolean modal, SBdb db, String descrip) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initComponents();
        this.init();
        this.jTextFieldDescription.setText(descrip);
    }

    private void init() throws SQLException, SBException {
        if (this.interpHdr == null) {
            this.setTitle("Version : Add");
        } else {
            this.setTitle("Version : Edit Header");
            this.jTextFieldDescription.setText(this.interpHdr.getDescription());
            this.jTextFieldCreatedBy.setText(this.interpHdr.getCreatorString());
            this.jTextFieldCreated.setText(this.interpHdr.getCreatedString());
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldDescription = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldCreated = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldCreatedBy = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogVersionHeader this$0;
            {
                DialogVersionHeader dialogVersionHeader = this$0;
                Objects.requireNonNull(dialogVersionHeader);
                this.this$0 = dialogVersionHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogVersionHeader this$0;
            {
                DialogVersionHeader dialogVersionHeader = this$0;
                Objects.requireNonNull(dialogVersionHeader);
                this.this$0 = dialogVersionHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Name:");
        this.jTextFieldDescription.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogVersionHeader this$0;
            {
                DialogVersionHeader dialogVersionHeader = this$0;
                Objects.requireNonNull(dialogVersionHeader);
                this.this$0 = dialogVersionHeader;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldDescriptionFocusGained(evt);
            }
        });
        this.jTextFieldDescription.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogVersionHeader this$0;
            {
                DialogVersionHeader dialogVersionHeader = this$0;
                Objects.requireNonNull(dialogVersionHeader);
                this.this$0 = dialogVersionHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDescriptionKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Created:");
        this.jTextFieldCreated.setEditable(false);
        this.jTextFieldCreated.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogVersionHeader this$0;
            {
                DialogVersionHeader dialogVersionHeader = this$0;
                Objects.requireNonNull(dialogVersionHeader);
                this.this$0 = dialogVersionHeader;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldCreatedFocusGained(evt);
            }
        });
        this.jTextFieldCreated.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogVersionHeader this$0;
            {
                DialogVersionHeader dialogVersionHeader = this$0;
                Objects.requireNonNull(dialogVersionHeader);
                this.this$0 = dialogVersionHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCreatedKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Created by:");
        this.jTextFieldCreatedBy.setEditable(false);
        this.jTextFieldCreatedBy.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogVersionHeader this$0;
            {
                DialogVersionHeader dialogVersionHeader = this$0;
                Objects.requireNonNull(dialogVersionHeader);
                this.this$0 = dialogVersionHeader;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldCreatedByFocusGained(evt);
            }
        });
        this.jTextFieldCreatedBy.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogVersionHeader this$0;
            {
                DialogVersionHeader dialogVersionHeader = this$0;
                Objects.requireNonNull(dialogVersionHeader);
                this.this$0 = dialogVersionHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCreatedByKeyTyped(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSeparator1, -1, 421, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldCreated, -2, 91, -2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldCreatedBy, -1, 217, Short.MAX_VALUE)).add((Component)this.jTextFieldDescription, -1, 374, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldDescription, -2, -1, -2)).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jTextFieldCreatedBy, -2, -1, -2).add((Component)this.jTextFieldCreated, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldCreatedByFocusGained(FocusEvent evt) {
        this.jTextFieldCreatedBy.setSelectionStart(0);
        this.jTextFieldCreatedBy.setSelectionEnd(this.jTextFieldCreatedBy.getText().length());
    }

    private void jTextFieldCreatedByKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldCreatedBy, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCreatedKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldCreated, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCreatedFocusGained(FocusEvent evt) {
        this.jTextFieldCreated.setSelectionStart(0);
        this.jTextFieldCreated.setSelectionEnd(this.jTextFieldCreated.getText().length());
    }

    private void jTextFieldDescriptionKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldDescription, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDescriptionFocusGained(FocusEvent evt) {
        this.jTextFieldDescription.setSelectionStart(0);
        this.jTextFieldDescription.setSelectionEnd(this.jTextFieldDescription.getText().length());
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String desc = this.jTextFieldDescription.getText().trim();
        if (desc.isEmpty()) {
            JOptionPane.showMessageDialog(this, "You must enter a description", this.getTitle(), 2);
            return;
        }
        try {
            if (this.interpHdr == null) {
                this.interpHdr = this.db.addInterp(desc, null);
            } else if (!desc.equals(this.interpHdr.getDescription()) && this.interpHdr.setDescription(desc)) {
                this.interpHdr.notifyObservers();
            }
            this.isOK = true;
            this.db.commit();
            this.dispose();
        }
        catch (InvalidFieldException | SBException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }
}

