/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import jsbugs.TableModelSB;
import jsbugs.table.ColourRenderer;
import jsbugs.table.SampleRenderer;
import model3.EnvScheme;
import model3.IGDIntervalEnv;
import model3.SBdb;
import model3.Sample;

public class EnvTableModel
extends TableModelSB {
    private char units = (char)77;
    List<IGDIntervalEnv> envs = null;
    static String[] columnTitles = new String[]{"Top Sample", "Base Sample", "Scheme", "Palaeoenvironment", "Proximal", "Distal", "Mod. By", "Modified"};
    private static final int[] defaultColumnWidths = new int[]{55, 55, 30, 100, 15, 15, 20, 20};
    static final int COL_TOP = 0;
    static final int COL_BASE = 1;
    static final int COL_SCHEME = 2;
    static final int COL_ENV = 3;
    static final int COL_PCOLOUR = 4;
    static final int COL_DCOLOUR = 5;
    static final int COL_MODIFIER = 6;
    static final int COL_MODIFIED = 7;
    private SampleRenderer topSampleRenderer;
    private SampleRenderer bottomSampleRenderer;

    @Override
    void setUnits(char units) {
        if (this.units != units) {
            this.units = units;
            if (this.topSampleRenderer != null) {
                this.topSampleRenderer.setUnits(units);
            }
            if (this.bottomSampleRenderer != null) {
                this.bottomSampleRenderer.setUnits(units);
            }
        }
    }

    public char getUnits() {
        return this.units;
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row > this.envs.size() - 1) {
            return null;
        }
        IGDIntervalEnv env = this.envs.get(row);
        switch (col) {
            case 0: {
                return env.getTopSample();
            }
            case 1: {
                return env.getBaseSample();
            }
            case 2: {
                EnvScheme envScheme = env.getScheme();
                if (envScheme != null) {
                    return envScheme.toString();
                }
                return "";
            }
            case 3: {
                return env.toString();
            }
            case 4: {
                return env.getColour();
            }
            case 5: {
                return env.getColourDistal();
            }
            case 7: {
                return env.getModified();
            }
            case 6: {
                return env.getModifierAbr();
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.envs == null) {
            return 0;
        }
        return this.envs.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return Sample.class;
            }
            case 3: 
            case 6: {
                return String.class;
            }
            case 7: {
                return Date.class;
            }
            case 4: 
            case 5: 
        }
        return Color.class;
    }

    @Override
    public void setupTable(JTable jTableEnv, SBdb sbdb) {
        this.init(jTableEnv, sbdb);
        this.topSampleRenderer = new SampleRenderer(this.units);
        this.bottomSampleRenderer = new SampleRenderer(this.units);
        jTableEnv.getColumnModel().getColumn(0).setCellRenderer(this.topSampleRenderer);
        jTableEnv.getColumnModel().getColumn(1).setCellRenderer(this.bottomSampleRenderer);
        jTableEnv.setDefaultRenderer(Color.class, new ColourRenderer(true));
        this.restoreColumnOrder(jTableEnv);
    }

    @Override
    public String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    public String getPrefString() {
        return "TMENVIRONM";
    }

    @Override
    public String getPrefOrderString() {
        return "TOENVIRONM";
    }

    @Override
    public final String getAutoResizeString() {
        return "TARENVIRO";
    }
}

