/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Font;
import java.io.File;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.fontbox.util.autodetect.FontFileFinder;

public class FontMatchManager {
    private static final Logger LOGGER = Logger.getLogger(FontMatchManager.class.getName());
    private List<File> fontFiles = null;

    private void populateFontList() {
        FontFileFinder fontFinder = new FontFileFinder();
        this.fontFiles = fontFinder.find().stream().map(uri -> new File((URI)uri)).collect(Collectors.toList());
    }

    public List<AbstractMap.SimpleEntry<Font, File>> getFontMatches(List<Font> fontsToMatch, boolean exactFontNameMatchesOnly) {
        ArrayList<AbstractMap.SimpleEntry<Font, File>> matches = new ArrayList<AbstractMap.SimpleEntry<Font, File>>();
        for (Font font : fontsToMatch) {
            File matchingFile = this.searchForExactMatch(font);
            if (matchingFile == null && !exactFontNameMatchesOnly) {
                matchingFile = this.searchForMatchUsingFontFamily(font);
            }
            if (matchingFile == null) continue;
            matches.add(new AbstractMap.SimpleEntry<Font, File>(font, matchingFile));
        }
        return matches;
    }

    private File searchForExactMatch(Font fontToMatch) {
        if (this.fontFiles == null) {
            this.populateFontList();
        }
        for (File fontFile : this.fontFiles) {
            try {
                Font javaFont = Font.createFont(0, fontFile);
                if (!javaFont.getFontName().equals(fontToMatch.getFontName())) continue;
                return fontFile;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error loading font file : " + fontFile.getPath(), ex);
            }
        }
        return null;
    }

    private File searchForMatchUsingFontFamily(Font fontToMatch) {
        if (this.fontFiles == null) {
            this.populateFontList();
        }
        for (File fontFile : this.fontFiles) {
            try {
                Font javaFont = Font.createFont(0, fontFile);
                String lowerName = javaFont.getFontName().toLowerCase();
                if (fontFile.getPath().endsWith(".tcc")) {
                    Font[] fonts;
                    for (Font font : fonts = Font.createFonts(fontFile)) {
                    }
                }
                if (!javaFont.getFamily().equalsIgnoreCase(fontToMatch.getFamily()) || !(fontToMatch.isBold() && fontToMatch.isItalic() ? lowerName.contains("bold") && lowerName.contains("italic") : (fontToMatch.isBold() ? lowerName.contains("bold") && !lowerName.contains("italic") : (fontToMatch.isItalic() ? lowerName.contains("italic") && !lowerName.contains("bold") : !lowerName.contains("bold") && !lowerName.contains("italic"))))) continue;
                return fontFile;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error loading font file : " + fontFile.getPath(), ex);
            }
        }
        return null;
    }
}

