/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.FrameJsbugs;
import jsbugs.FrameSamples;
import jsbugs.overlay.IOverlayControlsListener;
import jsbugs.overlay.IOverlayDesignControlsListener;
import jsbugs.overlay.ITaxonDoubleClickListener;
import jsbugs.overlay.JPanelOverlayControls;
import jsbugs.overlay.JPanelOverlayDesignControls;
import jsbugs.overlay.JPanelOverlayNumpad;
import jsbugs.overlay.OverlayJPanel;
import jsbugs.overlay.TaxonCountManager;
import jsbugs.userconnect.SbugsSession;
import model3.Overlay;
import model3.SBdb;
import model3.Smpdtl;
import model3.Taxon;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class FrameOverlay
extends JFrame
implements IOverlayControlsListener,
IOverlayDesignControlsListener,
Observer {
    final OverlayJPanel jPanelOverlay;
    private TaxonCountManager countManager;
    private JPanelOverlayControls pControls;
    private JPanelOverlayDesignControls pDesignControls = new JPanelOverlayDesignControls();
    private JPanelOverlayNumpad numpadPanel = new JPanelOverlayNumpad();
    private JPanel controlsPanel = new JPanel();
    private FrameSamples frameSamples;
    private Clip soundClip;
    private Smpdtl smpdtl;
    private JLayeredPane layeredPane;
    private Well well;

    public FrameOverlay(GraphicsConfiguration gc, Frame parent, SBdb db, Well well, Smpdtl smpdtl, Overlay overlay, boolean showCMF, FrameSamples frameSamples) {
        super(gc);
        this.initComponents();
        this.jPanelOverlay = new OverlayJPanel(db, overlay, well, smpdtl, showCMF);
        this.countManager = new TaxonCountManager(db, well, smpdtl);
        this.pControls = new JPanelOverlayControls(showCMF);
        this.pControls.enableQSQSelection();
        this.well = well;
        this.smpdtl = smpdtl;
        this.frameSamples = frameSamples;
        this.init();
        this.setAbundanceScheme();
    }

    public FrameOverlay(GraphicsConfiguration gc, Frame parent, SBdb db, Overlay overlay, boolean showCMF, FrameSamples frameSamples) {
        this.initComponents();
        this.jPanelOverlay = new OverlayJPanel(db, overlay, null, null, showCMF);
        this.countManager = new TaxonCountManager(db, null, null);
        this.pControls = new JPanelOverlayControls(showCMF);
        this.well = null;
        this.smpdtl = null;
        this.frameSamples = frameSamples;
        this.init();
    }

    public void setSmpdtl(Well newWell, Smpdtl smpdtl) {
        this.jPanelOverlay.setSmpdtl(newWell, smpdtl);
        this.countManager.setSmpdtl(newWell, smpdtl);
        this.smpdtl = smpdtl;
        if (this.well == null || !this.well.equals(newWell)) {
            if (this.well != null) {
                this.well.deleteObserver(this);
            }
            this.well = newWell;
            this.well.addObserver(this);
        }
        this.setAbundanceScheme();
        if (smpdtl != null) {
            this.pControls.enableQSQSelection();
        }
        this.setTitle();
    }

    private void setTitle() {
        if (this.well != null) {
            Object title = "Overlay : ";
            if (this.jPanelOverlay.getOverlay() != null) {
                title = (String)title + this.jPanelOverlay.getOverlay().getName();
            }
            title = (String)title + " : " + this.well.getWellName();
            if (this.smpdtl != null) {
                try {
                    title = (String)title + " : " + this.smpdtl.getSample().toString() + " : " + this.smpdtl.getAnalystAbr() + (String)(this.smpdtl.getHeader().getAnalyNumber() > 1 ? "/" + this.smpdtl.getHeader().getAnalyNumber() : "");
                }
                catch (SQLException | SBException ex) {
                    ex.printStackTrace();
                }
            }
            this.setTitle((String)title);
        } else if (this.jPanelOverlay.getOverlay() != null) {
            this.setTitle("StrataBugs Overlay Designer: " + this.jPanelOverlay.getOverlay().getName());
        } else {
            this.setTitle("StrataBugs Overlay Designer");
        }
    }

    private void init() {
        this.setAlwaysOnTop(this.frameSamples == null ? true : this.frameSamples.overlayWindowOnTop);
        this.setMinimumSize(new Dimension(500, 300));
        BorderLayout bl = new BorderLayout();
        this.getContentPane().setLayout(bl);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.add((Component)this.jPanelOverlay, (Object)1);
        this.layeredPane.add((Component)this.numpadPanel, (Object)2);
        this.getContentPane().add((Component)this.layeredPane, "Center");
        this.numpadPanel.setVisible(false);
        this.numpadPanel.setFocusable(false);
        this.controlsPanel.setLayout(new CardLayout());
        this.controlsPanel.add((Component)this.pControls, "COUNT");
        this.controlsPanel.add((Component)this.pDesignControls, "DESIGN");
        this.controlsPanel.setFocusable(false);
        this.pControls.setFocusable(false);
        this.pDesignControls.setFocusable(false);
        this.getContentPane().add((Component)this.controlsPanel, "South");
        this.jPanelOverlay.addTaxonSelectionListener(this.pControls);
        if (this.well != null) {
            this.well.addObserver(this);
        }
        this.setTitle();
        LinkedList<Image> imageList = new LinkedList<Image>();
        for (String png : new String[]{"32Overlay.png", "24Overlay.png", "16Overlay.png"}) {
            imageList.add(Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/resources/frameicon/" + png)));
        }
        this.setIconImages(imageList);
        this.pack();
        this.layoutOverlayAndNumpad();
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.this$0.layoutOverlayAndNumpad();
            }
        });
        this.jPanelOverlay.setFocusable(false);
        this.setupKeyActions();
        this.jPanelOverlay.addTaxonDoubleClickListener(new ITaxonDoubleClickListener(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void taxonDoubleClicked(Taxon t, boolean isLeftMouseButton) {
                this.this$0.incrementTaxonCount(isLeftMouseButton ? 1 : -1);
            }
        });
        this.pControls.setListener(this);
        this.pDesignControls.setListener(this);
    }

    private void setupKeyActions() {
        InputMap im = this.getRootPane().getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), "incrementBy1");
        im.put(KeyStroke.getKeyStroke(127, 0), "decrementBy1");
        im.put(KeyStroke.getKeyStroke(107, 0), "setOutsideTheCount");
        im.put(KeyStroke.getKeyStroke(40, 0), "moveDown");
        im.put(KeyStroke.getKeyStroke(38, 0), "moveUp");
        im.put(KeyStroke.getKeyStroke(37, 0), "moveLeft");
        im.put(KeyStroke.getKeyStroke(39, 0), "moveRight");
        im.put(KeyStroke.getKeyStroke(81, 0), "toggleQuestionable");
        im.put(KeyStroke.getKeyStroke(82, 0), "toggleRework");
        im.put(KeyStroke.getKeyStroke(67, 0), "toggleCaved");
        im.put(KeyStroke.getKeyStroke(77, 0), "toggleMarker");
        im.put(KeyStroke.getKeyStroke(8, 0), "numpadClear");
        ActionMap am = this.getRootPane().getActionMap();
        am.put("incrementBy1", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.incrementTaxonCount(1);
            }
        });
        am.put("decrementBy1", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.incrementTaxonCount(-1);
            }
        });
        am.put("setOutsideTheCount", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.setOutsideTheCount();
            }
        });
        am.put("moveDown", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jPanelOverlay.moveSelectionDown();
            }
        });
        am.put("moveUp", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jPanelOverlay.moveSelectionUp();
            }
        });
        am.put("moveLeft", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jPanelOverlay.moveSelectionLeft();
            }
        });
        am.put("moveRight", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jPanelOverlay.moveSelectionRight();
            }
        });
        am.put("toggleQuestionable", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.pControls.toggleQuestionable();
            }
        });
        am.put("toggleRework", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.pControls.toggleReworked();
            }
        });
        am.put("toggleCaved", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.pControls.toggleCaved();
            }
        });
        am.put("toggleMarker", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.pControls.toggleMarker();
            }
        });
        am.put("numpadClear", new AbstractAction(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.numpadPanel.setPlaceholderNumber();
            }
        });
        for (final char c : Arrays.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0'), Character.valueOf('-'))) {
            im.put(KeyStroke.getKeyStroke(c), "numpad" + c);
            am.put("numpad" + c, new AbstractAction(this){
                final /* synthetic */ FrameOverlay this$0;
                {
                    FrameOverlay frameOverlay = this$0;
                    Objects.requireNonNull(frameOverlay);
                    this.this$0 = frameOverlay;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!this.this$0.numpadPanel.isVisible()) {
                        this.this$0.numpadPanel.setVisible(true);
                        this.this$0.pControls.setNumpadButtonHighlighted();
                    }
                    this.this$0.numpadPanel.appendNumber(c);
                }
            });
        }
    }

    Overlay getOverlay() {
        if (this.jPanelOverlay == null) {
            return null;
        }
        return this.jPanelOverlay.getOverlay();
    }

    UndoableEditSupport getUndoSupport() {
        if (this.countManager == null) {
            return null;
        }
        return this.countManager.getUndoSupport();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                this.this$0.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                this.this$0.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ FrameOverlay this$0;
            {
                FrameOverlay frameOverlay = this$0;
                Objects.requireNonNull(frameOverlay);
                this.this$0 = frameOverlay;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.formKeyPressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 852, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 636, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.jPanelOverlay.close();
        if (this.well != null) {
            this.well.deleteObserver(this);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            if (this.jPanelOverlay.getOverlay().mapChanged()) {
                if (JOptionPane.showConfirmDialog(this, "Save changes to overlay?", this.getTitle(), 0, 3) == 0) {
                    this.jPanelOverlay.getOverlay().storeMap();
                    this.jPanelOverlay.commit();
                } else {
                    this.jPanelOverlay.getOverlay().reload();
                }
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.jPanelOverlay != null) {
            this.jPanelOverlay.repaint();
        }
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    void setCMF(boolean cmf) {
        if (cmf) {
            this.pControls.displaySizeFactors();
        } else {
            this.pControls.hideSizeFactors();
        }
        this.pControls.invalidate();
        this.pControls.repaint();
    }

    private void setAbundanceScheme() {
        if (this.smpdtl == null) {
            this.pControls.clearAbundanceScheme();
            return;
        }
        try {
            AbundanceScheme scheme = SbugsSession.getDb().getAbundanceSchemeService().findAbundanceScheme(this.smpdtl.getHeader().getAbnSchID()).orElse(null);
            this.pControls.setAbundanceScheme(scheme);
        }
        catch (RuntimeException ex) {
            Logger.getLogger(FrameOverlay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setOutsideTheCount() {
        try {
            Taxon t = this.jPanelOverlay.getSelectedTaxon();
            if (t == null) {
                return;
            }
            this.countManager.addOutsideTheCountOcc(t, this.pControls.getSituation(), this.pControls.isQuestionable(), this.pControls.isMkr());
        }
        catch (SQLException | SBException ex) {
            Logger.getLogger(FrameOverlay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void incrementTaxonCount(int increment) {
        if (this.smpdtl == null) {
            return;
        }
        try {
            Taxon t = this.jPanelOverlay.getSelectedTaxon();
            if (t == null) {
                return;
            }
            if (!this.numpadPanel.isPlaceholderNumber()) {
                increment = this.numpadPanel.getIncrementNumber();
            }
            if (this.pControls.isQuantativeMode()) {
                this.countManager.addQuantitativeCount(t, this.pControls.getSelectedSize(), increment, this.pControls.getSituation(), this.pControls.isQuestionable(), this.pControls.isMkr());
            } else {
                if (SbugsSession.getDb().getAbundanceSchemeService().findAbundanceScheme(this.smpdtl.getHeader().getAbnSchID()).isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Select abundance scheme for suite", "Overlay", 1);
                    this.getToolkit().beep();
                    return;
                }
                this.countManager.setSemiQuantCount(t, this.pControls.getSituation(), this.pControls.isQuestionable(), this.pControls.isMkr(), this.pControls.isCaved(), this.pControls.getAbundanceEntry());
            }
            if (this.pControls.isQuantativeMode()) {
                this.numpadPanel.setPlaceholderNumber();
            }
            if (this.frameSamples.playOccSounds()) {
                this.playSound();
            }
        }
        catch (SQLException | SBException ex) {
            Logger.getLogger(FrameOverlay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void onDesignToggle() {
        this.pDesignControls.setShowImages(this.jPanelOverlay.getOverlay().showImages());
        CardLayout cl = (CardLayout)this.controlsPanel.getLayout();
        cl.next(this.controlsPanel);
        this.jPanelOverlay.setDesignMode();
    }

    @Override
    public void onEnterPressed() {
        this.incrementTaxonCount(1);
    }

    private void playSound() {
        this.soundClip = SB.playSound((Frame)this.frameSamples, (Clip)this.soundClip, (String)"/resources/wav/Swat.wav", (String)"win.sound.exclamation");
    }

    @Override
    public void imagesDisplayChanged(boolean visible) {
        this.jPanelOverlay.getOverlay().setImages(visible);
        this.repaint();
    }

    @Override
    public void numpadDisplayChanged(boolean visible) {
        this.numpadPanel.setVisible(visible);
        this.jPanelOverlay.repaint();
    }

    @Override
    public void showTaxonImagesChanged(boolean shown) {
        this.imagesDisplayChanged(shown);
    }

    @Override
    public void okButtonClicked() {
        this.jPanelOverlay.overlayEditOk();
        this.switchToCountControls();
    }

    @Override
    public void cancelButtonClicked() {
        this.jPanelOverlay.overlayEditCancel();
        this.switchToCountControls();
        this.jPanelOverlay.repaint();
    }

    public void switchToCountControls() {
        this.pControls.setShowImages(this.jPanelOverlay.getOverlay().showImages());
        CardLayout cl = (CardLayout)this.controlsPanel.getLayout();
        cl.next(this.controlsPanel);
        this.jPanelOverlay.setCountMode();
    }

    @Override
    public void removeSelectedClick() {
        this.jPanelOverlay.removeSelectedTaxon();
    }

    @Override
    public void autoArrangeClick() {
        this.jPanelOverlay.autoArrange();
    }

    @Override
    public void setInsertByRow() {
        this.jPanelOverlay.setInsertRowMode();
    }

    @Override
    public void setInsertByColumn() {
        this.jPanelOverlay.setInsertColumnMode();
    }

    void setDesignMode() {
        this.pDesignControls.setShowImages(this.jPanelOverlay.getOverlay().showImages());
        CardLayout cl = (CardLayout)this.controlsPanel.getLayout();
        cl.show(this.controlsPanel, "DESIGN");
        this.jPanelOverlay.setDesignMode();
    }

    private void layoutOverlayAndNumpad() {
        this.jPanelOverlay.setBounds(0, 0, this.layeredPane.getWidth(), this.layeredPane.getHeight());
        Dimension pref = this.numpadPanel.getPreferredSize();
        this.numpadPanel.setBounds(this.layeredPane.getWidth() - pref.width, this.layeredPane.getHeight() - pref.height, pref.width, pref.height);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o != null && o.equals(this.well)) {
            if (arg != null && this.smpdtl != null && arg.equals(this.smpdtl.getHeader())) {
                this.setAbundanceScheme();
            }
            this.setTitle();
        }
    }
}

