/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import jsbchart.block.LocationBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.panel.PanelProjectLocation;
import jsbugs.ChartJPanel;
import jsbugs.DialogProjectLocProps;
import jsbugs.FrameJsbugs;
import jsbugs.GUI;
import jsbugs.util.SBFrame;
import model3.SBdb;
import model3.Well;
import model3.project.WellList;
import util.SBException;
import util.exception.StackError;

public class FrameProjectLocation
extends SBFrame {
    private static final String[] FRAME_ICONS = new String[]{"16Map.png", "24Map.png", "32Map.png", "48Map.png"};
    WellList wellList;
    ChartJPanel chartJPanel;
    Chart chart;
    SBdb sbdb;
    FrameJsbugs parent;
    final float zoomIncrement = 1.5f;
    float zoom = 1.0f;
    private JButton jButtonProperties;
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JLabel jLabelInfo;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemClose;
    private JMenuItem jMenuItemHelp;
    private JMenuItem jMenuItemPrint;
    private JScrollPane jScrollPaneProjectLocation;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;

    public FrameProjectLocation(FrameJsbugs parent, SBdb sbdb, WellList wellList) {
        this.parent = parent;
        this.sbdb = sbdb;
        this.wellList = wellList;
        this.initComponents();
        this.init();
    }

    private void init() {
        super.init("Sidetrack Chart : " + this.wellList.getName(), FRAME_ICONS);
        this.setupChart();
        this.jLabelInfo.setText("");
    }

    private void setupChart() {
        if (this.chart == null) {
            PanelProjectLocation panel;
            this.chart = new Chart();
            ChartProperties chartProperties = this.chart.getProperties();
            chartProperties.setPanelCaptionHeight(0.0f);
            chartProperties.setPanelHeaderHeight(0.0f);
            chartProperties.setMargin(10.0f);
            this.chartJPanel = new ChartJPanel(this.chart);
            this.jScrollPaneProjectLocation.getViewport().add(this.chartJPanel);
            LocationBlock block = new LocationBlock(this.sbdb);
            Well wellIndex = null;
            try {
                wellIndex = this.sbdb.getWellIterator(this.wellList.getID()).next();
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            block.panel = panel = new PanelProjectLocation(this.wellList, wellIndex, block);
            this.chart.addBlock(block);
            this.chart.getProperties().setPanelHeaderHeight(20.0f);
            this.chart.doLayout();
            this.chartJPanel.setSize();
            this.chartJPanel.addMouseMotionListener(new MouseMotionAdapter(this){
                final /* synthetic */ FrameProjectLocation this$0;
                {
                    FrameProjectLocation frameProjectLocation = this$0;
                    Objects.requireNonNull(frameProjectLocation);
                    this.this$0 = frameProjectLocation;
                }

                @Override
                public void mouseMoved(MouseEvent evt) {
                    this.this$0.chartJPanelMouseMoved(evt);
                }
            });
        } else {
            PanelProjectLocation panel;
            LocationBlock block = (LocationBlock)this.chart.getBlocks().get(0);
            Well wellIndex = block.panel.getWellIndex();
            char units = block.panel.getUnits();
            block.clearPanel();
            block.panel = panel = new PanelProjectLocation(this.wellList, wellIndex, block);
            panel.setUnits(units);
        }
        this.chartJPanel.repaint();
    }

    public void setProject(WellList wellList) {
        this.wellList = wellList;
        this.setupChart();
    }

    private void chartJPanelMouseMoved(MouseEvent evt) {
        try {
            Point2D.Float cursorLoc = this.chartJPanel.getPoint(evt.getPoint());
            String string = this.chartJPanel.getTooltip(evt);
            if (cursorLoc.y < this.chart.getProperties().getPanelHeaderHeight() + this.chart.getProperties().margin) {
                string = "";
            }
            this.jLabelInfo.setText(string);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonProperties = new JButton();
        this.jScrollPaneProjectLocation = new JScrollPane();
        this.jToolBar2 = new JToolBar();
        this.jLabelInfo = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemPrint = new JMenuItem();
        this.jMenuItemClose = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemHelp = new JMenuItem();
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomIn24.png")));
        this.jButtonZoomIn.setFocusable(false);
        this.jButtonZoomIn.setHorizontalTextPosition(0);
        this.jButtonZoomIn.setVerticalTextPosition(3);
        this.jButtonZoomIn.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameProjectLocation this$0;
            {
                FrameProjectLocation frameProjectLocation = this$0;
                Objects.requireNonNull(frameProjectLocation);
                this.this$0 = frameProjectLocation;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomOut24.png")));
        this.jButtonZoomOut.setFocusable(false);
        this.jButtonZoomOut.setHorizontalTextPosition(0);
        this.jButtonZoomOut.setVerticalTextPosition(3);
        this.jButtonZoomOut.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameProjectLocation this$0;
            {
                FrameProjectLocation frameProjectLocation = this$0;
                Objects.requireNonNull(frameProjectLocation);
                this.this$0 = frameProjectLocation;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomOut);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonProperties.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_ChartProperties.png")));
        this.jButtonProperties.setToolTipText("Properties...");
        this.jButtonProperties.setFocusable(false);
        this.jButtonProperties.setHorizontalTextPosition(0);
        this.jButtonProperties.setVerticalTextPosition(3);
        this.jButtonProperties.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameProjectLocation this$0;
            {
                FrameProjectLocation frameProjectLocation = this$0;
                Objects.requireNonNull(frameProjectLocation);
                this.this$0 = frameProjectLocation;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPropertiesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonProperties);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jLabelInfo.setText("~~~~~~~");
        this.jToolBar2.add(this.jLabelInfo);
        this.jMenuFile.setText("File");
        this.jMenuItemPrint.setText("Print...");
        this.jMenuItemPrint.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameProjectLocation this$0;
            {
                FrameProjectLocation frameProjectLocation = this$0;
                Objects.requireNonNull(frameProjectLocation);
                this.this$0 = frameProjectLocation;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPrintActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemPrint);
        this.jMenuItemClose.setText("Close");
        this.jMenuItemClose.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameProjectLocation this$0;
            {
                FrameProjectLocation frameProjectLocation = this$0;
                Objects.requireNonNull(frameProjectLocation);
                this.this$0 = frameProjectLocation;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCloseActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemClose);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuHelp.setText("Help");
        this.jMenuItemHelp.setText("Help with project mapping...");
        this.jMenuItemHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameProjectLocation this$0;
            {
                FrameProjectLocation frameProjectLocation = this$0;
                Objects.requireNonNull(frameProjectLocation);
                this.this$0 = frameProjectLocation;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelp);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, GroupLayout.Alignment.TRAILING, -1, 664, Short.MAX_VALUE).addComponent(this.jScrollPaneProjectLocation, -1, 664, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jToolBar2, -1, 644, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneProjectLocation, -1, 480, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar2, -2, 20, -2)));
        this.pack();
    }

    private void jMenuItemCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        DialogProjectLocProps dialog = new DialogProjectLocProps(this, true, this.sbdb, this.wellList, this.chartJPanel.chart.getLocationBlock().getPanel(), (LocationBlock)this.chart.getBlocks().get(0));
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.setupChart();
        }
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom *= 1.5f;
        GUI.setScrollPaneSize(this.chartJPanel, this.zoom, 1.5f);
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom /= 1.5f;
        GUI.setScrollPaneSize(this.chartJPanel, this.zoom, 1.5f);
    }

    private void jMenuItemPrintActionPerformed(ActionEvent evt) {
        PrinterJob job;
        if (this.chart == null) {
            JOptionPane.showMessageDialog(this, "Problem printing: null chart");
        }
        if (!(job = PrinterJob.getPrinterJob()).printDialog()) {
            return;
        }
        PageFormat pf = job.defaultPage();
        PageFormat newPf = null;
        newPf = job.pageDialog(pf);
        if (newPf == pf) {
            return;
        }
        job.setPrintable(new ChartJPanel(this.chart), newPf);
        try {
            job.print();
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(this, "Problem printing");
            exp.printStackTrace();
        }
    }

    private void jMenuItemHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("projectmapping.html");
    }
}

