/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.ui.HelpUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import jsbchart.core.ChartTemplate;
import jsbchart.graphics.map.CrsCode;
import jsbugs.DialogCreateDatabase;
import jsbugs.DialogList;
import jsbugs.DialogPermissions;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectProjectWellList;
import jsbugs.DialogTVD;
import jsbugs.DialogTWT;
import jsbugs.DialogTable;
import jsbugs.FrameJsbugs;
import jsbugs.FrameProjectLocation;
import jsbugs.FrameWellsSession;
import jsbugs.TableModelProjectMembership;
import jsbugs.chart.WellSelectionMapJPanel;
import jsbugs.list.WellsListRenderer;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.SBFrame;
import jsbugs.util.UserPrefsHelper;
import jsbugs.wellheader.DialogSelectWell;
import jsbugs.wellheader.DialogWell;
import jsbugs.wells.DialogCasing;
import jsbugs.wells.DialogCores;
import jsbugs.wells.DialogCurves;
import jsbugs.wells.DialogIntLith;
import jsbugs.wells.DialogMarkers;
import jsbugs.wells.FrameWellsListTransferHandler;
import jsbugs.wells.ModelessWellInfoDialog;
import model3.Lastval;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Well;
import model3.WellHeader;
import model3.project.Project;
import model3.project.ProjectObserver;
import model3.project.WellList;
import model3.project.WellListObserver;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;

public class FrameWells
extends SBFrame
implements Observer,
WellListObserver,
ProjectObserver {
    private static Logger LOGGER = Logger.getLogger(FrameWells.class.getName());
    private static final int DEFAULT_WIDTH_PX = 800;
    private static final int DEFAULT_HEIGHT_PX = 600;
    private final SBdb sbdb;
    final FrameJsbugs parent;
    private final DefaultListModel<Well> listModelWells = new DefaultListModel();
    private final DefaultComboBoxModel comboBoxModelProjects = new DefaultComboBoxModel();
    private final DefaultComboBoxModel comboBoxModelWellLists = new DefaultComboBoxModel();
    private final WellsListRenderer listRenderer = new WellsListRenderer();
    private final ModelessDialogList<DialogCores> coresDialogs = new ModelessDialogList<DialogCores>(this){
        final /* synthetic */ FrameWells this$0;
        {
            FrameWells frameWells = this$0;
            Objects.requireNonNull(frameWells);
            this.this$0 = frameWells;
            super(this$0);
        }

        @Override
        DialogCores newDialog(Well well) throws SQLException, SBException {
            return new DialogCores((Frame)this.this$0, false, well);
        }
    };
    private final ModelessDialogList<DialogCasing> casingDialogs = new ModelessDialogList<DialogCasing>(this){
        final /* synthetic */ FrameWells this$0;
        {
            FrameWells frameWells = this$0;
            Objects.requireNonNull(frameWells);
            this.this$0 = frameWells;
            super(this$0);
        }

        @Override
        DialogCasing newDialog(Well well) throws SQLException, SBException {
            return new DialogCasing((Frame)this.this$0, false, well);
        }
    };
    private final ModelessDialogList<DialogMarkers> markersDialogs = new ModelessDialogList<DialogMarkers>(this){
        final /* synthetic */ FrameWells this$0;
        {
            FrameWells frameWells = this$0;
            Objects.requireNonNull(frameWells);
            this.this$0 = frameWells;
            super(this$0);
        }

        @Override
        DialogMarkers newDialog(Well well) throws SQLException, SBException {
            return new DialogMarkers((Frame)this.this$0, false, well);
        }
    };
    private final ModelessDialogList<DialogCurves> curvesDialogs = new ModelessDialogList<DialogCurves>(this){
        final /* synthetic */ FrameWells this$0;
        {
            FrameWells frameWells = this$0;
            Objects.requireNonNull(frameWells);
            this.this$0 = frameWells;
            super(this$0);
        }

        @Override
        DialogCurves newDialog(Well well) throws SQLException, SBException {
            return new DialogCurves((Frame)this.this$0, false, well);
        }
    };
    private final ModelessDialogList<DialogIntLith> lithologyDialogs = new ModelessDialogList<DialogIntLith>(this){
        final /* synthetic */ FrameWells this$0;
        {
            FrameWells frameWells = this$0;
            Objects.requireNonNull(frameWells);
            this.this$0 = frameWells;
            super(this$0);
        }

        @Override
        DialogIntLith newDialog(Well well) throws SQLException, SBException {
            return new DialogIntLith((Frame)this.this$0, false, this.this$0.sbdb, well);
        }
    };
    FrameProjectLocation frameProjectLocation = null;
    private boolean mapVisible = true;
    private WellSelectionMapJPanel wsmp;
    private UserPrefsHelper userPrefsHelper;
    private boolean sortSidetracks = true;
    private JMenuItem jMenuItemShowMap;
    private JMenuItem jMenuItemHideMap;
    private JMenu jMenuSelectionMapProjection = new JMenu("Map projection");
    private JRadioButtonMenuItem jRadioButtonMenuItemSelectionMapProjectionMercator = new JRadioButtonMenuItem("Mercator");
    private JRadioButtonMenuItem jRadioButtonMenuItemSelectionMapProjectionWGS84 = new JRadioButtonMenuItem("WGS 84");
    private JButton jButtonProjects;
    private JButton jButtonSelectWell;
    private JButton jButtonResetMap;
    private JButton jButtonWellList;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxWellList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList<Well> jListWells;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenuItem jMenuItemAddWell;
    private JMenuItem jMenuItemClose;
    private JMenuItem jMenuItemCreateDatabase;
    private JMenuItem jMenuItemHelp;
    private JMenuItem jMenuItemKml;
    private JMenuItem jMenuItemProjectPlan;
    private JMenuItem jMenuItemSelectWell;
    private JMenu jMenuProject;
    private JMenu jMenuWells;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenuWells;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator3;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;

    public FrameWells(FrameJsbugs parent, SBdb sbdb) throws SQLException, SBException {
        this(parent, sbdb, true);
    }

    public FrameWells(FrameJsbugs parent, SBdb sbdb, boolean restoreProject) throws SQLException, SBException {
        this.sbdb = sbdb;
        this.userPrefsHelper = new UserPrefsHelper(sbdb);
        this.parent = parent;
        this.initComponents();
        this.init(restoreProject);
    }

    final void init(boolean restoreProject) throws SQLException, SBException {
        this.setTitle("Wells & Outcrops - StrataBugs");
        this.setIcons();
        this.initWellsMenus();
        this.jListWells.setCellRenderer(this.listRenderer);
        this.loadList();
        this.jListWells.setModel(this.listModelWells);
        this.listModelWells.addListDataListener(new ListDataListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.this$0.setListRendererIcons();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.this$0.setListRendererIcons();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.this$0.setListRendererIcons();
            }
        });
        this.jListWells.setTransferHandler(new FrameWellsListTransferHandler(this::importCurves));
        this.jListWells.setVisibleRowCount(10);
        this.jListWells.repaint();
        this.updateProjectList();
        this.jComboBoxProject.setModel(this.comboBoxModelProjects);
        this.jComboBoxProject.repaint();
        this.jComboBoxWellList.setModel(this.comboBoxModelWellLists);
        this.jComboBoxWellList.repaint();
        this.jListWells.addListSelectionListener(e -> this.wellListSelectionChanged(e));
        this.jToolBar1.setFloatable(false);
        this.centreOnScreen();
        this.setSize(800, 600);
        this.decodeSession(restoreProject);
        this.setUpAndAddWellSelectionMapPanel();
    }

    private void setUpAndAddWellSelectionMapPanel() {
        this.wsmp = new WellSelectionMapJPanel();
        try {
            Project project = this.getProjectSelection().orElse(null);
            this.wsmp.setup(project != null ? Integer.valueOf(project.getID()) : null);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while setting up well selection map panel.", e);
            return;
        }
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.wsmp);
        this.wsmp.setWellsListModel(this.jListWells.getModel());
        this.wsmp.setSelectionModel(this.jListWells.getSelectionModel());
        this.wsmp.setWellPopupMenuHandler(this::showPopupMenuWells);
        this.wsmp.setWellDoubleClickHandler(this::openSamplesForWellList);
        this.jSplitPane1.setRightComponent(jsp);
        this.jSplitPane1.getLeftComponent().setMinimumSize(new Dimension(200, 100));
        JMenu jMenuView = new JMenu("View");
        this.jMenuItemHideMap = new JMenuItem("Hide Map");
        this.jMenuItemHideMap.addActionListener(a -> this.hideMap());
        jMenuView.add(this.jMenuItemHideMap);
        this.jMenuItemShowMap = new JMenuItem("Show Map");
        this.jMenuItemShowMap.addActionListener(a -> this.showMap());
        jMenuView.add(this.jMenuItemShowMap);
        if (this.sbdb != null && this.sbdb.isConnected()) {
            JMenuItem jMenuItemSetMapBackground = new JMenuItem("Select map background...");
            jMenuItemSetMapBackground.addActionListener(a -> {
                this.wsmp.showBackgroundSelectDialog();
                this.updateProjectionRadioButtons();
            });
            jMenuView.add(jMenuItemSetMapBackground);
            JMenuItem jMenuItemResetMapBackground = new JMenuItem("Reset map background");
            jMenuItemResetMapBackground.addActionListener(a -> {
                this.wsmp.resetMapBackground();
                this.updateProjectionRadioButtons();
            });
            jMenuView.add(jMenuItemResetMapBackground);
            this.jRadioButtonMenuItemSelectionMapProjectionWGS84.setSelected(this.wsmp.isWGS84Projection());
            this.jRadioButtonMenuItemSelectionMapProjectionMercator.setSelected(!this.wsmp.isWGS84Projection());
            this.jMenuSelectionMapProjection.add(this.jRadioButtonMenuItemSelectionMapProjectionWGS84);
            this.jRadioButtonMenuItemSelectionMapProjectionWGS84.addActionListener(a -> this.onSelectionProjectionWGS84());
            this.jMenuSelectionMapProjection.add(this.jRadioButtonMenuItemSelectionMapProjectionMercator);
            this.jRadioButtonMenuItemSelectionMapProjectionMercator.addActionListener(a -> this.onSelectionProjectionMercator());
            jMenuView.add(this.jMenuSelectionMapProjection);
            JMenuItem jMenuMaxWellLabels = new JMenuItem("Set well label threshold ... (currently " + this.wsmp.getMaxWellsToShowLabels() + ")");
            jMenuView.add(jMenuMaxWellLabels);
            jMenuMaxWellLabels.addActionListener(a -> {
                String wellLabelLimit = JOptionPane.showInputDialog(this, "Enter the maximum number of labelled wells: ", this.wsmp.getMaxWellsToShowLabels());
                try {
                    this.wsmp.setMaxWellsToShowLabels(Integer.parseInt(wellLabelLimit));
                    jMenuMaxWellLabels.setText("Set well label threshold ... (currently " + this.wsmp.getMaxWellsToShowLabels() + ")");
                    this.wsmp.checkNumberOfWellsAndSetLabelsIfNeeded();
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Enter a valid number", "Input error", 2);
                }
            });
            jMenuView.add(jMenuMaxWellLabels);
        }
        this.jMenuBar1.add(jMenuView);
        if (!this.mapVisible) {
            this.jPanel1.remove(this.jSplitPane1);
            this.jPanel1.add(this.jScrollPane1);
            this.wsmp.disableUpdates();
        } else {
            this.wsmp.updateWellList();
            this.wsmp.resetMapBounds();
            this.wsmp.enableUpdates();
        }
        this.jMenuItemShowMap.setVisible(!this.mapVisible);
        this.jMenuItemHideMap.setVisible(this.mapVisible);
        this.jButtonResetMap.setVisible(this.mapVisible);
    }

    private void onSelectionProjectionWGS84() {
        try {
            this.wsmp.setMapCRS(CrsCode.WGS84);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception while trying to change the selection map CRS to WGS84", e);
        }
        this.updateProjectionRadioButtons();
        this.wsmp.repaint();
    }

    private void onSelectionProjectionMercator() {
        try {
            this.wsmp.setMapCRS(CrsCode.MERCATOR);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception while trying to change the selection map CRS to Mercator", e);
        }
        this.updateProjectionRadioButtons();
        this.wsmp.repaint();
    }

    private void updateProjectionRadioButtons() {
        if (this.wsmp.getBlock().getProp().getCrsCode() == CrsCode.WGS84) {
            this.jRadioButtonMenuItemSelectionMapProjectionWGS84.setSelected(true);
            this.jRadioButtonMenuItemSelectionMapProjectionMercator.setSelected(false);
        } else {
            this.jRadioButtonMenuItemSelectionMapProjectionWGS84.setSelected(false);
            this.jRadioButtonMenuItemSelectionMapProjectionMercator.setSelected(true);
        }
    }

    private void wellListSelectionChanged(ListSelectionEvent e) {
        if (!this.jListWells.getSelectionModel().isSelectionEmpty()) {
            this.jListWells.ensureIndexIsVisible(this.jListWells.getSelectedIndex());
        }
    }

    private void hideMap() {
        this.jPanel1.remove(this.jSplitPane1);
        this.jPanel1.add(this.jScrollPane1);
        this.jButtonResetMap.setVisible(false);
        this.jMenuItemHideMap.setVisible(false);
        this.jMenuItemShowMap.setVisible(true);
        this.mapVisible = false;
        this.jListWells.setVisibleRowCount(10);
        this.wsmp.disableUpdates();
        this.pack();
        this.repaint();
    }

    private void showMap() {
        this.jPanel1.remove(this.jScrollPane1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jPanel1.add(this.jSplitPane1);
        this.jButtonResetMap.setVisible(true);
        this.jMenuItemHideMap.setVisible(true);
        this.jMenuItemShowMap.setVisible(false);
        this.mapVisible = true;
        this.pack();
        this.setSize(800, 600);
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.wsmp.updateWellList();
            this.wsmp.resetMapBounds();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.wsmp.enableUpdates();
        this.repaint();
    }

    private void setIcons() {
        this.setMultiResIconImage("frameWells.svg");
        if (SbugsSession.getSession().useHiResIcons()) {
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonSelectWell, "searchWells.svg")));
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonResetMap, "zoom-to-extents.svg")));
        }
    }

    private void setListRendererIcons() {
        boolean hasLocked = false;
        boolean hasColours = false;
        boolean hasLocations = false;
        for (int i = 0; i < this.jListWells.getModel().getSize(); ++i) {
            Well w = this.jListWells.getModel().getElementAt(i);
            try {
                if (!hasLocked && w.isReadOnly()) {
                    hasLocked = true;
                }
            }
            catch (SBException e) {
                throw new RuntimeException(e);
            }
            if (!hasColours && !Color.BLACK.equals(w.getHeader().getColour())) {
                hasColours = true;
            }
            if (hasLocations || !w.getHeader().hasLocation()) continue;
            hasLocations = true;
        }
        this.listRenderer.setIcons(new WellsListRenderer.WellsListIcons(hasLocked, hasLocations, hasColours));
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs instanceof Well && obj instanceof WellHeader || obs instanceof Well && obj instanceof com.stratadata.model3.well.WellHeader) {
                this.loadList();
                this.jListWells.repaint();
            }
        }
        catch (RuntimeException | SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    @Override
    public void projectWellListsChanged(Project project) {
        if (project == this.jComboBoxProject.getSelectedItem()) {
            try {
                this.loadList();
            }
            catch (RuntimeException | SQLException | SBException sql) {
                SbugsExceptionHandler.showStackError(sql);
            }
        }
    }

    private void updateProjectList() throws SQLException {
        Object selection = this.jComboBoxProject.getSelectedItem();
        this.comboBoxModelProjects.removeAllElements();
        ProjectUtils.loadProjectCombo(this.sbdb, this.comboBoxModelProjects, true);
        this.jComboBoxProject.setSelectedItem(selection);
        Project project = this.jComboBoxProject.getSelectedItem() instanceof Project ? (Project)((Object)this.jComboBoxProject.getSelectedItem()) : null;
        this.jComboBoxWellList.removeAllItems();
        if (project != null) {
            ProjectUtils.loadWellListCombo(this.sbdb.getWellListService(), this.comboBoxModelWellLists, true, project.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList() throws SQLException, SBException {
        long start;
        block10: {
            start = System.currentTimeMillis();
            try {
                Iterator<Well> wellIt;
                WellList wellList;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.listModelWells.clear();
                Project project = this.jComboBoxProject.getSelectedItem() instanceof Project ? (Project)((Object)this.jComboBoxProject.getSelectedItem()) : null;
                WellList wellList2 = wellList = this.jComboBoxWellList.getSelectedItem() instanceof WellList ? (WellList)((Object)this.jComboBoxWellList.getSelectedItem()) : null;
                if (project == null) break block10;
                project.addListener(this);
                if (wellList == null) {
                    wellIt = this.sbdb.getWellService().getProjectWells(project.getID());
                } else {
                    wellList.addListener(this);
                    wellIt = this.sbdb.getWellIterator(wellList.getID());
                }
                List<Well> wells = new ArrayList<Well>();
                while (wellIt.hasNext()) {
                    Well well = wellIt.next();
                    well.addObserver(this);
                    wells.add(well);
                }
                if (this.sortSidetracks) {
                    try {
                        wells = new SidetrackSorter(this).sortSidetracks(wells);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error sorting wells with sidetracks: " + e.getMessage());
                    }
                }
                this.listModelWells.addAll(wells);
                if (this.listModelWells.getSize() == 1) {
                    this.jListWells.setSelectedIndex(0);
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        LOGGER.log(Level.FINE, "FrameWells.loadList() in {0}", new Object[]{System.currentTimeMillis() - start});
    }

    private void loadList(List<Well> selection) {
        this.listModelWells.clear();
        for (Well well : selection) {
            this.listModelWells.addElement(well);
            well.addObserver(this);
        }
        if (this.listModelWells.getSize() == 1) {
            this.jListWells.setSelectedIndex(0);
        }
    }

    private boolean checkSelection() {
        if (this.jListWells.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select well/outcrop(s)", this.getTitle(), 2);
            return false;
        }
        return true;
    }

    private Well getSelection() {
        List<Well> selection = this.jListWells.getSelectedValuesList();
        if (selection.size() != 1) {
            JOptionPane.showMessageDialog(this, "Select one well only", this.getTitle(), 2);
            return null;
        }
        return selection.get(0);
    }

    private Optional<Project> getProjectSelection() {
        Project p;
        Object object = this.jComboBoxProject.getSelectedItem();
        return Optional.ofNullable(object instanceof Project ? (p = (Project)((Object)object)) : null);
    }

    private Optional<WellList> getWellListSelection() {
        WellList l;
        Object object = this.jComboBoxWellList.getSelectedItem();
        return Optional.ofNullable(object instanceof WellList ? (l = (WellList)((Object)object)) : null);
    }

    private void initWellsMenus() {
        this.initMenuItem("Edit header...", WellsMenuItem.ListSelectionCondition.SINGLE_WELL, new FunctionalAction(ae -> this.editHeader()));
        this.initMenuItem("Remove from well list...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, WellsMenuItem.ProjectSelectionCondition.ANY, new FunctionalAction(ae -> this.removeWell(false)));
        this.initMenuItem("Remove from project...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, WellsMenuItem.ProjectSelectionCondition.PROJECT, new FunctionalAction(ae -> this.removeWell(true)));
        this.initMenuItem("Delete", WellsMenuItem.ListSelectionCondition.MULTI_WELL, new FunctionalAction(ae -> this.deleteWell()));
        this.initMenuItem("Permissions...", WellsMenuItem.ListSelectionCondition.SINGLE_WELL, new FunctionalAction(ae -> this.permissions()));
        this.initMenuItem("Project / well list membership...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, new FunctionalAction(ae -> this.projectMembership()));
        this.initMenuSeparator();
        this.initMenuItem("Samples & Interpretations...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, WellsMenuItem.ProjectSelectionCondition.ANY, new FunctionalAction(ae -> this.openSamples()), new ImageIcon(this.getClass().getResource("/resources/frameicon/16Samples.png")), true);
        this.initMenuItem("Cored intervals...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, new FunctionalAction(ae -> this.cores()));
        this.initMenuItem("Casing...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, new FunctionalAction(ae -> this.casing()));
        this.initMenuItem("Wireline logs...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, new FunctionalAction(ae -> this.curves()));
        this.initMenuItem("Lithology...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, new FunctionalAction(ae -> this.lithology()));
        this.initMenuItem("Seismic markers...", WellsMenuItem.ListSelectionCondition.MULTI_WELL, new FunctionalAction(ae -> this.markers()));
        this.initMenuItem("Deviation survey (TVD)...", WellsMenuItem.ListSelectionCondition.SINGLE_WELL, new FunctionalAction(ae -> this.tvd()));
        this.initMenuItem("Two way time (TWT)...", WellsMenuItem.ListSelectionCondition.SINGLE_WELL, new FunctionalAction(ae -> this.twt()));
        this.initMenuSeparator();
        this.initMenuItem("Save as well list...", WellsMenuItem.ListSelectionCondition.ANY, new FunctionalAction(ae -> this.saveAsWellList()));
    }

    private void initMenuItem(String text, WellsMenuItem.ListSelectionCondition sc, AbstractAction action) {
        this.initMenuItem(text, sc, WellsMenuItem.ProjectSelectionCondition.ANY, action, null, false);
    }

    private void initMenuItem(String text, WellsMenuItem.ListSelectionCondition sc, WellsMenuItem.ProjectSelectionCondition pc, AbstractAction action) {
        this.initMenuItem(text, sc, pc, action, null, false);
    }

    private void initMenuItem(String text, WellsMenuItem.ListSelectionCondition sc, WellsMenuItem.ProjectSelectionCondition pc, AbstractAction action, Icon icon, boolean boldFont) {
        this.jMenuWells.add(new WellsMenuItem(text, sc, pc, action, icon, boldFont));
        this.jPopupMenuWells.add(new WellsMenuItem(text, sc, pc, action, icon, boldFont));
    }

    private void initMenuSeparator() {
        this.jMenuWells.add(new JPopupMenu.Separator());
        this.jPopupMenuWells.add(new JPopupMenu.Separator());
    }

    private void initComponents() {
        this.jPopupMenuWells = new JPopupMenu();
        this.jComboBoxProject = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jButtonProjects = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxWellList = new JComboBox();
        this.jButtonWellList = new JButton();
        this.jToolBar1 = new JToolBar();
        this.jButtonSelectWell = new JButton();
        this.jButtonResetMap = new JButton();
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jListWells = new JList();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemSelectWell = new JMenuItem();
        this.jMenuItemAddWell = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemHelp = new JMenuItem();
        this.jMenuItemClose = new JMenuItem();
        this.jMenuProject = new JMenu();
        this.jMenuItemCreateDatabase = new JMenuItem();
        this.jMenuItemProjectPlan = new JMenuItem();
        this.jMenuItemKml = new JMenuItem();
        this.jMenuWells = new JMenu();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jComboBoxProject.setMaximumRowCount(40);
        this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxProject.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxProjectActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Project:");
        this.jButtonProjects.setText("...");
        this.jButtonProjects.setToolTipText("Open project selector");
        this.jButtonProjects.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonProjects.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonProjectsActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(11);
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jLabel2.setText(bundle.getString("label.welllist"));
        this.jComboBoxWellList.setMaximumRowCount(40);
        this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxWellList.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxWellListActionPerformed(evt);
            }
        });
        this.jButtonWellList.setText("...");
        this.jButtonWellList.setToolTipText("Open well list selector");
        this.jButtonProjects.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonWellList.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellListActionPerformed(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonSelectWell.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/searchWells.png")));
        this.jButtonSelectWell.setToolTipText("Select wells...");
        this.jButtonSelectWell.setFocusable(false);
        this.jButtonSelectWell.setHorizontalTextPosition(0);
        this.jButtonSelectWell.setVerticalTextPosition(3);
        this.jButtonSelectWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectWellActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSelectWell);
        this.jToolBar1.add(Box.createHorizontalGlue());
        this.jButtonResetMap.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/zoom-to-extents.png")));
        this.jButtonResetMap.setToolTipText("Reset map zoom");
        this.jButtonResetMap.setFocusable(false);
        this.jButtonResetMap.setHorizontalTextPosition(0);
        this.jButtonResetMap.setVerticalTextPosition(3);
        this.jButtonResetMap.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonResetMapActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonResetMap);
        this.jPanel1.setLayout(new BorderLayout());
        this.jListWells.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListWells.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListWellsMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jListWellsMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jListWellsMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWells);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.jMenuFile.setText(bundle.getString("menu.file"));
        this.jMenuItemSelectWell.setText(bundle.getString("menu.selectwells"));
        this.jMenuItemSelectWell.setToolTipText("Search for wells to add to the selected project");
        this.jMenuItemSelectWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSelectWellActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSelectWell);
        this.jMenuItemAddWell.setText(bundle.getString("FrameWells.menu.newwell"));
        this.jMenuItemAddWell.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAddWellActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemAddWell);
        this.jMenuFile.add(this.jSeparator3);
        this.jMenuItemHelp.setText(bundle.getString("menu.help"));
        this.jMenuItemHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemHelpActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemHelp);
        this.jMenuItemClose.setText(bundle.getString("menu.exit"));
        this.jMenuItemClose.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCloseActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemClose);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuProject.setText("Project");
        this.jMenuItemCreateDatabase.setText(bundle.getString("FrameWells.menu.createdb"));
        this.jMenuItemCreateDatabase.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemCreateDatabaseActionPerformed(evt);
            }
        });
        this.jMenuProject.add(this.jMenuItemCreateDatabase);
        this.jMenuItemProjectPlan.setIcon(new ImageIcon(this.getClass().getResource("/resources/frameicon/16Map.png")));
        this.jMenuItemProjectPlan.setText("Sidetrack chart...");
        this.jMenuItemProjectPlan.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemProjectPlanActionPerformed(evt);
            }
        });
        this.jMenuProject.add(this.jMenuItemProjectPlan);
        this.jMenuItemKml.setText("Export KML positions");
        this.jMenuItemKml.addActionListener(new ActionListener(this){
            final /* synthetic */ FrameWells this$0;
            {
                FrameWells frameWells = this$0;
                Objects.requireNonNull(frameWells);
                this.this$0 = frameWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemKmlActionPerformed(evt);
            }
        });
        this.jMenuProject.add(this.jMenuItemKml);
        this.jMenuBar1.add(this.jMenuProject);
        this.jMenuWells.setText("Wells");
        this.jMenuBar1.add(this.jMenuWells);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).add((Component)this.jToolBar1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1, -2, 43, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jComboBoxProject, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxWellList, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonProjects, -2, 29, -2).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonWellList, -2, 29, -2).addContainerGap()))))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxProject, -2, -1, -2).add((Component)this.jButtonProjects)).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxWellList, -2, -1, -2).add((Component)this.jButtonWellList)).add(7, 7, 7).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jToolBar1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void jButtonProjectsActionPerformed(ActionEvent evt) {
        try {
            DialogSelectProject dialogProjects = new DialogSelectProject(this, true, this.sbdb, true, this.parent.getChartManager());
            Point p = this.getLocation();
            dialogProjects.setLocation(p.x + 25, p.y + 25);
            dialogProjects.setVisible(true);
            this.updateProjectList();
            if (dialogProjects.selection != null) {
                this.jComboBoxProject.setSelectedItem((Object)dialogProjects.selection);
                this.parent.setProject(dialogProjects.selection);
            }
        }
        catch (RuntimeException | SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    private void openSamples() {
        this.openSamplesForWellList(this.jListWells.getSelectedValuesList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSamplesForWellList(List<Well> wells) {
        try {
            if (this.wsmp != null) {
                this.wsmp.clearCursor();
            }
            this.setCursor(3);
            for (Well well : wells) {
                try {
                    this.parent.addSamplesWell(well, true);
                }
                catch (RuntimeException | SQLException | SBException e) {
                    SbugsExceptionHandler.showStackError("SQL Error", e, this);
                }
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void markers() {
        this.markersDialogs.createOrShowDialog();
    }

    private void twt() {
        Well well = this.getSelection();
        if (well == null) {
            return;
        }
        try {
            DialogTWT dialog = new DialogTWT((Frame)this, true, well, well.getWellUnits());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void tvd() {
        Well well = this.getSelection();
        if (well == null) {
            return;
        }
        try {
            DialogTVD dialog = new DialogTVD((Frame)this, true, well, well.getWellUnits());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.wsmp.updateWellList();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void casing() {
        this.casingDialogs.createOrShowDialog();
    }

    private void cores() {
        this.coresDialogs.createOrShowDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWell(boolean fromProject) {
        String msgTitle = "Remove Well";
        if (this.jListWells.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select well/outcrop(s) to remove from project or well list", "Remove Well", 2);
            return;
        }
        if (this.jComboBoxProject.getSelectedIndex() < 1) {
            for (Well well : this.jListWells.getSelectedValuesList()) {
                this.listModelWells.removeElement(well);
            }
            return;
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            JOptionPane.showMessageDialog(this, SBRestrictable.getDeniedReason(false), "Remove Well", 2);
            return;
        }
        Project project = (Project)((Object)this.jComboBoxProject.getSelectedItem());
        List<Well> selectedValuesList = this.jListWells.getSelectedValuesList();
        if (selectedValuesList.size() < 1) {
            JOptionPane.showMessageDialog(this, "Please select well(s) to remove", "Remove Well", 1);
            return;
        }
        boolean removeAllFromProject = false;
        boolean remainAllInProject = false;
        Iterator<Well> iterator = selectedValuesList.iterator();
        while (iterator.hasNext()) {
            Well wellObj;
            Well well = wellObj = iterator.next();
            WellList wellList = null;
            Object object = this.jComboBoxWellList.getSelectedItem();
            if (object instanceof WellList) {
                WellList wl = (WellList)((Object)object);
                if (!fromProject) {
                    wellList = wl;
                }
            }
            boolean wellWillRemainInProject = false;
            List<Integer> chartIDs = Collections.EMPTY_LIST;
            List<String[]> tabs = Collections.EMPTY_LIST;
            try {
                if (wellList == null) {
                    if (this.sbdb.getWellListService().getWellLists(project.getID()).size() > 1) {
                        if (removeAllFromProject) {
                            wellWillRemainInProject = false;
                        } else {
                            message = "'" + well.getWellName() + "' will be removed from all well lists in project '" + project.getName() + "'.\nAre you sure you want to continue?";
                            options = new Object[]{"Yes", "Yes for all", "Cancel"};
                            int option = JOptionPane.showOptionDialog(this, message, "Remove Well", 2, 3, null, options, null);
                            switch (option) {
                                case 0: {
                                    wellWillRemainInProject = false;
                                    break;
                                }
                                case 1: {
                                    removeAllFromProject = true;
                                    break;
                                }
                                case 2: {
                                    return;
                                }
                            }
                        }
                    }
                } else {
                    block28: for (WellList wl : this.sbdb.getWellListService().getWellLists(project.getID())) {
                        if (wl == wellList) continue;
                        Iterator<Well> it = this.sbdb.getWellIterator(wl.getID());
                        while (it.hasNext()) {
                            if (it.next() != well) continue;
                            wellWillRemainInProject = true;
                            break block28;
                        }
                    }
                    if (wellWillRemainInProject) {
                        if (!remainAllInProject) {
                            message = "'" + well.getWellName() + "' will be removed from well list '" + wellList.getName() + "' but remains in the project via another well list.\nContinue?";
                            options = new Object[]{"Yes", "Yes for all", "Cancel"};
                            int option = JOptionPane.showOptionDialog(this, message, "Remove Well", 2, 3, null, options, null);
                            switch (option) {
                                case 0: {
                                    wellWillRemainInProject = true;
                                    break;
                                }
                                case 1: {
                                    remainAllInProject = true;
                                    break;
                                }
                                case 2: {
                                    return;
                                }
                            }
                        }
                    } else if (!removeAllFromProject) {
                        message = "'" + well.getWellName() + "' will be entirely removed from the project,\nas it does not belong to any other well list.\nAre you sure you want to continue?";
                        options = new Object[]{"Yes", "Yes for all", "Cancel"};
                        int option = JOptionPane.showOptionDialog(this, message, "Remove Well", 2, 3, null, options, null);
                        switch (option) {
                            case 0: {
                                wellWillRemainInProject = false;
                                break;
                            }
                            case 1: {
                                removeAllFromProject = true;
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                    }
                }
                if (!wellWillRemainInProject) {
                    chartIDs = this.parent.getChartManager().searchChartMember(well.getWellID(), project.getID());
                    tabs = this.parent.getChartManager().getTabs(well.getWellID(), project.getID());
                }
            }
            catch (RuntimeException | SQLException | SBException e) {
                SbugsExceptionHandler.showStackError("Error searching project data", e);
                return;
            }
            if (!(wellWillRemainInProject || chartIDs.isEmpty() && tabs.isEmpty())) {
                String msg = "Well '" + well.getWellName() + "' occurs in " + chartIDs.size() + " project chart" + (chartIDs.size() == 1 ? "" : "s") + ".";
                if (!chartIDs.isEmpty()) {
                    msg = msg + "\nRemoving the well from the project will remove it from these chart templates, and delete templates in which it was the only well.";
                }
                if (!tabs.isEmpty()) {
                    msg = msg + "\n\nThere are also " + tabs.size() + " chart tabs associated with this well/project.\nThese will be deleted if you continue (this may also affect other users).";
                }
                String showCharts = "Show charts...";
                String delete = "Remove well";
                String cancel = "Cancel";
                JOptionPane pane = new JOptionPane(msg, 0, 1, null, new Object[]{"Show charts...", "Remove well", "Cancel"}, well);
                JDialog dialog = pane.createDialog(this, "Remove Well");
                dialog.setVisible(true);
                Object val = pane.getValue();
                if (val == null || val.equals("Cancel")) {
                    return;
                }
                if (val == "Remove well") {
                    try {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        int[] results = this.parent.getChartManager().deleteWell(well.getWellID(), project.getID());
                        int tabResults = this.parent.getChartManager().deleteTabs(well.getWellID(), project.getID());
                        this.sbdb.commit();
                        String resultMsg = "Well blocks removed: " + results[0];
                        resultMsg = resultMsg + "\nScheme blocks updated: " + results[1];
                        resultMsg = resultMsg + "\nCharts deleted: " + results[2];
                        if (tabResults > 0) {
                            resultMsg = resultMsg + "\nTabs deleted: " + tabResults;
                        }
                        JOptionPane.showMessageDialog(this, resultMsg, well.getWellName(), 1);
                    }
                    catch (SQLException | SBException | SBPermissionException e) {
                        this.sbdb.doRollback();
                        SbugsExceptionHandler.showStackError("Error updating charts - well not removed from project", e);
                        return;
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                if (val == "Show charts...") {
                    try {
                        LinkedList<ChartTemplate> templates = new LinkedList<ChartTemplate>();
                        for (Integer id : chartIDs) {
                            templates.add(this.parent.getChartManager().getChartTemplate(id));
                        }
                        DialogList.displayListDialog(this, "Chart Templates in Project With Well: " + String.valueOf(well), new UserPrefsHelper(this.sbdb), templates, null);
                    }
                    catch (SQLException e) {
                        SbugsExceptionHandler.showDialogStackError(e, this);
                    }
                    return;
                }
            }
            try {
                if (wellList != null) {
                    this.sbdb.removeWellsFromWellList(List.of(well), wellList.getID());
                } else {
                    this.sbdb.removeWellFromProject(well, project.getID());
                }
                this.sbdb.commit();
                this.loadList();
            }
            catch (RuntimeException | SQLException | SBException | SBPermissionException e) {
                SbugsExceptionHandler.showStackError("Error removing well", e, this);
            }
        }
    }

    public void restoreFrame() {
        this.setState(0);
    }

    private void saveAsWellList() {
        List<Well> selection = this.jListWells.getSelectedValuesList();
        List<Well> toAdd = null;
        if (!selection.isEmpty()) {
            int opt = JOptionPane.showConfirmDialog(this, "Restrict to selected well/outcrop(s)?", this.getTitle(), 1, 3);
            if (opt == 2) {
                return;
            }
            if (opt == 0) {
                toAdd = selection;
            }
        }
        if (toAdd == null) {
            toAdd = Collections.list(this.listModelWells.elements());
        }
        try {
            DialogSelectProjectWellList dialog = new DialogSelectProjectWellList((Window)this, this.sbdb, null, this.parent.getChartManager());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                WellList wellList = dialog.getSelection();
                if (this.sbdb.getnWells(wellList.getID()) > 0) {
                    JOptionPane.showMessageDialog(this, "Please choose an empty well list", "Save as well list", 2);
                    return;
                }
                this.sbdb.addWellsToWellList(toAdd, wellList.getID());
                this.updateProjectList();
                this.jComboBoxProject.setSelectedItem((Object)this.sbdb.getProject(wellList.getProjID()));
                this.jComboBoxWellList.setSelectedItem((Object)wellList);
            }
        }
        catch (SQLException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jListWellsMouseClicked(MouseEvent evt) {
        this.mouseClicked(evt);
    }

    private void jComboBoxProjectActionPerformed(ActionEvent evt) {
        try {
            Object o = this.jComboBoxProject.getSelectedItem();
            if (o == null) {
                return;
            }
            if (o instanceof Project) {
                Project project = (Project)((Object)o);
                ProjectUtils.loadWellListCombo(this.sbdb.getWellListService(), this.comboBoxModelWellLists, true, project.getID());
                this.loadList();
                this.parent.setProject(project);
                if (this.wsmp != null && this.mapVisible) {
                    this.wsmp.setProject(project.getID());
                    this.wsmp.resetMapBounds();
                }
            } else if (o instanceof String) {
                this.comboBoxModelWellLists.removeAllElements();
                if (this.wsmp != null && this.mapVisible) {
                    this.wsmp.setProject(null);
                    this.wsmp.resetMapBounds();
                }
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e);
        }
    }

    private void selectWell() {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemCloseActionPerformed(null);
            return;
        }
        DialogSelectWell dialog = new DialogSelectWell(this, true, this.sbdb, true);
        int x = this.getX() + this.getWidth();
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        if (x + dialog.getWidth() > screenWidth) {
            x = screenWidth - dialog.getWidth();
        }
        dialog.setLocation(x, this.getY() + 25);
        dialog.setVisible(true);
        if (dialog.getSelection() == null) {
            return;
        }
        this.addWellSelection(dialog.getSelection());
    }

    public void addWellSelection(List<Well> selection) {
        try {
            Object object = this.jComboBoxProject.getSelectedItem();
            if (object instanceof Project) {
                Project project = (Project)((Object)object);
                WellList wellList = null;
                Object object2 = this.jComboBoxWellList.getSelectedItem();
                if (object2 instanceof WellList) {
                    WellList wl;
                    wellList = wl = (WellList)((Object)object2);
                }
                boolean askProject = false;
                boolean askWellList = false;
                if (SBRestrictable.canWrite(this.sbdb)) {
                    for (Well well : selection) {
                        if (wellList != null && !well.getHeader().isWellListMember(wellList.getID())) {
                            askWellList = true;
                            break;
                        }
                        if (wellList != null || this.sbdb.getWellListService().isWellProjectMember(project.getID(), well.getWellID())) continue;
                        askProject = true;
                        break;
                    }
                }
                if (askProject || askWellList) {
                    if (JOptionPane.showConfirmDialog(this, "Add selected wells to " + (askWellList ? "well list?" : "project?"), this.getTitle(), 0, 3) == 0) {
                        if (wellList == null && (wellList = this.sbdb.getDefaultWellList(project.getID(), false)) == null) {
                            JOptionPane.showMessageDialog(this, "No well list selected and no default well list available, well(s) not added.", this.getTitle(), 1);
                            return;
                        }
                        this.sbdb.addWellsToWellList(selection, wellList.getID());
                        this.sbdb.commit();
                        this.jComboBoxWellList.setSelectedItem((Object)wellList);
                        this.loadList();
                    } else {
                        this.jComboBoxProject.setSelectedIndex(0);
                        this.jComboBoxWellList.removeAllItems();
                        this.loadList(selection);
                    }
                }
            } else {
                this.loadList(selection);
            }
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void deleteWell() {
        block33: {
            if (this.jListWells.getSelectedValue() == null) {
                JOptionPane.showMessageDialog(this, "Select well/outcrop(s) to delete", this.getTitle(), 2);
                return;
            }
            if (!SBRestrictable.canWrite(this.sbdb)) {
                JOptionPane.showMessageDialog(this, SBRestrictable.getDeniedReason(false), "Delete Wells", 2);
                return;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                confirmWell = true;
                var2_2 = this.jListWells.getSelectedValuesList().iterator();
                while (var2_2.hasNext()) {
                    block36: {
                        block37: {
                            block34: {
                                well = obj = var2_2.next();
                                try {
                                    if (!well.canWrite(this.sbdb, null)) {
                                        JOptionPane.showMessageDialog(this, well.getDeniedReason(this.sbdb, "well", false), "Delete Wells", 2);
                                    }
                                }
                                catch (SQLException sql) {
                                    SbugsExceptionHandler.showStackError("SQL Error", sql, this);
                                    this.setCursor(Cursor.getDefaultCursor());
                                    return;
                                }
                                if (confirmWell) {
                                    options = new String[]{"Yes", "No", "All", "Cancel"};
                                    opt = JOptionPane.showOptionDialog(this, "Permanently delete well: " + well.getWellName() + "?", this.getTitle(), -1, 3, null, options, options[0]);
                                    if (opt == -1) break block33;
                                    if (opt == 3) {
                                        break;
                                    }
                                    if (opt == 1) continue;
                                    if (opt == 2) {
                                        confirmWell = false;
                                    }
                                }
                                charts = this.parent.getChartManager().searchChartMember(well.getWellID(), null);
                                if (charts.isEmpty()) ** GOTO lbl71
                                msg = "This well: " + well.getWellName() + " occurs in " + charts.size() + " chart" + (charts.size() == 1 ? "" : "s") + ".\n";
                                msg = msg + "Deleting the well will remove it from chart templates, and delete templates in which it was the only well.";
                                showCharts = "Show charts...";
                                delete = "Delete well";
                                cancel = "Cancel";
                                pane = new JOptionPane(msg, 0, 1, null, new Object[]{showCharts, delete, cancel}, obj);
                                dialog = pane.createDialog(this, "Delete Well");
                                dialog.setVisible(true);
                                val = pane.getValue();
                                if (val == null || val.equals(cancel)) {
                                    return;
                                }
                                if (val != delete) break block34;
                                results = null;
                                try {
                                    this.setCursor(Cursor.getPredefinedCursor(3));
                                    results = this.parent.getChartManager().deleteWell(well.getWellID(), null);
                                }
                                finally {
                                    this.setCursor(Cursor.getDefaultCursor());
                                }
                                resultMsg = "Well blocks removed: " + results[0];
                                resultMsg = resultMsg + "\nScheme blocks updated: " + results[1];
                                resultMsg = resultMsg + "\nCharts deleted: " + results[2];
                                JOptionPane.showMessageDialog(this, resultMsg, this.getTitle(), 1);
                                break block37;
                            }
                            if (val == showCharts) {
                                templates = new LinkedList<ChartTemplate>();
                                for (Integer id : charts) {
                                    templates.add(this.parent.getChartManager().getChartTemplate(id));
                                }
                                DialogList.displayListDialog(this, "Chart Templates with well: " + String.valueOf(well), new UserPrefsHelper(this.sbdb), templates, null);
                                return;
                            }
                        }
                        try {
                            break block36;
lbl71:
                            // 1 sources

                            blockTemplatesWithChildren = this.parent.getChartManager().searchBlockTemplateChildren(well.getWellID());
                            if (!blockTemplatesWithChildren.isEmpty()) {
                                this.parent.getChartManager().deleteWell(well.getWellID(), null);
                            }
                        }
                        catch (RuntimeException | SQLException | SBException | SBPermissionException e) {
                            SbugsExceptionHandler.showStackError(e, this);
                            return;
                        }
                    }
                    if (this.parent.samplesFrame != null) {
                        this.parent.samplesFrame.removeWell(well);
                    }
                    try {
                        this.parent.getChartManager().fireWellWillBeDeleted(well.getWellID());
                    }
                    catch (RuntimeException re) {
                        SbugsExceptionHandler.showStackError(re);
                        this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    try {
                        this.sbdb.deleteWell(well);
                        this.sbdb.commit();
                        this.listModelWells.removeElement(well);
                    }
                    catch (SBPermissionException pe) {
                        JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
                    }
                    catch (SQLException | SBException sql) {
                        this.sbdb.doRollback();
                        SbugsExceptionHandler.showStackError("Error", sql, this);
                    }
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void editHeader() {
        Well well = this.getSelection();
        if (well == null) {
            return;
        }
        try {
            DialogWell dialog = new DialogWell(this, true, this.sbdb, well);
            dialog.setVisible(true);
            if (dialog.isOK() && this.wsmp != null) {
                this.wsmp.updateWellList();
                this.wsmp.updateSelectedWells();
            }
            if (!this.listModelWells.contains(well)) {
                this.loadList(List.of(well));
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showDialogStackError(sql, this);
        }
    }

    private void addWell() {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemCloseActionPerformed(null);
            return;
        }
        try {
            DialogWell dialog = new DialogWell(this, true, this.sbdb, null);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                Object object = this.jComboBoxProject.getSelectedItem();
                if (object instanceof Project) {
                    Project project = (Project)((Object)object);
                    if (JOptionPane.showConfirmDialog(this, "Add well to project?", this.getTitle(), 0, 3) == 0) {
                        WellList wellList = null;
                        Object object2 = this.jComboBoxWellList.getSelectedItem();
                        if (object2 instanceof WellList) {
                            WellList wl;
                            wellList = wl = (WellList)((Object)object2);
                        }
                        if (wellList == null && (wellList = this.sbdb.getDefaultWellList(project.getID(), false)) == null) {
                            JOptionPane.showMessageDialog(this, "No well list selected and no default well list available, well not added to project.", this.getTitle(), 1);
                            this.jComboBoxProject.setSelectedIndex(0);
                            this.loadList();
                            this.listModelWells.addElement(dialog.getWell());
                            return;
                        }
                        this.sbdb.addWellToWellList(dialog.getWell(), wellList.getID());
                        this.sbdb.commit();
                        this.loadList();
                    } else {
                        this.jComboBoxProject.setSelectedIndex(0);
                        this.loadList();
                        this.listModelWells.addElement(dialog.getWell());
                    }
                } else {
                    this.listModelWells.addElement(dialog.getWell());
                }
                this.jListWells.setSelectedValue(dialog.getWell(), true);
            }
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jMenuItemCloseActionPerformed(null);
    }

    private void kml() {
        LinkedList<Well> selectedWells = new LinkedList<Well>();
        Object title = null;
        try {
            Iterator wellIt;
            Project project;
            WellList wellList = this.jComboBoxWellList.getSelectedItem() instanceof WellList ? (WellList)((Object)this.jComboBoxWellList.getSelectedItem()) : null;
            Project project2 = project = this.jComboBoxProject.getSelectedItem() instanceof Project ? (Project)((Object)this.jComboBoxProject.getSelectedItem()) : null;
            if (wellList != null) {
                wellIt = this.sbdb.getWellService().getWellListWells(wellList.getID());
                title = project.getName() + " / " + wellList.getName();
            } else if (project != null) {
                wellIt = this.sbdb.getWellService().getProjectWells(project.getID());
                title = project.getName();
            } else {
                JOptionPane.showMessageDialog(this, "Select project / well list", "Export Positions", 2);
                return;
            }
            while (wellIt.hasNext()) {
                selectedWells.add((Well)wellIt.next());
            }
            if (selectedWells.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No wells selected", "Export Positions", 2);
                return;
            }
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("kml");
        filter.setDescription("KML files");
        jFileChooser1.setFileFilter((FileFilter)filter);
        jFileChooser1.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "WINKMLFILE", "UNXKMLFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser1.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 == jFileChooser1.showSaveDialog(this)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                String fileName = jFileChooser1.getSelectedFile().getName();
                String fileType = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim();
                Object filePath = jFileChooser1.getSelectedFile().getPath();
                if (!fileType.toLowerCase().equals("kml")) {
                    filePath = (String)filePath + ".kml";
                }
                try (BufferedWriter out = new BufferedWriter(new FileWriter((String)filePath, false));){
                    String eol = "\r\n";
                    out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + eol + "<kml xmlns=\"http://www.opengis.net/kml/2.2\">" + eol + "<Document>" + eol);
                    this.sbdb.writeWellLocations(selectedWells, (String)title, out, eol);
                    out.write("</Document>" + eol + "</kml>" + eol);
                }
                Lastval.putString(this.sbdb, "WINKMLFILE", "UNXKMLFILE", (String)filePath);
                this.sbdb.commit();
                String geExe = "C:\\Program Files\\Google\\Google Earth\\client\\googleearth.exe";
                if (new File(geExe).exists()) {
                    Runtime.getRuntime().exec("\"" + geExe + "\" \"" + (String)filePath + "\"");
                } else {
                    JOptionPane.showMessageDialog(this, "File created but Google Earth not found.\nAlternatively, you can import the file into Google Maps, after creating a new map.", this.getTitle(), 1);
                }
            }
            catch (Exception ex) {
                SbugsExceptionHandler.showStackError("Error during file write: ", ex, this);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void lithology() {
        this.lithologyDialogs.createOrShowDialog();
    }

    private void curves() {
        this.curvesDialogs.createOrShowDialog();
    }

    private void importCurves(File file) {
        this.curvesDialogs.createOrShowDialog();
        this.curvesDialogs.dialogs.stream().filter(d -> d.getWell() == this.jListWells.getSelectedValue()).findFirst().ifPresent(d -> d.importFile(file));
    }

    private void projectPlan() {
        WellList wellList;
        WellList wellList2 = wellList = this.jComboBoxWellList.getSelectedItem() instanceof WellList ? (WellList)((Object)this.jComboBoxWellList.getSelectedItem()) : null;
        if (wellList == null) {
            JOptionPane.showMessageDialog(this, "Select a well list", this.getTitle(), 1);
            return;
        }
        try {
            boolean hastvd = false;
            Iterator it = this.sbdb.getWellService().getWellListWells(wellList.getID());
            while (it.hasNext()) {
                Well well = (Well)it.next();
                if (well.getTVDlist(false) == null || well.getTVDlist(false).getList().isEmpty()) continue;
                hastvd = true;
                break;
            }
            if (!hastvd) {
                JOptionPane.showMessageDialog(this, "There are no deviation surveys in this well list.", this.getTitle(), 1);
                return;
            }
            if (this.frameProjectLocation != null) {
                this.frameProjectLocation.setProject(wellList);
                this.frameProjectLocation.setTitle("Sidetrack Chart : " + wellList.getName());
                this.frameProjectLocation.setVisible(true);
                this.frameProjectLocation.setExtendedState(0);
            } else {
                JOptionPane.showMessageDialog(this, "This feature is deprecated and will be incorporated into map blocks.\nPlease contact StrataData if you are interested.", "Sidetrack Chart", 1);
                this.frameProjectLocation = new FrameProjectLocation(this.parent, this.sbdb, wellList);
                this.frameProjectLocation.setVisible(true);
                this.frameProjectLocation.setLocationRelativeTo(this);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("SQL Error", sql, this);
        }
    }

    private void createDatabase() {
        WellList wl;
        Project project;
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", this.getTitle(), 2);
            return;
        }
        Project project2 = project = this.jComboBoxProject.getSelectedItem() instanceof Project ? (Project)((Object)this.jComboBoxProject.getSelectedItem()) : null;
        if (project == null) {
            JOptionPane.showMessageDialog(this, "Select a project", this.getTitle(), 1);
            return;
        }
        Object object = this.jComboBoxWellList.getSelectedItem();
        if (!(object instanceof WellList)) {
            JOptionPane.showMessageDialog(this, "Select a well list", this.getTitle(), 1);
            return;
        }
        WellList wellList = wl = (WellList)((Object)object);
        DialogCreateDatabase dialog = new DialogCreateDatabase(this, true, this.sbdb, this.parent.getChartManager(), project, wellList);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void permissions() {
        Well well = this.getSelection();
        if (well == null) {
            return;
        }
        try {
            DialogPermissions dialog = new DialogPermissions(this, true, this.sbdb, (SBRestrictable)well, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void projectMembership() {
        if (!this.checkSelection()) {
            return;
        }
        List<Well> wells = this.jListWells.getSelectedValuesList();
        try {
            TableModelProjectMembership tableModel = new TableModelProjectMembership(wells, this.sbdb);
            DialogTable dialog = new DialogTable(this, true, (AbstractTableModel)tableModel, "Project and Well List Membership", false);
            tableModel.setupTable(dialog.getTable());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("SQL Error", e, this);
        }
    }

    private void jComboBoxWellListActionPerformed(ActionEvent evt) {
        Object o = this.jComboBoxWellList.getSelectedItem();
        if (o != null) {
            this.wellListUpdate();
        }
    }

    private void jButtonWellListActionPerformed(ActionEvent evt) {
        Project project;
        Project project2 = project = this.jComboBoxProject.getSelectedItem() instanceof Project ? (Project)((Object)this.jComboBoxProject.getSelectedItem()) : null;
        if (project == null) {
            JOptionPane.showMessageDialog(this, "Please select a project", this.getTitle(), 1);
            return;
        }
        try {
            DialogSelectProjectWellList dialogWellLists = new DialogSelectProjectWellList((Window)this, this.sbdb, project, this.parent.getChartManager());
            Point p = this.getLocation();
            dialogWellLists.setLocation(p.x + 25, p.y + 25);
            dialogWellLists.setVisible(true);
            ProjectUtils.loadWellListCombo(this.sbdb.getWellListService(), this.comboBoxModelWellLists, true, project.getID());
            if (dialogWellLists.getSelection() != null) {
                this.jComboBoxWellList.setSelectedItem((Object)dialogWellLists.getSelection());
            }
        }
        catch (RuntimeException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void jListWellsMouseReleased(MouseEvent evt) {
        this.selectWellAndPopupMouseEvent(evt);
    }

    private void jListWellsMousePressed(MouseEvent evt) {
        this.selectWellAndPopupMouseEvent(evt);
    }

    private void jMenuItemSelectWellActionPerformed(ActionEvent evt) {
        this.selectWell();
    }

    private void jMenuItemAddWellActionPerformed(ActionEvent evt) {
        this.addWell();
    }

    private void jMenuItemCloseActionPerformed(ActionEvent evt) {
        this.encodeSession();
        this.setVisible(false);
    }

    private void jMenuItemHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"framewells.html");
    }

    private void jMenuItemCreateDatabaseActionPerformed(ActionEvent evt) {
        this.createDatabase();
    }

    private void jMenuItemKmlActionPerformed(ActionEvent evt) {
        this.kml();
    }

    private void jMenuItemProjectPlanActionPerformed(ActionEvent evt) {
        this.projectPlan();
    }

    private void jButtonSelectWellActionPerformed(ActionEvent evt) {
        this.selectWell();
    }

    private void jButtonResetMapActionPerformed(ActionEvent evt) {
        if (this.wsmp != null) {
            this.wsmp.resetMapBounds();
        }
    }

    private void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            int clickIndex = this.jListWells.locationToIndex(evt.getPoint());
            if (clickIndex == -1 || !this.jListWells.getCellBounds(clickIndex, clickIndex).contains(evt.getPoint())) {
                this.jListWells.clearSelection();
                this.selectWell();
                return;
            }
            List<Well> selected = this.jListWells.getSelectedValuesList();
            if (!selected.isEmpty()) {
                this.openSamples();
            }
        }
    }

    private void selectWellAndPopupMouseEvent(MouseEvent evt) {
        List<Well> selected = this.jListWells.getSelectedValuesList();
        if (selected.size() < 2) {
            this.jListWells.setSelectedIndex(this.jListWells.locationToIndex(evt.getPoint()));
        }
        this.showPopupMenuWells(evt);
    }

    private void showPopupMenuWells(MouseEvent evt) {
        List<Well> selected = this.jListWells.getSelectedValuesList();
        if (evt.isPopupTrigger() && !selected.isEmpty()) {
            int selectionSize = selected.size();
            boolean projectSelected = this.jComboBoxProject.getSelectedItem() instanceof Project;
            for (Component c : this.jPopupMenuWells.getComponents()) {
                if (c instanceof WellsMenuItem) {
                    WellsMenuItem item = (WellsMenuItem)c;
                    item.setEnabled(selectionSize, projectSelected);
                    continue;
                }
                if (!(c instanceof JPopupMenu.Separator)) continue;
                JPopupMenu.Separator separator = (JPopupMenu.Separator)c;
            }
            this.jPopupMenuWells.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void encodeSession() {
        int projID = this.getProjectSelection().map(project -> project.getID()).orElse(0);
        int wellListID = this.getWellListSelection().map(wellList -> wellList.getID()).orElse(0);
        FrameWellsSession newSession = new FrameWellsSession(this.getSize(), new Point(this.getX(), this.getY()), this.mapVisible, projID, wellListID);
        this.userPrefsHelper.setFrameWellsSession(newSession);
    }

    private void decodeSession(boolean restoreProject) {
        FrameWellsSession session = this.userPrefsHelper.getFrameWellsSession();
        if (session == null) {
            return;
        }
        if (session.isFrameDimensionSet()) {
            this.setSize(session.getFrameDimension());
        }
        if (session.isFrameLocationSet()) {
            GraphicsDevice[] gs;
            boolean onScreen = false;
            int x = session.getFrameLocation().x;
            int y = session.getFrameLocation().y;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            block4: for (GraphicsDevice curGs : gs = ge.getScreenDevices()) {
                GraphicsConfiguration[] gc;
                for (GraphicsConfiguration curGc : gc = curGs.getConfigurations()) {
                    Rectangle bounds = curGc.getBounds();
                    if (x >= bounds.x + bounds.width || x + 50 >= bounds.y + bounds.height) continue;
                    onScreen = true;
                    continue block4;
                }
            }
            if (onScreen) {
                this.setLocation(x, y);
            } else {
                this.centreOnScreen();
            }
        }
        if (session.isMapVisibleSet()) {
            this.mapVisible = session.getMapVisible();
        }
        if (session.isProjectIdSet() && session.getProjectId() > 0 && restoreProject) {
            Project project = null;
            try {
                project = this.sbdb.getProject(session.getProjectId());
                if (project != null && restoreProject) {
                    this.jComboBoxProject.setSelectedItem((Object)project);
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            if (project != null && session.isWellListIdSet() && session.getWellListId() > 0) {
                try {
                    WellList wellList = (WellList)this.sbdb.getWellListService().getWellList(session.getWellListId().intValue());
                    if (wellList.getProjID() == project.getID()) {
                        this.jComboBoxWellList.setSelectedItem((Object)wellList);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void wellListChanged(WellList notifier) {
        if (notifier == this.jComboBoxWellList.getSelectedItem()) {
            this.wellListUpdate();
        }
    }

    @Override
    public void wellRemoved(Well notifier) {
        this.wellListUpdate();
    }

    @Override
    public void wellsAdded(List<Well> notifier) {
        this.wellListUpdate();
    }

    @Override
    public void wellAdded(Well notifier) {
        this.wellListUpdate();
    }

    private void wellListUpdate() {
        try {
            this.loadList();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error re-loading well list", e, this);
        }
    }

    private abstract class ModelessDialogList<D extends ModelessWellInfoDialog> {
        private final List<D> dialogs;
        final /* synthetic */ FrameWells this$0;

        private ModelessDialogList(FrameWells frameWells) {
            FrameWells frameWells2 = frameWells;
            Objects.requireNonNull(frameWells2);
            this.this$0 = frameWells2;
            this.dialogs = new LinkedList<D>();
        }

        void createOrShowDialog() {
            if (!this.this$0.checkSelection()) {
                return;
            }
            DialogLocationCounter loc = new DialogLocationCounter(this.this$0.getX() + this.this$0.getWidth() + 25, this.this$0.getY() + 25);
            Dimension screenSize = this.this$0.getToolkit().getScreenSize();
            if (loc.x > screenSize.width || loc.y > screenSize.height) {
                loc.x = this.this$0.getX() + this.this$0.getWidth() / 2;
            }
            for (Well well : this.this$0.jListWells.getSelectedValuesList()) {
                this.dialogs.stream().filter(d -> d.getWell() == well).findFirst().ifPresentOrElse(d -> {
                    if (!d.isVisible()) {
                        d.testMaster();
                    }
                    d.setVisible(true);
                }, () -> this.createDialog(well, loc));
            }
        }

        private void createDialog(Well well, DialogLocationCounter loc) {
            try {
                D dialog = this.newDialog(well);
                ((Window)dialog).setLocation(loc.x, loc.y);
                ((Dialog)dialog).setVisible(true);
                this.dialogs.add(dialog);
                loc.increment();
            }
            catch (RuntimeException | SQLException | SBException e) {
                SbugsExceptionHandler.showDialogStackError(e, this.this$0);
            }
        }

        abstract D newDialog(Well var1) throws SQLException, SBException;

        private static class DialogLocationCounter {
            int x;
            int y;

            public DialogLocationCounter(int x, int y) {
                this.x = x;
                this.y = y;
            }

            private void increment() {
                this.x += 25;
                this.y += 25;
            }
        }
    }

    private class SidetrackSorter {
        final /* synthetic */ FrameWells this$0;

        private SidetrackSorter(FrameWells frameWells) {
            FrameWells frameWells2 = frameWells;
            Objects.requireNonNull(frameWells2);
            this.this$0 = frameWells2;
        }

        private List<Well> sortSidetracks(List<Well> wells) {
            if (wells.stream().anyMatch(w -> w.getHeader().getParentWellID() > 0)) {
                Map<Well, TreeSet> collection = wells.stream().collect(Collectors.groupingBy(h -> this.getRoot((Well)h), Collectors.toCollection(() -> new TreeSet<Well>(Comparator.comparing(h -> h.getHeader().getParentWellID()).thenComparing(h -> this.getKickoffFromRoot((Well)h)).thenComparing(h -> h.getHeader().getKickoValue()).thenComparing(h -> h.getWellID())))));
                TreeMap<Well, TreeSet> sorted = new TreeMap<Well, TreeSet>(Well::compareTo);
                sorted.putAll(collection);
                return sorted.sequencedValues().stream().flatMap(col -> col.stream()).collect(Collectors.toCollection(ArrayList::new));
            }
            return wells;
        }

        private Well getRoot(Well h) {
            Well root = h;
            while (root.getHeader().getParentWellID() > 0) {
                root = this.getWell(root.getHeader().getParentWellID());
            }
            return root;
        }

        private double getKickoffFromRoot(Well h) {
            Well root = this.getRoot(h);
            while (h.getHeader().getParentWellID() > 0 && h.getHeader().getParentWellID() != root.getWellID()) {
                h = this.getWell(h.getHeader().getParentWellID());
            }
            return h.getHeader().getKicko() != null ? h.getHeader().getKicko() : 0.0;
        }

        private Well getWell(int wellID) {
            try {
                return this.this$0.sbdb.getWell(wellID);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class WellsMenuItem
    extends JMenuItem {
        private final ListSelectionCondition listCondition;
        private final ProjectSelectionCondition projectCondition;

        public WellsMenuItem(String text, ListSelectionCondition listCondition, ProjectSelectionCondition projectCondition, AbstractAction action, Icon icon, boolean boldFont) {
            super(action);
            this.listCondition = listCondition;
            this.projectCondition = projectCondition;
            this.setText(text);
            this.setIcon(icon);
            if (boldFont) {
                this.setFont(this.getFont().deriveFont(1));
            }
        }

        public void setEnabled(int selectionSize, boolean projectSelected) {
            boolean enabled = switch (this.listCondition.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (selectionSize == 1) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (selectionSize > 0) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> true;
            };
            super.setEnabled(enabled &= (switch (this.projectCondition.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> true;
                case 0 -> projectSelected;
            }));
            this.getAction().setEnabled(enabled);
        }

        private static enum ListSelectionCondition {
            SINGLE_WELL,
            MULTI_WELL,
            ANY;

        }

        private static enum ProjectSelectionCondition {
            PROJECT,
            ANY;

        }
    }

    public static class FunctionalAction
    extends AbstractAction {
        private final ActionListener action;

        public FunctionalAction(ActionListener customAction) {
            this.action = customAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.actionPerformed(e);
        }
    }
}

