/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jsbugs.FrameJsbugs;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.EdgedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;

public class HintSequence {
    private final FrameJsbugs parent;
    private final JPanel hintPanel = new JPanel();
    private final JTextArea hintLabel = new JTextArea("Hint here");
    private final JButton cancelHintButton = new JButton("Turn off hints");
    private final JButton nextHintButton = new JButton("Next >>");
    private final JButton linkButton = new JButton("");
    private BalloonTip hint;
    private final MouseListener buttonMouseRolloverListener = new MouseAdapter(this){
        final Color buttonRolloverForeground;
        final /* synthetic */ HintSequence this$0;
        {
            HintSequence hintSequence = this$0;
            Objects.requireNonNull(hintSequence);
            this.this$0 = hintSequence;
            this.buttonRolloverForeground = new Color(51, 102, 204);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JButton button = (JButton)e.getComponent();
            button.setForeground(this.buttonRolloverForeground);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JButton button;
            button.setForeground((button = (JButton)e.getComponent()) == this.this$0.cancelHintButton ? Color.LIGHT_GRAY : Color.DARK_GRAY);
        }
    };
    public static BalloonTipStyle chartHintStyle = new EdgedBalloonStyle(new Color(255, 255, 204), Color.BLACK){
        private final int in = 5;

        public Insets getBorderInsets(Component c) {
            if (this.flipY) {
                return new Insets(this.verticalOffset + 5, 5, 5, 5);
            }
            return new Insets(5, 5, this.verticalOffset + 5, 5);
        }
    };

    private HintSequence(FrameJsbugs parent) {
        this.parent = parent;
    }

    public static HintSequence createHintSequence(FrameJsbugs parent) {
        HintSequence hintSequence = new HintSequence(parent);
        hintSequence.initHint(true);
        return hintSequence;
    }

    public static BalloonTip showHint(FrameJsbugs parent, JComponent attachComponent, String text, boolean left) {
        HintSequence sequence = new HintSequence(parent);
        sequence.initHint(false);
        sequence.setHintText(text);
        BalloonTip hint = left ? new BalloonTip(attachComponent, sequence.getHintComponent(), chartHintStyle, BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.EAST, attachComponent.getSize().width, 10, true) : new BalloonTip(attachComponent, sequence.getHintComponent(), chartHintStyle, BalloonTip.Orientation.RIGHT_ABOVE, BalloonTip.AttachLocation.WEST, attachComponent.getSize().width, 10, true);
        sequence.setHint(hint);
        hint.setVisible(true);
        return hint;
    }

    public static void showTimedBalloon(JComponent attachComponent, String text, BalloonTip.Orientation orientation, BalloonTip.AttachLocation attachLocation) {
        BalloonTip bTip = new BalloonTip(attachComponent, (JComponent)new JLabel(text), chartHintStyle, orientation, attachLocation, 0, 20, false);
        TimingUtils.showTimedBalloon((BalloonTip)bTip, (int)5000);
    }

    public void hideHint() {
        if (this.hint != null) {
            this.hint.closeBalloon();
        }
    }

    private void initHint(boolean withNextHintButton) {
        this.hintPanel.setLayout(new BoxLayout(this.hintPanel, 3));
        this.hintPanel.setOpaque(false);
        this.hintLabel.setAlignmentX(0.0f);
        this.hintLabel.setEditable(false);
        this.hintLabel.setLineWrap(true);
        this.hintLabel.setWrapStyleWord(true);
        this.hintLabel.setColumns(20);
        this.hintLabel.setFont(this.hintLabel.getFont().deriveFont((float)this.hintLabel.getFont().getSize() + 2.0f));
        this.hintLabel.setBorder(BorderFactory.createEmptyBorder(8, 10, 10, 10));
        this.hintPanel.add(this.hintLabel);
        this.hintPanel.add(Box.createVerticalStrut(8));
        for (JButton button : new JButton[]{this.cancelHintButton, this.linkButton, this.nextHintButton}) {
            this.initHintButton(button);
        }
        this.linkButton.setForeground(Color.BLACK);
        if (this.parent != null) {
            this.cancelHintButton.addActionListener(new ActionListener(this){
                final /* synthetic */ HintSequence this$0;
                {
                    HintSequence hintSequence = this$0;
                    Objects.requireNonNull(hintSequence);
                    this.this$0 = hintSequence;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$0.parent.setHints(false);
                    this.this$0.hideHint();
                }
            });
            this.hintPanel.add(this.cancelHintButton);
        }
        if (withNextHintButton) {
            this.hintPanel.add(this.nextHintButton);
        }
    }

    public void setHintText(String text) {
        this.hintLabel.setText(text);
    }

    public JComponent getHintComponent() {
        return this.hintPanel;
    }

    public void setHint(BalloonTip hint) {
        this.hint = hint;
    }

    public void setFinalHint(String linkButtonText, ActionListener linkButtonActionListener) {
        this.hintPanel.remove(this.nextHintButton);
        if (linkButtonText != null) {
            if (linkButtonActionListener != null) {
                this.linkButton.addActionListener(linkButtonActionListener);
            }
            this.linkButton.setText(linkButtonText);
            this.hintPanel.add((Component)this.linkButton, 2);
        }
    }

    private void initHintButton(JButton button) {
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setAlignmentX(0.0f);
        if (button != this.cancelHintButton) {
            button.setFont(button.getFont().deriveFont(1));
        }
        button.setForeground(button == this.cancelHintButton ? Color.LIGHT_GRAY : Color.DARK_GRAY);
        button.addMouseListener(this.buttonMouseRolloverListener);
    }

    public void initSequence(final Runnable[] steps) {
        this.nextHintButton.addActionListener(new ActionListener(){
            int n;
            final /* synthetic */ HintSequence this$0;
            {
                HintSequence hintSequence = this$0;
                Objects.requireNonNull(hintSequence);
                this.this$0 = hintSequence;
                this.n = 1;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.n < steps.length) {
                    if (!this.this$0.parent.showHints()) {
                        this.this$0.hideHint();
                        return;
                    }
                    if (this.this$0.hint != null) {
                        this.this$0.hint.closeBalloon();
                    }
                    try {
                        steps[this.n].run();
                    }
                    catch (Exception re) {
                        re.printStackTrace();
                        this.this$0.hint.closeBalloon();
                        this.this$0.nextHintButton.removeActionListener(this);
                        return;
                    }
                    this.this$0.hint.setVisible(true);
                    ++this.n;
                } else {
                    this.this$0.hint.closeBalloon();
                }
            }
        });
        steps[0].run();
        this.hint.setVisible(true);
    }
}

