/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.image.ImageSet;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.sample.SampleProperties;
import com.stratadata.model3.well.sample.SampleStringFactory;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartTemplateBase;
import jsbugs.DialogAnalysis;
import jsbugs.DialogAnalystHeaders;
import jsbugs.DialogBiocom;
import jsbugs.DialogCSVExport;
import jsbugs.DialogEditSamples;
import jsbugs.DialogEvent;
import jsbugs.DialogMergeSamples;
import jsbugs.DialogOccurrence;
import jsbugs.DialogOverlayWeb;
import jsbugs.DialogOverlays;
import jsbugs.DialogSample;
import jsbugs.DialogSampleCopy;
import jsbugs.DialogSampleGenerate;
import jsbugs.DialogSampleLithology;
import jsbugs.DialogSampleReport;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSelectSample;
import jsbugs.DialogSetRwCv;
import jsbugs.DialogTaxonReassign;
import jsbugs.DialogWellEvent;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOverlay;
import jsbugs.FrameSamples;
import jsbugs.FrameWellChartsDetached;
import jsbugs.JPanelCharts;
import jsbugs.JPanelPicklist;
import jsbugs.JPanelWellInterp;
import jsbugs.OverlayWebServer;
import jsbugs.SbugsIO;
import jsbugs.TableModelAnalyses;
import jsbugs.TableModelDocuments;
import jsbugs.TableModelOccurrences;
import jsbugs.TableModelSB;
import jsbugs.TableModelSamples;
import jsbugs.TablePair;
import jsbugs.TaxonTransferHandler;
import jsbugs.UndoRedoAction;
import jsbugs.image.DialogImageSet;
import jsbugs.imagegallery.DialogTaxonImages;
import jsbugs.samplesandinterps.DialogWellDoc;
import jsbugs.samplesandinterps.DialogWellDocRefs;
import jsbugs.samplesandinterps.JPanelPdfPreview;
import jsbugs.samplesandinterps.TabView;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.DontAskMeAgainFactory;
import model3.AnalystHeader;
import model3.Biocom;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBEvent;
import model3.SBdb;
import model3.Sample;
import model3.SampleLithology;
import model3.Smpdtl;
import model3.Surface;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;
import model3.WellDocument;
import model3.WellDocumentService;
import model3.WellHeader;
import model3.WellInterp;
import model3.WsWell;
import model3.taxa.TaxonCompareGenus;
import model3.taxa.TaxonCompareSpecies;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SBPrivilegeException;
import util.SbugsCompoundEdit;
import util.exception.StackError;
import util.table.SbugsTable;
import util.table.TableEventUtils;

public class JPanelWell
extends JPanel
implements Observer {
    private static final String ALL_STRING = "<all>";
    private static final String SELECT_STRING = "<Select>";
    private static final String DEFAULT_COMMENT_TEXT = "Double-click to add a biostratigraphic comment...";
    private static final Logger LOGGER = Logger.getLogger(JPanelWell.class.getName());
    static FrameSamples.TabTitle tabTitlePref = FrameSamples.TabTitle.NAME;
    final FrameSamples parent;
    final Well well;
    private final SBdb sbdb;
    private Discipline discID;
    FrameWellChartsDetached chartsFrameDetached = null;
    char units;
    private String analystString = null;
    private int analyNo = 0;
    boolean hasPrefs = false;
    private Biocom biocom;
    boolean inStartup = true;
    private OverlayWebServer overlayServer = null;
    private final TableModelSamples tableModelSamples = new TableModelSamples(false);
    final TableModelOccurrences tableModelOcc = new TableModelOccurrences();
    final TableModelAnalyses tableModelAnalyses = new TableModelAnalyses();
    final TableModelDocuments tableModelDocuments = new TableModelDocuments();
    private final DefaultComboBoxModel comboModelAnalyst = new DefaultComboBoxModel();
    private final DefaultComboBoxModel comboModelAnalyNo = new DefaultComboBoxModel();
    private final DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    final UndoManager undoManagerOccs;
    private final UndoableEditSupport undoSupportOccs = new UndoableEditSupport();
    final JPanelWellInterp jPanelInterpretations;
    private final JPanelCharts jPanelCharts;
    private int insertPrevLookback = 0;
    private static String insertPrevButtonLabel;
    private final ResourceBundle resources = ResourceBundle.getBundle("locale/UiText");
    private boolean splitColumnsDisplayed = false;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroupDepthUnits;
    private ButtonGroup buttonGroupViewer;
    private JButton jButtonAddDoc;
    private JButton jButtonAddSample;
    private JButton jButtonAddSampleSmpdtl;
    private JButton jButtonAddSmpdtl;
    private JButton jButtonAnalysesImages;
    private JButton jButtonAnalystHeader;
    private JButton jButtonDeleteDoc;
    private JButton jButtonDeleteOccurences;
    private JButton jButtonDeleteSamples;
    private JButton jButtonDeleteSmpdtl;
    private JButton jButtonDocRefs;
    private JButton jButtonEditSample;
    private JButton jButtonEditSelection;
    private JButton jButtonEditSmpdtl;
    private JButton jButtonNext;
    private JButton jButtonOccComment;
    private JButton jButtonOccEdit;
    private JButton jButtonOccEvent;
    private JButton jButtonOccInsertPrev;
    private JButton jButtonOccRedo;
    private JButton jButtonOccUndo;
    private JButton jButtonPrevious;
    private JButton jButtonSaveAsAnalyses;
    private JButton jButtonSaveSamples;
    private JButton jButtonSetRwCv;
    private JButton jButtonShowAll;
    private JButton jButtonShowDoc;
    private JButton jButtonTaxonImage;
    private JButton jButtonWriteDoc;
    private JCheckBox jCheckBoxBarren;
    private JComboBox jComboBoxAnalysisNumber;
    private JComboBox jComboBoxAnalyst;
    private JComboBox jComboBoxDiscipline;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelNtaxa;
    private JLabel jLabelNtaxaInSitu;
    private JLabel jLabelNtaxaTotal;
    private JLabel jLabelSamples;
    private JLabel jLabelnAnalyses;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItemAnalyEdit;
    private JMenuItem jMenuItemAnalyEditOcc;
    private JMenuItem jMenuItemAnalyEvent;
    private JMenuItem jMenuItemAnalyses;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemOccBiostratComment;
    private JMenuItem jMenuItemOccDelete;
    private JMenuItem jMenuItemOccEdit;
    private JMenuItem jMenuItemOccImage;
    private JMenuItem jMenuItemOccSetCvRe;
    private JMenuItem jMenuItemSamplesDelete;
    private JMenuItem jMenuItemSamplesEdit;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelAnalyses;
    private JPanel jPanelDocuments;
    private JPanel jPanelOccurences;
    private JPanelPdfPreview jPanelPdfPreview;
    private JPanel jPanelSamples;
    private JPanel jPanelTotals;
    private JPopupMenu jPopupMenuAnalyses;
    private JPopupMenu jPopupMenuOcc;
    private JPopupMenu jPopupMenuSamples;
    private JRadioButton jRadioButtonExternal;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonInternal;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPaneAnalyses;
    private JScrollPane jScrollPaneOccurences;
    private JScrollPane jScrollPaneSamples;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPaneSampleData;
    private JTable jTableAnalyses;
    private JTable jTableDocuments;
    private JTable jTableOccurrences;
    private JTable jTableSamples;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldDiscipline;
    private JTextField jTextFieldSample;
    private JToolBar jToolBarOccUndo;
    HashMap<String, TotalLabel> totalLabels;

    public JPanelWell(FrameSamples parent, SBdb sbdb, Well well) throws SQLException, SBException {
        this.undoManagerOccs = new UndoManager(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                this.this$0.undoManagerOccs.addEdit(e.getEdit());
                this.this$0.setUndoTooltips();
            }
        };
        this.totalLabels = new HashMap();
        this.parent = parent;
        this.well = well;
        this.sbdb = sbdb;
        this.initComponents();
        this.jPanelInterpretations = new JPanelWellInterp(parent, this, sbdb, well);
        this.jPanelCharts = new JPanelCharts(parent, this, sbdb);
        this.init();
        this.refresh();
    }

    private void init() throws SQLException, SBException {
        this.comboModelDiscipline.insertElementAt(ALL_STRING, 0);
        this.jComboBoxDiscipline.setSelectedIndex(0);
        this.tableModelSamples.setupTable(this.jTableSamples, true, this.sbdb, !this.well.hasShifts(), this.well.getTVDlist(false).getSize() == 0);
        this.jTableSamples.setRowSorter(new TableRowSorter<TableModelSamples>(this.tableModelSamples));
        new ColumnSortResetHandler(this.jTableSamples).attach();
        this.undoManagerOccs.setLimit(50);
        this.undoSupportOccs.addUndoableEditListener(this.undoManagerOccs);
        this.tableModelOcc.setupTable(this.jTableOccurrences, false, this.parent.getLogging(), this.sbdb);
        TableRowSorter<TableModelOccurrences> occRowSorter = new TableRowSorter<TableModelOccurrences>(this.tableModelOcc);
        occRowSorter.setComparator(3, new TaxonCompareGenus(new TaxonCompareSpecies()));
        this.jTableOccurrences.setRowSorter(occRowSorter);
        new ColumnSortResetHandler(this.jTableOccurrences).attach();
        this.tableModelOcc.undoSupport.addUndoableEditListener(this.undoManagerOccs);
        this.jToolBarOccUndo.setFloatable(false);
        this.jTableOccurrences.setDragEnabled(true);
        this.jTableOccurrences.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        this.jTableOccurrences.add(this.jPopupMenuOcc);
        this.tableModelAnalyses.setupTable(this.jTableAnalyses, this.sbdb);
        this.jTableAnalyses.setRowSorter(new TableRowSorter<TableModelAnalyses>(this.tableModelAnalyses));
        new ColumnSortResetHandler(this.jTableAnalyses).attach();
        this.jTableAnalyses.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    this.this$0.updateOverlay();
                }
            }
        });
        this.tableModelAnalyses.setTotExRwCv(this.parent.getTotExRwCv());
        this.jTabbedPaneSampleData.insertTab("Interpretations", IconFactory.getIcon("FrameSamples_IntTab.png"), this.jPanelInterpretations, null, 3);
        this.addChartTab();
        this.setUnits(this.well.getWellUnits());
        if (this.units == 'F') {
            this.jRadioButtonFeet.setSelected(true);
        } else {
            this.jRadioButtonMetres.setSelected(true);
        }
        this.tableModelDocuments.setupTable(this.jTableDocuments);
        this.tableModelDocuments.populateTable(this.well.getWellID(), this.sbdb);
        this.setSampleLabel();
        insertPrevButtonLabel = this.jButtonOccInsertPrev.getText();
        this.initKeyBindings();
        this.initHiResIcons();
        this.inStartup = false;
    }

    private void initHiResIcons() {
        if (SbugsSession.getSession().useHiResIcons()) {
            this.jTabbedPaneSampleData.setIconAt(this.jTabbedPaneSampleData.indexOfComponent(this.jPanelSamples), IconFactory.getIcon("FrameSamples_SamplesTab.svg"));
            this.jTabbedPaneSampleData.setIconAt(this.jTabbedPaneSampleData.indexOfComponent(this.jPanelAnalyses), IconFactory.getIcon("FrameJsbugs_jButtonSamples.svg", 16));
            this.jTabbedPaneSampleData.setIconAt(this.jTabbedPaneSampleData.indexOfComponent(this.jPanelOccurences), IconFactory.getIcon("FrameSamples_OccTab.svg"));
            this.jTabbedPaneSampleData.setIconAt(this.jTabbedPaneSampleData.indexOfComponent(this.jPanelInterpretations), IconFactory.getIcon("FrameSamples_IntTab.svg"));
            this.jTabbedPaneSampleData.setIconAt(this.jTabbedPaneSampleData.indexOfComponent(this.jPanelCharts), IconFactory.getIcon("FrameSamples_ChartTab.svg"));
            this.jTabbedPaneSampleData.setIconAt(this.jTabbedPaneSampleData.indexOfComponent(this.jPanelDocuments), IconFactory.getIcon("documents.svg"));
            IconFactory.setButtonIconsInBackground(List.of(new IconFactory.ButtonIconInfo(this.jButtonOccUndo, "undo.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonOccRedo, "redo.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonTaxonImage, "camera.svg", 24), new IconFactory.ButtonIconInfo(this.jButtonAnalysesImages, "camera.svg", 16)));
        }
    }

    boolean occurrencesTabSelected() {
        return this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelOccurences;
    }

    boolean analysesTabSelected() {
        return this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelAnalyses;
    }

    boolean documentsTabSelected() {
        return this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelDocuments;
    }

    UndoableEditSupport getUndoSupport() {
        return this.undoSupportOccs;
    }

    Smpdtl getSmpdtl() {
        if (this.jTableAnalyses.getSelectedRow() >= 0) {
            return this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
        }
        return null;
    }

    void hideBlockPropertiesDialog() {
        this.jPanelCharts.hideBlockPropertiesDialog();
    }

    char getDiscID() {
        return Discipline.getChar((Discipline)this.getDiscipline());
    }

    Discipline getDiscipline() {
        Object o = this.jComboBoxDiscipline.getSelectedItem();
        Discipline d = o instanceof Discipline ? (Discipline)o : null;
        return d;
    }

    void moveAnalyses() {
        if (this.jTableAnalyses.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one or more analyses from the list", this.parent.getTitle(), 1);
            return;
        }
        try {
            if (!this.well.canWrite(this.sbdb, null)) {
                JOptionPane.showMessageDialog(this, this.well.getDeniedReason(this.sbdb, "move analyses", "well", false), "Move Analyses", 2);
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        int[] selection = this.jTableAnalyses.getSelectedRows();
        AnalystHeader hdr = null;
        for (int i : selection) {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(i));
            if (hdr == null) {
                hdr = smpdtl.getHeader();
            } else if (hdr != smpdtl.getHeader()) {
                JOptionPane.showMessageDialog(this.parent, "You must select analyses from the same suite.", this.parent.getTitle(), 1);
                return;
            }
            smpdtls.add(smpdtl);
        }
        try {
            DialogAnalystHeaders dialog = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            AnalystHeader newHdr = dialog.selection;
            if (newHdr == hdr) {
                JOptionPane.showMessageDialog(this.parent, "The selected suite is the same as the selected analyses.", this.parent.getTitle(), 1);
                return;
            }
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = smpdtl.getSample();
                for (Smpdtl dtl : sample.getSmpdtls()) {
                    if (dtl.getHeader() != newHdr) continue;
                    JOptionPane.showMessageDialog(this.parent, "Can't move - already analysis in target set for sample: " + String.valueOf(sample), this.parent.getTitle(), 1);
                    return;
                }
            }
            Sample lastSample = null;
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = smpdtl.getSample();
                sample.moveDtl(this.well.getWellID(), hdr, newHdr);
                this.sbdb.commit();
                lastSample = sample;
            }
            if (lastSample != null) {
                lastSample.notifyObservers();
            }
            this.jTableAnalyses.clearSelection();
        }
        catch (SQLException | SBException ex) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error", (Throwable)ex);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    public String getTabTitle() {
        switch (tabTitlePref) {
            default: {
                return this.well.getWellName();
            }
            case CODE: {
                return this.well.getWellCode();
            }
            case ALT: 
        }
        return this.well.getHeader().getWellAltName(true);
    }

    void reassignTaxon() {
        if (this.jTableOccurrences.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one occurrence from the list on the occurrences tab.", this.parent.getTitle(), 1);
            return;
        }
        TaxonOcc occ = this.tableModelOcc.smpdtl.getOccurUnsorted().get(this.jTableOccurrences.convertRowIndexToModel(this.jTableOccurrences.getSelectedRow()));
        if (occ == null) {
            JOptionPane.showMessageDialog(this.parent, "No occurrence selected.", this.parent.getTitle(), 1);
            return;
        }
        try {
            DialogTaxonReassign dialog = new DialogTaxonReassign(this.parent, true, this.sbdb, this.parent.getSynSchID(), this.well, occ.getTaxon());
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            this.jTableOccurrences.clearSelection();
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, null);
        }
    }

    void printChart() {
        this.jPanelCharts.printChart();
    }

    void saveChart(boolean vector) {
        try {
            this.jPanelCharts.saveChart(vector);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    void exportChartHTML() {
        this.jPanelCharts.writeHTMLChart();
    }

    void exportChartSBG() {
        this.jPanelCharts.writeSBGChart();
    }

    void updateChartProperties(int blockTemplateID, ChartProperties updatedProperties) throws SQLException, SBException, IOException {
        this.jPanelCharts.updateChartProperties(blockTemplateID, updatedProperties);
    }

    void mergeAnalyses() {
        if (this.jTableAnalyses.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one or more analyses from the list", this.parent.getTitle(), 1);
            return;
        }
        try {
            if (!this.well.canWrite(this.sbdb, null)) {
                JOptionPane.showMessageDialog(this, this.well.getDeniedReason(this.sbdb, "merge analyses", "well", false), "Move Analyses", 2);
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        int[] selection = this.jTableAnalyses.getSelectedRows();
        AnalystHeader hdr = null;
        for (int i : selection) {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(i));
            if (hdr == null) {
                hdr = smpdtl.getHeader();
            } else if (hdr != smpdtl.getHeader()) {
                JOptionPane.showMessageDialog(this.parent, "You must select analyses from the same suite.", this.parent.getTitle(), 1);
                return;
            }
            smpdtls.add(smpdtl);
        }
        try {
            DialogAnalystHeaders dialog = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            AnalystHeader newHdr = dialog.selection;
            if (newHdr == hdr) {
                JOptionPane.showMessageDialog(this.parent, "The selected suite is the same as the selected analyses.", this.parent.getTitle(), 1);
                return;
            }
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = smpdtl.getSample();
                boolean foundExisting = false;
                for (Smpdtl dtl : sample.getSmpdtls()) {
                    if (dtl.getHeader() != newHdr) continue;
                    foundExisting = true;
                    break;
                }
                if (foundExisting) continue;
                JOptionPane.showMessageDialog(this.parent, "Can't merge - there is no analysis in target set for sample: " + String.valueOf(sample), this.parent.getTitle(), 1);
                return;
            }
            Sample lastSample = null;
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = smpdtl.getSample();
                sample.mergeDtl(this.well.getWellID(), smpdtl, newHdr);
                this.sbdb.commit();
                lastSample = sample;
            }
            lastSample.notifyObservers();
            this.jTableAnalyses.clearSelection();
        }
        catch (SQLException | SBException ex) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error", (Throwable)ex);
        }
    }

    void mergeSamples() {
        if (this.jTableSamples.getSelectedRowCount() != 2) {
            JOptionPane.showMessageDialog(this.parent, "Select two contiguous samples from the list", this.parent.getTitle(), 1);
            return;
        }
        int[] selection = this.jTableSamples.getSelectedRows();
        try {
            Sample sample1 = this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(selection[0]));
            Sample sample2 = this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(selection[1]));
            if (this.well.getSamples().indexOf(sample2) != this.well.getSamples().indexOf(sample1) + 1) {
                JOptionPane.showMessageDialog(this.parent, "Selected samples are not contiguous in the well. Remove intervening samples if necessary", this.parent.getTitle(), 1);
                return;
            }
            String reason = this.well.mergeSampleCheckConflicts(sample1.getSampID(), sample2.getSampID());
            if (reason != null) {
                JOptionPane.showMessageDialog(this, "Cannot merge these samples without creating conflicting data: " + reason + "\nDelete data before proceeding", this.parent.getTitle(), 2);
                return;
            }
            DialogMergeSamples dialog = new DialogMergeSamples(this.parent, true, this.sbdb, this.units, this.well, sample1, sample2);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jTableSamples.clearSelection();
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeAllSamples() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean merged = true;
            int nMerged = 0;
            block5: while (merged) {
                merged = false;
                List<Sample> samples = this.well.getSamples();
                for (int i = 0; i < samples.size() - 1; ++i) {
                    String reason;
                    Sample sample1 = samples.get(i);
                    Sample sample2 = samples.get(i + 1);
                    if (sample1.getType() != sample2.getType()) continue;
                    if (sample2.getTopDepth() == null && sample1.getTopDepth() != null && Math.abs(sample1.getBaseDepth() - sample2.getBaseDepth()) < (double)0.0029f) {
                        reason = this.well.mergeSampleCheckConflicts(sample1.getSampID(), sample2.getSampID());
                        if (reason != null) continue;
                        this.well.mergeSamples(sample2, sample1);
                        this.well.notifyObservers(sample1);
                        this.well.getDataModel().commit();
                        merged = true;
                        ++nMerged;
                        continue block5;
                    }
                    if (sample1.getBaseDepth() != null || sample2.getBaseDepth() == null || !(Math.abs(sample1.getTopDepth() - sample2.getTopDepth()) < (double)0.0029f) || (reason = this.well.mergeSampleCheckConflicts(sample1.getSampID(), sample2.getSampID())) != null) continue;
                    this.well.mergeSamples(sample1, sample2);
                    this.well.notifyObservers(sample2);
                    this.well.getDataModel().commit();
                    merged = true;
                    ++nMerged;
                    continue block5;
                }
            }
            JOptionPane.showMessageDialog(this.parent, nMerged + " sample(s) merged.", "Sample merge", 1);
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError(ex, null);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    List<Smpdtl> getSelectedSmpdtls() {
        int[] rows;
        List<Smpdtl> smpdtls = this.tableModelAnalyses.getSmpdtls();
        LinkedList<Smpdtl> selected = new LinkedList<Smpdtl>();
        for (int row : rows = this.jTableAnalyses.getSelectedRows()) {
            selected.add(smpdtls.get(this.jTableAnalyses.convertRowIndexToModel(row)));
        }
        return selected;
    }

    void openOverlay() {
        try {
            Smpdtl smpdtl = null;
            if (this.jTableAnalyses.getSelectedRowCount() == 1) {
                smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
            }
            if (this.parent.parent.getFrameOverlay() == null) {
                DialogOverlays dialog = new DialogOverlays(this.parent, this.parent.parent, true, this.sbdb, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                dialog.selection.load();
                FrameOverlay frameOverlay = new FrameOverlay(this.parent.getParent().getAltGC(), this.parent.getParent(), this.sbdb, this.well, smpdtl, dialog.selection, this.parent.isCMF(), this.parent);
                this.parent.parent.setFrameOverlay(frameOverlay);
                this.parent.parent.getFrameOverlay().setExtendedState(6);
                frameOverlay.getUndoSupport().addUndoableEditListener(this.undoManagerOccs);
                this.parent.setOverlayTotaliser();
            } else {
                JOptionPane.showMessageDialog(this, "An overlay is already in use - close before reopening", "Close Overlay", 2);
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error", (Throwable)ex);
        }
    }

    void openOverlayBrowser() {
        try {
            if (this.overlayServer != null) {
                if (JOptionPane.showConfirmDialog(this.parent, "An overlay server is already in use - restart?", this.parent.getTitle(), 0, 3) == 0) {
                    this.overlayServer.close();
                    this.overlayServer = null;
                } else {
                    return;
                }
            }
            DialogOverlays dialog = new DialogOverlays(this.parent, this.parent.parent, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            dialog.selection.load();
            DialogOverlayWeb dialogWeb = new DialogOverlayWeb((Frame)this.parent, true, this.sbdb, dialog.selection);
            dialogWeb.setLocationRelativeTo(this);
            dialogWeb.setVisible(true);
            if (!dialogWeb.isOk) {
                return;
            }
            this.overlayServer = new OverlayWebServer(dialogWeb.portNo, dialogWeb.textSize, dialogWeb.useSounds, this.sbdb, this.parent, this, dialog.selection);
            JOptionPane.showMessageDialog(this.parent, "Server started, use the following address in your browser:\nhttp://" + dialogWeb.myIp + ":" + dialogWeb.portNo, "StrataBugs overlay server", 1);
            this.overlayServer.getUndoSupport().addUndoableEditListener(this.undoManagerOccs);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.parent, ex.getMessage(), this.parent.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    void closeOverlayServer() {
        if (this.overlayServer == null) {
            return;
        }
        this.overlayServer.close();
        this.overlayServer = null;
    }

    private void updateOverlay() {
        if (this.parent.parent.getFrameOverlay() == null) {
            return;
        }
        if (this.jTableAnalyses.getSelectedRow() >= 0) {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
            this.parent.parent.getFrameOverlay().setSmpdtl(this.well, smpdtl);
            smpdtl.addWeakObserver(this);
        } else {
            this.parent.parent.getFrameOverlay().setSmpdtl(this.well, null);
        }
    }

    private void updateComments() {
        String comment = DEFAULT_COMMENT_TEXT;
        Color foreground = Color.GRAY;
        this.jTextAreaComment.setEditable(false);
        try {
            Smpdtl smpdtl = this.tableModelOcc.smpdtl;
            WellInterp interp = this.jPanelInterpretations.getInterp();
            if (interp == null) {
                comment = "No interpretation loaded";
            } else if (smpdtl != null) {
                char occDiscID = smpdtl.getDiscID();
                Iterator<Biocom> it = interp.getComments(occDiscID).iterator();
                this.biocom = null;
                while (it.hasNext()) {
                    Biocom b = it.next();
                    if (b.getTopSample() != smpdtl.getSample() || b.getAnalyst() != smpdtl.getHeader().getAnalystUsrid()) continue;
                    this.biocom = b;
                    break;
                }
                if (this.biocom != null) {
                    comment = this.biocom.getText();
                    foreground = Color.BLACK;
                    this.jTextAreaComment.setEditable(true);
                }
            }
        }
        catch (Exception sb) {
            sb.printStackTrace();
        }
        this.jTextAreaComment.setText(comment);
        this.jTextAreaComment.setForeground(foreground);
    }

    void sampleWeight() {
        if (this.jTableAnalyses.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select at least one sample analysis.", this.parent.getTitle(), 2);
            return;
        }
        int[] selection = this.jTableAnalyses.getSelectedRows();
        String weightString = JOptionPane.showInputDialog(this.parent, (Object)"Enter sample weight for all selected analyses: ");
        if (weightString == null || weightString.length() == 0) {
            return;
        }
        try {
            float weight = Float.parseFloat(weightString);
            Smpdtl last = null;
            for (int i = 0; i < selection.length; ++i) {
                Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(selection[i]);
                smpdtl.setWeight(this.sbdb, this.well.getWellID(), weight);
                last = smpdtl;
            }
            if (last != null) {
                last.notifyObservers();
            }
            this.sbdb.commit();
        }
        catch (SQLException | SBException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error", (Exception)ex, this.sbdb);
        }
    }

    void sampleCopy() {
        if (this.jTableAnalyses.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select a sample analysis to copy into", this.parent.getTitle(), 2);
            return;
        }
        if (this.tableModelOcc.unsaved != null && !this.tableModelOcc.unsaved.isEmpty()) {
            this.tableModelOcc.unsaved = null;
        }
        Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
        try {
            smpdtl.load(this.well.getWellID());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        String smpdtlStrg = smpdtl.getSample().toString(this.units) + " " + smpdtl.getHeader().toString();
        try {
            DialogSampleCopy dialog = new DialogSampleCopy(this.parent, true, this.sbdb, this.well, smpdtl.getDiscID(), smpdtlStrg, smpdtl.getNOccs() == 0);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.doSampleCopy(dialog.smpdtlFrom, smpdtl, dialog.getKeepAbundance(), dialog.getIgnoreQs(), dialog.getKeepComments(), dialog.getTaxa());
            }
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void doSampleCopy(Smpdtl smpdtlFrom, Smpdtl smpdtl, int abnOpt, boolean ignoreQ, boolean keepComments, List<Taxon> taxaToCopy) {
        try {
            this.showOccurrences();
            SbugsCompoundEdit edit = null;
            if (abnOpt != 3) {
                edit = new SbugsCompoundEdit("copy occurrences");
            }
            block7: for (TaxonOcc fss : smpdtlFrom.getOccurUnsorted()) {
                int medium;
                int coarse;
                String subj;
                if (!taxaToCopy.contains(fss.getTaxon())) continue;
                if (abnOpt == 3) {
                    for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                        if (occ.getTaxon() != fss.getTaxon() || !ignoreQ && (fss.getReworked() != occ.getReworked() || fss.getQuestionable() != occ.getQuestionable() || fss.getSpecType() != occ.getSpecType())) continue;
                        continue block7;
                    }
                    if (this.tableModelOcc.hasUnsaved(fss.getTaxon(), fss.getQuestionable(), fss.getSituation(), fss.getSpecType())) continue;
                }
                int fine = switch (abnOpt) {
                    default -> {
                        subj = fss.getSubAbund();
                        coarse = fss.getCoarse();
                        medium = fss.getMedium();
                        yield fss.getFine();
                    }
                    case 2, 3 -> {
                        subj = "+";
                        coarse = 0;
                        medium = 0;
                        yield 0;
                    }
                };
                TaxonOcc.Builder builder = new TaxonOcc.Builder(this.sbdb, fss.getTaxon(), ignoreQ ? Situation.INSITU : fss.getSituation(), ignoreQ ? false : fss.getQuestionable(), fss.getSpecType());
                if (!ignoreQ) {
                    builder.marker(fss.isMarker());
                }
                if (keepComments) {
                    builder.preservation(fss.getPreservation());
                    builder.colour(fss.getColour());
                    builder.comment(fss.getComment());
                }
                if (abnOpt == 3) {
                    this.tableModelOcc.addUnsaved(builder);
                    this.tableModelOcc.fireTableDataChanged();
                    continue;
                }
                builder.count(coarse, medium, fine).subjAbund(subj);
                edit.addEdit((UndoableEdit)((Object)smpdtl.insertOccurrence(builder, this.well.getWellID())));
            }
            this.sbdb.commit();
            if (edit != null) {
                edit.end();
                this.undoSupportOccs.postEdit((UndoableEdit)edit);
            }
            smpdtl.notifyObservers();
            this.well.setDataChanged();
            this.well.notifyObservers((Object)smpdtl);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    void sampleGenerate() {
        try {
            DialogSampleGenerate dialog = new DialogSampleGenerate(this.parent, true, this.sbdb, this.well, this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.addAnalyses && !dialog.generated.isEmpty()) {
                AnalystHeader hdr;
                if (this.well.getAnalystHeaders().size() == 1) {
                    hdr = this.well.getAnalystHeaders().get(0);
                } else {
                    DialogAnalystHeaders dialogAnalystHeaders = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
                    dialogAnalystHeaders.setLocationRelativeTo(this.parent);
                    dialogAnalystHeaders.setVisible(true);
                    hdr = dialogAnalystHeaders.selection;
                }
                if (hdr != null) {
                    int added = 0;
                    for (Sample sample : dialog.generated) {
                        sample.addDtl(this.well.getWellID(), hdr, Smpdtl.AnalysisType.PREPARED, "", "", "", "", 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0);
                        ++added;
                    }
                    if (added > 0) {
                        this.sbdb.commit();
                        this.well.setDataChanged();
                        this.well.notifyObservers(Smpdtl.class);
                        JOptionPane.showMessageDialog(this, added + " analyses added", "Generate samples", 1);
                    }
                }
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
    }

    private void initKeyBindings() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "undo");
        this.getActionMap().put("undo", new UndoAction(this, true));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), "redo");
        this.getActionMap().put("redo", new UndoAction(this, false));
    }

    void addChartTab() {
        this.jTabbedPaneSampleData.insertTab("Charts", IconFactory.getIcon("FrameSamples_ChartTab.png"), this.jPanelCharts, null, 4);
        this.jPanelCharts.hideBlockPropertiesDialog();
        this.chartsFrameDetached = null;
    }

    boolean detachChartTab() {
        boolean ret = false;
        if (this.chartsFrameDetached == null) {
            this.jPanelCharts.stateChanged();
            this.jPanelCharts.hideBlockPropertiesDialog();
            this.chartsFrameDetached = new FrameWellChartsDetached(this, this.jPanelCharts);
            this.remove(this.jPanelCharts);
            ret = true;
        }
        this.chartsFrameDetached.setLocationRelativeTo(this);
        this.chartsFrameDetached.setVisible(true);
        return ret;
    }

    @Override
    public void update(Observable o, Object a) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdate(o, a);
        } else {
            final Observable obs = o;
            final Object arg = a;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ JPanelWell this$0;
                {
                    JPanelWell jPanelWell = this$0;
                    Objects.requireNonNull(jPanelWell);
                    this.this$0 = jPanelWell;
                }

                @Override
                public void run() {
                    this.this$0.doUpdate(obs, arg);
                }
            });
        }
    }

    private void doUpdate(Observable obs, Object arg) {
        JPanelWell thisPanel = this;
        if (obs instanceof Well && obs == this.well) {
            if (!(arg instanceof WellInterp)) {
                if (arg instanceof WellHeader) {
                    this.parent.setWellTabTitle(this.well);
                } else if (arg instanceof AnalystHeader) {
                    AnalystHeader hdr = (AnalystHeader)arg;
                    if (this.comboModelAnalyNo.getIndexOf(hdr.getAnalyNumber()) < 0) {
                        this.comboModelAnalyNo.addElement(hdr.getAnalyNumber());
                        this.jComboBoxAnalysisNumber.repaint();
                    }
                    try {
                        if (this.comboModelAnalyst.getIndexOf(hdr.getAnalyst()) < 0) {
                            this.comboModelAnalyst.addElement(hdr.getAnalyst());
                            this.jComboBoxAnalyst.repaint();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (arg instanceof Smpdtl) {
                    if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelOccurences && (Smpdtl)((Object)arg) == this.tableModelOcc.smpdtl) {
                        this.tableModelOcc.clearCachedImagesForCurrentSmpdtl();
                        this.tableModelOcc.fireTableDataChanged();
                    } else {
                        this.refreshAnalyses();
                    }
                } else if (arg instanceof Sample || arg == Sample.class) {
                    this.tableModelSamples.fireTableDataChanged();
                    this.refreshAnalyses();
                    try {
                        this.setSampleLabel();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (arg == SampleLithology.class) {
                    this.tableModelSamples.fireTableDataChanged();
                } else {
                    this.tableModelSamples.fireTableDataChanged();
                    this.refreshAnalyses();
                    try {
                        this.setSampleLabel();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (obs instanceof Smpdtl && obs == this.tableModelOcc.smpdtl) {
            this.tableModelOcc.fireTableDataChanged();
            Smpdtl smpdtl = this.tableModelOcc.smpdtl;
            try {
                this.jTextFieldAnalyst.setText(smpdtl.getAnalystAbr() + "/" + smpdtl.getHeader().getAnalyNumber());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.jCheckBoxBarren.isSelected() != smpdtl.getBarren()) {
                this.jCheckBoxBarren.setSelected(smpdtl.getBarren());
            }
            this.setNTaxaText(smpdtl);
            this.updateTotals();
            if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelAnalyses) {
                this.refreshAnalyses();
            }
        } else if (obs instanceof Sample) {
            this.refreshAnalyses();
        } else if (obs instanceof WellInterp && obs == this.jPanelInterpretations.getInterp() && arg instanceof Biocom) {
            this.updateComments();
        }
    }

    void setNTaxaText() {
        this.setNTaxaText(this.getSmpdtl());
    }

    void setNTaxaText(Smpdtl smpdtl) {
        if (smpdtl != null) {
            String text = "<html><b>Taxa: </b>" + smpdtl.getNOccs() + "</html>";
            this.jLabelNtaxa.setText(text);
            int inSitu = smpdtl.getNOccs(true);
            if (inSitu != smpdtl.getNOccs()) {
                text = "<html><b>In situ: </b>" + inSitu + "</html>";
                this.jLabelNtaxaInSitu.setVisible(true);
                this.jLabelNtaxaInSitu.setText(text);
            } else {
                this.jLabelNtaxaInSitu.setVisible(false);
            }
            text = "<html><b>Total: </b>" + smpdtl.getTotalCount(this.parent.getTotExRwCv());
            if (this.parent.getPicklistTotaliser() > 0) {
                text = text + "/" + this.parent.getPicklistTotaliser();
            }
            text = text + "</html>";
            this.jLabelNtaxaTotal.setText(text);
        }
    }

    void updateTotExRwCv() {
        this.setNTaxaText();
        this.updateTotals();
        this.tableModelAnalyses.setTotExRwCv(this.parent.getTotExRwCv());
    }

    private void refresh() {
        this.well.addObserver(this);
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.tableModelSamples.setSamples(this.well, this);
            this.tableModelAnalyses.setSmpdtls(this.well.getAnalyses('\u0000', null, 0), this);
            this.fillAnalystCombo();
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error loading samples", (Throwable)e);
        }
        this.tableModelSamples.fireTableDataChanged();
        this.tableModelAnalyses.fireTableDataChanged();
        try {
            this.jPanelInterpretations.fillBioSchemeCombo();
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error loading samples", (Throwable)e);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    void setUnits(char units) {
        if (units == 'M' && this.units != 'M' || units == 'F' && this.units != 'F') {
            this.units = units;
            this.tableModelSamples.setUnits(units);
            TableUtils.updateTableColumnNames((JTable)this.jTableSamples);
            this.tableModelSamples.fireTableDataChanged();
            this.tableModelAnalyses.units = units;
            TableUtils.updateTableColumnNames((JTable)this.jTableAnalyses);
            this.tableModelAnalyses.fireTableDataChanged();
            this.jPanelInterpretations.setUnits(units);
        }
    }

    void setBarren(boolean barren) {
        this.jCheckBoxBarren.setSelected(barren);
    }

    private void fillAnalystCombo() throws SQLException, SBException {
        this.comboModelAnalyst.removeAllElements();
        this.comboModelAnalyst.addElement(ALL_STRING);
        this.comboModelAnalyNo.removeAllElements();
        this.comboModelAnalyNo.addElement(ALL_STRING);
        List<AnalystHeader> hdrs = this.well.getAnalystHeaders();
        for (AnalystHeader hdr : hdrs) {
            if (this.comboModelAnalyst.getIndexOf(hdr.getAnalyst()) < 0) {
                this.comboModelAnalyst.addElement(hdr.getAnalyst());
            }
            if (this.comboModelAnalyNo.getIndexOf(hdr.getAnalyNumber()) >= 0) continue;
            this.comboModelAnalyNo.addElement(hdr.getAnalyNumber());
        }
        this.jComboBoxAnalyst.updateUI();
        this.jComboBoxAnalyst.setSelectedIndex(0);
        this.jComboBoxAnalysisNumber.setSelectedIndex(0);
        this.analyNo = 0;
        this.analystString = "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean addAnalysis(boolean fromSampleTab) {
        try {
            if (!this.well.canWrite(this.sbdb, null)) {
                JOptionPane.showMessageDialog(this, this.well.getDeniedReason(this.sbdb, "add analyses", "well", false), this.parent.getTitle(), 2);
                return false;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return false;
        }
        try {
            AnalystHeader analyHdr;
            Sample sample = null;
            LinkedList<Sample> samples = null;
            if (!fromSampleTab && this.jTableAnalyses.getSelectedRowCount() == 1) {
                Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
                sample = smpdtl.getSample();
            } else if (this.jTableSamples.getSelectedRowCount() < 1) {
                DialogSelectSample samplesDialog = new DialogSelectSample(this.parent, true, this.sbdb, this.well, null, this.units);
                samplesDialog.setLocationRelativeTo(this);
                samplesDialog.setVisible(true);
                if (!samplesDialog.isOK()) return false;
                sample = samplesDialog.selection;
            } else if (this.jTableSamples.getSelectedRowCount() == 1) {
                sample = this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(this.jTableSamples.getSelectedRow()));
            } else {
                samples = new LinkedList<Sample>();
                int[] selection = this.jTableSamples.getSelectedRows();
                for (int index = 0; index < selection.length; ++index) {
                    samples.add(this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(selection[index])));
                }
            }
            Discipline currentDiscID = this.getDiscipline();
            if (currentDiscID == null || this.analystString == null || this.analystString.length() == 0 || this.analyNo == 0) {
                DialogAnalystHeaders dialogAnalystHeaders = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
                dialogAnalystHeaders.setLocationRelativeTo(this.parent);
                dialogAnalystHeaders.setVisible(true);
                if (dialogAnalystHeaders.selection == null) {
                    return false;
                }
                analyHdr = dialogAnalystHeaders.selection;
            } else {
                analyHdr = this.well.getAnalystHeader(this.analystString, currentDiscID.getChar(), this.analyNo, true);
            }
            if (samples == null) {
                DialogAnalysis dialog = new DialogAnalysis(this.parent, true, this.sbdb, this.well, sample, null, analyHdr, this.units);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (!dialog.isOK()) return false;
                this.tableModelSamples.fireTableDataChanged();
                this.setSelectedSample(sample);
                this.setSelectedAnalysis(sample, dialog.smpdtl);
                return true;
            }
            for (Sample toAdd : samples) {
                if (toAdd.getAnalysis(analyHdr.getAnalyID()) != null) continue;
                toAdd.addDtl(this.well.getWellID(), analyHdr, Smpdtl.AnalysisType.PREPARED, "", "", "", "", 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0);
                sample = toAdd;
            }
            if (sample != null) {
                this.sbdb.commit();
                sample.notifyObservers();
                this.well.setDataChanged();
                this.well.notifyObservers(Smpdtl.class);
                this.tableModelSamples.fireTableDataChanged();
                return true;
            }
            JOptionPane.showMessageDialog(this.parent, "Analyses already exist - no new analyses added", this.parent.getTitle(), 1);
            return false;
        }
        catch (SQLException | SBException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error adding analyses", (Exception)ex, this.sbdb);
            return false;
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        return false;
    }

    void editAnalysis() {
        if (this.jTableAnalyses.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one analysis from the list", this.parent.getTitle(), 1);
            return;
        }
        Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
        Sample sample = smpdtl.getSample();
        try {
            DialogAnalysis dialog = new DialogAnalysis(this.parent, true, this.sbdb, this.well, sample, smpdtl, smpdtl.getHeader(), this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            int index = this.jTableAnalyses.convertRowIndexToView(this.tableModelAnalyses.getSmpdtls().indexOf((Object)dialog.smpdtl));
            if (index >= 0) {
                this.jTableAnalyses.getSelectionModel().setSelectionInterval(index, index);
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, null);
        }
    }

    WellInterp getInterp() {
        return this.jPanelInterpretations.getInterp();
    }

    void selectDefaultVersion() {
        this.jPanelInterpretations.loadDefaultVersion();
    }

    Well getWell() {
        return this.well;
    }

    private void refreshAnalyses() {
        try {
            int index;
            Smpdtl selected = null;
            if (this.jTableAnalyses.getSelectedRow() >= 0) {
                selected = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
            }
            this.tableModelAnalyses.setSmpdtls(this.well.getAnalyses(this.getDiscID(), this.analystString, this.analyNo), this);
            this.tableModelAnalyses.fireTableDataChanged();
            if (this.tableModelOcc.smpdtl != null && this.tableModelAnalyses.getSmpdtls().indexOf((Object)this.tableModelOcc.smpdtl) < 0) {
                this.tableModelOcc.smpdtl = null;
                this.tableModelOcc.unsaved = null;
            }
            this.tableModelOcc.fireTableDataChanged();
            this.jLabelnAnalyses.setText(this.tableModelAnalyses.getSmpdtls().size() + " Analyses");
            if (selected != null && (index = this.tableModelAnalyses.getSmpdtls().indexOf((Object)selected)) >= 0) {
                this.jTableAnalyses.setRowSelectionInterval(this.jTableAnalyses.convertRowIndexToModel(index), this.jTableAnalyses.convertRowIndexToModel(index));
            }
        }
        catch (SQLException | SBException ex) {
            ex.printStackTrace();
        }
    }

    private void setSplits(Smpdtl smpdtl) {
        TableColumnModel columns = this.jTableOccurrences.getColumnModel();
        TableColumn coarseCol = columns.getColumn(this.jTableOccurrences.convertColumnIndexToView(8));
        TableColumn mediumCol = columns.getColumn(this.jTableOccurrences.convertColumnIndexToView(9));
        TableColumn fineCol = columns.getColumn(this.jTableOccurrences.convertColumnIndexToView(10));
        TableColumn aggCol = columns.getColumn(this.jTableOccurrences.convertColumnIndexToView(11));
        if (!(this.parent.isCMF() || smpdtl != null && smpdtl.hasSplitCountData())) {
            coarseCol.setMinWidth(0);
            coarseCol.setMaxWidth(0);
            coarseCol.setResizable(false);
            fineCol.setMinWidth(0);
            fineCol.setMaxWidth(0);
            fineCol.setResizable(false);
            aggCol.setMinWidth(0);
            aggCol.setMaxWidth(0);
            aggCol.setResizable(false);
            mediumCol.setHeaderValue("Counts");
            this.splitColumnsDisplayed = false;
        } else if (!this.splitColumnsDisplayed) {
            int maxwidth = columns.getColumn(9).getMaxWidth();
            coarseCol.setMaxWidth(maxwidth);
            coarseCol.setMinWidth(15);
            coarseCol.setPreferredWidth(this.tableModelOcc.getDefaultColumnWidths()[8]);
            coarseCol.setResizable(true);
            fineCol.setMaxWidth(maxwidth);
            fineCol.setMinWidth(15);
            fineCol.setPreferredWidth(this.tableModelOcc.getDefaultColumnWidths()[10]);
            fineCol.setResizable(true);
            aggCol.setMinWidth(15);
            aggCol.setMaxWidth(maxwidth);
            aggCol.setPreferredWidth(this.tableModelOcc.getDefaultColumnWidths()[11]);
            aggCol.setResizable(true);
            mediumCol.setHeaderValue(TableModelOccurrences.columnTitles[9]);
            this.splitColumnsDisplayed = true;
        }
    }

    private boolean showOccurrences() {
        if (this.tableModelAnalyses.getRowCount() > 0) {
            int row = this.jTableAnalyses.getSelectedRow();
            if (row < 0) {
                row = 0;
                this.jTableAnalyses.setRowSelectionInterval(row, row);
            }
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(row));
            if (this.tableModelOcc.smpdtl != null && smpdtl != this.tableModelOcc.smpdtl) {
                if (this.tableModelOcc.unsaved != null && !this.tableModelOcc.unsaved.isEmpty()) {
                    String msg = "You will lose all unsaved occurrences in analysis '" + this.tableModelOcc.smpdtl.getSample().toString(this.well.getWellUnits(), true, false) + " " + String.valueOf(this.tableModelOcc.smpdtl.getHeader()) + " " + SBdb.getDiscAbr(this.tableModelOcc.smpdtl.getDiscID()) + "'\nContinue?";
                    if (JOptionPane.showConfirmDialog(this.parent, msg, this.parent.getTitle(), 0) != 0) {
                        return false;
                    }
                    this.tableModelOcc.unsaved = null;
                }
                this.jButtonOccInsertPrev.setText(insertPrevButtonLabel);
                this.insertPrevLookback = 0;
            }
            try {
                smpdtl.load(this.well.getWellID());
                this.jTextFieldDiscipline.setText(SBdb.getDiscAbr(smpdtl.getDiscID()));
                this.jTextFieldSample.setText(smpdtl.getSample().toString(this.units));
                this.jTextFieldAnalyst.setText(smpdtl.getAnalystAbr() + "/" + smpdtl.getHeader().getAnalyNumber());
                this.jCheckBoxBarren.setSelected(smpdtl.getBarren());
                this.tableModelOcc.smpdtl = smpdtl;
                this.tableModelOcc.well = this.well;
                this.setSplits(smpdtl);
                this.tableModelOcc.fireTableDataChanged();
                this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelOccurences);
                this.setNTaxaText(smpdtl);
                this.updateTotals();
                smpdtl.addWeakObserver(this);
                for (JPanelPicklist picklist : this.parent.getPicklists()) {
                    picklist.setAbnScheme();
                    picklist.resetSampleTotalMessage();
                }
                this.parent.setOverlayTotaliser();
                this.updateComments();
                this.undoManagerOccs.discardAllEdits();
                this.setUndoTooltips();
                boolean enableOccButtons = true;
                if (this.sbdb.restrictedToDiscID(smpdtl.getDiscID())) {
                    enableOccButtons = false;
                }
                this.jButtonOccComment.setEnabled(enableOccButtons);
                this.jButtonOccEdit.setEnabled(enableOccButtons);
                this.jButtonOccEvent.setEnabled(enableOccButtons);
                this.jButtonDeleteOccurences.setEnabled(enableOccButtons);
                return true;
            }
            catch (SQLException ex) {
                FrameJsbugs.showStackError("SQL Error", ex, this.sbdb);
            }
            catch (SBException ex) {
                StackError.showStackError((String)"Error", (Throwable)ex);
            }
            return false;
        }
        this.jTextFieldDiscipline.setText("");
        this.jTextFieldSample.setText("No analyses");
        this.jTextFieldAnalyst.setText("");
        this.jLabelNtaxa.setText("");
        this.jCheckBoxBarren.setSelected(false);
        this.tableModelOcc.smpdtl = null;
        this.tableModelOcc.fireTableDataChanged();
        this.setNTaxaText(null);
        JPanelPicklist picklist = this.parent.getPicklists().get(0);
        if (picklist != null) {
            picklist.resetSampleTotalMessage();
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroupDepthUnits = new ButtonGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroupViewer = new ButtonGroup();
        this.jPopupMenuOcc = new JPopupMenu();
        this.jMenuItemOccEdit = new JMenuItem();
        this.jMenuItemOccDelete = new JMenuItem();
        this.jMenuItemOccImage = new JMenuItem();
        this.jMenuItemOccBiostratComment = new JMenuItem();
        this.jMenuItemOccSetCvRe = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jPopupMenuSamples = new JPopupMenu();
        this.jMenuItemSamplesEdit = new JMenuItem();
        this.jMenuItemSamplesDelete = new JMenuItem();
        this.jMenuItemAnalyses = new JMenuItem();
        this.jPopupMenuAnalyses = new JPopupMenu();
        this.jMenuItemAnalyEdit = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuItemAnalyEditOcc = new JMenuItem();
        this.jMenuItemAnalyEvent = new JMenuItem();
        this.jTabbedPaneSampleData = new JTabbedPane();
        this.jPanelSamples = new JPanel();
        this.jButtonAddSample = new JButton();
        this.jButtonEditSample = new JButton();
        this.jButtonDeleteSamples = new JButton();
        this.jScrollPaneSamples = new JScrollPane();
        this.jTableSamples = new JTable();
        this.jButtonAddSampleSmpdtl = new JButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jLabelSamples = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.jButtonSaveSamples = new JButton();
        this.jButtonEditSelection = new JButton();
        this.jPanelAnalyses = new JPanel();
        this.jScrollPaneAnalyses = new JScrollPane();
        this.jTableAnalyses = new JTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxDiscipline = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxAnalyst = new JComboBox();
        this.jButtonAnalystHeader = new JButton();
        this.jButtonAddSmpdtl = new JButton();
        this.jButtonEditSmpdtl = new JButton();
        this.jButtonDeleteSmpdtl = new JButton();
        this.jLabel7 = new JLabel();
        this.jComboBoxAnalysisNumber = new JComboBox();
        this.jButtonShowAll = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonSaveAsAnalyses = new JButton();
        this.jLabelnAnalyses = new JLabel();
        this.jButtonAnalysesImages = new JButton();
        this.jPanelOccurences = new JPanel();
        this.jTextFieldSample = new JTextField();
        this.jButtonNext = new JButton();
        this.jButtonPrevious = new JButton();
        this.jCheckBoxBarren = new JCheckBox();
        this.jTextFieldAnalyst = new JTextField();
        this.jTextFieldDiscipline = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonDeleteOccurences = new JButton();
        this.jButtonOccEvent = new JButton();
        this.jButtonOccEdit = new JButton();
        this.jButtonOccComment = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPaneOccurences = new JScrollPane();
        this.jTableOccurrences = new SbugsTable();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jPanelTotals = new JPanel();
        this.jPanelTotals.setLayout(new GridLayout(0, 1, 0, 3));
        this.jLabelNtaxa = new JLabel();
        this.jLabelNtaxaTotal = new JLabel();
        this.jLabelNtaxaInSitu = new JLabel();
        this.jSeparator6 = new JSeparator();
        this.jToolBarOccUndo = new JToolBar();
        this.jButtonOccUndo = new JButton();
        this.jButtonOccRedo = new JButton();
        this.jButtonOccInsertPrev = new JButton();
        this.jButtonSetRwCv = new JButton();
        this.jButtonTaxonImage = new JButton();
        this.jPanelDocuments = new JPanel();
        this.jButtonAddDoc = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonInternal = new JRadioButton();
        this.jRadioButtonExternal = new JRadioButton();
        this.jButtonDeleteDoc = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableDocuments = new JTable();
        this.jButtonShowDoc = new JButton();
        this.jButtonDocRefs = new JButton();
        this.jPanelPdfPreview = new JPanelPdfPreview();
        this.jButtonWriteDoc = new JButton();
        this.jMenuItemOccEdit.setText("Edit...");
        this.jMenuItemOccEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOccEditActionPerformed(evt);
            }
        });
        this.jPopupMenuOcc.add(this.jMenuItemOccEdit);
        this.jMenuItemOccDelete.setText("Delete");
        this.jMenuItemOccDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOccDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuOcc.add(this.jMenuItemOccDelete);
        this.jMenuItemOccImage.setText("Add/edit images...");
        this.jMenuItemOccImage.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOccImageActionPerformed(evt);
            }
        });
        this.jPopupMenuOcc.add(this.jMenuItemOccImage);
        this.jMenuItemOccBiostratComment.setText("Biostratigraphic comment...");
        this.jMenuItemOccBiostratComment.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOccBiostratCommentActionPerformed(evt);
            }
        });
        this.jPopupMenuOcc.add(this.jMenuItemOccBiostratComment);
        this.jMenuItemOccSetCvRe.setText("Set Rw/Cv...");
        this.jMenuItemOccSetCvRe.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOccSetCvReActionPerformed(evt);
            }
        });
        this.jPopupMenuOcc.add(this.jMenuItemOccSetCvRe);
        this.jMenuItem1.setText("jMenuItem1");
        this.jMenuItemSamplesEdit.setText("Edit...");
        this.jMenuItemSamplesEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSamplesEditActionPerformed(evt);
            }
        });
        this.jPopupMenuSamples.add(this.jMenuItemSamplesEdit);
        this.jMenuItemSamplesDelete.setText("Delete");
        this.jMenuItemSamplesDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemSamplesDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuSamples.add(this.jMenuItemSamplesDelete);
        this.jMenuItemAnalyses.setText("Analyses...");
        this.jMenuItemAnalyses.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAnalysesActionPerformed(evt);
            }
        });
        this.jPopupMenuSamples.add(this.jMenuItemAnalyses);
        this.jMenuItemAnalyEdit.setText("Edit...");
        this.jMenuItemAnalyEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAnalyEditActionPerformed(evt);
            }
        });
        this.jPopupMenuAnalyses.add(this.jMenuItemAnalyEdit);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuAnalyses.add(this.jMenuItemDelete);
        this.jMenuItemAnalyEditOcc.setText("Edit taxon occurrence...");
        this.jMenuItemAnalyEditOcc.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAnalyEditOccActionPerformed(evt);
            }
        });
        this.jPopupMenuAnalyses.add(this.jMenuItemAnalyEditOcc);
        this.jMenuItemAnalyEvent.setText("Add event for taxon...");
        this.jMenuItemAnalyEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemAnalyEventActionPerformed(evt);
            }
        });
        this.jPopupMenuAnalyses.add(this.jMenuItemAnalyEvent);
        this.jTabbedPaneSampleData.setMinimumSize(new Dimension(550, 600));
        this.jTabbedPaneSampleData.setPreferredSize(new Dimension(300, 100));
        this.jTabbedPaneSampleData.addChangeListener(new ChangeListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jTabbedPaneSampleDataStateChanged(evt);
            }
        });
        this.jTabbedPaneSampleData.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTabbedPaneSampleDataFocusGained(evt);
            }
        });
        this.jTabbedPaneSampleData.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTabbedPaneSampleDataMouseClicked(evt);
            }
        });
        this.jButtonAddSample.setText("Add...");
        this.jButtonAddSample.setToolTipText("Add a new sample");
        this.jButtonAddSample.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddSampleActionPerformed(evt);
            }
        });
        this.jButtonEditSample.setText("Edit...");
        this.jButtonEditSample.setToolTipText("Edit selected sample");
        this.jButtonEditSample.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditSampleActionPerformed(evt);
            }
        });
        this.jButtonDeleteSamples.setText("Delete");
        this.jButtonDeleteSamples.setToolTipText("<html>Delete selected sample(s)<br>\n[DEL]");
        this.jButtonDeleteSamples.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteSamplesActionPerformed(evt);
            }
        });
        this.jTableSamples.setModel(this.tableModelSamples);
        this.jTableSamples.setAutoResizeMode(1);
        this.jTableSamples.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableSamplesMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTableSamplesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableSamplesMouseReleased(evt);
            }
        });
        this.jTableSamples.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableSamplesKeyPressed(evt);
            }
        });
        this.jScrollPaneSamples.setViewportView(this.jTableSamples);
        this.jButtonAddSampleSmpdtl.setText("Add Analysis...");
        this.jButtonAddSampleSmpdtl.setToolTipText("Create analysis for selected sample(s)");
        this.jButtonAddSampleSmpdtl.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddSampleSmpdtl.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddSampleSmpdtlActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupDepthUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupDepthUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabelSamples.setFont(this.jLabelSamples.getFont().deriveFont(this.jLabelSamples.getFont().getStyle() & 0xFFFFFFFE));
        this.jLabelSamples.setText("Samples");
        this.jButtonSaveSamples.setText("Save as...");
        this.jButtonSaveSamples.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveSamplesActionPerformed(evt);
            }
        });
        this.jButtonEditSelection.setText("Edit selection...");
        this.jButtonEditSelection.setToolTipText("Edit the currently selected samples");
        this.jButtonEditSelection.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditSelectionActionPerformed(evt);
            }
        });
        GroupLayout jPanelSamplesLayout = new GroupLayout((Container)this.jPanelSamples);
        this.jPanelSamples.setLayout((LayoutManager)jPanelSamplesLayout);
        jPanelSamplesLayout.setHorizontalGroup((GroupLayout.Group)jPanelSamplesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSamplesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSamplesLayout.createParallelGroup(1, false).add((Component)this.jSeparator5).add((Component)this.jButtonDeleteSamples, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditSample, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddSample, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelSamples).add((Component)this.jSeparator4).add((Component)this.jButtonSaveSamples, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddSampleSmpdtl, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditSelection, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jScrollPaneSamples, -1, 685, Short.MAX_VALUE)));
        jPanelSamplesLayout.setVerticalGroup((GroupLayout.Group)jPanelSamplesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSamplesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSamplesLayout.createParallelGroup(1).add((Component)this.jScrollPaneSamples).add((GroupLayout.Group)jPanelSamplesLayout.createSequentialGroup().add((Component)this.jButtonAddSample).addPreferredGap(0).add((Component)this.jButtonEditSample).addPreferredGap(0).add((Component)this.jButtonDeleteSamples).addPreferredGap(0).add((Component)this.jButtonEditSelection).addPreferredGap(1).add((Component)this.jSeparator4, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonAddSampleSmpdtl).addPreferredGap(1).add((Component)this.jSeparator5, -2, 11, -2).addPreferredGap(0).add((Component)this.jButtonSaveSamples).add(28, 28, 28).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0, 271, Short.MAX_VALUE).add((Component)this.jLabelSamples))).addContainerGap()));
        this.jTabbedPaneSampleData.addTab("Samples", new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_SamplesTab.png")), this.jPanelSamples);
        this.jTableAnalyses.setModel(this.tableModelAnalyses);
        this.jTableAnalyses.setAutoResizeMode(1);
        this.jTableAnalyses.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableAnalysesMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTableAnalysesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableAnalysesMouseReleased(evt);
            }
        });
        this.jTableAnalyses.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableAnalysesKeyPressed(evt);
            }
        });
        this.jScrollPaneAnalyses.setViewportView(this.jTableAnalyses);
        this.jLabel1.setForeground(new Color(51, 102, 204));
        this.jLabel1.setText("Discipline:");
        this.jComboBoxDiscipline.setModel(this.comboModelDiscipline);
        this.jComboBoxDiscipline.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxDiscipline.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDisciplineActionPerformed(evt);
            }
        });
        this.jLabel2.setForeground(new Color(51, 102, 204));
        this.jLabel2.setText("Analyst:");
        this.jComboBoxAnalyst.setModel(this.comboModelAnalyst);
        this.jComboBoxAnalyst.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxAnalyst.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxAnalystActionPerformed(evt);
            }
        });
        this.jButtonAnalystHeader.setText("...");
        this.jButtonAnalystHeader.setToolTipText("View analyst suites");
        this.jButtonAnalystHeader.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonAnalystHeader.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalystHeaderActionPerformed(evt);
            }
        });
        this.jButtonAddSmpdtl.setText("Add...");
        this.jButtonAddSmpdtl.setToolTipText("Add new analysis for selected sample");
        this.jButtonAddSmpdtl.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddSmpdtlActionPerformed(evt);
            }
        });
        this.jButtonEditSmpdtl.setText("Edit...");
        this.jButtonEditSmpdtl.setToolTipText("Edit selected analysis");
        this.jButtonEditSmpdtl.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditSmpdtlActionPerformed(evt);
            }
        });
        this.jButtonDeleteSmpdtl.setText("Delete");
        this.jButtonDeleteSmpdtl.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteSmpdtlActionPerformed(evt);
            }
        });
        this.jLabel7.setForeground(new Color(51, 102, 204));
        this.jLabel7.setText("Suite:");
        this.jComboBoxAnalysisNumber.setModel(this.comboModelAnalyNo);
        this.jComboBoxAnalysisNumber.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxAnalysisNumber.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxAnalysisNumberActionPerformed(evt);
            }
        });
        this.jButtonShowAll.setText("Show all");
        this.jButtonShowAll.setToolTipText("Show all disciplines, analysts and suites");
        this.jButtonShowAll.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowAllActionPerformed(evt);
            }
        });
        this.jButtonSaveAsAnalyses.setText("Save as...");
        this.jButtonSaveAsAnalyses.setToolTipText("Save the list (or selected) analyses as a CSV/SBG file");
        this.jButtonSaveAsAnalyses.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsAnalysesActionPerformed(evt);
            }
        });
        this.jLabelnAnalyses.setFont(this.jLabelnAnalyses.getFont().deriveFont(this.jLabelnAnalyses.getFont().getStyle() | 1));
        this.jLabelnAnalyses.setText("Analyses");
        this.jButtonAnalysesImages.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/cameraSmall.png")));
        this.jButtonAnalysesImages.setText("Images");
        this.jButtonAnalysesImages.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalysesImagesActionPerformed(evt);
            }
        });
        GroupLayout jPanelAnalysesLayout = new GroupLayout((Container)this.jPanelAnalyses);
        this.jPanelAnalyses.setLayout((LayoutManager)jPanelAnalysesLayout);
        jPanelAnalysesLayout.setHorizontalGroup((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1, false).add((Component)this.jButtonAddSmpdtl, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelnAnalyses).add((Component)this.jButtonAnalysesImages, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAsAnalyses, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator2).add((Component)this.jButtonDeleteSmpdtl, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditSmpdtl, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jScrollPaneAnalyses)).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxDiscipline, -2, 128, -2).add(7, 7, 7).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jComboBoxAnalyst, -2, 83, -2).add(12, 12, 12).add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.jComboBoxAnalysisNumber, -2, 60, -2).addPreferredGap(0).add((Component)this.jButtonAnalystHeader, -2, 30, -2).addPreferredGap(0).add((Component)this.jButtonShowAll).add(0, 256, Short.MAX_VALUE))).addContainerGap()));
        jPanelAnalysesLayout.setVerticalGroup((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxDiscipline, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jComboBoxAnalyst, -2, -1, -2).add((Component)this.jComboBoxAnalysisNumber, -2, -1, -2).add((Component)this.jButtonAnalystHeader).add((Component)this.jButtonShowAll).add((Component)this.jLabel7)).add(13, 13, 13).add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().add((Component)this.jButtonAddSmpdtl).add(4, 4, 4).add((Component)this.jButtonEditSmpdtl).addPreferredGap(0).add((Component)this.jButtonDeleteSmpdtl).addPreferredGap(1).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSaveAsAnalyses).addPreferredGap(0).add((Component)this.jButtonAnalysesImages).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelnAnalyses).addContainerGap()).add((Component)this.jScrollPaneAnalyses, -1, 574, Short.MAX_VALUE))));
        this.jTabbedPaneSampleData.addTab("Analyses", new ImageIcon(this.getClass().getResource("/resources/frameicon/16Samples.png")), this.jPanelAnalyses);
        this.jTextFieldSample.setBackground(new Color(255, 255, 204));
        this.jTextFieldSample.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextFieldSample.setEnabled(false);
        this.jTextFieldSample.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldSampleFocusGained(evt);
            }
        });
        this.jButtonNext.setText("Next");
        this.jButtonNext.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNextActionPerformed(evt);
            }
        });
        this.jButtonNext.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jButtonNextKeyPressed(evt);
            }
        });
        this.jButtonPrevious.setText("Previous");
        this.jButtonPrevious.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jButtonPrevious.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jButtonPreviousKeyPressed(evt);
            }
        });
        this.jCheckBoxBarren.setText("Barren");
        this.jCheckBoxBarren.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxBarren.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxBarren.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxBarrenActionPerformed(evt);
            }
        });
        this.jTextFieldAnalyst.setEditable(false);
        this.jTextFieldAnalyst.setBackground(new Color(255, 255, 204));
        this.jTextFieldAnalyst.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextFieldAnalyst.setEnabled(false);
        this.jTextFieldDiscipline.setEditable(false);
        this.jTextFieldDiscipline.setBackground(new Color(255, 255, 204));
        this.jTextFieldDiscipline.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextFieldDiscipline.setEnabled(false);
        this.jLabel5.setText("Discipline:");
        this.jLabel6.setText("Analysis suite:");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Sample: ");
        this.jButtonDeleteOccurences.setText("Delete");
        this.jButtonDeleteOccurences.setPreferredSize(new Dimension(73, 23));
        this.jButtonDeleteOccurences.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteOccurencesActionPerformed(evt);
            }
        });
        this.jButtonOccEvent.setText("Event...");
        this.jButtonOccEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOccEventActionPerformed(evt);
            }
        });
        this.jButtonOccEdit.setText("Edit...");
        this.jButtonOccEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOccEditActionPerformed(evt);
            }
        });
        this.jButtonOccComment.setText("Comment...");
        this.jButtonOccComment.setToolTipText("<html>Add selected occurrences to<br> Biostratigraphic comment at this depth</html>");
        this.jButtonOccComment.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOccCommentActionPerformed(evt);
            }
        });
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jTableOccurrences.setModel(this.tableModelOcc);
        this.jTableOccurrences.setAutoResizeMode(4);
        this.jTableOccurrences.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableOccurrencesMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTableOccurrencesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableOccurrencesMouseReleased(evt);
            }
        });
        this.jTableOccurrences.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableOccurrencesKeyPressed(evt);
            }
        });
        this.jScrollPaneOccurences.setViewportView(this.jTableOccurrences);
        this.jSplitPane1.setTopComponent(this.jScrollPaneOccurences);
        this.jTextAreaComment.setEditable(false);
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(this.jTextAreaComment.getFont());
        this.jTextAreaComment.setForeground(Color.GRAY);
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.setText(DEFAULT_COMMENT_TEXT);
        this.jTextAreaComment.setToolTipText("Biostratigraphic comments");
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jTextAreaComment.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jTextAreaCommentFocusLost(evt);
            }
        });
        this.jTextAreaComment.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTextAreaCommentMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jPanelTotals.setBorder(BorderFactory.createTitledBorder("Totals"));
        GroupLayout jPanelTotalsLayout = new GroupLayout((Container)this.jPanelTotals);
        this.jPanelTotals.setLayout((LayoutManager)jPanelTotalsLayout);
        jPanelTotalsLayout.setHorizontalGroup((GroupLayout.Group)jPanelTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelTotalsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelTotalsLayout.createParallelGroup(1, false).add((Component)this.jLabelNtaxaTotal, -1, 57, Short.MAX_VALUE).add((Component)this.jLabelNtaxa, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelNtaxaInSitu, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator6)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelTotalsLayout.linkSize(new Component[]{this.jLabelNtaxa, this.jLabelNtaxaInSitu, this.jLabelNtaxaTotal}, 1);
        jPanelTotalsLayout.setVerticalGroup((GroupLayout.Group)jPanelTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelTotalsLayout.createSequentialGroup().add((Component)this.jLabelNtaxa, -2, 16, -2).addPreferredGap(0).add((Component)this.jLabelNtaxaTotal, -2, 13, -2).addPreferredGap(0).add((Component)this.jLabelNtaxaInSitu, -2, 13, -2).add(18, 18, 18).add((Component)this.jSeparator6, -2, 3, -2).addContainerGap(23, Short.MAX_VALUE)));
        jPanelTotalsLayout.linkSize(new Component[]{this.jLabelNtaxa, this.jLabelNtaxaInSitu, this.jLabelNtaxaTotal}, 2);
        this.jToolBarOccUndo.setRollover(true);
        this.jButtonOccUndo.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/undo24.png")));
        this.jButtonOccUndo.setHorizontalTextPosition(0);
        this.jButtonOccUndo.setVerticalTextPosition(3);
        this.jButtonOccUndo.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOccUndoActionPerformed(evt);
            }
        });
        this.jToolBarOccUndo.add(this.jButtonOccUndo);
        this.jButtonOccRedo.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/redo24.png")));
        this.jButtonOccRedo.setHorizontalTextPosition(0);
        this.jButtonOccRedo.setVerticalTextPosition(3);
        this.jButtonOccRedo.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOccRedoActionPerformed(evt);
            }
        });
        this.jToolBarOccUndo.add(this.jButtonOccRedo);
        this.jButtonOccInsertPrev.setText("Ins. prev");
        this.jButtonOccInsertPrev.setToolTipText("Add all taxa from previous analysis as unsaved occurrences");
        this.jButtonOccInsertPrev.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonOccInsertPrev.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOccInsertPrevActionPerformed(evt);
            }
        });
        this.jButtonSetRwCv.setText("Set Rw/Cv...");
        this.jButtonSetRwCv.setToolTipText("Set selected occurrence(s) to Reworked and/or Caved");
        this.jButtonSetRwCv.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSetRwCv.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSetRwCvActionPerformed(evt);
            }
        });
        this.jButtonTaxonImage.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/cameraSmall.png")));
        this.jButtonTaxonImage.setText("Image");
        this.jButtonTaxonImage.setToolTipText("Display image(s) of selected taxon");
        this.jButtonTaxonImage.setIconTextGap(8);
        this.jButtonTaxonImage.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTaxonImageActionPerformed(evt);
            }
        });
        GroupLayout jPanelOccurencesLayout = new GroupLayout((Container)this.jPanelOccurences);
        this.jPanelOccurences.setLayout((LayoutManager)jPanelOccurencesLayout);
        jPanelOccurencesLayout.setHorizontalGroup((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 792, Short.MAX_VALUE).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(2).add((Component)this.jLabel5).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1, false).add((Component)this.jTextFieldAnalyst).add((Component)this.jTextFieldDiscipline, -1, 69, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1, false).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().add((Component)this.jButtonPrevious, -2, 86, -2).addPreferredGap(0).add((Component)this.jButtonNext, -2, 78, -2)).add((Component)this.jTextFieldSample)).add(18, 18, 18).add((Component)this.jCheckBoxBarren).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1, false).add((Component)this.jButtonOccEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteOccurences, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOccEvent, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOccComment, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOccInsertPrev, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSetRwCv, -1, -1, Short.MAX_VALUE).add((Component)this.jPanelTotals, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonTaxonImage, -1, -1, Short.MAX_VALUE).add((Component)this.jToolBarOccUndo, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jSplitPane1, -1, 709, Short.MAX_VALUE))).addContainerGap()));
        jPanelOccurencesLayout.linkSize(new Component[]{this.jButtonNext, this.jButtonPrevious}, 1);
        jPanelOccurencesLayout.setVerticalGroup((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(3).add((Component)this.jTextFieldDiscipline, -2, 20, -2).add((Component)this.jTextFieldSample, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jLabel5).add((Component)this.jCheckBoxBarren, -2, 23, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldAnalyst, -2, -1, -2).add((Component)this.jButtonPrevious).add((Component)this.jButtonNext)).add(15, 15, 15).add((Component)this.jSeparator1, -2, 8, -2).addPreferredGap(0).add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().add((Component)this.jToolBarOccUndo, -2, 25, -2).addPreferredGap(1).add((Component)this.jButtonOccEdit).addPreferredGap(0).add((Component)this.jButtonDeleteOccurences, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonOccEvent).addPreferredGap(0).add((Component)this.jButtonOccComment).addPreferredGap(0).add((Component)this.jButtonOccInsertPrev).addPreferredGap(0).add((Component)this.jButtonSetRwCv).addPreferredGap(0).add((Component)this.jButtonTaxonImage).add(32, 32, 32).add((Component)this.jPanelTotals, -2, -1, -2).add(0, 141, Short.MAX_VALUE)).add((Component)this.jSplitPane1))));
        this.jTabbedPaneSampleData.addTab("Occurrences", new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_OccTab.png")), this.jPanelOccurences);
        this.jButtonAddDoc.setText("Add...");
        this.jButtonAddDoc.setToolTipText("Import a new document associated with this well");
        this.jButtonAddDoc.setMaximumSize(new Dimension(133, 29));
        this.jButtonAddDoc.setMinimumSize(new Dimension(133, 29));
        this.jButtonAddDoc.setPreferredSize(new Dimension(133, 29));
        this.jButtonAddDoc.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddDocActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Viewer"));
        this.buttonGroupViewer.add(this.jRadioButtonInternal);
        this.jRadioButtonInternal.setSelected(true);
        this.jRadioButtonInternal.setText("Internal");
        this.buttonGroupViewer.add(this.jRadioButtonExternal);
        this.jRadioButtonExternal.setText("External");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonExternal).add((Component)this.jRadioButtonInternal)).addContainerGap(24, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonExternal).addPreferredGap(0).add((Component)this.jRadioButtonInternal).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonDeleteDoc.setText("Delete");
        this.jButtonDeleteDoc.setToolTipText("Delete the selected document from the database");
        this.jButtonDeleteDoc.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteDocActionPerformed(evt);
            }
        });
        this.jTableDocuments.setModel(this.tableModelDocuments);
        this.jTableDocuments.setAutoResizeMode(4);
        this.jTableDocuments.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableDocumentsMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableDocuments);
        this.jButtonShowDoc.setText("Show");
        this.jButtonShowDoc.setToolTipText("Show selected document in viewer");
        this.jButtonShowDoc.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowDocActionPerformed(evt);
            }
        });
        this.jButtonDocRefs.setText("Wells...");
        this.jButtonDocRefs.setToolTipText("Associate the selected document with other wells");
        this.jButtonDocRefs.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDocRefsActionPerformed(evt);
            }
        });
        this.jButtonWriteDoc.setText("Write...");
        this.jButtonWriteDoc.setToolTipText("Write the document out to a file");
        this.jButtonWriteDoc.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWell this$0;
            {
                JPanelWell jPanelWell = this$0;
                Objects.requireNonNull(jPanelWell);
                this.this$0 = jPanelWell;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWriteDocActionPerformed(evt);
            }
        });
        GroupLayout jPanelDocumentsLayout = new GroupLayout((Container)this.jPanelDocuments);
        this.jPanelDocuments.setLayout((LayoutManager)jPanelDocumentsLayout);
        jPanelDocumentsLayout.setHorizontalGroup((GroupLayout.Group)jPanelDocumentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelDocumentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelDocumentsLayout.createParallelGroup(1).add((Component)this.jPanelPdfPreview, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanelDocumentsLayout.createSequentialGroup().add((GroupLayout.Group)jPanelDocumentsLayout.createParallelGroup(1, false).add((Component)this.jButtonDocRefs, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddDoc, -2, 0, Short.MAX_VALUE).add((Component)this.jButtonDeleteDoc, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonShowDoc, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonWriteDoc, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 616, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2))).addContainerGap()));
        jPanelDocumentsLayout.setVerticalGroup((GroupLayout.Group)jPanelDocumentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelDocumentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelDocumentsLayout.createParallelGroup(1, false).add((Component)this.jPanel1, -2, -1, -2).add((GroupLayout.Group)jPanelDocumentsLayout.createSequentialGroup().add((Component)this.jButtonAddDoc, -2, 24, -2).addPreferredGap(0).add((Component)this.jButtonDocRefs).addPreferredGap(0).add((Component)this.jButtonDeleteDoc).addPreferredGap(0).add((Component)this.jButtonWriteDoc).addPreferredGap(0).add((Component)this.jButtonShowDoc)).add((Component)this.jScrollPane2, -2, 0, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jPanelPdfPreview, -1, 450, Short.MAX_VALUE).addContainerGap()));
        jPanelDocumentsLayout.linkSize(new Component[]{this.jButtonAddDoc, this.jButtonDeleteDoc, this.jButtonShowDoc}, 2);
        this.jTabbedPaneSampleData.addTab("Documents", new ImageIcon(this.getClass().getResource("/resources/icon/documents.png")), this.jPanelDocuments);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPaneSampleData, -1, 817, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPaneSampleData, -1, 647, Short.MAX_VALUE));
        this.jTabbedPaneSampleData.getAccessibleContext().setAccessibleName("Documents");
    }

    private void jButtonAddSampleActionPerformed(ActionEvent evt) {
        DialogSample dialog = new DialogSample(this.parent, true, this.sbdb, this.well, this.units, null, true);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.setSelectedSample(dialog.sample);
                if (dialog.addAnalysis()) {
                    AnalystHeader hdr;
                    if (this.well.getAnalystHeaders().size() == 1) {
                        hdr = this.well.getAnalystHeaders().get(0);
                    } else {
                        DialogAnalystHeaders dialogAnalystHeaders = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
                        dialogAnalystHeaders.setLocationRelativeTo(this.parent);
                        dialogAnalystHeaders.setVisible(true);
                        hdr = dialogAnalystHeaders.selection;
                    }
                    if (hdr != null) {
                        Smpdtl smpdtl = dialog.sample.addDtl(this.well.getWellID(), hdr, Smpdtl.AnalysisType.PREPARED, "", "", "", "", 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0);
                        this.sbdb.commit();
                        this.well.setDataChanged();
                        this.well.notifyObservers(Smpdtl.class);
                        this.setSmpdtl(smpdtl);
                    }
                }
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error adding sample: ", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private void jButtonEditSampleActionPerformed(ActionEvent evt) {
        if (this.jTableSamples.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one sample to edit", this.parent.getTitle(), 1);
            return;
        }
        try {
            Sample sample = this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(this.jTableSamples.getSelectedRow()));
            DialogSample dialog = new DialogSample(this.parent, true, this.sbdb, this.well, this.units, sample, false);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jTableSamples.clearSelection();
                this.tableModelSamples.fireTableDataChanged();
                int index = this.jTableSamples.convertRowIndexToModel(this.tableModelSamples.getSamples().indexOf(dialog.sample));
                if (index >= 0) {
                    this.jTableSamples.getSelectionModel().setSelectionInterval(index, index);
                }
            }
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error", (Throwable)e);
        }
    }

    private void jButtonDeleteSamplesActionPerformed(ActionEvent evt) {
        try {
            if (!this.well.canWrite(this.sbdb, null)) {
                JOptionPane.showMessageDialog(this, this.well.getDeniedReason(this.sbdb, "well", false), this.parent.getTitle(), 2);
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        int[] selected = this.jTableSamples.getSelectedRows();
        if (selected.length == 0) {
            JOptionPane.showMessageDialog(this.parent, "No samples selected", this.parent.getTitle(), 1);
            return;
        }
        LinkedList<Sample> samples = new LinkedList<Sample>();
        try {
            for (int i : selected) {
                samples.add(this.well.getSamples().get(this.jTableSamples.convertRowIndexToModel(i)));
            }
            Object object = samples.iterator();
            while (object.hasNext()) {
                Sample sample = (Sample)object.next();
                int dType = this.well.hasSampleIGD(sample);
                if (dType == 0) continue;
                String msg = "Can't delete sample '" + sample.toString(this.units) + "' because of associated interpreted data, which should be deleted first.\nData type: " + SBdb.dTypeNames[dType];
                JOptionPane.showMessageDialog(this.parent, msg, this.parent.getTitle(), 1);
                return;
            }
            if (!samples.isEmpty()) {
                String msg = "Really delete " + (String)(samples.size() > 1 ? "these " + samples.size() + " samples?" : "this sample?");
                int analyses = 0;
                for (Sample s : samples) {
                    analyses += s.getSmpdtls().size();
                }
                if (analyses > 0) {
                    msg = msg + "\n" + analyses + (analyses == 1 ? " analysis" : " analyses") + " will also be deleted.";
                }
                if (JOptionPane.showConfirmDialog(this.parent, msg, this.parent.getTitle(), 0, 3) != 0) {
                    return;
                }
                this.well.deleteSamples(samples);
                this.well.setDataChanged();
                this.well.notifyObservers(samples.get(0));
                this.sbdb.commit();
            }
        }
        catch (IllegalArgumentException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.parent.getTitle(), 2);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.parent.getTitle(), 2);
        }
        catch (SQLException | SBException e) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", (Exception)e, this.sbdb);
        }
    }

    private void jTableSamplesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            Sample sample;
            int col = this.jTableSamples.getColumnModel().getColumn(this.jTableSamples.getSelectedColumn()).getModelIndex();
            int row = this.jTableSamples.getSelectedRow();
            try {
                sample = this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(row));
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error", (Throwable)e);
                return;
            }
            if (col == 11 && sample != null) {
                try {
                    DialogSampleLithology dialog = new DialogSampleLithology(this.parent, true, this.sbdb, this.well, sample);
                    dialog.setLocationRelativeTo(this.jScrollPaneSamples);
                    dialog.setVisible(true);
                    if (dialog.isOK()) {
                        this.tableModelSamples.fireTableDataChanged();
                    }
                }
                catch (Exception e) {
                    StackError.showStackError((String)"Error", (Throwable)e);
                }
            } else if (col == 7 && sample != null) {
                this.selectAnalyses(sample);
            } else {
                this.jButtonEditSampleActionPerformed(null);
            }
        }
    }

    private void selectAnalyses(Sample sample) {
        if (sample.getSmpdtls().isEmpty()) {
            this.jButtonAddSmpdtlActionPerformed(null);
            if (sample.getSmpdtls().isEmpty()) {
                return;
            }
        } else {
            List<Smpdtl> smpdtls = this.tableModelAnalyses.getSmpdtls();
            boolean first = true;
            int i = 0;
            for (Smpdtl dtl : smpdtls) {
                if (dtl.getSample() == sample) {
                    int index = this.jTableAnalyses.convertRowIndexToModel(i);
                    if (first) {
                        this.jTableAnalyses.setRowSelectionInterval(index, index);
                        first = false;
                    } else {
                        this.jTableAnalyses.addRowSelectionInterval(index, index);
                    }
                }
                ++i;
            }
        }
        this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelAnalyses);
    }

    private void jButtonAddSampleSmpdtlActionPerformed(ActionEvent evt) {
        if (this.addAnalysis(true)) {
            this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelAnalyses);
        }
    }

    private void jTableAnalysesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.showOccurrences();
            this.updateOverlay();
            this.setPicklistHighlighting(this.getSmpdtl());
        } else {
            super.processMouseEvent(evt);
        }
    }

    private void jComboBoxDisciplineActionPerformed(ActionEvent evt) {
        Object o = this.jComboBoxDiscipline.getSelectedItem();
        Discipline d = o instanceof Discipline ? (Discipline)o : null;
        if (d != this.discID) {
            this.discID = d;
            this.refreshAnalyses();
        }
    }

    private void jComboBoxAnalystActionPerformed(ActionEvent evt) {
        String tempAnalyst = (String)this.jComboBoxAnalyst.getSelectedItem();
        if (tempAnalyst.equals(ALL_STRING)) {
            tempAnalyst = "";
        }
        if (tempAnalyst != null && !tempAnalyst.equals(this.analystString)) {
            try {
                this.analystString = tempAnalyst;
                this.refreshAnalyses();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "Error getting analyst", this.parent.getTitle(), 0);
            }
        }
    }

    private void jButtonAnalystHeaderActionPerformed(ActionEvent evt) {
        try {
            DialogAnalystHeaders dialog = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error creating dialog", (Throwable)e);
        }
    }

    private void jButtonAddSmpdtlActionPerformed(ActionEvent evt) {
        this.addAnalysis(false);
    }

    private void jButtonEditSmpdtlActionPerformed(ActionEvent evt) {
        this.editAnalysis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteSmpdtlActionPerformed(ActionEvent evt) {
        int[] selection;
        if (this.jTableAnalyses.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one or more analyses from the list", this.parent.getTitle(), 1);
            return;
        }
        try {
            if (!this.well.canWrite(this.sbdb, null)) {
                JOptionPane.showMessageDialog(this, this.well.getDeniedReason(this.sbdb, "delete analyses", "well", false), "Delete Analyses", 2);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this.parent);
        }
        LinkedList<Smpdtl> smpdtlsToDelete = new LinkedList<Smpdtl>();
        for (int i : selection = this.jTableAnalyses.getSelectedRows()) {
            Smpdtl smpdtl2 = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(i));
            smpdtlsToDelete.add(smpdtl2);
        }
        try {
            Object msg;
            HashMap<String, Integer> analyMap = new HashMap<String, Integer>();
            for (Smpdtl smpdtl3 : smpdtlsToDelete) {
                if (analyMap.get(smpdtl3.getAnalystAbr()) == null) {
                    analyMap.put(smpdtl3.getAnalystAbr(), 1);
                    continue;
                }
                analyMap.put(smpdtl3.getAnalystAbr(), (Integer)analyMap.get(smpdtl3.getAnalystAbr()) + 1);
            }
            if (smpdtlsToDelete.size() == 1) {
                msg = "Really delete this analysis?";
            } else {
                msg = "Really delete these " + smpdtlsToDelete.size() + " analyses from: ";
                msg = (String)msg + StringUtils.join(analyMap.keySet().stream().map(analyst -> analyst + " (" + String.valueOf(analyMap.get(analyst)) + ")").toList(), (String)", ") + "?";
            }
            msg = (String)msg + this.getOccImageDeleteConfirmMessage(smpdtlsToDelete.stream().flatMap(smpdtl -> smpdtl.getOccurUnsorted().stream()).toList());
            if (JOptionPane.showConfirmDialog(this.parent, msg, this.parent.getTitle(), 0, 3) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            Sample lastSample = null;
            for (Smpdtl smpdtl2 : smpdtlsToDelete) {
                Sample sample = this.well.getSample(smpdtl2.getSample().getSampID());
                sample.deleteDtl(this.well.getWellID(), smpdtl2.getHeader().getAnalyID(), smpdtl2);
                this.sbdb.commit();
                lastSample = sample;
            }
            this.sbdb.updateAuditTrail("ANALYSES", "DELETE " + smpdtlsToDelete.size() + " from " + this.well.toString() + " [" + this.well.getWellID() + "]");
            lastSample.notifyObservers();
            this.jTableAnalyses.clearSelection();
            this.refreshAnalyses();
            this.well.setDataChanged();
            this.well.notifyObservers(Smpdtl.class);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, null);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private String getOccImageDeleteConfirmMessage(List<TaxonOcc> occsToDelete) {
        Object msg = "";
        int nImageSetsToDelete = 0;
        int nImagesToDelete = 0;
        int nTypeImageSetsToRetain = 0;
        for (TaxonOcc occ : occsToDelete) {
            if (occ.getImageSetID() <= 0) continue;
            TaxonImageSet imageSet = this.sbdb.getTaxonImageService().getTaxonImageSet(occ.getImageSetID());
            if (!imageSet.isType()) {
                ++nImageSetsToDelete;
                nImagesToDelete += imageSet.getImageRecords(this.sbdb.getImageRecordService()).size();
                continue;
            }
            ++nTypeImageSetsToRetain;
        }
        if (nImageSetsToDelete > 0) {
            msg = (String)msg + "\n" + nImageSetsToDelete + " image set" + (nImageSetsToDelete > 1 ? "s (" : " (") + nImagesToDelete + " image" + (nImagesToDelete > 1 ? "s)" : ")") + " will also be deleted.";
        }
        if (nTypeImageSetsToRetain > 0) {
            msg = (String)msg + "\n" + nTypeImageSetsToRetain + " type image sets will be retained.";
        }
        return msg;
    }

    private void jComboBoxAnalysisNumberActionPerformed(ActionEvent evt) {
        int tempNo = 0;
        try {
            tempNo = (Integer)this.jComboBoxAnalysisNumber.getSelectedItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tempNo != this.analyNo) {
            try {
                this.analyNo = tempNo;
                this.refreshAnalyses();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "Error getting analyst", this.parent.getTitle(), 0);
            }
        }
    }

    private void jTextFieldSampleFocusGained(FocusEvent evt) {
        this.jTextFieldSample.setSelectionStart(0);
        this.jTextFieldSample.setSelectionEnd(this.jTextFieldSample.getText().length());
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            this.nextOcc(true);
        }
        catch (SBException se) {
            JOptionPane.showMessageDialog(this.parent, se.getMessage(), this.parent.getTitle(), 2);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            this.nextOcc(false);
        }
        catch (SBException se) {
            JOptionPane.showMessageDialog(this.parent, se.getMessage(), this.parent.getTitle(), 2);
        }
    }

    void nextOcc(boolean forward) throws SBException {
        this.stopCellEditor();
        int selectedRow = this.jTableAnalyses.getSelectedRow();
        if (selectedRow < 0) {
            throw new SBException("Make a selection from list of Analyses");
        }
        selectedRow = forward ? ++selectedRow : --selectedRow;
        try {
            this.jTableAnalyses.convertRowIndexToModel(selectedRow);
        }
        catch (Exception e) {
            throw new SBException("There is no " + (forward ? "next" : "previous") + " sample in selected data set");
        }
        this.jTableAnalyses.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        if (!this.showOccurrences()) {
            if (forward) {
                this.jTableAnalyses.getSelectionModel().setSelectionInterval(--selectedRow, selectedRow);
            } else {
                this.jTableAnalyses.getSelectionModel().setSelectionInterval(++selectedRow, selectedRow);
            }
        }
        this.updateComments();
        this.updateOverlay();
        this.updateTotals();
        this.jButtonOccInsertPrev.setText(insertPrevButtonLabel);
        this.insertPrevLookback = 0;
        for (JPanelPicklist picklist : this.parent.getPicklists()) {
            picklist.restorePicklist();
        }
        this.setPicklistHighlighting(this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(selectedRow)));
    }

    private void jCheckBoxBarrenActionPerformed(ActionEvent evt) {
        Smpdtl smpdtl = this.tableModelOcc.smpdtl;
        if (smpdtl == null) {
            this.jCheckBoxBarren.setSelected(false);
            return;
        }
        boolean clearOcc = false;
        if (this.jCheckBoxBarren.isSelected() != smpdtl.getBarren()) {
            if (!smpdtl.getBarren() && smpdtl.getNOccs() > 0) {
                int nInSitu = smpdtl.getNOccs(true);
                Object[] options = new String[]{this.resources.getString("button.yes"), this.resources.getString("button.no"), this.resources.getString("button.cancel")};
                int opt = JOptionPane.showOptionDialog(this.parent, "Clear occurrences (" + nInSitu + " in-situ)?", this.parent.getTitle(), 1, 3, null, options, options[1]);
                if (opt == 2) {
                    this.jCheckBoxBarren.setSelected(false);
                    return;
                }
                if (opt == 0) {
                    clearOcc = true;
                }
            }
            try {
                AbstractUndoableEdit e = smpdtl.setBarren(this.well.getWellID(), this.jCheckBoxBarren.isSelected(), clearOcc);
                if (e != null) {
                    this.undoSupportOccs.postEdit(e);
                }
                this.well.setDataChanged();
                this.well.notifyObservers((Object)smpdtl);
                smpdtl.notifyObservers();
                this.sbdb.commit();
            }
            catch (SQLException | SBException ex) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("Error setting barren flag", (Exception)ex, this.sbdb);
                this.jCheckBoxBarren.setSelected(smpdtl.getBarren());
            }
        }
    }

    private void jButtonDeleteOccurencesActionPerformed(ActionEvent evt) {
        int[] selection;
        this.stopCellEditor();
        if (this.jTableOccurrences.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this.parent, "No occurrences selected.", this.parent.getTitle(), 2);
            return;
        }
        try {
            if (!this.well.canWrite(this.sbdb, null)) {
                JOptionPane.showMessageDialog(this, this.well.getDeniedReason(this.sbdb, "delete occurrences", "well", false), "Delete Occurrences", 2);
                return;
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
            return;
        }
        for (int i : selection = this.jTableOccurrences.getSelectedRows()) {
            if (this.tableModelOcc.getSaved(this.jTableOccurrences.convertRowIndexToModel(i))) continue;
            this.getToolkit().beep();
            return;
        }
        Smpdtl smpdtl = this.tableModelOcc.smpdtl;
        String msg = "Really delete " + (String)(selection.length > 1 ? "these " + selection.length + " " : "this ") + "occurrence" + (selection.length > 1 ? "s?" : "?");
        List<TaxonOcc> occsToDelete = Arrays.stream(selection).map(this.jTableOccurrences::convertRowIndexToModel).mapToObj(index -> smpdtl.getOccur(index)).toList();
        Object imageDeleteConfirmMessage = this.getOccImageDeleteConfirmMessage(occsToDelete);
        if (!((String)imageDeleteConfirmMessage).isEmpty()) {
            imageDeleteConfirmMessage = (String)imageDeleteConfirmMessage + "\nImage sets may not be restored by undo actions.";
        }
        msg = msg + (String)imageDeleteConfirmMessage;
        try {
            int opt = JOptionPane.showConfirmDialog(this.parent, msg, this.parent.getTitle(), 0, 3);
            if (opt != 0) {
                return;
            }
            this.undoSupportOccs.postEdit(smpdtl.deleteOccs(this.well.getWellID(), occsToDelete));
            this.sbdb.commit();
            this.well.setDataChanged();
        }
        catch (SBPrivilegeException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.getMessage(), this.parent.getTitle(), 2);
            return;
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this.parent);
            return;
        }
        this.well.notifyObservers((Object)smpdtl);
        this.jTableOccurrences.clearSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOccEventActionPerformed(ActionEvent evt) {
        this.stopCellEditor();
        if (this.jTableOccurrences.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this.parent, "Select an occurrence to create a well event from", this.parent.getTitle(), 1);
            return;
        }
        int selection = this.jTableOccurrences.getSelectedRow();
        if (!this.tableModelOcc.getSaved(this.jTableOccurrences.convertRowIndexToModel(selection))) {
            JOptionPane.showMessageDialog(this.parent, "Cannot create event for unsaved occurrence", this.parent.getTitle(), 1);
            return;
        }
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this.parent, "Select a version", this.parent.getTitle(), 1);
            return;
        }
        if (selection < 0) {
            JOptionPane.showMessageDialog(this.parent, "Select an occurrence", this.parent.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
            if (smpdtl != null) {
                SBEvent event;
                Taxon taxon = smpdtl.getOccurUnsorted().get(this.jTableOccurrences.convertRowIndexToModel(selection)).getTaxon();
                List<SBEvent> list = this.sbdb.getSBEvents(taxon.getSpecID());
                if (list == null || list.isEmpty()) {
                    int opt = JOptionPane.showConfirmDialog(this.parent, "There are no events available in the event dictionary for selected taxon.\nDo you want to add it to the dictionary?", this.parent.getTitle(), 0, 3);
                    if (opt != 0) {
                        return;
                    }
                    DialogEvent dialogEvent = new DialogEvent(this.parent, true, this.sbdb, null, null);
                    dialogEvent.setTaxon(taxon);
                    dialogEvent.setLocation(this.jButtonOccEvent.getLocationOnScreen());
                    dialogEvent.setVisible(true);
                    if (dialogEvent.sbEvent == null) {
                        return;
                    }
                    event = dialogEvent.sbEvent;
                } else {
                    DialogSelectEvent dialog = new DialogSelectEvent((Frame)this.parent, true, this.sbdb, list);
                    dialog.setLocation(this.jButtonOccEvent.getLocationOnScreen());
                    dialog.setVisible(true);
                    if (dialog.selection == null) {
                        return;
                    }
                    event = dialog.selection;
                }
                DialogWellEvent dialog = new DialogWellEvent(this.parent, true, this.sbdb, this.well, wellInterp, this.units, null, smpdtl.getSample(), event, null);
                dialog.setSmpdtl(smpdtl.getDiscID(), smpdtl.getAnalystAbr());
                dialog.setLocation(this.jButtonOccEvent.getLocationOnScreen());
                dialog.setVisible(true);
            }
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTableOccurrencesMouseClicked(MouseEvent evt) {
        block38: {
            if (this.parent.isMultiClick() && evt.getClickCount() > 1 || !this.parent.isMultiClick() && evt.getClickCount() == 2) {
                try {
                    int selectedRow = this.jTableOccurrences.getSelectedRow();
                    if (selectedRow < 0) {
                        return;
                    }
                    Object o = this.tableModelOcc.getOcc(this.jTableOccurrences.convertRowIndexToModel(selectedRow));
                    if (o == null) {
                        return;
                    }
                    boolean saved = true;
                    if (!this.tableModelOcc.getSaved(this.jTableOccurrences.convertRowIndexToModel(selectedRow))) {
                        saved = false;
                    }
                    if (this.jTableOccurrences.convertColumnIndexToModel(this.jTableOccurrences.getSelectedColumn()) == 2) {
                        this.jButtonTaxonImageActionPerformed(null);
                        return;
                    }
                    if (this.parent.getLogging()) {
                        if (!this.well.canWrite(this.sbdb, null)) {
                            return;
                        }
                        TaxonOcc newFss = null;
                        if (this.parent.isNumeric()) {
                            int total;
                            if (this.parent.getPicklistTotaliser() > 0 && (total = this.tableModelOcc.smpdtl.getTotalCount()) >= this.parent.getPicklistTotaliser()) {
                                this.getToolkit().beep();
                                if (JPanelPicklist.getSampleTotalMessage()) {
                                    JOptionPane.showMessageDialog(this, "Total count reached", "Samples", 1);
                                    JPanelPicklist.setSampleTotalMessage();
                                }
                                return;
                            }
                            int sizeFraction = 2;
                            JPanelPicklist picklistPanel = this.parent.getSelectedPicklist(null);
                            if (picklistPanel != null) {
                                sizeFraction = picklistPanel.getSelectedSizeFraction();
                            }
                            if (!saved) {
                                TaxonOcc.Builder occBuilder = (TaxonOcc.Builder)o;
                                this.tableModelOcc.unsaved.remove(occBuilder);
                                if (evt.getButton() == 1) {
                                    switch (sizeFraction) {
                                        case 1: {
                                            occBuilder.coarse(1);
                                            break;
                                        }
                                        case 2: {
                                            occBuilder.count(1);
                                            break;
                                        }
                                        case 3: {
                                            occBuilder.fine(1);
                                        }
                                    }
                                }
                                Smpdtl.OccAddDelete edit = this.tableModelOcc.smpdtl.insertOccurrence(occBuilder, this.well.getWellID());
                                newFss = edit.getOccurrence();
                                this.undoSupportOccs.postEdit((UndoableEdit)((Object)edit));
                            } else {
                                int increment = this.parent.showOccPopup ? (evt.isAltDown() || evt.isControlDown() ? -1 : 1) : (evt.getButton() == 1 ? 1 : -1);
                                TaxonOcc fss = (TaxonOcc)o;
                                if (increment == -1 && (fss.getSubAbund(true).equals("+") || sizeFraction == 0 && fss.getMedium() == 0)) {
                                    this.getToolkit().beep();
                                    return;
                                }
                                this.undoSupportOccs.postEdit(this.tableModelOcc.smpdtl.incrementOcc(this.well.getWellID(), this.tableModelOcc.smpdtl.getSample().getSampID(), fss, sizeFraction, increment, true));
                            }
                        } else {
                            AbundanceScheme abundanceScheme = this.sbdb.getAbundanceSchemeService().findAbundanceScheme(this.tableModelOcc.smpdtl.getHeader().getAbnSchID()).orElse(null);
                            if (!saved) {
                                TaxonOcc.Builder occBuilder = (TaxonOcc.Builder)o;
                                this.tableModelOcc.unsaved.remove(occBuilder);
                                if (abundanceScheme != null) {
                                    occBuilder.subjAbund(abundanceScheme.getEntry(0).abr());
                                }
                                Smpdtl.OccAddDelete addition = this.tableModelOcc.smpdtl.insertOccurrence((TaxonOcc.Builder)o, this.well.getWellID());
                                this.undoSupportOccs.postEdit((UndoableEdit)((Object)addition));
                                newFss = addition.getOccurrence();
                                int select = this.jTableOccurrences.convertRowIndexToModel(this.tableModelOcc.smpdtl.getOccurUnsorted().indexOf(newFss));
                                this.jTableOccurrences.setRowSelectionInterval(select, select);
                            } else {
                                TaxonOcc fss = (TaxonOcc)o;
                                if (abundanceScheme == null) {
                                    JOptionPane.showMessageDialog(this.parent, "You must set an abundance scheme for this analyst suite\nbefore recording semi-quantitative data.", "Edit abundance", 2);
                                    return;
                                }
                                if (fss.getTotalCount() > 0 && JOptionPane.showConfirmDialog(this.parent, "You can't mix semi-quantitative and quantitative abundance.\nDelete quantitative data?", "Edit abundance", 0) != 0) {
                                    return;
                                }
                                if (evt.getButton() != 1 && (fss.getSubAbund().isEmpty() || fss.getSubAbund(true).equals("+"))) {
                                    this.getToolkit().beep();
                                    return;
                                }
                                if (evt.getButton() == 1 && !abundanceScheme.canIncrementSubjAbund(fss.getSubAbund())) {
                                    this.getToolkit().beep();
                                    return;
                                }
                                this.undoSupportOccs.postEdit(this.tableModelOcc.smpdtl.incrementOcc(this.well.getWellID(), this.tableModelOcc.smpdtl.getSample().getSampID(), fss, 0, evt.getButton() == 1 ? 1 : -1, false));
                            }
                        }
                        this.sbdb.commit();
                        this.tableModelOcc.smpdtl.notifyObservers();
                        if (!saved && newFss != null) {
                            int select = this.jTableOccurrences.convertRowIndexToView(this.tableModelOcc.smpdtl.getIndexOfOccur(newFss));
                            this.jTableOccurrences.setRowSelectionInterval(select, select);
                        } else {
                            int select = this.jTableOccurrences.convertRowIndexToView(this.tableModelOcc.smpdtl.getIndexOfOccur((TaxonOcc)o));
                            this.jTableOccurrences.setRowSelectionInterval(select, select);
                        }
                        if (this.parent.playOccSounds()) {
                            this.parent.playOccSound();
                        }
                        break block38;
                    }
                    if (!saved) {
                        System.out.println("Didn't edit unsaved occ");
                        break block38;
                    }
                    this.editOccurrence((TaxonOcc)o);
                }
                catch (SQLException | SBException e) {
                    this.sbdb.doRollback();
                    FrameJsbugs.showStackError("Error", (Exception)e, this.sbdb);
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"", (Throwable)re);
                }
            } else if (!evt.isShiftDown() && !evt.isControlDown()) {
                int row = this.jTableOccurrences.rowAtPoint(evt.getPoint());
                if (row < 0) {
                    return;
                }
                this.jTableOccurrences.changeSelection(row, this.jTableOccurrences.getSelectedColumn(), false, false);
            }
        }
    }

    private void editOccurrence(TaxonOcc fss) throws SQLException, SBException {
        this.stopCellEditor();
        DialogOccurrence dialog = new DialogOccurrence(this.parent, true, this.sbdb, this.parent.getSynSchID(), this.well, this.tableModelOcc.smpdtl, fss, null, Situation.INSITU, false, false, this.parent.isCMF());
        dialog.setLocationRelativeTo(this.jScrollPaneOccurences);
        dialog.undoSupport.addUndoableEditListener(this.undoManagerOccs);
        dialog.setVisible(true);
        this.tableModelOcc.clearCachedImage(fss.getImageSetID());
    }

    private void jTabbedPaneSampleDataMouseClicked(MouseEvent evt) {
        if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelOccurences) {
            if (!this.showOccurrences()) {
                this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelAnalyses);
            }
            this.updateOverlay();
        }
    }

    private void jTabbedPaneSampleDataStateChanged(ChangeEvent evt) {
        if (!SbugsLicense.checkRLMlicense()) {
            JOptionPane.showMessageDialog(this.parent, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.parent.exit(false);
            return;
        }
        this.stopCellEditor();
        if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelCharts) {
            this.jPanelCharts.stateChanged();
            this.jPanelCharts.initHintSequence();
        } else if (this.jPanelCharts != null) {
            this.jPanelCharts.hideBlockPropertiesDialog();
            if (this.parent.getWellPanel().getInterp() == null) {
                // empty if block
            }
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        if (this.units != 'M') {
            this.setUnits('M');
        }
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        if (this.units != 'F') {
            this.setUnits('F');
        }
    }

    private void jButtonOccEditActionPerformed(ActionEvent evt) {
        try {
            int selectedRow = this.jTableOccurrences.getSelectedRow();
            if (selectedRow < 0) {
                return;
            }
            if (this.jTableOccurrences.getSelectedRowCount() != 1) {
                JOptionPane.showMessageDialog(this.parent, "Select one row in the table.", this.parent.getTitle(), 1);
                return;
            }
            if (!this.tableModelOcc.getSaved(this.jTableOccurrences.convertRowIndexToModel(selectedRow))) {
                this.getToolkit().beep();
                return;
            }
            TaxonOcc fss = this.tableModelOcc.smpdtl.getOccur(this.jTableOccurrences.convertRowIndexToModel(selectedRow));
            if (fss != null) {
                this.editOccurrence(fss);
            }
        }
        catch (SQLException | SBException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
    }

    private void jTableSamplesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteSamplesActionPerformed(null);
        }
    }

    private void jTableAnalysesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteSmpdtlActionPerformed(null);
        }
    }

    private void jTableOccurrencesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteOccurencesActionPerformed(null);
        }
    }

    private void jButtonOccCommentActionPerformed(ActionEvent evt) {
        this.editBiocomOcc(true);
    }

    private void editBiocomOcc(boolean useSelection) {
        this.stopCellEditor();
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this.parent, "No version selected", this.parent.getTitle(), 1);
            return;
        }
        if (this.jTableAnalyses.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No analysis selected!", this.parent.getTitle(), 2);
            return;
        }
        try {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
            if (smpdtl != null) {
                DialogBiocom dialog;
                if (this.sbdb.restrictedToDiscID(smpdtl.getDiscID())) {
                    throw new SBPrivilegeException("You can only add/edit data within " + String.valueOf(this.sbdb.getUser().getDiscipline()));
                }
                Iterator<Biocom> it = wellInterp.getComments().iterator();
                Biocom comment = null;
                while (it.hasNext()) {
                    Biocom b = it.next();
                    if (b.getTopSample() != smpdtl.getSample() || b.getAnalyst() != smpdtl.getHeader().getAnalystUsrid() || b.getDiscID() != smpdtl.getHeader().getDiscID()) continue;
                    comment = b;
                    break;
                }
                if (comment != null) {
                    dialog = new DialogBiocom(this.parent, true, this.sbdb, this.well, wellInterp, this.units, comment, null, null);
                } else {
                    dialog = new DialogBiocom(this.parent, true, this.sbdb, this.well, wellInterp, this.units, null, smpdtl.getSample(), null);
                    dialog.setAnalyst(smpdtl.getAnalystAbr());
                    dialog.setDiscipline(Discipline.getDisc((char)smpdtl.getDiscID()));
                }
                dialog.undoSupport.addUndoableEditListener(this.undoManagerOccs);
                if (useSelection) {
                    boolean abr = this.parent.isAbrBiocom();
                    Object text = "";
                    int[] selection = this.jTableOccurrences.getSelectedRows();
                    for (int i = 0; i < selection.length; ++i) {
                        if (!this.tableModelOcc.getSaved(this.jTableOccurrences.convertRowIndexToModel(selection[i]))) continue;
                        TaxonOcc occ = smpdtl.getOccur(this.jTableOccurrences.convertRowIndexToModel(selection[i]));
                        if (occ == null) {
                            LOGGER.log(Level.WARNING, "Null TaxonOcc pointer in jtableOcc index: " + this.jTableOccurrences.convertRowIndexToModel(selection[i]) + " selection[i]: " + selection[i] + ", i=" + i);
                            continue;
                        }
                        Taxon taxon = occ.getTaxon();
                        if (((String)text).length() > 0) {
                            text = (String)text + ", ";
                        }
                        text = (String)text + taxon.toGenString(abr, false);
                    }
                    dialog.addText((String)text);
                }
                dialog.setLocation(this.jButtonOccComment.getLocationOnScreen());
                dialog.setVisible(true);
                if (dialog.isOK() && useSelection) {
                    this.jTableOccurrences.clearSelection();
                }
                this.updateComments();
            }
        }
        catch (SBPrivilegeException e) {
            JOptionPane.showMessageDialog(this.parent, e.getMessage(), this.parent.getTitle(), 2);
            e.printStackTrace();
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)e);
        }
    }

    private void jTextAreaCommentMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1 && this.jTextAreaComment.getText().equals(DEFAULT_COMMENT_TEXT)) {
            this.stopCellEditor();
            this.editBiocomOcc(true);
        }
    }

    private void jTextAreaCommentFocusLost(FocusEvent evt) {
        String comment = this.jTextAreaComment.getText().trim();
        if (!comment.equals(DEFAULT_COMMENT_TEXT)) {
            if (this.biocom != null) {
                if (this.sbdb.restrictedToDiscID(this.biocom.getDiscID())) {
                    JOptionPane.showMessageDialog(this.parent, "You can only add/edit data within " + String.valueOf(this.sbdb.getUser().getDiscipline()));
                    return;
                }
                if (!this.biocom.getText().equals(comment)) {
                    try {
                        if (comment.isEmpty()) {
                            this.undoSupportOccs.postEdit((UndoableEdit)((Object)this.getInterp().deleteBiocom(this.biocom, this.well.getWellID())));
                            this.biocom = null;
                        } else {
                            Biocom.Builder builder = new Biocom.Builder(this.sbdb, this.biocom.getDiscipline(), this.biocom.getAnalyst(), this.biocom.getTopSample(), comment);
                            WellInterp.BiocomEdit edit = this.getInterp().updateBiocom(this.biocom, builder, this.well.getWellID());
                            this.biocom = edit.getBiocom();
                            this.getInterp().notifyObservers(this.biocom);
                            this.undoSupportOccs.postEdit((UndoableEdit)((Object)edit));
                        }
                        this.sbdb.commit();
                    }
                    catch (SQLException | SBException ex) {
                        this.sbdb.doRollback();
                        FrameJsbugs.showStackError("Error updating comment", (Exception)ex, this.sbdb);
                        this.updateComments();
                    }
                }
            } else {
                System.out.println("Biocom null in focus lost!");
            }
        }
    }

    private void jButtonShowAllActionPerformed(ActionEvent evt) {
        this.jComboBoxDiscipline.setSelectedIndex(0);
        this.jComboBoxAnalyst.setSelectedIndex(0);
        this.jComboBoxAnalysisNumber.setSelectedIndex(0);
    }

    private List<Smpdtl> getSelectedSmpdtlsOrAll() {
        int opt;
        LinkedList<Smpdtl> selection = new LinkedList<Smpdtl>();
        if (this.jTableAnalyses.getSelectedRowCount() > 0 && (opt = JOptionPane.showConfirmDialog(this, "Restrict to the selected " + this.jTableAnalyses.getSelectedRowCount() + " analyses only?", this.parent.getTitle(), 0, 3)) == 0) {
            int[] selected = this.jTableAnalyses.getSelectedRows();
            for (int i = 0; i < selected.length; ++i) {
                selection.add(this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(selected[i])));
            }
        }
        if (selection.isEmpty()) {
            for (int i = 0; i < this.jTableAnalyses.getRowCount(); ++i) {
                selection.add(this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(i)));
            }
        }
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveAsAnalysesActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.\n(See config | Personnel for privilege options)", this.parent.getTitle(), 2);
            return;
        }
        try {
            List<Smpdtl> selection = this.getSelectedSmpdtlsOrAll();
            if (selection.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No analyses to export", this.parent.getTitle(), 2);
                return;
            }
            boolean allPrepared = selection.stream().noneMatch(smpdtl -> smpdtl.isAnalysed());
            if (allPrepared) {
                String message = "Export prepared analyses to directory structure for importing annotation files?";
                Object[] options = new String[]{this.resources.getString("button.yes"), this.resources.getString("button.no"), this.resources.getString("button.help")};
                int opt = JOptionPane.showOptionDialog(this, message, "Export Analyses", 1, 3, null, options, options[0]);
                if (opt == 2) {
                    HelpUtils.openHelp((String)"organiser_import_annotations.html");
                    return;
                }
                if (opt == 0) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(1);
                    int result = fc.showSaveDialog(this.parent);
                    if (result == 0) {
                        String parentDir = fc.getSelectedFile().getPath();
                        File wellDir = parentDir.endsWith(this.well.getWellCode()) ? fc.getSelectedFile() : new File(parentDir + File.separator + this.well.getWellCode());
                        for (Smpdtl dtl : selection) {
                            String dirName = StringUtils.joinWith((String)"_", (Object[])new Object[]{SampleStringFactory.toString((SampleProperties)dtl.getSample(), (DepthUnits)this.well.getHeader().getDepthUnits(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null), this.well.getHeader().getDepthUnits().getAbr(), dtl.getSample().getType(), Character.valueOf(dtl.getHeader().getDiscipline().getChar()), dtl.getHeader().getAnalyst(), dtl.getHeader().getAnalyNumber()});
                            File dtlDir = new File(wellDir, dirName);
                            dtlDir.mkdirs();
                        }
                        JOptionPane.showMessageDialog(this, "Directories created. Use Organiser to import.");
                    }
                    return;
                }
            }
            LinkedList<Discipline> discs = new LinkedList<Discipline>();
            for (Smpdtl smpdtl2 : selection) {
                if (discs.contains(smpdtl2.getDiscipline())) continue;
                discs.add(smpdtl2.getDiscipline());
            }
            String lastFile = Lastval.tryGetString(this.sbdb, "WINSMPDTL", "UNXSMPDTL");
            Object suffix = "";
            for (Discipline disc : discs) {
                suffix = (String)suffix + "_" + disc.getAbr(false).toLowerCase();
            }
            File file = FileChooserUtils.saveAsDialogWithFilters((Component)this, (String)lastFile, (String)SB.makeFileName((String)(this.well.getWellCode() + (String)suffix)), (FileNameExtensionFilter[])new FileNameExtensionFilter[]{FileChooserUtils.SBG_FILTER, FileChooserUtils.EXCEL_FILTER, FileChooserUtils.CSV_FILTER, FileChooserUtils.LEGACY_EXCEL_FILTER});
            if (file == null) {
                return;
            }
            String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            if (extension.equalsIgnoreCase("sbg")) {
                if (FileOverwriteCheck.checkForFileOverwrite(file, this.parent)) {
                    Lastval.putString(this.sbdb, "WINSMPDTL", "UNXSMPDTL", file.getPath());
                    this.exportSmpdtlXML(file, selection);
                }
            } else {
                DialogCSVExport dialog = new DialogCSVExport(this.parent, true, this.sbdb, selection, this.well, this.units, this.discID, this.sbdb.getUserID(this.analystString), this.analyNo, file.getPath());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
        }
        catch (SQLException | SBException e) {
            StackError.showStackError((String)"Error writing file", (Throwable)e);
            this.sbdb.doRollback();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void jButtonSaveSamplesActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.\n(See config | Personnel for privilege options)", this.parent.getTitle(), 2);
            return;
        }
        LinkedList<Sample> selection = null;
        try {
            int opt;
            if (this.jTableSamples.getSelectedRowCount() > 0 && (opt = JOptionPane.showConfirmDialog(this, "Restrict output to the selected " + this.jTableSamples.getSelectedRowCount() + " samples only?", this.parent.getTitle(), 0, 3)) == 0) {
                selection = new LinkedList();
                int[] selected = this.jTableSamples.getSelectedRows();
                for (int i = 0; i < selected.length; ++i) {
                    selection.add(this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(selected[i])));
                }
            }
            if (selection == null) {
                selection = new LinkedList<Sample>();
                for (int i = 0; i < this.jTableSamples.getRowCount(); ++i) {
                    selection.add(this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(i)));
                }
            }
            if (selection.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No samples to export", this.parent.getTitle(), 2);
                return;
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, null);
        }
        String lastFile = Lastval.tryGetString(this.sbdb, "SMPRPRTWIN", "SMPRPRTUNX");
        File file = FileChooserUtils.saveAsDialogWithFilters((Component)this, (String)lastFile, (String)SB.makeFileName((String)(this.well.getWellCode() + "_samples")), (FileNameExtensionFilter[])new FileNameExtensionFilter[]{FileChooserUtils.CSV_FILTER});
        if (file == null) {
            return;
        }
        DialogSampleReport dialog = new DialogSampleReport(this.parent, true, this.well, file.getPath(), this.sbdb, selection);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonOccUndoActionPerformed(ActionEvent evt) {
        this.undoRedoOccs(true);
    }

    private void jButtonOccRedoActionPerformed(ActionEvent evt) {
        this.undoRedoOccs(false);
    }

    private void jButtonOccInsertPrevActionPerformed(ActionEvent evt) {
        try {
            if (!this.well.canWrite(this.sbdb, null)) {
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        int selectedRow = this.jTableAnalyses.getSelectedRow();
        if (selectedRow < 0) {
            JOptionPane.showMessageDialog(this, "No analysis", "Copy", 2);
            return;
        }
        Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(selectedRow));
        Smpdtl prevDtl = null;
        int lookback = this.insertPrevLookback;
        while (prevDtl == null && selectedRow > 0) {
            Smpdtl candidate = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(--selectedRow));
            if (candidate.getHeader().getDiscipline() != smpdtl.getHeader().getDiscipline() || !candidate.isAnalysed() || candidate.getBarren()) continue;
            if (lookback == 0) {
                prevDtl = candidate;
            }
            --lookback;
        }
        if (prevDtl == null) {
            JOptionPane.showMessageDialog(this, "No previous analysis in " + smpdtl.getHeader().getDiscipline().getAbr(true), "copy", 2);
            return;
        }
        ArrayList<Taxon> list = new ArrayList<Taxon>();
        for (TaxonOcc occ : prevDtl.getOccurUnsorted()) {
            list.add(occ.getTaxon());
        }
        this.doSampleCopy(prevDtl, smpdtl, 3, false, false, list);
        ++this.insertPrevLookback;
        this.jButtonOccInsertPrev.setText(insertPrevButtonLabel + " (-" + this.insertPrevLookback + ")");
    }

    private void jButtonEditSelectionActionPerformed(ActionEvent evt) {
        LinkedList<Sample> samples = new LinkedList<Sample>();
        int[] selection = this.jTableSamples.getSelectedRows();
        try {
            for (int index = 0; index < selection.length; ++index) {
                samples.add(this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(selection[index])));
            }
            if (samples.isEmpty()) {
                JOptionPane.showMessageDialog(this.parent, "No sample(s) selected", "Sample Edit", 1);
                return;
            }
            DialogEditSamples dialog = new DialogEditSamples(this.parent, true, this.sbdb, this.well, this.units, samples);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException sqle) {
            FrameJsbugs.showStackError(sqle.getMessage(), (Exception)sqle, this.sbdb);
            sqle.printStackTrace();
        }
    }

    private void jButtonSetRwCvActionPerformed(ActionEvent evt) {
        this.setCvRw();
    }

    private void setCvRw() {
        int[] selectedRows;
        if (this.jTableOccurrences.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one or more rows from the table.", this.parent.getTitle(), 1);
            return;
        }
        for (int selectedRow : selectedRows = this.jTableOccurrences.getSelectedRows()) {
            if (this.tableModelOcc.getSaved(this.jTableOccurrences.convertRowIndexToModel(selectedRow))) continue;
            this.getToolkit().beep();
            return;
        }
        LinkedList<TaxonOcc> list = new LinkedList<TaxonOcc>();
        for (int selectedRow : selectedRows) {
            TaxonOcc fss = this.tableModelOcc.smpdtl.getOccur(this.jTableOccurrences.convertRowIndexToModel(selectedRow));
            if (fss == null) continue;
            list.add(fss);
        }
        DialogSetRwCv dialog = new DialogSetRwCv(this.parent, true, this.sbdb, list, this.well, this.tableModelOcc.smpdtl);
        dialog.setLocationRelativeTo(this.jButtonSetRwCv);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.tableModelOcc.smpdtl.notifyObservers();
            this.well.setDataChanged();
            this.well.notifyObservers((Object)this.tableModelOcc.smpdtl);
        }
    }

    private void jButtonNextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 155 || evt.getKeyCode() == 73) {
            this.insertPicklistTaxon(false);
        } else if (evt.getKeyCode() == 520 || evt.getKeyCode() == 81) {
            this.insertPicklistTaxon(true);
        } else if (evt.getKeyCode() == 37) {
            this.jButtonPrevious.requestFocusInWindow();
        } else if (evt.getKeyCode() == 38) {
            this.jButtonPreviousActionPerformed(null);
        } else if (evt.getKeyCode() == 40) {
            this.jButtonNextActionPerformed(null);
        } else if (evt.getKeyCode() == 127) {
            this.jButtonDeleteOccurencesActionPerformed(null);
        }
    }

    private void jButtonPreviousKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 155 || evt.getKeyCode() == 73) {
            this.insertPicklistTaxon(false);
        } else if (evt.getKeyCode() == 520 || evt.getKeyCode() == 81) {
            this.insertPicklistTaxon(true);
        } else if (evt.getKeyCode() == 39) {
            this.jButtonNext.requestFocusInWindow();
        } else if (evt.getKeyCode() == 38) {
            this.jButtonPreviousActionPerformed(null);
        } else if (evt.getKeyCode() == 40) {
            this.jButtonNextActionPerformed(null);
        } else if (evt.getKeyCode() == 127) {
            this.jButtonDeleteOccurencesActionPerformed(null);
        }
    }

    private void jButtonTaxonImageActionPerformed(ActionEvent evt) {
        int selectedRow = this.jTableOccurrences.getSelectedRow();
        if (selectedRow < 0 || this.jTableOccurrences.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one row in the table.", this.parent.getTitle(), 1);
            return;
        }
        if (!this.tableModelOcc.getSaved(this.jTableOccurrences.convertRowIndexToModel(selectedRow))) {
            this.getToolkit().beep();
            return;
        }
        TaxonOcc fss = this.tableModelOcc.smpdtl.getOccur(this.jTableOccurrences.convertRowIndexToModel(selectedRow));
        ImageSet imageSet = null;
        if (fss.getImageSetID() > 0) {
            imageSet = new ImageSet(fss.getImageSetID());
        }
        try {
            DialogImageSet dialog = new DialogImageSet(this.parent, true, this.sbdb, imageSet, this.well.canWrite(this.sbdb, null));
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                int setAsType;
                fss.updateImageSet(this.well.getWellID(), this.getSmpdtl().getAnalyID(), this.getSmpdtl().getSample().getSampID(), dialog.getImageSetID());
                this.tableModelOcc.clearCachedImage(dialog.getImageSetID());
                if (dialog.getImageSetID() > 0 && !this.sbdb.getTaxonImageService().hasTypeImage(fss.getTaxon().getSpecID()) && (setAsType = DontAskMeAgainFactory.getConfirmOption("TAXONOCCTYPE", (Window)this.parent, 0, "There is no type reference image for this taxon. Use this image?", fss.getTaxon().toString(false), 1)) == 0) {
                    this.sbdb.getTaxonImageService().setTaxonImageSetType(fss.getTaxon().getSpecID(), new TaxonImageSet(dialog.getImageSetID(), fss.getTaxon().getSpecID(), false), true);
                }
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    private void jButtonAddDocActionPerformed(ActionEvent evt) {
        int opt;
        long size;
        String PREF_STRING = "WELLDOC";
        File file = SbugsIO.chooseFileToOpen(this.sbdb, this.parent, "WELLDOC", "PDF", "pdf");
        if (file == null) {
            return;
        }
        try {
            size = Files.size(file.toPath());
        }
        catch (IOException ioe) {
            SbugsExceptionHandler.showStackError("Error reading file", ioe);
            return;
        }
        if (size > 20000000L && (opt = JOptionPane.showConfirmDialog(this.parent, "This is a large file (" + FileUtils.byteCountToDisplaySize((long)size) + "). Large documents may cause performance issues.\nAre you sure you want to continue?", "Import Well Document", 0)) != 0) {
            return;
        }
        DialogWellDoc dialog = new DialogWellDoc(this.parent, true);
        dialog.setDocName(file.getName());
        JComboBox jComboBoxVersion = dialog.getInterpCombo();
        jComboBoxVersion.removeAllItems();
        jComboBoxVersion.addItem("None");
        Iterator<WellInterp> interpIt = this.well.getInterpIterator();
        while (interpIt.hasNext()) {
            jComboBoxVersion.addItem(interpIt.next());
        }
        jComboBoxVersion.setSelectedIndex(0);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        String docName = dialog.getDocName();
        Integer interpID = null;
        Object object = dialog.getVersion();
        if (object instanceof WellInterp) {
            WellInterp interp = (WellInterp)object;
            interpID = interp.getInterpId();
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            if (fis.available() == 0) {
                JOptionPane.showMessageDialog(this, "File is empty!", "Problem Reading File", 2);
                return;
            }
            new WellDocumentService(this.sbdb).storeDocument(this.well.getID(), interpID, docName, file.toString(), fis);
            this.sbdb.commit();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.parent, "File not found: " + file.toString());
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError("Failed to write PDF to the database", ex, this.parent);
        }
        catch (IOException ex) {
            SbugsExceptionHandler.showStackError("Error reading file", ex, this.parent);
        }
        this.tableModelDocuments.populateTable(this.well.getWellID(), this.sbdb);
        this.tableModelDocuments.fireTableDataChanged();
    }

    private File getWellDocumentContentAtRow(int row) {
        WellDocument doc = this.tableModelDocuments.getDocumentAt(row);
        try {
            return doc.getTempPDF(new WellDocumentService(this.sbdb));
        }
        catch (IOException | SQLException ex) {
            SbugsExceptionHandler.showStackError("Error reading document content", ex, this.parent);
            return null;
        }
    }

    public void documentPreviewDetach() {
        JFrame frame = this.jPanelPdfPreview.createDetachedViewer(this.getWell().getWellName());
        if (frame == null) {
            JOptionPane.showMessageDialog(this, "No document preview to show", "Document Viewer", 1);
            return;
        }
        frame.setVisible(true);
    }

    private void jTableDocumentsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.openWellDocument();
        }
    }

    private void openWellDocument() {
        if (this.jTableDocuments.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select a single document to show from the table", "Document Viewer", 1);
            return;
        }
        int row = this.jTableDocuments.getSelectedRow();
        File tempFile = this.getWellDocumentContentAtRow(row);
        if (tempFile == null) {
            return;
        }
        if (!tempFile.toPath().toString().toLowerCase().endsWith(".pdf") || this.jRadioButtonExternal.isSelected()) {
            try {
                Desktop.getDesktop().open(tempFile);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Unable to find a suitable viewer associated with the file type.\n(Try writing the file out and opening it.)", "Document Viewer", 1);
                ex.printStackTrace();
            }
            return;
        }
        this.jPanelPdfPreview.displayPdf(tempFile, this.tableModelDocuments.getDocumentAt(row).getDescr());
    }

    private void jButtonDeleteDocActionPerformed(ActionEvent evt) {
        int[] rows = this.jTableDocuments.getSelectedRows();
        if (rows.length == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", "Delete Documents", 2);
            return;
        }
        try {
            for (int row : rows) {
                WellDocument doc = this.tableModelDocuments.getDocumentAt(row);
                if (doc.getPrimaryWellID() != this.well.getWellID()) {
                    JOptionPane.showMessageDialog(this, "Use the " + doc.getPrimaryWellName() + " tab to delete this document", "Delete Document", 2);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "Delete document '" + doc.getDescr() + "' from database?", "Delete Document", 0, 3) != 0) {
                    return;
                }
                new WellDocumentService(this.sbdb).deleteDocument(doc.getDocID());
                this.sbdb.commit();
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError("Error deleting document", ex, this.parent);
        }
        this.jPanelPdfPreview.clearDisplay();
        this.tableModelDocuments.populateTable(this.well.getWellID(), this.sbdb);
        this.tableModelDocuments.fireTableDataChanged();
    }

    private void jButtonShowDocActionPerformed(ActionEvent evt) {
        this.openWellDocument();
    }

    private void jButtonDocRefsActionPerformed(ActionEvent evt) {
        DialogWellDocRefs dialog;
        if (this.jTableDocuments.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select a single row to edit", "Update well associations", 2);
            return;
        }
        WellDocument doc = this.tableModelDocuments.getDocumentAt(this.jTableDocuments.getSelectedRow());
        if (doc.getPrimaryWellID() != this.well.getWellID()) {
            JOptionPane.showMessageDialog(this, "Use the " + doc.getPrimaryWellName() + " tab to update this document's associated wells", "Update well associations", 2);
            return;
        }
        WellDocumentService docService = new WellDocumentService(this.sbdb);
        try {
            dialog = new DialogWellDocRefs(this.parent, true, doc, docService, this.sbdb.getWellService(), this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showDialogStackError(sql, this.parent);
            return;
        }
        if (dialog.isOK()) {
            List<Well> refs = dialog.getWells();
            Set<Integer> wellIDs = refs.stream().map(Well::getWellID).collect(Collectors.toSet());
            try {
                docService.storeReferences(doc.getDocID(), wellIDs);
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError("Error storing references", sql, this.parent);
            }
        }
    }

    private void jTabbedPaneSampleDataFocusGained(FocusEvent evt) {
        this.tableModelDocuments.populateTable(this.well.getWellID(), this.sbdb);
        this.tableModelDocuments.fireTableDataChanged();
    }

    private void jMenuItemOccEditActionPerformed(ActionEvent evt) {
        this.jButtonOccEditActionPerformed(evt);
    }

    private void jMenuItemOccDeleteActionPerformed(ActionEvent evt) {
        this.jButtonDeleteOccurencesActionPerformed(evt);
    }

    private void jMenuItemOccImageActionPerformed(ActionEvent evt) {
        this.jButtonTaxonImageActionPerformed(evt);
    }

    private void jTableOccurrencesMousePressed(MouseEvent evt) {
        if (this.parent.showOccPopup) {
            TableEventUtils.setRowSelectionPopup((JTable)this.jTableOccurrences, (MouseEvent)evt, (JPopupMenu)this.jPopupMenuOcc);
        }
    }

    private void jTableOccurrencesMouseReleased(MouseEvent evt) {
        if (this.parent.showOccPopup) {
            TableEventUtils.setRowSelectionPopup((JTable)this.jTableOccurrences, (MouseEvent)evt, (JPopupMenu)this.jPopupMenuOcc);
        }
    }

    private void jMenuItemOccBiostratCommentActionPerformed(ActionEvent evt) {
        this.jButtonOccCommentActionPerformed(evt);
    }

    private void jTableSamplesMousePressed(MouseEvent evt) {
        TableEventUtils.setRowSelectionPopup((JTable)this.jTableSamples, (MouseEvent)evt, (JPopupMenu)this.jPopupMenuSamples);
    }

    private void jTableSamplesMouseReleased(MouseEvent evt) {
        TableEventUtils.setRowSelectionPopup((JTable)this.jTableSamples, (MouseEvent)evt, (JPopupMenu)this.jPopupMenuSamples);
    }

    private void jMenuItemSamplesEditActionPerformed(ActionEvent evt) {
        this.jButtonEditSampleActionPerformed(evt);
    }

    private void jMenuItemSamplesDeleteActionPerformed(ActionEvent evt) {
        this.jButtonDeleteSamplesActionPerformed(evt);
    }

    private void jTableAnalysesMousePressed(MouseEvent evt) {
        TableEventUtils.setRowSelectionPopup((JTable)this.jTableAnalyses, (MouseEvent)evt, (JPopupMenu)this.jPopupMenuAnalyses);
    }

    private void jTableAnalysesMouseReleased(MouseEvent evt) {
        TableEventUtils.setRowSelectionPopup((JTable)this.jTableAnalyses, (MouseEvent)evt, (JPopupMenu)this.jPopupMenuAnalyses);
    }

    private void jMenuItemAnalyEditActionPerformed(ActionEvent evt) {
        this.jButtonEditSmpdtlActionPerformed(evt);
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.jButtonDeleteSmpdtlActionPerformed(evt);
    }

    private void jMenuItemAnalysesActionPerformed(ActionEvent evt) {
        try {
            Sample sample = this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(this.jTableSamples.getSelectedRow()));
            if (sample != null) {
                this.selectAnalyses(sample);
            }
        }
        catch (SQLException sbe) {
            LOGGER.log(Level.WARNING, "Error selecting sample", sbe);
        }
        catch (SBException ex) {
            LOGGER.log(Level.WARNING, "Error selecting sample", ex);
        }
    }

    private void jMenuItemOccSetCvReActionPerformed(ActionEvent evt) {
        this.setCvRw();
    }

    private void jMenuItemAnalyEditOccActionPerformed(ActionEvent evt) {
        Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
        if (smpdtl != null) {
            if (this.tableModelAnalyses.getCurrentTaxon() != null) {
                List<TaxonOcc> list;
                if (this.tableModelOcc.smpdtl == null) {
                    this.showOccurrences();
                }
                if ((list = this.tableModelAnalyses.getOccurrencesForTaxon(this.tableModelAnalyses.getCurrentTaxon(), smpdtl)).size() > 1) {
                    JOptionPane.showMessageDialog(this, "There is more than one occurrence of this taxon in this sample.", "Samples", 1);
                    return;
                }
                if (!list.isEmpty()) {
                    try {
                        this.editOccurrence(list.get(0));
                        this.tableModelAnalyses.fireTableDataChanged();
                    }
                    catch (SQLException | SBException sql) {
                        this.sbdb.doRollback();
                        FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "No occurrence to edit for selected taxon.", "Samples", 1);
                }
            } else {
                JOptionPane.showMessageDialog(this, "No taxon selected in picklist.", "Samples", 1);
            }
        }
    }

    private void jMenuItemAnalyEventActionPerformed(ActionEvent evt) {
        try {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
            if (smpdtl != null) {
                if (this.tableModelAnalyses.getCurrentTaxon() != null) {
                    SBEvent event;
                    SBDialog dialog;
                    Taxon taxon = this.tableModelAnalyses.getCurrentTaxon();
                    List<SBEvent> events = this.sbdb.getSBEvents(taxon.getSpecID());
                    Sample sample = smpdtl.getSample();
                    if (events.isEmpty()) {
                        dialog = new DialogEvent(this.parent, true, this.sbdb, null, taxon);
                        dialog.setLocationRelativeTo((Component)this);
                        dialog.setVisible(true);
                        if (dialog.sbEvent == null) {
                            return;
                        }
                        event = dialog.sbEvent;
                    } else if (events.size() == 1) {
                        event = events.get(0);
                    } else {
                        dialog = new DialogSelectEvent((Frame)this.parent, true, this.sbdb, events);
                        dialog.setLocationRelativeTo((Component)this.parent);
                        dialog.setVisible(true);
                        if (dialog.selection == null) {
                            return;
                        }
                        event = dialog.selection;
                    }
                    if (!this.checkEventPicked(event)) {
                        return;
                    }
                    dialog = new DialogWellEvent(this.parent, true, this.sbdb, this.well, this.getInterp(), this.well.getWellUnits(), null, sample, event, null);
                    dialog.setLocationRelativeTo((Component)this.parent);
                    dialog.setSmpdtl(smpdtl.getDiscID(), smpdtl.getAnalystAbr());
                    dialog.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, "No taxon selected in picklist.", "Samples", 1);
                }
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }

    private void jButtonAnalysesImagesActionPerformed(ActionEvent evt) {
        List<Smpdtl> smpdtls = this.getSelectedSmpdtlsOrAll();
        if (smpdtls.isEmpty()) {
            return;
        }
        DialogTaxonImages dialog = DialogTaxonImages.imageGalleryDialogForAnalyses(this.parent, smpdtls, this.sbdb);
        dialog.setLocationRelativeTo(this.parent);
        dialog.enableAnalysisSelection();
        dialog.setVisible(true);
        if (dialog.getSelectedAnalysis() != null) {
            DialogTaxonImages.SelectedAnalysis selectedAnalysis = dialog.getSelectedAnalysis();
            this.setSelectedAnalysis(null, selectedAnalysis.smpdtl());
            this.showOccurrences();
        }
    }

    private void jButtonWriteDocActionPerformed(ActionEvent evt) {
        if (this.jTableDocuments.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select a single document from the table", "Document Viewer", 1);
            return;
        }
        int row = this.jTableDocuments.getSelectedRow();
        WellDocument doc = this.tableModelDocuments.getDocumentAt(row);
        try {
            File file;
            File tempfile = doc.getTempPDF(new WellDocumentService(this.sbdb));
            if (tempfile == null) {
                return;
            }
            String filepath = doc.getPath();
            String fileName = null;
            String fileType = "";
            if (!StringUtils.isEmpty((CharSequence)filepath)) {
                fileName = filepath.contains(File.separator) ? filepath.substring(filepath.indexOf(File.separator) + 1) : filepath;
                fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
            }
            if ((file = FileChooserUtils.chooseFileToWrite((SBdb)this.sbdb, (Component)this.parent, (String)"DOCFILE", null, (String[])new String[]{fileType}, (String[])new String[]{"Image or document files"}, (String)fileName)) == null) {
                return;
            }
            FileUtils.copyFile((File)tempfile, (File)file);
            JOptionPane.showMessageDialog(this, "File written: " + file.getPath(), "Samples", 1);
        }
        catch (IOException | SQLException ex) {
            SbugsExceptionHandler.showStackError("Error reading document content", ex, this.parent);
            return;
        }
    }

    private boolean checkEventPicked(SBEvent event) {
        String msg = this.getInterp().checkEventPicked(event);
        return msg == null || JOptionPane.showConfirmDialog(this.parent, msg + "\nContinue?\n", "Pick Event", 0) == 0;
    }

    private void insertPicklistTaxon(boolean isQuestionable) {
        JPanelPicklist picklist = this.parent.getPicklists().get(0);
        if (picklist != null) {
            picklist.addToSample(true, isQuestionable);
        }
    }

    private void undoRedoOccs(boolean undo) {
        this.stopCellEditor();
        if (undo && this.undoManagerOccs.canUndo() || !undo && this.undoManagerOccs.canRedo()) {
            if (undo) {
                this.undoManagerOccs.undo();
            } else {
                this.undoManagerOccs.redo();
            }
            this.tableModelOcc.fireTableDataChanged();
            this.tableModelOcc.smpdtl.notifyObservers();
            this.setUndoTooltips();
        } else {
            this.getToolkit().beep();
        }
    }

    private void setUndoTooltips() {
        Object modifier = "Ctrl";
        if (FrameJsbugs.isMacPlatform()) {
            char appleCmd = '\u2318';
            modifier = "" + appleCmd;
        }
        this.jButtonOccUndo.setToolTipText(this.undoManagerOccs.getUndoPresentationName() + " (" + (String)modifier + " + Z)");
        this.jButtonOccRedo.setToolTipText(this.undoManagerOccs.getRedoPresentationName() + " (" + (String)modifier + " + Shift + Z)");
    }

    private void exportSmpdtlXML(File file, List<Smpdtl> dtls) throws SQLException, SBException {
        int opt;
        SBdb ws = new SBdb(this.sbdb);
        WsWell wsWell = ws.addWellToWorkspace(this.well);
        if (this.parent.getSynSchID() > 0 && (opt = JOptionPane.showConfirmDialog(this, "Continue to export data using selected synonym scheme?", this.parent.getTitle(), 0, 3)) == 1) {
            return;
        }
        wsWell.fillAnalyses(dtls, true, this.parent.getSynSchID());
        if (ws.getUser(this.well.getHeader().getModifier()) == null && this.well.getHeader().getModifier() > 0) {
            ws.fillUser(this.sbdb, this.well.getHeader().getModifier());
        }
        if (ws.getUser(this.well.getHeader().getCreator()) == null && this.well.getHeader().getCreator() > 0) {
            ws.fillUser(this.sbdb, this.well.getHeader().getCreator());
        }
        HashSet<Integer> dTypes = new HashSet<Integer>();
        dTypes.add(6);
        dTypes.add(2);
        dTypes.add(4);
        dTypes.add(8);
        try {
            SbugsIO.saveSBGfile(this.sbdb, null, ws, file, this.parent, dTypes, false);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "Export Analyses", 2);
        }
        catch (IOException e) {
            StackError.showStackError((String)"Error writing file", (Throwable)e);
        }
    }

    Sample getSelectedSample() throws SQLException, SBException {
        Sample sample = null;
        if (this.jTableSamples.getSelectedRowCount() > 0) {
            sample = this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(this.jTableSamples.getSelectedRows()[0]));
        }
        return sample;
    }

    Sample getSelectedTopSample() throws SQLException, SBException {
        if (this.jTableSamples.getSelectedRowCount() > 0) {
            return this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(this.jTableSamples.getSelectedRows()[0]));
        }
        return null;
    }

    Sample getSelectedBaseSample() throws SQLException, SBException {
        if (this.jTableSamples.getSelectedRowCount() > 0) {
            return this.tableModelSamples.getSamples().get(this.jTableSamples.convertRowIndexToModel(this.jTableSamples.getSelectedRows()[this.jTableSamples.getSelectedRowCount() - 1]));
        }
        return null;
    }

    void clearSampleSelection() {
        this.jTableSamples.clearSelection();
    }

    void setSamplesInterp(WellInterp wellInterp) throws SQLException, SBException {
        this.tableModelSamples.setInterp(this.well, wellInterp, this.sbdb);
        this.jTableSamples.setToolTipText(null);
        this.jTextAreaComment.setToolTipText("Biostratigraphic Comments - " + wellInterp.getHeader().toString());
    }

    void setVersion(WellInterp wellInterp, Object caller) throws SQLException, SBException {
        try {
            this.well.getInterp(wellInterp.getInterpId());
        }
        catch (SBException sbe) {
            return;
        }
        this.setSamplesInterp(wellInterp);
        if (this.jPanelCharts != null && !(caller instanceof JPanelCharts.JPanelChartsVersionItemListener)) {
            this.jPanelCharts.setInterp(wellInterp);
        }
        if (this.jPanelInterpretations != null && caller != this.jPanelInterpretations) {
            this.jPanelInterpretations.setVersion(wellInterp.getHeader(), true);
        }
        this.parent.setSchemeChartVersion(this.well, wellInterp.getHeader().getInterpID());
        if (!this.inStartup) {
            this.parent.setTabVersion(this, wellInterp.getHeader());
        }
    }

    void fillChartInterpCombo(WellInterp wellInterp) {
        if (this.jPanelCharts != null) {
            this.jPanelCharts.fillInterpCombo(this.well, wellInterp);
        }
    }

    void setVersion(InterpHdr header) throws SQLException, SBException {
        this.jPanelInterpretations.setVersion(header, false);
    }

    void addZone(int igdType, IGDUnitBase unit, IGDScheme scheme) {
        this.jPanelInterpretations.addZone(igdType, unit, scheme);
    }

    void addEvent(SBEvent event, EventType evType) {
        this.jPanelInterpretations.addEvent(event, evType);
    }

    void addSQPick(Surface surface) {
        this.jPanelInterpretations.addSQPick(surface);
    }

    void setSelectedSample(Sample sample) throws SQLException, SBException {
        int index = this.tableModelSamples.getSamples().indexOf(sample);
        if (index >= 0) {
            index = this.jTableSamples.convertRowIndexToView(index);
            this.jTableSamples.setRowSelectionInterval(index, index);
            this.jTableSamples.scrollRectToVisible(this.jTableSamples.getCellRect(index, 0, true));
        }
    }

    void clearPicklistHighlighting() {
        for (JPanelPicklist picklist : this.parent.getPicklists()) {
            picklist.highlightMap.clear();
            picklist.repaint();
        }
    }

    void setPicklistHighlighting(Smpdtl smpdtl) {
        if (this.parent.picklistHighlighting == null) {
            return;
        }
        if (smpdtl == null) {
            if (this.jTableAnalyses.getSelectedRow() < 0) {
                return;
            }
            smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.jTableAnalyses.convertRowIndexToModel(this.jTableAnalyses.getSelectedRow()));
        }
        int sampleLookBack = this.parent.picklistHighlighting.nSamples;
        int mostPopularCutoff = this.parent.picklistHighlighting.nTaxa;
        boolean mostPoularPercent = this.parent.picklistHighlighting.isPercent;
        List<Smpdtl> list = this.tableModelAnalyses.getSmpdtls();
        int ind = list.indexOf((Object)smpdtl);
        List<JPanelPicklist> picklists = this.parent.getPicklists();
        Iterator<JPanelPicklist> it = picklists.iterator();
        while (ind > 0 && it.hasNext()) {
            int nAnalyses = sampleLookBack;
            JPanelPicklist picklist = it.next();
            picklist.highlightMap.clear();
            while (ind > 0 && nAnalyses > 0) {
                if (list.get(--ind).getDiscID() != smpdtl.getDiscID()) continue;
                Smpdtl s = list.get(ind);
                for (TaxonOcc occ : s.getOccurUnsorted()) {
                    int nOcc = 0;
                    if (picklist.highlightMap.containsKey(occ.getTaxon().getSpecID())) {
                        nOcc = picklist.highlightMap.get(occ.getTaxon().getSpecID());
                    }
                    picklist.highlightMap.put(occ.getTaxon().getSpecID(), ++nOcc);
                }
                --nAnalyses;
            }
            int mostPopular = mostPopularCutoff;
            if (mostPoularPercent) {
                mostPopular = (int)((double)picklist.highlightMap.size() * ((double)mostPopularCutoff / 100.0));
            }
            if (picklist.highlightMap.size() > 0 && mostPopular > 0) {
                LinkedList<Integer> values = new LinkedList<Integer>(picklist.highlightMap.values());
                Collections.sort(values);
                picklist.highlightThreshold = values.size() > mostPopular ? (Integer)values.get(values.size() - mostPopular) : 0;
            } else {
                picklist.highlightThreshold = -1;
            }
            picklist.repaintList();
            ind = list.indexOf((Object)smpdtl);
        }
    }

    void setSelectedAnalysis(Sample sample, Smpdtl smpdtl) {
        int index;
        if (smpdtl != null && (index = this.tableModelAnalyses.getSmpdtls().indexOf((Object)smpdtl)) >= 0) {
            index = this.jTableAnalyses.convertRowIndexToModel(index);
            this.jTableAnalyses.setRowSelectionInterval(index, index);
            this.jTableAnalyses.scrollRectToVisible(this.jTableAnalyses.getCellRect(index, 0, true));
            return;
        }
        if (sample != null && (smpdtl = sample.getSmpdtls().get(sample.getSmpdtls().size() - 1)) != null && (index = this.tableModelAnalyses.getSmpdtls().indexOf((Object)smpdtl)) >= 0) {
            index = this.jTableAnalyses.convertRowIndexToModel(index);
            this.jTableAnalyses.setRowSelectionInterval(index, index);
            this.jTableAnalyses.scrollRectToVisible(this.jTableAnalyses.getCellRect(index, 0, true));
        }
    }

    boolean isOccurrencesTableScroll() {
        return this.jTableOccurrences.getAutoResizeMode() != 4;
    }

    void setOccurrencesTableScroll(boolean scroll) {
        if (scroll) {
            this.jTableOccurrences.setAutoResizeMode(0);
        } else {
            this.jTableOccurrences.setAutoResizeMode(4);
        }
    }

    void setCMF(boolean cMF) {
        Smpdtl smpdtl = this.tableModelOcc.smpdtl;
        this.setSplits(smpdtl);
        this.tableModelOcc.setSplits(this.jTableOccurrences, cMF);
        if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelOccurences) {
            this.tableModelOcc.fireTableDataChanged();
        }
    }

    void setSmpdtl(Smpdtl smpdtl) {
        this.setSelectedAnalysis(null, smpdtl);
        this.jButtonShowAllActionPerformed(null);
        this.showOccurrences();
        this.updateOverlay();
        this.insertPrevLookback = 0;
        this.jButtonOccInsertPrev.setText(insertPrevButtonLabel);
        this.setPicklistHighlighting(smpdtl);
    }

    JTable getOccTable() {
        return this.jTableOccurrences;
    }

    void removeChart() {
        if (this.chartsFrameDetached != null) {
            this.chartsFrameDetached.setVisible(false);
            this.chartsFrameDetached = null;
        }
    }

    void setSampleLabel() throws SQLException, SBException {
        List<Sample> samples = this.well.getSamples();
        int[] nSampleType = new int[SampleType.values().length];
        block0: for (Sample sample : samples) {
            int i = 0;
            SampleType[] sampleTypeArray = SampleType.values();
            int n = sampleTypeArray.length;
            for (int j = 0; j < n; ++j) {
                SampleType type = sampleTypeArray[j];
                if (sample.getType() == type) {
                    int n2 = i;
                    nSampleType[n2] = nSampleType[n2] + 1;
                    continue block0;
                }
                ++i;
            }
        }
        Object types = "<html>";
        int i = 0;
        for (SampleType type : SampleType.values()) {
            if (nSampleType[i] > 0) {
                types = (String)types + "<b>" + nSampleType[i] + "</b> " + type.getShortName() + "<br>";
            }
            ++i;
        }
        types = (String)types + "<b>" + samples.size() + "</b> Samples</html>";
        this.jLabelSamples.setText((String)types);
    }

    void setSelectedTaxonOcc(TaxonOcc occ) {
        if (occ == null || this.tableModelOcc.smpdtl.getIndexOfOccur(occ) < 0) {
            return;
        }
        int index = this.jTableOccurrences.convertRowIndexToView(this.tableModelOcc.smpdtl.getIndexOfOccur(occ));
        this.jTableOccurrences.getSelectionModel().setSelectionInterval(index, index);
        this.jTableOccurrences.scrollRectToVisible(this.jTableOccurrences.getCellRect(index, 0, true));
    }

    void setSelectedTaxon(Taxon taxon) {
        if (taxon == null) {
            return;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (TaxonOcc occ : this.tableModelOcc.smpdtl.getOccurUnsorted()) {
            if (occ.getTaxon() != taxon) continue;
            indexes.add(this.jTableOccurrences.convertRowIndexToView(this.tableModelOcc.smpdtl.getIndexOfOccur(occ)));
        }
        this.jTableOccurrences.getSelectionModel().clearSelection();
        if (!indexes.isEmpty()) {
            Iterator<TaxonOcc> iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)((Object)iterator.next());
                this.jTableOccurrences.getSelectionModel().addSelectionInterval(index, index);
            }
            this.jTableOccurrences.scrollRectToVisible(this.jTableOccurrences.getCellRect((Integer)indexes.get(0), 0, true));
        }
    }

    void stopCellEditor() {
        TableCellEditor editor = this.jTableOccurrences.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    boolean addChartTemplateTab(ChartTemplateBase templ, String chartProp, String hdrProp, String keyProp, int schID) throws SQLException {
        return this.jPanelCharts.addChartTemplateTab(templ, chartProp, hdrProp, keyProp, schID);
    }

    void updateTotals() {
        for (int i = this.jPanelTotals.getComponentCount() - 1; i > 3; --i) {
            this.jPanelTotals.remove(i);
        }
        this.totalLabels = new HashMap();
        this.jPanelTotals.setLayout(new GridLayout(0, 1, 0, 3));
        if (this.getSmpdtl() != null) {
            AbundanceScheme scheme = this.sbdb.getAbundanceSchemeService().findAbundanceScheme(this.getSmpdtl().getHeader().getAbnSchID()).orElse(null);
            for (TaxonOcc occ : this.getSmpdtl().getOccurSorted()) {
                int count;
                if (this.parent.getTotExRwCv() && (occ.getCaved() || occ.getReworked())) continue;
                String mnem = occ.getTaxon().getCatMnem();
                if (this.totalLabels.get(mnem) == null) {
                    this.totalLabels.put(mnem, new TotalLabel(this, mnem));
                }
                if ((count = occ.getTotalCount()) > 0) {
                    this.totalLabels.get((Object)mnem).count += count;
                    continue;
                }
                String abn = occ.getSubAbund(true);
                if (scheme != null) {
                    this.totalLabels.get((Object)mnem).abnIndex = Math.max(scheme.getIndex(abn), this.totalLabels.get((Object)mnem).abnIndex);
                    continue;
                }
                this.totalLabels.get((Object)mnem).abnIndex = -1;
            }
            LinkedList<TotalLabel> values = new LinkedList<TotalLabel>(this.totalLabels.values());
            Collections.sort(values);
            for (TotalLabel label : values) {
                label.updateLabel(scheme);
                this.jPanelTotals.add(label.label);
                label.label.setVisible(true);
            }
        }
        this.jPanelTotals.revalidate();
        this.jPanelTotals.repaint();
    }

    void putTableColumnWidths() {
        HashMap<JTable, TableModelSB> tables = new HashMap<JTable, TableModelSB>();
        tables.put(this.jTableOccurrences, this.tableModelOcc);
        tables.put(this.jTableAnalyses, this.tableModelAnalyses);
        tables.put(this.jTableSamples, this.tableModelSamples);
        try {
            for (Map.Entry entry : tables.entrySet()) {
                ((TableModelSB)entry.getValue()).putTableColumnWidths(this.sbdb, (JTable)entry.getKey());
                ((TableModelSB)entry.getValue()).putTableColumnOrder(this.sbdb, (JTable)entry.getKey());
            }
            this.jPanelInterpretations.putTableColumnWidthsAndOrder();
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    TableModelSB getSelectedTable() {
        Component c = this.jTabbedPaneSampleData.getSelectedComponent();
        if (c == this.jPanelSamples) {
            return this.tableModelSamples;
        }
        if (c == this.jPanelAnalyses) {
            return this.tableModelAnalyses;
        }
        if (c == this.jPanelOccurences) {
            return this.tableModelOcc;
        }
        if (c instanceof JPanelWellInterp) {
            return ((JPanelWellInterp)c).getSelectedTable();
        }
        return null;
    }

    LinkedList<TablePair> getTablePair(TableModelSB model) {
        LinkedList<TablePair> tables = new LinkedList<TablePair>();
        if (model instanceof TableModelOccurrences) {
            tables.add(new TablePair(this.tableModelOcc, this.jTableOccurrences));
        } else if (model instanceof TableModelSamples) {
            tables.add(new TablePair(this.tableModelSamples, this.jTableSamples));
        } else if (model instanceof TableModelAnalyses) {
            tables.add(new TablePair(this.tableModelAnalyses, this.jTableAnalyses));
        } else {
            tables.addAll(this.jPanelInterpretations.getTablePair(model));
        }
        return tables;
    }

    void removeTab(ChartTemplateBase templ) {
        this.jPanelCharts.removeTab(templ);
    }

    public void setDisplayCuttingCorrections(boolean value) {
        this.tableModelSamples.setDisplayCuttingCorrections(value);
        if (this.jPanelInterpretations != null) {
            this.jPanelInterpretations.setDisplayCuttingCorrections(value);
        }
    }

    public void terminate() {
        this.jPanelCharts.terminate();
    }

    public TabView getCurrentView() {
        Component c = this.jTabbedPaneSampleData.getSelectedComponent();
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            try {
                wellInterp = this.well.getInterp(0);
            }
            catch (SBException ex) {
                System.out.println("Error fetching interp: " + ex.getMessage());
                return null;
            }
        }
        if (c == this.jPanelSamples) {
            return TabView.createSamplesTabView();
        }
        if (c == this.jPanelAnalyses) {
            return TabView.createAnalysesTabView(this.getDiscipline(), this.analystString, this.analyNo);
        }
        if (c == this.jPanelOccurences) {
            return TabView.createOccurrencesTabView(this.getDiscipline(), this.analystString, this.analyNo);
        }
        if (c instanceof JPanelWellInterp) {
            return TabView.createInterpsTabView(wellInterp.getHeader().getInterpID(), this.jPanelInterpretations.getSelectedTabDataType());
        }
        if (c == this.jPanelCharts) {
            return TabView.createChartsTabView(wellInterp.getHeader().getInterpID(), this.jPanelCharts.getSelectedBlockTemplateID(), this.jPanelCharts.getSelectedChartTemplateID());
        }
        if (c == this.jPanelDocuments) {
            return TabView.createDocumentsTabView(wellInterp.getHeader().getInterpID());
        }
        return null;
    }

    public void applyView(TabView view) {
        block1 : switch (view.getTabType()) {
            case SAMPLES: {
                this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelSamples);
                break;
            }
            case ANALYSES: 
            case OCCURRENCES: {
                this.jComboBoxDiscipline.setSelectedItem(view.getDisc() != null ? view.getDisc() : ALL_STRING);
                this.jComboBoxAnalyst.setSelectedItem(view.getAnalyst() != null ? view.getAnalyst() : ALL_STRING);
                this.jComboBoxAnalysisNumber.setSelectedItem(view.getSuiteNo());
                switch (view.getTabType()) {
                    case ANALYSES: {
                        this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelAnalyses);
                        break;
                    }
                    case OCCURRENCES: {
                        this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelOccurences);
                    }
                }
                break;
            }
            case INTERPS: 
            case CHARTS: {
                try {
                    this.jPanelInterpretations.setVersion(this.sbdb.getInterp(view.getInterpID()), true);
                }
                catch (SQLException sqlex) {
                    SbugsExceptionHandler.showStackError(sqlex);
                    return;
                }
                switch (view.getTabType()) {
                    case INTERPS: {
                        this.jPanelInterpretations.setSelectedTab(view.getInterpsTabDataType());
                        this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelInterpretations);
                        break block1;
                    }
                    case CHARTS: {
                        if (view.getBlockTemplateID() != null) {
                            this.jPanelCharts.selectTemplateTab(view.getBlockTemplateID(), view.getChartTemplateID());
                        }
                        this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelCharts);
                    }
                }
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        private boolean undo;
        final /* synthetic */ JPanelWell this$0;

        UndoAction(JPanelWell jPanelWell, boolean undo) {
            JPanelWell jPanelWell2 = jPanelWell;
            Objects.requireNonNull(jPanelWell2);
            this.this$0 = jPanelWell2;
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.this$0.jTabbedPaneSampleData.getSelectedComponent() == this.this$0.jPanelCharts) {
                new UndoRedoAction(this.undo, this.this$0.jPanelCharts).actionPerformed(e);
            } else if (this.this$0.jTabbedPaneSampleData.getSelectedComponent() == this.this$0.jPanelOccurences) {
                new UndoOccsAction(this.this$0, this.undo).actionPerformed(e);
            }
        }
    }

    class TotalLabel
    implements Comparable {
        JLabel label;
        int count;
        int abnIndex;

        TotalLabel(JPanelWell this$0, String mnem) {
            Objects.requireNonNull(this$0);
            this.abnIndex = -1;
            this.label = new JLabel(mnem);
        }

        void updateLabel(AbundanceScheme sch) {
            Object text = "";
            text = this.count > 0 ? (String)text + this.count : (sch != null && this.abnIndex > -1 ? (String)text + sch.getEntry(this.abnIndex).abr() : "+");
            this.label.setText(this.label.getText() + ": " + (String)text);
        }

        public int compareTo(Object o) {
            return this.label.getText().compareTo(((TotalLabel)o).label.getText());
        }
    }

    private class UndoOccsAction
    extends AbstractAction {
        private boolean undo;
        final /* synthetic */ JPanelWell this$0;

        public UndoOccsAction(JPanelWell jPanelWell, boolean undo) {
            JPanelWell jPanelWell2 = jPanelWell;
            Objects.requireNonNull(jPanelWell2);
            this.this$0 = jPanelWell2;
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.undo) {
                this.this$0.undoRedoOccs(true);
            } else {
                this.this$0.undoRedoOccs(false);
            }
        }
    }
}

