/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.model3.wellinterp.LOCNode;
import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableRowSorter;
import jsbugs.BiocomTableModel;
import jsbugs.BiocomTableModelWithCorrection;
import jsbugs.DialogBiocom;
import jsbugs.DialogEditBiocoms;
import jsbugs.DialogEditWellEventError;
import jsbugs.DialogEnv;
import jsbugs.DialogEvent;
import jsbugs.DialogEventComments;
import jsbugs.DialogFault;
import jsbugs.DialogFillHierarchy;
import jsbugs.DialogGenerateEvent;
import jsbugs.DialogIGDColmap;
import jsbugs.DialogIGDHdrs;
import jsbugs.DialogIGDZoneExportOptions;
import jsbugs.DialogIPSBathy;
import jsbugs.DialogIntcoms;
import jsbugs.DialogInterval;
import jsbugs.DialogIntervalComment;
import jsbugs.DialogMoveInterp;
import jsbugs.DialogSQPick;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSelectGroup;
import jsbugs.DialogSelectVersion;
import jsbugs.DialogWellEvent;
import jsbugs.EnvTableModel;
import jsbugs.EventsTableModel;
import jsbugs.EventsTableModelWithCorrection;
import jsbugs.FrameJsbugs;
import jsbugs.FrameSamples;
import jsbugs.IntervalCommentsTableModel;
import jsbugs.JPanelWell;
import jsbugs.LOCTableModel;
import jsbugs.TableModelSB;
import jsbugs.TablePair;
import jsbugs.TaxonDropTarget;
import jsbugs.TaxonTransferHandler;
import jsbugs.ZonesTableModel;
import jsbugs.ZonesTableModelWithCorrected;
import jsbugs.depthage.DialogLOCnode;
import jsbugs.depthage.DialogSnapToEvent;
import jsbugs.depthage.LOCNodeShiftRequest;
import jsbugs.io.GridBuilderIGDZones;
import jsbugs.model2.event.DialogCmpStd;
import jsbugs.model2.wellinterp.FaultsTableModel;
import jsbugs.model2.wellinterp.InterpItemTableModel;
import jsbugs.model2.wellinterp.SQPickTableModel;
import jsbugs.model2.wellinterp.SQPickTableModelWithCorrections;
import jsbugs.sampleage.PanelInterpSampleAge;
import jsbugs.table.SampleDistance;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.SampleUtils;
import model3.Biocom;
import model3.Fault;
import model3.IGDInterval;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.Intcom;
import model3.InterpHdr;
import model3.LASFile;
import model3.LOC;
import model3.Lastval;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.SampleInsertException;
import model3.Surface;
import model3.Taxon;
import model3.TxGroup;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.wellinterp.InterpItem;
import org.jdesktop.layout.GroupLayout;
import util.AgeFormat;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.CellDataFormat;
import util.gridwriter.CellFormat;
import util.gridwriter.GridSheet;
import util.gridwriter.GridWriter;

public class JPanelWellInterp
extends JPanel
implements Observer {
    private final FrameSamples parentFrame;
    private final JPanelWell parentPanel;
    private final SBdb sbdb;
    private final Well well;
    private char units;
    private static final Logger LOGGER = Logger.getLogger(JPanelWellInterp.class.getName());
    private ZonesTableModel tableModelBiozones;
    private EventsTableModel tableModelEvents;
    private BiocomTableModel tableModelBiocom;
    private final IntervalCommentsTableModel tableModelIntervalComments = new IntervalCommentsTableModel();
    private ZonesTableModel tableModelChrono;
    private SQPickTableModel tableModelSQPicks;
    private final EnvTableModel tableModelEnv = new EnvTableModel();
    private ZonesTableModel tableModelLstrat;
    private final LOCTableModel tableModelLOC = new LOCTableModel();
    private final FaultsTableModel tableModelFaults = new FaultsTableModel();
    private final DefaultComboBoxModel comboModelBioScheme = new DefaultComboBoxModel();
    private static final String SELECT_STRING = "<Select>";
    private static final String SAVEAS_TOOLTIP = "<html>Save this table to a text file<br>(<b>Hint:</b> copy table cells using <b>CTRL+C</b>)</html>";
    private ButtonGroup buttonGroupAgeDisplay;
    private JButton jButton1;
    private JButton jButtonAddBio;
    private JButton jButtonAddChrono;
    private JButton jButtonAddCom;
    private JButton jButtonAddEvent;
    private JButton jButtonAddFault;
    private JButton jButtonAddIntCom;
    private JButton jButtonAddLOC;
    private JButton jButtonAddLith;
    private JButton jButtonAddPal;
    private JButton jButtonAddSQPick;
    private JButton jButtonBioColmap;
    private JButton jButtonBiozoneComments;
    private JButton jButtonChronoColmap;
    private JButton jButtonChronoComments;
    private JButton jButtonCommentEvents;
    private JButton jButtonCopyBio;
    private JButton jButtonCopyChrono;
    private JButton jButtonCopyCom;
    private JButton jButtonCopyEvents;
    private JButton jButtonCopyIntCom;
    private JButton jButtonCopyLOC;
    private JButton jButtonCopyLith;
    private JButton jButtonCopyPal;
    private JButton jButtonCopySQPicks;
    private JButton jButtonCreateComposite;
    private JButton jButtonCreateSamples;
    private JButton jButtonDeleteBio;
    private JButton jButtonDeleteChrono;
    private JButton jButtonDeleteCom;
    private JButton jButtonDeleteEvent;
    private JButton jButtonDeleteFault;
    private JButton jButtonDeleteIntCom;
    private JButton jButtonDeleteLOC;
    private JButton jButtonDeleteLith;
    private JButton jButtonDeletePal;
    private JButton jButtonDeleteSQPick;
    private JButton jButtonEditBio;
    private JButton jButtonEditChrono;
    private JButton jButtonEditCom;
    private JButton jButtonEditEvent;
    private JButton jButtonEditFault;
    private JButton jButtonEditIntCom;
    private JButton jButtonEditLith;
    private JButton jButtonEditPal;
    private JButton jButtonEditSQPick;
    private JButton jButtonEditSelectedCom;
    private JButton jButtonEnvComments;
    private JButton jButtonEventComments;
    private JButton jButtonEventDepthError;
    private JButton jButtonEventTxGroup;
    private JButton jButtonFillBiozoneHierachy;
    private JButton jButtonFillChronoHierachy;
    private JButton jButtonFillLstratHierachy;
    private JButton jButtonGenerateEvents;
    private JButton jButtonIGDHdrs;
    private JButton jButtonIPSBathy;
    private JButton jButtonLOCComment;
    private JButton jButtonLOCCommentsCancel;
    private JButton jButtonLOCCommentsOK;
    private JButton jButtonLOCWeight;
    private JButton jButtonLstratColmap;
    private JButton jButtonMoveBio;
    private JButton jButtonMoveChrono;
    private JButton jButtonMoveCom;
    private JButton jButtonMoveEvents;
    private JButton jButtonMoveIntCom;
    private JButton jButtonMoveInterp;
    private JButton jButtonMoveLOC;
    private JButton jButtonMoveLith;
    private JButton jButtonMovePal;
    private JButton jButtonMoveSQPick;
    private JButton jButtonMoveToSample;
    private JButton jButtonReadLOC;
    private JButton jButtonSaveAsBio;
    private JButton jButtonSaveAsChrono;
    private JButton jButtonSaveAsCom;
    private JButton jButtonSaveAsIntCom;
    private JButton jButtonSaveAsLOC;
    private JButton jButtonSaveAsLith;
    private JButton jButtonSaveAsPal;
    private JButton jButtonSaveAsSQPick;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectAllBio;
    private JButton jButtonSelectAllChrono;
    private JButton jButtonSelectAllCom;
    private JButton jButtonSelectAllEvents;
    private JButton jButtonSelectAllIntCom;
    private JButton jButtonSelectAllLith;
    private JButton jButtonSelectAllPal;
    private JButton jButtonSelectAllSQPick;
    private JButton jButtonShowChronoScheme;
    private JButton jButtonShowLstratScheme;
    private JButton jButtonShowSQschemetScheme;
    private JButton jButtonShowSchemeBiozone;
    private JButton jButtonSnapToEvent;
    private JButton jButtonVersionSelect;
    private JComboBox jComboBoxSchemeBio;
    private JComboBox jComboBoxVersion;
    private JDialog jDialogLOCComment;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JLabel jLabelLOCAudit;
    private JLabel jLabelLOCWeight;
    private JPanel jPanel1;
    private JPanel jPanelBiozones;
    private JPanel jPanelChrono;
    private JPanel jPanelComments;
    private JPanel jPanelEnv;
    private JPanel jPanelEvents;
    private JPanel jPanelFaults;
    private JPanel jPanelIntComments;
    private JPanel jPanelLOC;
    private JPanel jPanelLStrat;
    private JPanel jPanelSQPick;
    private JRadioButton jRadioButtonAgeFormatKa;
    private JRadioButton jRadioButtonAgeFormatMA;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JScrollPane jScrollPaneComments;
    private JScrollPane jScrollPaneEventsTable;
    private JScrollPane jScrollPaneIntComments;
    private JScrollPane jScrollPaneLOC;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JSeparator jSeparator15;
    private JSeparator jSeparator16;
    private JSeparator jSeparator17;
    private JSeparator jSeparator18;
    private JSeparator jSeparator19;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JTabbedPane jTabbedPaneInterpretations;
    private JTable jTableBiozones;
    private JTable jTableChrono;
    private JTable jTableComments;
    private JTable jTableEnv;
    private JTable jTableEvents;
    private JTable jTableFaults;
    private JTable jTableIntComments;
    private JTable jTableLOC;
    private JTable jTableLStrat;
    private JTable jTableSQPicks;
    private JTextArea jTextAreaLOCComments;
    private JTextField jTextFieldLOCColour;
    private PanelInterpSampleAge panelInterpSampleAge;

    public JPanelWellInterp(FrameSamples parent, JPanelWell parentPanel, SBdb sbdb, Well well) throws SQLException, SBException {
        this.initComponents();
        this.parentFrame = parent;
        this.parentPanel = parentPanel;
        this.sbdb = sbdb;
        this.well = well;
        this.init();
    }

    private void init() throws SQLException, SBException {
        if (this.well.hasShifts()) {
            this.tableModelBiozones = new ZonesTableModelWithCorrected("TMBIOZWC", "TOBIOZWC", "TARBIOZWC");
            this.tableModelChrono = new ZonesTableModelWithCorrected("TMCHRZWC", "TOCHRZWC", "TARCHRZWC");
            this.tableModelLstrat = new ZonesTableModelWithCorrected("TMLSTZWC", "TOLSTZWC", "TARLSTZWC");
            this.tableModelEvents = new EventsTableModelWithCorrection();
            this.tableModelBiocom = new BiocomTableModelWithCorrection();
            this.tableModelSQPicks = new SQPickTableModelWithCorrections();
        } else {
            this.tableModelBiozones = new ZonesTableModel("TMBIOZ", "TOBIOZ", "TARBIOZ");
            this.tableModelChrono = new ZonesTableModel("TMCHRZ", "TOCHRZ", "TARCHRZ");
            this.tableModelLstrat = new ZonesTableModel("TMLSTZ", "TOLSTZ", "TARLSTZ");
            this.tableModelEvents = new EventsTableModel();
            this.tableModelBiocom = new BiocomTableModel();
            this.tableModelSQPicks = new SQPickTableModel();
        }
        this.jTableBiozones.setModel(this.tableModelBiozones);
        this.jTableChrono.setModel(this.tableModelChrono);
        this.jTableLStrat.setModel(this.tableModelLstrat);
        this.jTableEvents.setModel(this.tableModelEvents);
        this.jTableComments.setModel(this.tableModelBiocom);
        this.jTableSQPicks.setModel(this.tableModelSQPicks);
        this.tableModelBiozones.setupTable(this.jTableBiozones, this.sbdb);
        this.jTableBiozones.setRowSorter(new TableRowSorter<ZonesTableModel>(this.tableModelBiozones));
        new ColumnSortResetHandler(this.jTableBiozones).attach();
        this.tableModelEvents.setupTable(this.jTableEvents, this.sbdb);
        this.jTableEvents.setRowSorter(new TableRowSorter<EventsTableModel>(this.tableModelEvents));
        new ColumnSortResetHandler(this.jTableEvents).attach();
        this.tableModelBiocom.setupTable(this.jTableComments, this.sbdb);
        this.jTableComments.setRowSorter(new TableRowSorter<BiocomTableModel>(this.tableModelBiocom));
        new ColumnSortResetHandler(this.jTableComments).attach();
        this.tableModelIntervalComments.setupTable(this.jTableIntComments, this.sbdb);
        this.jTableIntComments.setRowSorter(new TableRowSorter<IntervalCommentsTableModel>(this.tableModelIntervalComments));
        new ColumnSortResetHandler(this.jTableIntComments).attach();
        this.tableModelChrono.setupTable(this.jTableChrono, this.sbdb);
        this.jTableChrono.setRowSorter(new TableRowSorter<ZonesTableModel>(this.tableModelChrono));
        new ColumnSortResetHandler(this.jTableChrono).attach();
        this.tableModelSQPicks.setupTable(this.jTableSQPicks, this.sbdb);
        this.jTableSQPicks.setRowSorter(new TableRowSorter<SQPickTableModel>(this.tableModelSQPicks));
        new ColumnSortResetHandler(this.jTableSQPicks).attach();
        this.tableModelEnv.setupTable(this.jTableEnv, this.sbdb);
        this.jTableEnv.setRowSorter(new TableRowSorter<EnvTableModel>(this.tableModelEnv));
        new ColumnSortResetHandler(this.jTableEnv).attach();
        this.tableModelLstrat.setupTable(this.jTableLStrat, this.sbdb);
        this.jTableLStrat.setRowSorter(new TableRowSorter<ZonesTableModel>(this.tableModelLstrat));
        new ColumnSortResetHandler(this.jTableLStrat).attach();
        this.tableModelFaults.setupTable(this.jTableFaults, this.sbdb);
        this.jTableFaults.setRowSorter(new TableRowSorter<FaultsTableModel>(this.tableModelFaults));
        new ColumnSortResetHandler(this.jTableFaults).attach();
        this.tableModelLOC.setupTable(this.jTableLOC, this.sbdb);
        this.panelInterpSampleAge.setup(this.well, this.units);
        this.well.loadInterps();
        this.sbdb.commit();
        this.well.fillInterpCombo(this.jComboBoxVersion);
        if (this.jComboBoxVersion.getItemCount() > 1) {
            this.jComboBoxVersion.insertItemAt(SELECT_STRING, 0);
            this.jComboBoxVersion.setSelectedIndex(0);
        } else {
            this.jComboBoxVersion.setSelectedIndex(0);
            this.getInterp().addObserver(this.parentPanel);
        }
        this.fillBioSchemeCombo();
        this.versionChanged();
        this.jComboBoxVersion.addItemListener(new ItemListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 2 && e.getStateChange() == 1) {
                    this.this$0.versionChanged();
                }
            }
        });
        this.jButtonEventDepthError.setEnabled(true);
        this.initDnD();
    }

    private void initDnD() {
        this.jTableEvents.setDragEnabled(true);
        this.jTableEvents.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
        this.jTableEvents.setDropTarget(null);
        this.jPanelEvents.setTransferHandler(new TaxonTransferHandler(this.sbdb, null));
    }

    @Override
    public void update(Observable o, Object a) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdate(o, a);
        } else {
            final Observable obs = o;
            final Object arg = a;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ JPanelWellInterp this$0;
                {
                    JPanelWellInterp jPanelWellInterp = this$0;
                    Objects.requireNonNull(jPanelWellInterp);
                    this.this$0 = jPanelWellInterp;
                }

                @Override
                public void run() {
                    this.this$0.doUpdate(obs, arg);
                }
            });
        }
    }

    private void doUpdate(Observable o, Object a) {
        final Observable obs = o;
        final Object arg = a;
        final JPanelWellInterp thisPanel = this;
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp2 = this$0;
                Objects.requireNonNull(jPanelWellInterp2);
                this.this$0 = jPanelWellInterp2;
            }

            @Override
            public void run() {
                if (arg != null && (arg.getClass() == WellInterp.class || arg.getClass() == InterpHdr.class)) {
                    int origID = 0;
                    if (this.this$0.getInterp() != null) {
                        origID = this.this$0.getInterp().getHeader().getInterpID();
                    }
                    this.this$0.well.fillInterpCombo(this.this$0.jComboBoxVersion);
                    try {
                        if (arg.getClass() == WellInterp.class && this.this$0.well.getInterp(((WellInterp)arg).getHeader().getInterpID()) != null) {
                            this.this$0.jComboBoxVersion.setSelectedItem(arg);
                        } else if (arg.getClass() == InterpHdr.class && this.this$0.getInterp().getHeader().getInterpID() != origID) {
                            this.this$0.versionChanged();
                        }
                    }
                    catch (SBException sbe) {
                        StackError.showStackError((String)sbe.toString(), (Throwable)sbe);
                    }
                } else if (obs instanceof WellInterp) {
                    if (arg == null) {
                        this.this$0.well.fillInterpCombo(this.this$0.jComboBoxVersion);
                        this.this$0.jComboBoxVersion.setSelectedIndex(0);
                    } else {
                        this.this$0.sbdb.clearVersionsInProjectCache();
                        int igdType = 0;
                        if (arg.getClass() == IGDIntervalZone.class) {
                            IGDIntervalZone zone = (IGDIntervalZone)arg;
                            igdType = zone.getIGDType();
                        } else if (arg.getClass() == Biocom.class) {
                            igdType = 19;
                        } else if (arg.getClass() == Integer.class) {
                            igdType = (Integer)arg;
                        } else if (arg.getClass() == IGDIntervalEnv.class) {
                            igdType = 5;
                        } else if (arg.getClass() == WellEvent.class) {
                            igdType = 20;
                        } else if (arg.getClass() == SQPick.class) {
                            igdType = 21;
                        } else if (arg.getClass() == Intcom.class) {
                            igdType = 22;
                        } else if (arg.getClass() == LOC.class) {
                            igdType = 23;
                        } else if (arg.getClass() == Fault.class) {
                            igdType = 24;
                        }
                        switch (igdType) {
                            case 3: {
                                this.this$0.tableModelChrono.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableChrono, this.this$0.tableModelChrono.getZones());
                                break;
                            }
                            case 2: {
                                this.this$0.tableModelLstrat.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableLStrat, this.this$0.tableModelLstrat.getZones());
                                break;
                            }
                            case 10: {
                                System.out.println("In IGD_SEQUENCE??");
                                this.this$0.tableModelSQPicks.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableSQPicks, this.this$0.tableModelSQPicks.getItems());
                                break;
                            }
                            case 4: {
                                this.this$0.jComboBoxSchemeBioActionPerformed(null);
                                try {
                                    this.this$0.updateBioSchemeCombo();
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog(this.this$0.parentFrame, "Error updating biozone scheme combo: " + ex.getMessage(), this.this$0.parentFrame.getTitle(), 1);
                                    ex.printStackTrace();
                                }
                                this.this$0.setTableSelection(arg, this.this$0.jTableBiozones, this.this$0.tableModelBiozones.getZones());
                                break;
                            }
                            case 19: {
                                this.this$0.tableModelBiocom.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableComments, this.this$0.tableModelBiocom.comments);
                                break;
                            }
                            case 5: {
                                this.this$0.tableModelEnv.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableEnv, this.this$0.tableModelEnv.envs);
                                break;
                            }
                            case 20: {
                                this.this$0.tableModelEvents.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableEvents, this.this$0.tableModelEvents.events);
                                break;
                            }
                            case 21: {
                                this.this$0.tableModelSQPicks.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableSQPicks, this.this$0.tableModelSQPicks.getItems());
                                break;
                            }
                            case 22: {
                                this.this$0.tableModelIntervalComments.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableIntComments, this.this$0.tableModelIntervalComments.comments);
                                break;
                            }
                            case 24: {
                                this.this$0.tableModelFaults.fireTableDataChanged();
                                this.this$0.setTableSelection(arg, this.this$0.jTableFaults, this.this$0.tableModelFaults.getItems());
                                break;
                            }
                            case 23: {
                                WellInterp wellInterp = this.this$0.getInterp();
                                if (wellInterp != null) {
                                    try {
                                        AgeFormat original = this.this$0.tableModelLOC.getAgeFormat();
                                        AgeFormat af = this.this$0.tableModelLOC.setLOC(wellInterp, this.this$0.jTableLOC, this.this$0.well.getWellID(), this.this$0.well);
                                        if (wellInterp.getLOC() != null) {
                                            this.this$0.jLabelLOCAudit.setText(wellInterp.getLOC().getAudit().toString(this.this$0.sbdb, true));
                                        } else {
                                            this.this$0.jLabelLOCAudit.setText("");
                                        }
                                        if (original != null) {
                                            this.this$0.tableModelLOC.setAgeFormat(original);
                                            this.this$0.setAgeFormatButton(original);
                                        } else {
                                            this.this$0.setAgeFormatButton(af);
                                        }
                                    }
                                    catch (Exception e) {
                                        StackError.showStackError((String)"Error updating LOC table", (Throwable)e);
                                    }
                                    if (wellInterp.getLOC() != null) {
                                        wellInterp.getLOC().addWeakObserver(thisPanel);
                                    }
                                } else if (obs instanceof LOC && obs == this.this$0.tableModelLOC.getLOC()) {
                                    this.this$0.tableModelLOC.fireTableDataChanged();
                                }
                                this.this$0.tableModelLOC.fireTableDataChanged();
                            }
                        }
                    }
                }
            }
        });
    }

    void setUnits(char units) {
        if (units == 'M' && this.units != 'M' || units == 'F' && this.units != 'F') {
            this.units = units;
            this.tableModelChrono.setUnits(units);
            this.tableModelChrono.fireTableDataChanged();
            this.tableModelLstrat.setUnits(units);
            this.tableModelLstrat.fireTableDataChanged();
            this.tableModelBiozones.setUnits(units);
            this.tableModelBiozones.fireTableDataChanged();
            this.tableModelEnv.setUnits(units);
            this.tableModelEnv.fireTableDataChanged();
            this.tableModelBiocom.setUnits(units);
            this.tableModelBiocom.fireTableDataChanged();
            this.tableModelEvents.setUnits(units);
            this.tableModelEvents.fireTableDataChanged();
            this.tableModelIntervalComments.setUnits(units);
            this.tableModelIntervalComments.setWellType(this.well.getType());
            this.tableModelIntervalComments.fireTableDataChanged();
            this.tableModelLOC.setUnits(units);
            this.tableModelLOC.updateCellEditors(this.jTableLOC);
            this.tableModelLOC.type = this.well.getType();
            this.tableModelLOC.fireTableDataChanged();
            this.tableModelSQPicks.setUnits(units);
            this.tableModelSQPicks.fireTableDataChanged();
            this.tableModelFaults.setUnits(units);
            this.tableModelFaults.fireTableDataChanged();
            this.panelInterpSampleAge.setUnits(units);
        }
    }

    void fillBioSchemeCombo() throws SQLException {
        this.comboModelBioScheme.removeAllElements();
        Object obj = this.jComboBoxVersion.getSelectedItem();
        if (obj instanceof WellInterp) {
            WellInterp wellInterp = (WellInterp)obj;
            for (IGDIntervalZone zone : wellInterp.getIGDList(4, 0)) {
                IGDScheme scheme = this.sbdb.getIGDScheme(zone.getSchID());
                if (this.comboModelBioScheme.getIndexOf(scheme) >= 0) continue;
                this.comboModelBioScheme.addElement(scheme);
            }
            this.jComboBoxSchemeBio.repaint();
        }
    }

    void updateBioSchemeCombo() throws SQLException {
        IGDScheme addedScheme = null;
        Object obj = this.jComboBoxVersion.getSelectedItem();
        if (obj instanceof WellInterp) {
            WellInterp wellInterp = (WellInterp)obj;
            for (IGDIntervalZone zone : wellInterp.getIGDList(4, 0)) {
                IGDScheme scheme = this.sbdb.getIGDScheme(zone.getSchID());
                if (this.comboModelBioScheme.getIndexOf(scheme) >= 0) continue;
                this.comboModelBioScheme.addElement(scheme);
                addedScheme = scheme;
            }
            this.jComboBoxSchemeBio.repaint();
        }
        if (addedScheme != null) {
            this.comboModelBioScheme.setSelectedItem(addedScheme);
        }
    }

    WellInterp getInterp() {
        if (!(this.jComboBoxVersion.getSelectedItem() instanceof WellInterp)) {
            return null;
        }
        WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
        try {
            this.well.getInterp(wellInterp.getInterpId());
        }
        catch (SBException e) {
            return null;
        }
        return wellInterp;
    }

    void loadDefaultVersion() {
        if (!(this.jComboBoxVersion.getSelectedItem() instanceof WellInterp)) {
            try {
                this.jComboBoxVersion.setSelectedItem(this.well.getInterp(0));
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
        }
    }

    void editZone(IGDIntervalZone zone) {
        try {
            WellInterp wellInterp = this.getInterp();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
                return;
            }
            DialogInterval dialog = new DialogInterval(this.parentFrame, true, zone.getIGDType(), this.sbdb, this.well, wellInterp, this.units, zone, null, null, null, null, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error opening dialog: " + e.getMessage(), this.parentFrame.getTitle(), 0);
        }
    }

    void addEvent(SBEvent event, EventType eventType) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        Sample sample = null;
        try {
            sample = this.parentPanel.getSelectedSample();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error getting selected sample", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        try {
            DialogWellEvent dialog = new DialogWellEvent(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, null, sample, event, eventType);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
    }

    void addSQPick(Surface surface) {
        try {
            WellInterp wellInterp = this.getSelectedVersion();
            if (wellInterp == null) {
                return;
            }
            Sample sample = null;
            IGDScheme scheme = null;
            try {
                sample = this.parentPanel.getSelectedSample();
                if (surface == null) {
                    Iterator<SQPick> iterator = wellInterp.getSQPicks().iterator();
                    if (iterator.hasNext()) {
                        SQPick pick = iterator.next();
                        scheme = pick.getSurface().getScheme();
                    }
                } else {
                    scheme = surface.getScheme();
                }
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("Error getting selected sample", sql, this.sbdb);
            }
            try {
                DialogSQPick dialog = new DialogSQPick(this.parentFrame, true, this.sbdb, scheme, this.well, wellInterp, this.units, null, sample, surface);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
            catch (SQLException e) {
                FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
            }
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    void addZone(int igdType, IGDUnitBase unit, IGDScheme scheme) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            Sample topSample = this.parentPanel.getSelectedTopSample();
            Sample baseSample = this.parentPanel.getSelectedBaseSample();
            if (scheme == null) {
                for (IGDIntervalZone zone : wellInterp.getIGDList(igdType, 0)) {
                    scheme = this.sbdb.getIGDScheme(zone.getSchID());
                }
            }
            DialogInterval dialog = new DialogInterval(this.parentFrame, true, igdType, this.sbdb, this.well, wellInterp, this.units, null, topSample, baseSample, unit, scheme, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.baseSample != null) {
                this.parentPanel.setSelectedSample(dialog.baseSample);
            }
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    void deleteZones(JTable table, ZonesTableModel model) {
        int nRows = table.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select interval(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        Object msg = "Really delete ";
        msg = nRows == 1 ? (String)msg + "this interval?" : (String)msg + "these " + nRows + " intervals?";
        if (JOptionPane.showConfirmDialog(this, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<IGDIntervalZone> toKill = new LinkedList<IGDIntervalZone>();
        for (int row : table.getSelectedRows()) {
            toKill.add(model.getZones().get(table.convertRowIndexToModel(row)));
        }
        try {
            wellInterp.deleteZones(this.well, toKill);
            this.sbdb.commit();
            Object arg = null;
            for (IGDIntervalZone zone : toKill) {
                if (arg == null || arg instanceof IGDIntervalZone && ((IGDInterval)arg).getIGDType() == zone.getIGDType() && (zone.getIGDType() != 4 || ((IGDIntervalZone)arg).getSchID() == zone.getSchID())) {
                    arg = zone;
                    continue;
                }
                arg = zone.getIGDType();
            }
            table.clearSelection();
            wellInterp.notifyObservers(arg);
        }
        catch (SQLException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error deleting zones", ex, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error deleting zones", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void initComponents() {
        this.buttonGroupAgeDisplay = new ButtonGroup();
        this.jDialogLOCComment = new JDialog();
        this.jScrollPane8 = new JScrollPane();
        this.jTextAreaLOCComments = new JTextArea();
        this.jButtonLOCCommentsCancel = new JButton();
        this.jButtonLOCCommentsOK = new JButton();
        this.jLabel4 = new JLabel();
        this.jComboBoxVersion = new JComboBox();
        this.jButtonVersionSelect = new JButton();
        this.jTabbedPaneInterpretations = new JTabbedPane();
        this.jPanelChrono = new JPanel();
        this.jButtonAddChrono = new JButton();
        this.jButtonEditChrono = new JButton();
        this.jButtonDeleteChrono = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jButtonSelectAllChrono = new JButton();
        this.jButtonCopyChrono = new JButton();
        this.jButtonMoveChrono = new JButton();
        this.jSeparator5 = new JSeparator();
        this.jButtonSaveAsChrono = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableChrono = new JTable();
        this.jButtonChronoColmap = new JButton();
        this.jButtonFillChronoHierachy = new JButton();
        this.jButtonShowChronoScheme = new JButton();
        this.jButtonChronoComments = new JButton();
        this.jPanelBiozones = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.jTableBiozones = new JTable();
        this.jButtonAddBio = new JButton();
        this.jButtonEditBio = new JButton();
        this.jButtonDeleteBio = new JButton();
        this.jButtonMoveBio = new JButton();
        this.jButtonCopyBio = new JButton();
        this.jButtonSelectAllBio = new JButton();
        this.jButtonSaveAsBio = new JButton();
        this.jSeparator12 = new JSeparator();
        this.jSeparator13 = new JSeparator();
        this.jComboBoxSchemeBio = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jButtonBioColmap = new JButton();
        this.jButtonFillBiozoneHierachy = new JButton();
        this.jButtonShowSchemeBiozone = new JButton();
        this.jButtonBiozoneComments = new JButton();
        this.jPanelLStrat = new JPanel();
        this.jButtonAddLith = new JButton();
        this.jButtonEditLith = new JButton();
        this.jButtonDeleteLith = new JButton();
        this.jSeparator10 = new JSeparator();
        this.jButtonSelectAllLith = new JButton();
        this.jButtonCopyLith = new JButton();
        this.jButtonMoveLith = new JButton();
        this.jSeparator11 = new JSeparator();
        this.jButtonSaveAsLith = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.jTableLStrat = new JTable();
        this.jButtonLstratColmap = new JButton();
        this.jButtonFillLstratHierachy = new JButton();
        this.jButtonShowLstratScheme = new JButton();
        this.jButton1 = new JButton();
        this.jPanelSQPick = new JPanel();
        this.jButtonAddSQPick = new JButton();
        this.jButtonEditSQPick = new JButton();
        this.jButtonDeleteSQPick = new JButton();
        this.jSeparator18 = new JSeparator();
        this.jButtonSelectAllSQPick = new JButton();
        this.jButtonMoveSQPick = new JButton();
        this.jSeparator19 = new JSeparator();
        this.jButtonSaveAsSQPick = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.jTableSQPicks = new JTable();
        this.jButtonShowSQschemetScheme = new JButton();
        this.jButtonCopySQPicks = new JButton();
        this.jPanelFaults = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableFaults = new JTable();
        this.jButtonAddFault = new JButton();
        this.jButtonEditFault = new JButton();
        this.jButtonDeleteFault = new JButton();
        this.jPanelEnv = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableEnv = new JTable();
        this.jButtonAddPal = new JButton();
        this.jButtonEditPal = new JButton();
        this.jButtonDeletePal = new JButton();
        this.jSeparator6 = new JSeparator();
        this.jButtonSelectAllPal = new JButton();
        this.jButtonCopyPal = new JButton();
        this.jButtonMovePal = new JButton();
        this.jSeparator7 = new JSeparator();
        this.jButtonSaveAsPal = new JButton();
        this.jButtonEnvComments = new JButton();
        this.jSeparator8 = new JSeparator();
        this.jButtonIPSBathy = new JButton();
        this.jPanelComments = new JPanel();
        this.jScrollPaneComments = new JScrollPane();
        this.jTableComments = new JTable();
        this.jButtonAddCom = new JButton();
        this.jButtonEditCom = new JButton();
        this.jButtonDeleteCom = new JButton();
        this.jButtonSaveAsCom = new JButton();
        this.jButtonCopyCom = new JButton();
        this.jButtonMoveCom = new JButton();
        this.jButtonSelectAllCom = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jButtonCommentEvents = new JButton();
        this.jButtonEditSelectedCom = new JButton();
        this.jPanelIntComments = new JPanel();
        this.jScrollPaneIntComments = new JScrollPane();
        this.jTableIntComments = new JTable();
        this.jButtonAddIntCom = new JButton();
        this.jButtonEditIntCom = new JButton();
        this.jButtonDeleteIntCom = new JButton();
        this.jButtonSaveAsIntCom = new JButton();
        this.jButtonCopyIntCom = new JButton();
        this.jButtonMoveIntCom = new JButton();
        this.jButtonSelectAllIntCom = new JButton();
        this.jSeparator16 = new JSeparator();
        this.jPanelEvents = new EventsPanel(this);
        this.jScrollPaneEventsTable = new JScrollPane();
        this.jTableEvents = new JTable();
        this.jButtonAddEvent = new JButton();
        this.jButtonDeleteEvent = new JButton();
        this.jButtonGenerateEvents = new JButton();
        this.jSeparator14 = new JSeparator();
        this.jButtonSelectAllEvents = new JButton();
        this.jButtonMoveEvents = new JButton();
        this.jButtonCopyEvents = new JButton();
        this.jSeparator15 = new JSeparator();
        this.jButtonEditEvent = new JButton();
        this.jButtonCreateComposite = new JButton();
        this.jButtonEventComments = new JButton();
        this.jButtonEventTxGroup = new JButton();
        this.jButtonEventDepthError = new JButton();
        this.jPanelLOC = new JPanel();
        this.jScrollPaneLOC = new JScrollPane();
        this.jTableLOC = new JTable();
        this.jButtonAddLOC = new JButton();
        this.jButtonDeleteLOC = new JButton();
        this.jButtonSaveAsLOC = new JButton();
        this.jButtonCopyLOC = new JButton();
        this.jButtonMoveLOC = new JButton();
        this.jSeparator17 = new JSeparator();
        this.jLabel10 = new JLabel();
        this.jTextFieldLOCColour = new JTextField();
        this.jButtonCreateSamples = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonAgeFormatMA = new JRadioButton();
        this.jRadioButtonAgeFormatKa = new JRadioButton();
        this.jLabelLOCAudit = new JLabel();
        this.jButtonLOCComment = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabelLOCWeight = new JLabel();
        this.jButtonLOCWeight = new JButton();
        this.jButtonMoveToSample = new JButton();
        this.jButtonSnapToEvent = new JButton();
        this.jButtonReadLOC = new JButton();
        this.jButtonSelectAll = new JButton();
        this.panelInterpSampleAge = new PanelInterpSampleAge();
        this.jButtonIGDHdrs = new JButton();
        this.jButtonMoveInterp = new JButton();
        this.jDialogLOCComment.setTitle("Depth/Age Curve Comments");
        this.jDialogLOCComment.setModal(true);
        this.jDialogLOCComment.setResizable(false);
        this.jTextAreaLOCComments.setColumns(20);
        this.jTextAreaLOCComments.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaLOCComments.setLineWrap(true);
        this.jTextAreaLOCComments.setRows(5);
        this.jTextAreaLOCComments.setWrapStyleWord(true);
        this.jTextAreaLOCComments.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextAreaLOCCommentsKeyTyped(evt);
            }
        });
        this.jScrollPane8.setViewportView(this.jTextAreaLOCComments);
        this.jButtonLOCCommentsCancel.setText("Cancel");
        this.jButtonLOCCommentsCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLOCCommentsCancelActionPerformed(evt);
            }
        });
        this.jButtonLOCCommentsOK.setText("OK");
        this.jButtonLOCCommentsOK.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLOCCommentsOKActionPerformed(evt);
            }
        });
        GroupLayout jDialogLOCCommentLayout = new GroupLayout(this.jDialogLOCComment.getContentPane());
        this.jDialogLOCComment.getContentPane().setLayout((LayoutManager)jDialogLOCCommentLayout);
        jDialogLOCCommentLayout.setHorizontalGroup((GroupLayout.Group)jDialogLOCCommentLayout.createParallelGroup(1).add((GroupLayout.Group)jDialogLOCCommentLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jDialogLOCCommentLayout.createParallelGroup(1).add((Component)this.jScrollPane8, -1, 279, Short.MAX_VALUE).add(2, (GroupLayout.Group)jDialogLOCCommentLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonLOCCommentsOK).addPreferredGap(0).add((Component)this.jButtonLOCCommentsCancel))).addContainerGap()));
        jDialogLOCCommentLayout.linkSize(new Component[]{this.jButtonLOCCommentsCancel, this.jButtonLOCCommentsOK}, 1);
        jDialogLOCCommentLayout.setVerticalGroup((GroupLayout.Group)jDialogLOCCommentLayout.createParallelGroup(1).add((GroupLayout.Group)jDialogLOCCommentLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane8, -1, 146, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)jDialogLOCCommentLayout.createParallelGroup(3).add((Component)this.jButtonLOCCommentsCancel).add((Component)this.jButtonLOCCommentsOK)).addContainerGap()));
        this.jLabel4.setText("Version:");
        this.jComboBoxVersion.setMaximumRowCount(30);
        this.jComboBoxVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxVersion.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jButtonVersionSelect.setText("...");
        this.jButtonVersionSelect.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonVersionSelect.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonVersionSelectActionPerformed(evt);
            }
        });
        this.jButtonAddChrono.setText("Add...");
        this.jButtonAddChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddChronoActionPerformed(evt);
            }
        });
        this.jButtonEditChrono.setText("Edit...");
        this.jButtonEditChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditChronoActionPerformed(evt);
            }
        });
        this.jButtonDeleteChrono.setText("Delete");
        this.jButtonDeleteChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteChronoActionPerformed(evt);
            }
        });
        this.jButtonSelectAllChrono.setText("Select all");
        this.jButtonSelectAllChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllChronoActionPerformed(evt);
            }
        });
        this.jButtonCopyChrono.setText("Copy...");
        this.jButtonCopyChrono.setToolTipText("Copy selected intervals to a different version");
        this.jButtonCopyChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyChronoActionPerformed(evt);
            }
        });
        this.jButtonMoveChrono.setText("Move...");
        this.jButtonMoveChrono.setToolTipText("Move selected intervals to different version");
        this.jButtonMoveChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveChronoActionPerformed(evt);
            }
        });
        this.jButtonSaveAsChrono.setText("Save as...");
        this.jButtonSaveAsChrono.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsChrono.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsChronoActionPerformed(evt);
            }
        });
        this.jTableChrono.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableChronoMouseClicked(evt);
            }
        });
        this.jTableChrono.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableChronoKeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableChrono);
        this.jButtonChronoColmap.setText("Column mapping...");
        this.jButtonChronoColmap.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChronoColmapActionPerformed(evt);
            }
        });
        this.jButtonFillChronoHierachy.setText("Fill...");
        this.jButtonFillChronoHierachy.setToolTipText("Fill the higher levels of selected intervals from the scheme");
        this.jButtonFillChronoHierachy.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFillChronoHierachyActionPerformed(evt);
            }
        });
        this.jButtonShowChronoScheme.setText("Show Scheme...");
        this.jButtonShowChronoScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowChronoSchemeActionPerformed(evt);
            }
        });
        this.jButtonChronoComments.setText("Comments...");
        this.jButtonChronoComments.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonChronoComments.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChronoCommentsActionPerformed(evt);
            }
        });
        GroupLayout jPanelChronoLayout = new GroupLayout((Container)this.jPanelChrono);
        this.jPanelChrono.setLayout((LayoutManager)jPanelChronoLayout);
        jPanelChronoLayout.setHorizontalGroup((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1, false).add((Component)this.jButtonAddChrono, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditChrono, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteChrono, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator4).add((Component)this.jButtonSelectAllChrono, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonFillChronoHierachy, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator5).add((Component)this.jButtonSaveAsChrono, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopyChrono, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonChronoComments, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveChrono, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().add((Component)this.jButtonChronoColmap).addPreferredGap(0, 441, Short.MAX_VALUE).add((Component)this.jButtonShowChronoScheme)).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.jScrollPane2, -1, 699, Short.MAX_VALUE))).addContainerGap()));
        jPanelChronoLayout.setVerticalGroup((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(3).add((Component)this.jButtonChronoColmap).add((Component)this.jButtonShowChronoScheme)).addPreferredGap(1).add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().add((Component)this.jButtonAddChrono).addPreferredGap(0).add((Component)this.jButtonEditChrono).addPreferredGap(0).add((Component)this.jButtonDeleteChrono).addPreferredGap(0).add((Component)this.jSeparator4, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllChrono).addPreferredGap(0).add((Component)this.jButtonCopyChrono).addPreferredGap(0).add((Component)this.jButtonMoveChrono).addPreferredGap(1).add((Component)this.jSeparator5, -2, 10, -2).add(10, 10, 10).add((Component)this.jButtonFillChronoHierachy).addPreferredGap(0).add((Component)this.jButtonSaveAsChrono).addPreferredGap(0).add((Component)this.jButtonChronoComments).addContainerGap()).add((Component)this.jScrollPane2, -1, 582, Short.MAX_VALUE))));
        this.jTabbedPaneInterpretations.addTab("Chronostratigraphy", this.jPanelChrono);
        this.jTableBiozones.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableBiozonesMouseClicked(evt);
            }
        });
        this.jTableBiozones.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableBiozonesKeyPressed(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.jTableBiozones);
        this.jButtonAddBio.setText("Add...");
        this.jButtonAddBio.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddBioActionPerformed(evt);
            }
        });
        this.jButtonEditBio.setText("Edit...");
        this.jButtonEditBio.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditBioActionPerformed(evt);
            }
        });
        this.jButtonDeleteBio.setText("Delete");
        this.jButtonDeleteBio.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteBioActionPerformed(evt);
            }
        });
        this.jButtonMoveBio.setText("Move...");
        this.jButtonMoveBio.setToolTipText("move zones to new version");
        this.jButtonMoveBio.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveBioActionPerformed(evt);
            }
        });
        this.jButtonCopyBio.setText("Copy...");
        this.jButtonCopyBio.setToolTipText("Copy selected intervals to a different version");
        this.jButtonCopyBio.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyBioActionPerformed(evt);
            }
        });
        this.jButtonSelectAllBio.setText("Select all");
        this.jButtonSelectAllBio.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllBioActionPerformed(evt);
            }
        });
        this.jButtonSaveAsBio.setText("Save as...");
        this.jButtonSaveAsBio.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsBio.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsBioActionPerformed(evt);
            }
        });
        this.jComboBoxSchemeBio.setModel(this.comboModelBioScheme);
        this.jComboBoxSchemeBio.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxSchemeBio.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSchemeBioActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Scheme:");
        this.jButtonBioColmap.setText("Column mapping...");
        this.jButtonBioColmap.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonBioColmapActionPerformed(evt);
            }
        });
        this.jButtonFillBiozoneHierachy.setText("Fill...");
        this.jButtonFillBiozoneHierachy.setToolTipText("Fill the higher levels of selected intervals from the scheme");
        this.jButtonFillBiozoneHierachy.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFillBiozoneHierachyActionPerformed(evt);
            }
        });
        this.jButtonShowSchemeBiozone.setText("Show...");
        this.jButtonShowSchemeBiozone.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowSchemeBiozoneActionPerformed(evt);
            }
        });
        this.jButtonBiozoneComments.setText("Comments...");
        this.jButtonBiozoneComments.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonBiozoneComments.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonBiozoneCommentsActionPerformed(evt);
            }
        });
        GroupLayout jPanelBiozonesLayout = new GroupLayout((Container)this.jPanelBiozones);
        this.jPanelBiozones.setLayout((LayoutManager)jPanelBiozonesLayout);
        jPanelBiozonesLayout.setHorizontalGroup((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1, false).add((Component)this.jButtonBiozoneComments, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAsBio, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonFillBiozoneHierachy, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator12).add((Component)this.jButtonMoveBio, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopyBio, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAllBio, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator13).add((Component)this.jButtonDeleteBio, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditBio, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddBio, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createSequentialGroup().add((Component)this.jButtonBioColmap).add(97, 97, 97).add((Component)this.jLabel8).addPreferredGap(0).add((Component)this.jComboBoxSchemeBio, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonShowSchemeBiozone).addContainerGap()).add((Component)this.jScrollPane7, -1, 723, Short.MAX_VALUE))));
        jPanelBiozonesLayout.setVerticalGroup((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(3).add((Component)this.jButtonBioColmap).add((Component)this.jComboBoxSchemeBio, -2, -1, -2).add((Component)this.jLabel8).add((Component)this.jButtonShowSchemeBiozone)).addPreferredGap(0).add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createSequentialGroup().add((Component)this.jButtonAddBio).addPreferredGap(0).add((Component)this.jButtonEditBio).addPreferredGap(0).add((Component)this.jButtonDeleteBio).addPreferredGap(0).add((Component)this.jSeparator13, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllBio).addPreferredGap(0).add((Component)this.jButtonCopyBio).addPreferredGap(0).add((Component)this.jButtonMoveBio).addPreferredGap(0).add((Component)this.jSeparator12, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonFillBiozoneHierachy).addPreferredGap(0).add((Component)this.jButtonSaveAsBio).addPreferredGap(0).add((Component)this.jButtonBiozoneComments).addContainerGap()).add((Component)this.jScrollPane7, -1, 593, Short.MAX_VALUE))));
        this.jTabbedPaneInterpretations.addTab("Biozones", this.jPanelBiozones);
        this.jButtonAddLith.setText("Add...");
        this.jButtonAddLith.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddLithActionPerformed(evt);
            }
        });
        this.jButtonEditLith.setText("Edit...");
        this.jButtonEditLith.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditLithActionPerformed(evt);
            }
        });
        this.jButtonDeleteLith.setText("Delete");
        this.jButtonDeleteLith.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteLithActionPerformed(evt);
            }
        });
        this.jButtonSelectAllLith.setText("Select all");
        this.jButtonSelectAllLith.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllLithActionPerformed(evt);
            }
        });
        this.jButtonCopyLith.setText("Copy...");
        this.jButtonCopyLith.setToolTipText("Copy selected intervals to a different version");
        this.jButtonCopyLith.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyLithActionPerformed(evt);
            }
        });
        this.jButtonMoveLith.setText("Move...");
        this.jButtonMoveLith.setToolTipText("move zones to a different version");
        this.jButtonMoveLith.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveLithActionPerformed(evt);
            }
        });
        this.jButtonSaveAsLith.setText("Save as...");
        this.jButtonSaveAsLith.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsLith.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsLithActionPerformed(evt);
            }
        });
        this.jTableLStrat.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableLStratMouseClicked(evt);
            }
        });
        this.jTableLStrat.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableLStratKeyPressed(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTableLStrat);
        this.jButtonLstratColmap.setText("Column mapping...");
        this.jButtonLstratColmap.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLstratColmapActionPerformed(evt);
            }
        });
        this.jButtonFillLstratHierachy.setText("Fill...");
        this.jButtonFillLstratHierachy.setToolTipText("Fill the higher levels of selected intervals from the scheme");
        this.jButtonFillLstratHierachy.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFillLstratHierachyActionPerformed(evt);
            }
        });
        this.jButtonShowLstratScheme.setText("Show Scheme...");
        this.jButtonShowLstratScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowLstratSchemeActionPerformed(evt);
            }
        });
        this.jButton1.setText("Comments...");
        this.jButton1.setMargin(new Insets(2, 8, 2, 8));
        this.jButton1.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanelLStratLayout = new GroupLayout((Container)this.jPanelLStrat);
        this.jPanelLStrat.setLayout((LayoutManager)jPanelLStratLayout);
        jPanelLStratLayout.setHorizontalGroup((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((Component)this.jButtonSelectAllLith, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonEditLith, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonAddLith, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonDeleteLith, -1, 83, Short.MAX_VALUE).add((Component)this.jSeparator10, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonCopyLith, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonMoveLith, -1, 83, Short.MAX_VALUE).add((Component)this.jSeparator11, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonFillLstratHierachy, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAsLith).add((Component)this.jButton1)).addPreferredGap(0).add((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().add((Component)this.jButtonLstratColmap).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonShowLstratScheme)).add((Component)this.jScrollPane4, -1, 678, Short.MAX_VALUE)).addContainerGap()));
        jPanelLStratLayout.linkSize(new Component[]{this.jButton1, this.jButtonAddLith, this.jButtonCopyLith, this.jButtonDeleteLith, this.jButtonEditLith, this.jButtonFillLstratHierachy, this.jButtonMoveLith, this.jButtonSaveAsLith, this.jButtonSelectAllLith, this.jSeparator10, this.jSeparator11}, 1);
        jPanelLStratLayout.setVerticalGroup((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(3).add((Component)this.jButtonLstratColmap).add((Component)this.jButtonShowLstratScheme)).addPreferredGap(0).add((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().add((Component)this.jButtonAddLith).addPreferredGap(0).add((Component)this.jButtonEditLith).addPreferredGap(0).add((Component)this.jButtonDeleteLith).addPreferredGap(0).add((Component)this.jSeparator10, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllLith).addPreferredGap(0).add((Component)this.jButtonCopyLith).addPreferredGap(0).add((Component)this.jButtonMoveLith).addPreferredGap(0).add((Component)this.jSeparator11, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonFillLstratHierachy).addPreferredGap(0).add((Component)this.jButtonSaveAsLith).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()).add((Component)this.jScrollPane4, -1, 593, Short.MAX_VALUE))));
        this.jTabbedPaneInterpretations.addTab("Lithostratigraphy", this.jPanelLStrat);
        this.jButtonAddSQPick.setText("Add...");
        this.jButtonAddSQPick.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddSQPickActionPerformed(evt);
            }
        });
        this.jButtonEditSQPick.setText("Edit...");
        this.jButtonEditSQPick.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditSQPickActionPerformed(evt);
            }
        });
        this.jButtonDeleteSQPick.setText("Delete");
        this.jButtonDeleteSQPick.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteSQPickActionPerformed(evt);
            }
        });
        this.jButtonSelectAllSQPick.setText("Select all");
        this.jButtonSelectAllSQPick.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllSQPickActionPerformed(evt);
            }
        });
        this.jButtonMoveSQPick.setText("Move...");
        this.jButtonMoveSQPick.setToolTipText("move picks to a different version");
        this.jButtonMoveSQPick.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveSQPickActionPerformed(evt);
            }
        });
        this.jButtonSaveAsSQPick.setText("Save as...");
        this.jButtonSaveAsSQPick.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsSQPick.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsSQPickActionPerformed(evt);
            }
        });
        this.jTableSQPicks.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableSQPicksMouseClicked(evt);
            }
        });
        this.jTableSQPicks.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableSQPicksKeyPressed(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.jTableSQPicks);
        this.jButtonShowSQschemetScheme.setText("Show Scheme...");
        this.jButtonShowSQschemetScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowSQschemetSchemeActionPerformed(evt);
            }
        });
        this.jButtonCopySQPicks.setText("Copy...");
        this.jButtonCopySQPicks.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopySQPicksActionPerformed(evt);
            }
        });
        GroupLayout jPanelSQPickLayout = new GroupLayout((Container)this.jPanelSQPick);
        this.jPanelSQPick.setLayout((LayoutManager)jPanelSQPickLayout);
        jPanelSQPickLayout.setHorizontalGroup((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().add((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((Component)this.jButtonSaveAsSQPick, -2, 85, -2).add((Component)this.jSeparator18, -2, 85, -2).add((Component)this.jSeparator19, -2, 85, -2).add((Component)this.jButtonDeleteSQPick, -2, 85, -2).add((Component)this.jButtonEditSQPick, -2, 85, -2).add((Component)this.jButtonAddSQPick, -2, 85, -2).add((Component)this.jButtonSelectAllSQPick, -2, 85, -2).add((Component)this.jButtonCopySQPicks, -2, 85, -2).add((Component)this.jButtonMoveSQPick, -2, 85, -2)).addPreferredGap(0).add((Component)this.jScrollPane6, -1, 686, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().add((Component)this.jButtonShowSQschemetScheme).addContainerGap()))));
        jPanelSQPickLayout.setVerticalGroup((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().addContainerGap().add((Component)this.jButtonShowSQschemetScheme).addPreferredGap(0).add((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((Component)this.jScrollPane6, -1, 593, Short.MAX_VALUE).add((GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().add((Component)this.jButtonAddSQPick).addPreferredGap(0).add((Component)this.jButtonEditSQPick).addPreferredGap(0).add((Component)this.jButtonDeleteSQPick).addPreferredGap(0).add((Component)this.jSeparator18, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllSQPick).addPreferredGap(0).add((Component)this.jButtonCopySQPicks).addPreferredGap(0).add((Component)this.jButtonMoveSQPick).addPreferredGap(0).add((Component)this.jSeparator19, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSaveAsSQPick).addContainerGap(364, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Sequence Picks", this.jPanelSQPick);
        this.jTableFaults.setModel(this.tableModelFaults);
        this.jTableFaults.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableFaultsMouseClicked(evt);
            }
        });
        this.jTableFaults.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableFaultsKeyPressed(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableFaults);
        this.jButtonAddFault.setText("Add...");
        this.jButtonAddFault.setToolTipText("Create a new disconformity");
        this.jButtonAddFault.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddFaultActionPerformed(evt);
            }
        });
        this.jButtonEditFault.setText("Edit...");
        this.jButtonEditFault.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditFaultActionPerformed(evt);
            }
        });
        this.jButtonDeleteFault.setText("Delete");
        this.jButtonDeleteFault.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteFaultActionPerformed(evt);
            }
        });
        GroupLayout jPanelFaultsLayout = new GroupLayout((Container)this.jPanelFaults);
        this.jPanelFaults.setLayout((LayoutManager)jPanelFaultsLayout);
        jPanelFaultsLayout.setHorizontalGroup((GroupLayout.Group)jPanelFaultsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelFaultsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelFaultsLayout.createParallelGroup(1).add((Component)this.jButtonAddFault).add((Component)this.jButtonEditFault).add((Component)this.jButtonDeleteFault)).addPreferredGap(0).add((Component)this.jScrollPane3, -1, 708, Short.MAX_VALUE)));
        jPanelFaultsLayout.linkSize(new Component[]{this.jButtonAddFault, this.jButtonDeleteFault, this.jButtonEditFault}, 1);
        jPanelFaultsLayout.setVerticalGroup((GroupLayout.Group)jPanelFaultsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelFaultsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelFaultsLayout.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 622, Short.MAX_VALUE).add((GroupLayout.Group)jPanelFaultsLayout.createSequentialGroup().add((Component)this.jButtonAddFault).addPreferredGap(0).add((Component)this.jButtonEditFault).addPreferredGap(0).add((Component)this.jButtonDeleteFault).addContainerGap(541, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Disconformities", this.jPanelFaults);
        this.jTableEnv.setModel(this.tableModelEnv);
        this.jTableEnv.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableEnvMouseClicked(evt);
            }
        });
        this.jTableEnv.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableEnvKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableEnv);
        this.jButtonAddPal.setText("Add...");
        this.jButtonAddPal.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddPalActionPerformed(evt);
            }
        });
        this.jButtonEditPal.setText("Edit...");
        this.jButtonEditPal.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditPalActionPerformed(evt);
            }
        });
        this.jButtonDeletePal.setText("Delete");
        this.jButtonDeletePal.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeletePalActionPerformed(evt);
            }
        });
        this.jButtonSelectAllPal.setText("Select all");
        this.jButtonSelectAllPal.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllPalActionPerformed(evt);
            }
        });
        this.jButtonCopyPal.setText("Copy...");
        this.jButtonCopyPal.setToolTipText("Copy seleced intervals to a different version");
        this.jButtonCopyPal.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyPalActionPerformed(evt);
            }
        });
        this.jButtonMovePal.setText("Move...");
        this.jButtonMovePal.setToolTipText("Move selected intervals to a different version");
        this.jButtonMovePal.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMovePalActionPerformed(evt);
            }
        });
        this.jButtonSaveAsPal.setText("Save as...");
        this.jButtonSaveAsPal.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsPal.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsPalActionPerformed(evt);
            }
        });
        this.jButtonEnvComments.setText("Comments...");
        this.jButtonEnvComments.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonEnvComments.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEnvCommentsActionPerformed(evt);
            }
        });
        this.jButtonIPSBathy.setText("IPS Bathy...");
        this.jButtonIPSBathy.setToolTipText("Enter or read derived palaeobathymetry from the IPS system");
        this.jButtonIPSBathy.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonIPSBathy.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonIPSBathyActionPerformed(evt);
            }
        });
        GroupLayout jPanelEnvLayout = new GroupLayout((Container)this.jPanelEnv);
        this.jPanelEnv.setLayout((LayoutManager)jPanelEnvLayout);
        jPanelEnvLayout.setHorizontalGroup((GroupLayout.Group)jPanelEnvLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEnvLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEnvLayout.createParallelGroup(1, false).add((Component)this.jButtonAddPal, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEnvComments, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAsPal, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator7).add((Component)this.jSeparator6).add((Component)this.jSeparator8).add((Component)this.jButtonIPSBathy, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAllPal, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopyPal, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMovePal, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditPal, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeletePal, -1, -1, Short.MAX_VALUE)).add(15, 15, 15).add((Component)this.jScrollPane1, -1, 679, Short.MAX_VALUE)));
        jPanelEnvLayout.setVerticalGroup((GroupLayout.Group)jPanelEnvLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEnvLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEnvLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 622, Short.MAX_VALUE).add((GroupLayout.Group)jPanelEnvLayout.createSequentialGroup().add((Component)this.jButtonAddPal).addPreferredGap(0).add((Component)this.jButtonEditPal).addPreferredGap(0).add((Component)this.jButtonDeletePal).addPreferredGap(0).add((Component)this.jSeparator6, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllPal).addPreferredGap(0).add((Component)this.jButtonCopyPal).addPreferredGap(0).add((Component)this.jButtonMovePal).addPreferredGap(0).add((Component)this.jSeparator7, -2, 10, -2).add(1, 1, 1).add((Component)this.jButtonSaveAsPal).addPreferredGap(1).add((Component)this.jButtonEnvComments).addPreferredGap(1).add((Component)this.jSeparator8, -2, 11, -2).addPreferredGap(0).add((Component)this.jButtonIPSBathy).addContainerGap(-1, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Palaeoenvironments", this.jPanelEnv);
        this.jTableComments.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableCommentsMouseClicked(evt);
            }
        });
        this.jTableComments.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableCommentsKeyPressed(evt);
            }
        });
        this.jScrollPaneComments.setViewportView(this.jTableComments);
        this.jButtonAddCom.setText("Add...");
        this.jButtonAddCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddComActionPerformed(evt);
            }
        });
        this.jButtonEditCom.setText("Edit...");
        this.jButtonEditCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditComActionPerformed(evt);
            }
        });
        this.jButtonDeleteCom.setText("Delete");
        this.jButtonDeleteCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteComActionPerformed(evt);
            }
        });
        this.jButtonSaveAsCom.setText("Save as...");
        this.jButtonSaveAsCom.setToolTipText("Save the comments as a CSV file, or to copy the text, select the row(s), press Ctrl-C, and Paste into your application");
        this.jButtonSaveAsCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsComActionPerformed(evt);
            }
        });
        this.jButtonCopyCom.setText("Copy...");
        this.jButtonCopyCom.setToolTipText("Copy selected comments to a different version");
        this.jButtonCopyCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyComActionPerformed(evt);
            }
        });
        this.jButtonMoveCom.setText("Move...");
        this.jButtonMoveCom.setToolTipText("Move selected comments to a different version");
        this.jButtonMoveCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveComActionPerformed(evt);
            }
        });
        this.jButtonSelectAllCom.setText("Select all");
        this.jButtonSelectAllCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllComActionPerformed(evt);
            }
        });
        this.jButtonCommentEvents.setText("Events...");
        this.jButtonCommentEvents.setToolTipText("Parse events from selected comments");
        this.jButtonCommentEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCommentEventsActionPerformed(evt);
            }
        });
        this.jButtonEditSelectedCom.setText("Edit selection...");
        this.jButtonEditSelectedCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditSelectedComActionPerformed(evt);
            }
        });
        GroupLayout jPanelCommentsLayout = new GroupLayout((Container)this.jPanelComments);
        this.jPanelComments.setLayout((LayoutManager)jPanelCommentsLayout);
        jPanelCommentsLayout.setHorizontalGroup((GroupLayout.Group)jPanelCommentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelCommentsLayout.createParallelGroup(1, false).add((Component)this.jSeparator2).add((Component)this.jSeparator3).add((Component)this.jButtonSaveAsCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAllCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopyCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCommentEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditSelectedCom, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jScrollPaneComments, -1, 699, Short.MAX_VALUE)));
        jPanelCommentsLayout.setVerticalGroup((GroupLayout.Group)jPanelCommentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelCommentsLayout.createParallelGroup(1).add((Component)this.jScrollPaneComments, -1, 622, Short.MAX_VALUE).add((GroupLayout.Group)jPanelCommentsLayout.createSequentialGroup().add((Component)this.jButtonAddCom).addPreferredGap(0).add((Component)this.jButtonEditCom).addPreferredGap(0).add((Component)this.jButtonDeleteCom).addPreferredGap(0).add((Component)this.jButtonEditSelectedCom).addPreferredGap(0).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllCom).addPreferredGap(0).add((Component)this.jButtonCopyCom, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMoveCom).addPreferredGap(0).add((Component)this.jSeparator3, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSaveAsCom).addPreferredGap(0).add((Component)this.jButtonCommentEvents).addContainerGap(-1, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Bio. Comments", this.jPanelComments);
        this.jTableIntComments.setModel(this.tableModelIntervalComments);
        this.jTableIntComments.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableIntCommentsMouseClicked(evt);
            }
        });
        this.jTableIntComments.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableIntCommentsKeyPressed(evt);
            }
        });
        this.jScrollPaneIntComments.setViewportView(this.jTableIntComments);
        this.jButtonAddIntCom.setText("Add...");
        this.jButtonAddIntCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddIntComActionPerformed(evt);
            }
        });
        this.jButtonEditIntCom.setText("Edit...");
        this.jButtonEditIntCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditIntComActionPerformed(evt);
            }
        });
        this.jButtonDeleteIntCom.setText("Delete");
        this.jButtonDeleteIntCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteIntComActionPerformed(evt);
            }
        });
        this.jButtonSaveAsIntCom.setText("Save as...");
        this.jButtonSaveAsIntCom.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsIntCom.setEnabled(false);
        this.jButtonCopyIntCom.setText("Copy...");
        this.jButtonCopyIntCom.setToolTipText("Copy selected comments to another version");
        this.jButtonCopyIntCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyIntComActionPerformed(evt);
            }
        });
        this.jButtonMoveIntCom.setText("Move...");
        this.jButtonMoveIntCom.setToolTipText("Move interval comments to a different version");
        this.jButtonMoveIntCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveIntComActionPerformed(evt);
            }
        });
        this.jButtonSelectAllIntCom.setText("Select all");
        this.jButtonSelectAllIntCom.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllIntComActionPerformed(evt);
            }
        });
        GroupLayout jPanelIntCommentsLayout = new GroupLayout((Container)this.jPanelIntComments);
        this.jPanelIntComments.setLayout((LayoutManager)jPanelIntCommentsLayout);
        jPanelIntCommentsLayout.setHorizontalGroup((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelIntCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1, false).add((Component)this.jSeparator16).add((Component)this.jButtonSaveAsIntCom, -2, 0, Short.MAX_VALUE).add((Component)this.jButtonEditIntCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteIntCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddIntCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAllIntCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopyIntCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveIntCom, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jScrollPaneIntComments, -1, 696, Short.MAX_VALUE)));
        jPanelIntCommentsLayout.setVerticalGroup((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelIntCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add((Component)this.jScrollPaneIntComments, -1, 622, Short.MAX_VALUE).add((GroupLayout.Group)jPanelIntCommentsLayout.createSequentialGroup().add((Component)this.jButtonAddIntCom).addPreferredGap(0).add((Component)this.jButtonEditIntCom).addPreferredGap(0).add((Component)this.jButtonDeleteIntCom).addPreferredGap(0).add((Component)this.jSeparator16, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllIntCom).addPreferredGap(0).add((Component)this.jButtonCopyIntCom, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMoveIntCom).add(22, 22, 22).add((Component)this.jButtonSaveAsIntCom).addContainerGap(-1, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Interval Comments", this.jPanelIntComments);
        this.jTableEvents.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableEventsMouseClicked(evt);
            }
        });
        this.jTableEvents.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableEventsKeyPressed(evt);
            }
        });
        this.jScrollPaneEventsTable.setViewportView(this.jTableEvents);
        this.jButtonAddEvent.setText("Add...");
        this.jButtonAddEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddEventActionPerformed(evt);
            }
        });
        this.jButtonDeleteEvent.setText("Delete");
        this.jButtonDeleteEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteEventActionPerformed(evt);
            }
        });
        this.jButtonGenerateEvents.setText("Generate...");
        this.jButtonGenerateEvents.setToolTipText("Generate events from occurrences");
        this.jButtonGenerateEvents.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonGenerateEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGenerateEventsActionPerformed(evt);
            }
        });
        this.jButtonSelectAllEvents.setText("Select all");
        this.jButtonSelectAllEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllEventsActionPerformed(evt);
            }
        });
        this.jButtonMoveEvents.setText("Move...");
        this.jButtonMoveEvents.setToolTipText("Move selected events to a different version");
        this.jButtonMoveEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveEventsActionPerformed(evt);
            }
        });
        this.jButtonCopyEvents.setText("Copy...");
        this.jButtonCopyEvents.setToolTipText("Copy selected events to a different version");
        this.jButtonCopyEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyEventsActionPerformed(evt);
            }
        });
        this.jButtonEditEvent.setText("Edit...");
        this.jButtonEditEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditEventActionPerformed(evt);
            }
        });
        this.jButtonCreateComposite.setText("Composite...");
        this.jButtonCreateComposite.setToolTipText("<html>Create a new composite standard<br>based on this list of events</html>");
        this.jButtonCreateComposite.setMargin(new Insets(2, 6, 2, 6));
        this.jButtonCreateComposite.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCreateCompositeActionPerformed(evt);
            }
        });
        this.jButtonEventComments.setText("Comments...");
        this.jButtonEventComments.setToolTipText("Create biostratigraphic comments from selected events");
        this.jButtonEventComments.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonEventComments.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEventCommentsActionPerformed(evt);
            }
        });
        this.jButtonEventTxGroup.setText("Group...");
        this.jButtonEventTxGroup.setToolTipText("Add taxa from selected events to new or existing taxon group");
        this.jButtonEventTxGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEventTxGroupActionPerformed(evt);
            }
        });
        this.jButtonEventDepthError.setText("Error +/-...");
        this.jButtonEventDepthError.setToolTipText("Set depth errors for selected events");
        this.jButtonEventDepthError.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEventDepthErrorActionPerformed(evt);
            }
        });
        GroupLayout jPanelEventsLayout = new GroupLayout((Container)this.jPanelEvents);
        this.jPanelEvents.setLayout((LayoutManager)jPanelEventsLayout);
        jPanelEventsLayout.setHorizontalGroup((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1, false).add((Component)this.jButtonGenerateEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator14).add((Component)this.jSeparator15).add((Component)this.jButtonCreateComposite, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEventComments, -2, 89, Short.MAX_VALUE).add((Component)this.jButtonMoveEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopyEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAllEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteEvent, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditEvent, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddEvent, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEventTxGroup, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEventDepthError, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jScrollPaneEventsTable, -1, 682, Short.MAX_VALUE)));
        jPanelEventsLayout.linkSize(new Component[]{this.jButtonCreateComposite, this.jButtonEventComments}, 1);
        jPanelEventsLayout.setVerticalGroup((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((Component)this.jScrollPaneEventsTable, -1, 622, Short.MAX_VALUE).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().add((Component)this.jButtonGenerateEvents).addPreferredGap(0).add((Component)this.jButtonAddEvent).addPreferredGap(0).add((Component)this.jButtonEditEvent).addPreferredGap(0).add((Component)this.jButtonDeleteEvent).addPreferredGap(0).add((Component)this.jSeparator14, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllEvents).addPreferredGap(0).add((Component)this.jButtonCopyEvents).addPreferredGap(0).add((Component)this.jButtonMoveEvents).addPreferredGap(0).add((Component)this.jSeparator15, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonCreateComposite).addPreferredGap(0).add((Component)this.jButtonEventComments).addPreferredGap(0).add((Component)this.jButtonEventTxGroup).addPreferredGap(1).add((Component)this.jButtonEventDepthError).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanelEventsLayout.linkSize(new Component[]{this.jButtonAddEvent, this.jButtonDeleteEvent, this.jButtonEditEvent, this.jButtonGenerateEvents}, 2);
        jPanelEventsLayout.linkSize(new Component[]{this.jButtonCopyEvents, this.jButtonMoveEvents, this.jButtonSelectAllEvents}, 2);
        jPanelEventsLayout.linkSize(new Component[]{this.jButtonCreateComposite, this.jButtonEventComments}, 2);
        this.jTabbedPaneInterpretations.addTab("Events", this.jPanelEvents);
        this.jTableLOC.setModel(this.tableModelLOC);
        this.jTableLOC.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableLOCKeyPressed(evt);
            }
        });
        this.jScrollPaneLOC.setViewportView(this.jTableLOC);
        this.jButtonAddLOC.setText("Add");
        this.jButtonAddLOC.setToolTipText("Add new node");
        this.jButtonAddLOC.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddLOCActionPerformed(evt);
            }
        });
        this.jButtonDeleteLOC.setText("Delete");
        this.jButtonDeleteLOC.setToolTipText("Delete selected node");
        this.jButtonDeleteLOC.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteLOCActionPerformed(evt);
            }
        });
        this.jButtonSaveAsLOC.setText("Save as...");
        this.jButtonSaveAsLOC.setToolTipText("Write depth/age curve to .las file");
        this.jButtonSaveAsLOC.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSaveAsLOC.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsLOCActionPerformed(evt);
            }
        });
        this.jButtonCopyLOC.setText("Copy...");
        this.jButtonCopyLOC.setToolTipText("Copy depth/age node(s) to a different version");
        this.jButtonCopyLOC.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyLOCActionPerformed(evt);
            }
        });
        this.jButtonMoveLOC.setText("Move...");
        this.jButtonMoveLOC.setToolTipText("Move depth/age node(s)  to a different version");
        this.jButtonMoveLOC.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveLOCActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Line colour:");
        this.jTextFieldLOCColour.setEditable(false);
        this.jTextFieldLOCColour.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTextFieldLOCColourMouseClicked(evt);
            }
        });
        this.jButtonCreateSamples.setText("Create samples...");
        this.jButtonCreateSamples.setToolTipText("Create LOG samples at node depths");
        this.jButtonCreateSamples.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCreateSamples.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCreateSamplesActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Display:", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupAgeDisplay.add(this.jRadioButtonAgeFormatMA);
        this.jRadioButtonAgeFormatMA.setText("Ma");
        this.jRadioButtonAgeFormatMA.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonAgeFormatMAActionPerformed(evt);
            }
        });
        this.buttonGroupAgeDisplay.add(this.jRadioButtonAgeFormatKa);
        this.jRadioButtonAgeFormatKa.setText("Ka");
        this.jRadioButtonAgeFormatKa.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonAgeFormatKaActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonAgeFormatMA).add((Component)this.jRadioButtonAgeFormatKa)).addContainerGap(50, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonAgeFormatMA).addPreferredGap(0).add((Component)this.jRadioButtonAgeFormatKa)));
        this.jLabelLOCAudit.setForeground(new Color(153, 153, 153));
        this.jLabelLOCAudit.setText("Created by: on:; Modified by: on:");
        this.jButtonLOCComment.setText("Comment...");
        this.jButtonLOCComment.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLOCCommentActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Line weight:");
        this.jLabelLOCWeight.setText("1");
        this.jButtonLOCWeight.setText("...");
        this.jButtonLOCWeight.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonLOCWeight.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLOCWeightActionPerformed(evt);
            }
        });
        this.jButtonMoveToSample.setText("Snap to sample");
        this.jButtonMoveToSample.setToolTipText("Move selected nodes to nearest Sample");
        this.jButtonMoveToSample.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveToSampleActionPerformed(evt);
            }
        });
        this.jButtonSnapToEvent.setText("Snap to event...");
        this.jButtonSnapToEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSnapToEventActionPerformed(evt);
            }
        });
        this.jButtonReadLOC.setText("Read...");
        this.jButtonReadLOC.setToolTipText("Read depth/age from text file");
        this.jButtonReadLOC.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonReadLOC.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadLOCActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllActionPerformed(evt);
            }
        });
        GroupLayout jPanelLOCLayout = new GroupLayout((Container)this.jPanelLOC);
        this.jPanelLOC.setLayout((LayoutManager)jPanelLOCLayout);
        jPanelLOCLayout.setHorizontalGroup((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((Component)this.jButtonAddLOC, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteLOC, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAll, -2, 110, -2).add((Component)this.jSeparator17).add((Component)this.jButtonCopyLOC, -2, 143, -2).add((Component)this.jButtonMoveLOC, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAsLOC, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonReadLOC, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCreateSamples, -2, 0, Short.MAX_VALUE).add((Component)this.jButtonLOCComment, -1, 140, Short.MAX_VALUE).add((Component)this.jButtonMoveToSample, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSnapToEvent, -1, -1, Short.MAX_VALUE)).add(7, 7, 7).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((Component)this.jLabelLOCAudit).add((Component)this.jScrollPaneLOC, -1, 665, Short.MAX_VALUE))).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel10)).addPreferredGap(0).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1, false).add((Component)this.jTextFieldLOCColour, -2, 43, -2).add(2, (GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().add((Component)this.jLabelLOCWeight, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonLOCWeight, -2, 30, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelLOCLayout.linkSize(new Component[]{this.jButtonAddLOC, this.jButtonCopyLOC, this.jButtonCreateSamples, this.jButtonDeleteLOC, this.jButtonLOCComment, this.jButtonMoveLOC, this.jButtonMoveToSample, this.jButtonReadLOC, this.jButtonSaveAsLOC, this.jButtonSelectAll, this.jButtonSnapToEvent, this.jSeparator17}, 1);
        jPanelLOCLayout.setVerticalGroup((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().add((Component)this.jButtonAddLOC).addPreferredGap(0).add((Component)this.jButtonDeleteLOC).addPreferredGap(1).add((Component)this.jSeparator17, -2, -1, -2).addPreferredGap(1).add((Component)this.jButtonSelectAll, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonCopyLOC, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMoveLOC).addPreferredGap(0).add((Component)this.jButtonSaveAsLOC).addPreferredGap(0).add((Component)this.jButtonReadLOC).add(34, 34, 34).add((Component)this.jButtonCreateSamples).addPreferredGap(0).add((Component)this.jButtonLOCComment).addPreferredGap(0).add((Component)this.jButtonMoveToSample).addPreferredGap(0).add((Component)this.jButtonSnapToEvent).addPreferredGap(0, 107, Short.MAX_VALUE).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(3).add((Component)this.jTextFieldLOCColour, -2, -1, -2).add((Component)this.jLabel10)).addPreferredGap(0).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabelLOCWeight).add((Component)this.jButtonLOCWeight))).add((Component)this.jScrollPaneLOC)).add((Component)this.jLabelLOCAudit).addContainerGap()));
        jPanelLOCLayout.linkSize(new Component[]{this.jButtonReadLOC, this.jButtonSaveAsLOC}, 2);
        this.jTabbedPaneInterpretations.addTab("Depth/Age Curve", this.jPanelLOC);
        this.jTabbedPaneInterpretations.addTab("Sample Age", this.panelInterpSampleAge);
        this.jButtonIGDHdrs.setText("Notes...");
        this.jButtonIGDHdrs.setToolTipText("Notes on use of schemes within interpretations");
        this.jButtonIGDHdrs.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonIGDHdrsActionPerformed(evt);
            }
        });
        this.jButtonMoveInterp.setText("Move data to...");
        this.jButtonMoveInterp.setToolTipText("Move/publish all data from this interpretation");
        this.jButtonMoveInterp.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelWellInterp this$0;
            {
                JPanelWellInterp jPanelWellInterp = this$0;
                Objects.requireNonNull(jPanelWellInterp);
                this.this$0 = jPanelWellInterp;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveInterpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jComboBoxVersion, -2, 195, -2).addPreferredGap(0).add((Component)this.jButtonVersionSelect, -2, 30, -2).addPreferredGap(0).add((Component)this.jButtonIGDHdrs).addPreferredGap(0).add((Component)this.jButtonMoveInterp).addContainerGap(-1, Short.MAX_VALUE)).add(2, (Component)this.jTabbedPaneInterpretations));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxVersion, -2, -1, -2).add((Component)this.jButtonVersionSelect).add((Component)this.jButtonIGDHdrs).add((Component)this.jButtonMoveInterp)).addPreferredGap(0).add((Component)this.jTabbedPaneInterpretations)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void versionChanged() {
        if (this.jComboBoxVersion.getSelectedItem() == null || this.jComboBoxVersion.getSelectedItem().toString().equals(SELECT_STRING)) {
            return;
        }
        WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            IGDScheme.MissingSchemeException missingSchemeException = null;
            try {
                this.well.loadInterp(wellInterp);
            }
            catch (IGDScheme.MissingSchemeException e) {
                missingSchemeException = e;
            }
            try {
                this.well.getInterp(wellInterp.getInterpId());
            }
            catch (SBException e) {
                this.jComboBoxVersion.setSelectedIndex(0);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            wellInterp.getIGDSchemes(3);
            this.tableModelChrono.setZones(wellInterp.getIGDList(3, 0), this.well);
            this.tableModelChrono.fireTableDataChanged();
            wellInterp.getIGDSchemes(2);
            this.tableModelLstrat.setZones(wellInterp.getIGDList(2, 0), this.well);
            this.tableModelLstrat.fireTableDataChanged();
            wellInterp.getIGDSchemes(4);
            this.tableModelBiozones.setZones(wellInterp.getIGDList(4, 0), this.well);
            this.tableModelBiozones.fireTableDataChanged();
            this.tableModelBiocom.setBioComments(wellInterp.getComments(), this.well);
            this.tableModelBiocom.fireTableDataChanged();
            this.tableModelIntervalComments.comments = wellInterp.getIntcoms();
            this.tableModelIntervalComments.fireTableDataChanged();
            this.tableModelEnv.envs = wellInterp.getEnvs();
            this.tableModelEnv.fireTableDataChanged();
            this.tableModelEvents.setEvents(wellInterp.getEvents(), this.well);
            this.tableModelEvents.fireTableDataChanged();
            this.tableModelSQPicks.setItems(wellInterp.getInterpListViewer(21), this.well);
            this.tableModelSQPicks.fireTableDataChanged();
            this.tableModelFaults.setItems(wellInterp.getInterpListViewer(24));
            this.tableModelFaults.fireTableDataChanged();
            this.panelInterpSampleAge.setInterpretationId(wellInterp.getHeader().getInterpID());
            AgeFormat af = this.tableModelLOC.setLOC(wellInterp, this.jTableLOC, this.well.getWellID(), this.well);
            this.setAgeFormatButton(af);
            this.tableModelLOC.fireTableDataChanged();
            if (wellInterp.getLOC() != null) {
                wellInterp.getLOC().addWeakObserver(this);
                this.jLabelLOCAudit.setText(wellInterp.getLOC().getAudit().toString(this.sbdb, true));
            } else {
                this.jLabelLOCAudit.setText("");
            }
            if (this.tableModelLOC.getLOC() != null) {
                this.jTextFieldLOCColour.setBackground(this.tableModelLOC.getLOC().getColour());
                this.jLabelLOCWeight.setText("" + this.tableModelLOC.getLOC().getLineWidth());
            }
            Iterator<IGDScheme> it = wellInterp.getIGDSchemes(4).iterator();
            this.jComboBoxSchemeBio.removeAllItems();
            while (it.hasNext()) {
                this.jComboBoxSchemeBio.addItem(it.next());
            }
            this.jComboBoxSchemeBio.repaint();
            wellInterp.addObserver(this);
            wellInterp.addObserver(this.parentPanel);
            this.parentPanel.setVersion(wellInterp, this);
            if (this.jComboBoxVersion.getItemAt(0).toString().equals(SELECT_STRING)) {
                this.jComboBoxVersion.removeItemAt(0);
                this.jComboBoxVersion.repaint();
            }
            if (missingSchemeException != null) {
                JOptionPane.showMessageDialog(this.parentPanel, "Version not fully loaded because one or more dependent schemes are hidden or missing.\nLast error was: " + missingSchemeException.getMessage(), "Version", 2);
            }
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonVersionSelectActionPerformed(ActionEvent evt) {
        List<Well> list = Arrays.asList(this.well);
        try {
            DialogSelectVersion dialog = new DialogSelectVersion((Frame)this.parentFrame, true, this.sbdb, list);
            dialog.setLocation(this.jButtonVersionSelect.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.selection != null) {
                WellInterp wellInterp = this.well.getAddInterp(dialog.selection.get(0));
                this.well.fillInterpCombo(this.jComboBoxVersion);
                this.parentPanel.fillChartInterpCombo(wellInterp);
                this.jComboBoxVersion.setSelectedItem(wellInterp);
            }
        }
        catch (SQLException sqlex) {
            FrameJsbugs.showStackError(null, sqlex, this.sbdb);
        }
    }

    private void jTableBiozonesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditBioActionPerformed(null);
        }
    }

    private void jButtonAddBioActionPerformed(ActionEvent evt) {
        IGDScheme scheme = (IGDScheme)this.jComboBoxSchemeBio.getSelectedItem();
        this.addZone(4, null, scheme);
    }

    private void jButtonEditBioActionPerformed(ActionEvent evt) {
        if (this.jTableBiozones.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one interval to edit", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDIntervalZone zone = this.tableModelBiozones.getZones().get(this.jTableBiozones.convertRowIndexToModel(this.jTableBiozones.getSelectedRow()));
        this.editZone(zone);
    }

    private void jButtonDeleteBioActionPerformed(ActionEvent evt) {
        this.deleteZones(this.jTableBiozones, this.tableModelBiozones);
    }

    private void jButtonSelectAllBioActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableBiozones);
    }

    private void jComboBoxSchemeBioActionPerformed(ActionEvent evt) {
        if (this.jComboBoxVersion.getSelectedItem().getClass() == WellInterp.class) {
            WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
            int schemeID = 0;
            try {
                IGDScheme scheme = (IGDScheme)this.jComboBoxSchemeBio.getSelectedItem();
                schemeID = scheme.getID();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tableModelBiozones.setZones(wellInterp.getIGDList(4, schemeID), this.well);
            this.tableModelBiozones.fireTableDataChanged();
        }
    }

    private void jButtonAddChronoActionPerformed(ActionEvent evt) {
        this.addZone(3, null, null);
    }

    private void jButtonEditChronoActionPerformed(ActionEvent evt) {
        if (this.jTableChrono.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one interval to edit", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDIntervalZone zone = this.tableModelChrono.getZones().get(this.jTableChrono.convertRowIndexToModel(this.jTableChrono.getSelectedRow()));
        this.editZone(zone);
    }

    private void jButtonDeleteChronoActionPerformed(ActionEvent evt) {
        this.deleteZones(this.jTableChrono, this.tableModelChrono);
    }

    private void jButtonSelectAllChronoActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableChrono);
    }

    private void jTableChronoMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditChronoActionPerformed(null);
        }
    }

    private void jButtonAddLithActionPerformed(ActionEvent evt) {
        this.addZone(2, null, null);
    }

    private void jButtonEditLithActionPerformed(ActionEvent evt) {
        if (this.jTableLStrat.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one interval to edit", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDIntervalZone zone = this.tableModelLstrat.getZones().get(this.jTableLStrat.convertRowIndexToModel(this.jTableLStrat.getSelectedRow()));
        this.editZone(zone);
    }

    private void jButtonDeleteLithActionPerformed(ActionEvent evt) {
        this.deleteZones(this.jTableLStrat, this.tableModelLstrat);
    }

    private void jButtonSelectAllLithActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableLStrat);
    }

    private void jTableLStratMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditLithActionPerformed(null);
        }
    }

    private void jButtonAddSQPickActionPerformed(ActionEvent evt) {
        this.addSQPick(null);
    }

    private void jButtonEditSQPickActionPerformed(ActionEvent evt) {
        int nRows = this.jTableSQPicks.getSelectedRowCount();
        if (nRows != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one pick from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
        SQPick pick = (SQPick)this.tableModelSQPicks.getItems().get(this.jTableSQPicks.convertRowIndexToModel(this.jTableSQPicks.getSelectedRow()));
        try {
            DialogSQPick dialog = new DialogSQPick(this.parentFrame, true, this.sbdb, null, this.well, wellInterp, this.units, pick, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showDialogStackError(sql, this.parentFrame);
        }
    }

    private void jButtonDeleteSQPickActionPerformed(ActionEvent evt) {
        int nRows = this.jTableSQPicks.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one or more picks from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        Object msg = "Really delete ";
        msg = nRows == 1 ? (String)msg + "this pick?" : (String)msg + "these " + nRows + " picks?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        WellInterp wellInterp = this.getInterp();
        LinkedList<SQPick> toKill = new LinkedList<SQPick>();
        for (int row : this.jTableSQPicks.getSelectedRows()) {
            toKill.add((SQPick)this.tableModelSQPicks.getItems().get(this.jTableSQPicks.convertRowIndexToModel(row)));
        }
        try {
            wellInterp.delete(toKill, this.well.getWellID());
            this.sbdb.commit();
            this.jTableSQPicks.clearSelection();
            wellInterp.notifyObservers(21);
        }
        catch (SQLException | SBException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonSelectAllSQPickActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableSQPicks);
    }

    private void jTableSQPicksMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditSQPickActionPerformed(null);
        }
    }

    private void jTableEventsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditEventActionPerformed(null);
        }
    }

    private void jButtonAddEventActionPerformed(ActionEvent evt) {
        this.addEvent(null, null);
    }

    private void jButtonDeleteEventActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one or more event from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        Object msg = "Really delete ";
        msg = nRows == 1 ? (String)msg + "this event?" : (String)msg + "these " + nRows + " events?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<WellEvent> toKill = new LinkedList<WellEvent>();
        for (int row : this.jTableEvents.getSelectedRows()) {
            toKill.add(this.tableModelEvents.events.get(this.jTableEvents.convertRowIndexToModel(row)));
        }
        try {
            wellInterp.deleteEvents(toKill, this.well.getWellID());
            this.sbdb.commit();
            this.jTableEvents.clearSelection();
            this.tableModelEvents.fireTableDataChanged();
            wellInterp.notifyObservers(20);
        }
        catch (SBException ex) {
            FrameJsbugs.showStackError("Error deleting events", (Exception)((Object)ex), this.sbdb);
        }
        catch (SQLException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error deleting events", ex, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonGenerateEventsActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogGenerateEvent dialog = new DialogGenerateEvent(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units);
            dialog.setLocationRelativeTo(this.jButtonGenerateEvents);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
        catch (SBException e) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)e);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSelectAllEventsActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableEvents);
    }

    private void jButtonEditEventActionPerformed(ActionEvent evt) {
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one event from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getInterp();
        WellEvent wellEvent = this.tableModelEvents.events.get(this.jTableEvents.convertRowIndexToModel(this.jTableEvents.getSelectedRow()));
        try {
            DialogWellEvent dialog = new DialogWellEvent(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, wellEvent, null, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
    }

    private void jTableEnvMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditPalActionPerformed(null);
        }
    }

    private void jButtonAddPalActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            Sample topSample = this.parentPanel.getSelectedTopSample();
            Sample baseSample = this.parentPanel.getSelectedBaseSample();
            DialogEnv dialog = new DialogEnv(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, null, topSample, baseSample);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonEditPalActionPerformed(ActionEvent evt) {
        if (this.jTableEnv.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one interval to edit", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDIntervalEnv zone = this.tableModelEnv.envs.get(this.jTableEnv.convertRowIndexToModel(this.jTableEnv.getSelectedRow()));
        try {
            WellInterp wellInterp = this.getInterp();
            DialogEnv dialog = new DialogEnv(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, zone, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonDeletePalActionPerformed(ActionEvent evt) {
        int nRows = this.jTableEnv.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select interval(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        Object msg = "Really delete ";
        msg = nRows == 1 ? (String)msg + "this interval?" : (String)msg + "these " + nRows + " intervals?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<IGDIntervalEnv> toKill = new LinkedList<IGDIntervalEnv>();
        for (int row : this.jTableEnv.getSelectedRows()) {
            toKill.add(this.tableModelEnv.envs.get(this.jTableEnv.convertRowIndexToModel(row)));
        }
        try {
            wellInterp.deleteEnvs(toKill, this.well.getWellID());
            this.sbdb.commit();
            this.jTableEnv.clearSelection();
            wellInterp.notifyObservers(5);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            this.sbdb.doRollback();
            SbugsExceptionHandler.showStackError("Error deleting environment intervals", ex, this.parentFrame);
        }
    }

    private void jButtonSelectAllPalActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableEnv);
    }

    private void jTableCommentsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditComActionPerformed(null);
        }
    }

    private void jButtonAddComActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            Sample topSample = this.parentPanel.getSelectedTopSample();
            Sample baseSample = this.parentPanel.getSelectedBaseSample();
            DialogBiocom dialog = new DialogBiocom(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, null, topSample, baseSample);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.parentPanel.clearSampleSelection();
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)sbe);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sqle, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonEditComActionPerformed(ActionEvent evt) {
        int nRows = this.jTableComments.getSelectedRowCount();
        if (nRows != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one comment from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            Biocom biocom = this.tableModelBiocom.comments.get(this.jTableComments.convertRowIndexToModel(this.jTableComments.getSelectedRow()));
            WellInterp wellInterp = this.getInterp();
            DialogBiocom dialog = new DialogBiocom(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, biocom, null, null);
            dialog.setLocation(this.jButtonEditCom.getLocationOnScreen());
            dialog.setVisible(true);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonDeleteComActionPerformed(ActionEvent evt) {
        int nRows = this.jTableComments.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select comment(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        Object msg = "Really delete ";
        msg = nRows == 1 ? (String)msg + "this comment?" : (String)msg + "these " + nRows + " comments?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<Biocom> toKill = new LinkedList<Biocom>();
        for (int row : this.jTableComments.getSelectedRows()) {
            toKill.add(this.tableModelBiocom.comments.get(this.jTableComments.convertRowIndexToModel(row)));
        }
        try {
            wellInterp.deleteBiocoms(toKill, this.well.getWellID());
            this.sbdb.commit();
            this.jTableComments.clearSelection();
            wellInterp.notifyObservers(19);
        }
        catch (SQLException | SBException ex) {
            FrameJsbugs.showStackError("Error deleting biostrat comments", (Exception)ex, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonSelectAllComActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableComments);
    }

    private void jTableIntCommentsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditIntComActionPerformed(null);
        }
    }

    private void jButtonAddIntComActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            DialogIntervalComment dialog = new DialogIntervalComment(this.parentFrame, true, this.sbdb, this.well, wellInterp, null, this.units, 0);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
    }

    private WellInterp getSelectedVersion() {
        Object o = this.jComboBoxVersion.getSelectedItem();
        if (o != null && o instanceof WellInterp) {
            return (WellInterp)o;
        }
        JOptionPane.showMessageDialog(this, "Select a version", this.parentFrame.getTitle(), 2);
        return null;
    }

    private void jButtonEditIntComActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        Intcom intcom = this.tableModelIntervalComments.comments.get(this.jTableIntComments.convertRowIndexToModel(this.jTableIntComments.getSelectedRow()));
        try {
            DialogIntervalComment dialog = new DialogIntervalComment(this.parentFrame, true, this.sbdb, this.well, wellInterp, intcom, this.units, 0);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
    }

    private void jButtonDeleteIntComActionPerformed(ActionEvent evt) {
        int nRows = this.jTableIntComments.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select comment(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        Object msg = "Really delete ";
        msg = nRows == 1 ? (String)msg + "this comment?" : (String)msg + "these " + nRows + " comments?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
        LinkedList<Intcom> toKill = new LinkedList<Intcom>();
        for (int row : this.jTableIntComments.getSelectedRows()) {
            toKill.add(this.tableModelIntervalComments.comments.get(this.jTableIntComments.convertRowIndexToModel(row)));
        }
        try {
            wellInterp.deleteIntcoms(this.well.getWellID(), toKill);
            this.sbdb.commit();
            this.jTableIntComments.clearSelection();
            wellInterp.notifyObservers(22);
        }
        catch (SQLException | SBException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error deleting interval comment", (Exception)ex, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonSelectAllIntComActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableIntComments);
    }

    private void jButtonAddLOCActionPerformed(ActionEvent evt) {
        if (this.tableModelLOC.getLOC() == null) {
            JOptionPane.showMessageDialog(this, "No depth/age curve defined! Use a depth/age panel to define a new curve.", this.parentFrame.getTitle(), 1);
            return;
        }
        DialogLOCnode dialog = new DialogLOCnode(this.parentFrame, true, this.units, this.well, this.getInterp(), this.tableModelLOC.getAgeFormat());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.tableModelLOC.fireTableDataChanged();
    }

    private void jButtonDeleteLOCActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null || this.tableModelLOC.getLOC() == null) {
            return;
        }
        int nRows = this.jTableLOC.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select node(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            if (this.tableModelLOC.getRowCount() == nRows) {
                if (JOptionPane.showConfirmDialog(this.parentFrame, "Delete this Depth/Age curve?", this.parentFrame.getTitle(), 0, 3) != 0) {
                    return;
                }
                wellInterp.deleteLOC(this.well.getWellID());
                this.sbdb.commit();
                AgeFormat af = this.tableModelLOC.setLOC(wellInterp, this.jTableLOC, this.well.getWellID(), this.well);
                this.setAgeFormatButton(af);
            } else {
                if (this.tableModelLOC.getRowCount() - nRows < 2) {
                    JOptionPane.showMessageDialog(this.parentFrame, "You must leave at least 2 nodes.", this.parentFrame.getTitle(), 2);
                    return;
                }
                Object msg = "Really delete ";
                msg = nRows == 1 ? (String)msg + "this node?" : (String)msg + "these " + nRows + " nodes?";
                if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
                    return;
                }
                LinkedList<LOCNode> toKill = new LinkedList<LOCNode>();
                for (int row : this.jTableLOC.getSelectedRows()) {
                    toKill.add(this.tableModelLOC.getLOC().getNode(row));
                }
                Object object = toKill.iterator();
                while (object.hasNext()) {
                    LOCNode locNode = (LOCNode)object.next();
                    try {
                        wellInterp.deleteLOCNode(locNode, this.well.getWellID());
                    }
                    catch (InvalidFieldException ife) {
                        JOptionPane.showMessageDialog(this, ife.getMessage(), "Delete LOC nodes", 2);
                    }
                }
                wellInterp.notifyObservers((Object)wellInterp.getLOC());
            }
            this.jTableLOC.clearSelection();
            wellInterp.notifyObservers(23);
            this.tableModelLOC.fireTableDataChanged();
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jTextFieldLOCColourMouseClicked(MouseEvent evt) {
        Color locColour;
        if (this.tableModelLOC.getLOC() != null && evt.getClickCount() > 1 && (locColour = JColorChooser.showDialog(this.parentFrame, "Select Depth/Age Curve Colour", this.jTextFieldLOCColour.getBackground())) != null) {
            try {
                this.tableModelLOC.getLOC().setColour(locColour, this.well.getWellID(), this.getInterp().getHeader().getInterpID());
                this.jTextFieldLOCColour.setBackground(locColour);
                this.sbdb.commit();
            }
            catch (SQLException sqle) {
                FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
            }
        }
    }

    private void jButtonMoveChronoActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableChrono, this.tableModelChrono, true);
    }

    private void jButtonMoveBioActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableBiozones, this.tableModelBiozones, true);
    }

    private void jButtonMoveLithActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableLStrat, this.tableModelLstrat, true);
    }

    private void jButtonMoveSQPickActionPerformed(ActionEvent evt) {
        this.copySQPicks(true);
    }

    private void jButtonMoveEventsActionPerformed(ActionEvent evt) {
        this.copyEvents(true);
    }

    private void jButtonChronoColmapActionPerformed(ActionEvent evt) {
        this.showColMap(3);
    }

    private void jButtonBioColmapActionPerformed(ActionEvent evt) {
        this.showColMap(4);
    }

    private void jButtonLstratColmapActionPerformed(ActionEvent evt) {
        this.showColMap(2);
    }

    private void jButtonCreateCompositeActionPerformed(ActionEvent evt) {
        if (this.tableModelEvents.events.isEmpty()) {
            JOptionPane.showMessageDialog(this.parentFrame, "No events in list. Composite not created.", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            DialogCmpStd dialog = new DialogCmpStd(this.parentFrame, true, this.sbdb, null);
            dialog.loadWellEvents(this.getInterp());
            dialog.setLocationRelativeTo(this.parentFrame);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error opening composite standard dialog", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error opening composite standard dialog", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonCopyLOCActionPerformed(ActionEvent evt) {
        this.copyLOC(false);
    }

    private void jButtonMoveLOCActionPerformed(ActionEvent evt) {
        this.copyLOC(true);
    }

    private void jTableChronoKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteChronoActionPerformed(null);
        }
    }

    private void jTableBiozonesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteBioActionPerformed(null);
        }
    }

    private void jTableLStratKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteLithActionPerformed(null);
        }
    }

    private void jTableSQPicksKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteSQPickActionPerformed(null);
        }
    }

    private void jTableEventsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteEventActionPerformed(null);
        }
    }

    private void jTableEnvKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeletePalActionPerformed(null);
        }
    }

    private void jTableCommentsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteComActionPerformed(null);
        }
    }

    private void jTableIntCommentsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteIntComActionPerformed(null);
        }
    }

    private void jTableLOCKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteLOCActionPerformed(null);
        }
    }

    private void jButtonCopyChronoActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableChrono, this.tableModelChrono, false);
    }

    private void jButtonCopyBioActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableBiozones, this.tableModelBiozones, false);
    }

    private void jButtonCopyLithActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableLStrat, this.tableModelLstrat, false);
    }

    private void jButtonCopyComActionPerformed(ActionEvent evt) {
        this.copyBiocom(false);
    }

    private void jButtonMoveComActionPerformed(ActionEvent evt) {
        this.copyBiocom(true);
    }

    private void jButtonCopyPalActionPerformed(ActionEvent evt) {
        this.copyPalenv(false);
    }

    private void jButtonMovePalActionPerformed(ActionEvent evt) {
        this.copyPalenv(true);
    }

    private void jButtonFillChronoHierachyActionPerformed(ActionEvent evt) {
        this.fillHierarchy(this.jTableChrono, this.tableModelChrono);
    }

    private void jButtonFillBiozoneHierachyActionPerformed(ActionEvent evt) {
        this.fillHierarchy(this.jTableBiozones, this.tableModelBiozones);
    }

    private void jButtonFillLstratHierachyActionPerformed(ActionEvent evt) {
        this.fillHierarchy(this.jTableLStrat, this.tableModelLstrat);
    }

    private void jButtonSaveAsComActionPerformed(ActionEvent evt) {
        if (!this.canExport()) {
            return;
        }
        if (this.tableModelBiocom.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No data to save", "Comments", 1);
            return;
        }
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "JBCFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        File file = FileChooserUtils.saveAsDialogWithFilters((Component)this, (String)setDir.getPath(), (String)SB.makeFileName((String)(this.well.getWellCode() + "_biocomments")), (FileNameExtensionFilter[])new FileNameExtensionFilter[]{FileChooserUtils.EXCEL_FILTER, FileChooserUtils.CSV_FILTER, FileChooserUtils.TEXT_FILTER, FileChooserUtils.LEGACY_EXCEL_FILTER});
        if (file == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String fileName = file.getName();
            char delim = fileName.toLowerCase().contains(".csv") ? (char)',' : '\t';
            CSVExportOptions csvOpts = new CSVExportOptions();
            csvOpts.setMaxFractionalDigits(2);
            csvOpts.setMinFractionalDigits(2);
            csvOpts.setColumnDelimiter(delim);
            GridWriter gw = new GridWriter();
            CellFormat DEPTH_FORMAT = new CellFormat().setDataFormat(CellDataFormat.Fixed2DP);
            gw.setCSVOptions(csvOpts);
            gw.getXLSOptions().setSheetName(this.well.getWellName());
            gw.getXLSOptions().setAuthorName(this.sbdb.getUser().getName());
            gw.getXLSOptions().setAutoSizeColumns(false);
            gw.getXLSOptions().setEnableBufferedOutput(true);
            Pattern p = Pattern.compile("[^.0-9 ]");
            if (FileOverwriteCheck.checkForGridFileOverwriting(this.parentFrame, (Component)this, file, gw)) {
                GridSheet gb = new GridSheet();
                boolean askCores = false;
                boolean askCuttings = false;
                boolean useCoreCorrections = false;
                boolean useCuttingCorrections = false;
                for (Biocom comment : this.tableModelBiocom.comments) {
                    if (comment.getTopSample().getType() == SampleType.CO && !askCores) {
                        askCores = true;
                        if (this.well.hasShifts()) {
                            int option = JOptionPane.showConfirmDialog(this.parentFrame, "Do you want to output core-corrected depths for Core samples?", this.parentFrame.getTitle(), 1, 3);
                            if (option == 2) {
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            if (option == 0) {
                                useCoreCorrections = true;
                            }
                        }
                    } else if (comment.getTopSample().getType() == SampleType.CU && !askCuttings) {
                        askCuttings = true;
                        if (this.well.hasShifts()) {
                            int option = JOptionPane.showConfirmDialog(this.parentFrame, "Do you want to output core-corrected depths for Cuttings?", this.parentFrame.getTitle(), 1, 3);
                            if (option == 2) {
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            if (option == 0) {
                                useCuttingCorrections = true;
                            }
                        }
                    }
                    Sample sample = comment.getTopSample();
                    Double correctedTop = null;
                    Double correctedBase = null;
                    if ((useCoreCorrections || useCuttingCorrections) && Math.abs(sample.getDepth() - this.well.getDepth(sample, useCoreCorrections, useCuttingCorrections)) > (double)0.0029f) {
                        correctedTop = sample.getTopDepth() != null ? Double.valueOf(this.well.getCorrectedDepth(sample.getTopDepth())) : null;
                        correctedBase = sample.getBaseDepth() != null ? Double.valueOf(this.well.getCorrectedDepth(sample.getBaseDepth())) : null;
                    }
                    String topSampleString = sample.toString(this.units, false, false, false, true, correctedTop, correctedBase);
                    String baseSampleString = "";
                    if (comment.getBaseSample() != null) {
                        sample = comment.getBaseSample();
                        correctedTop = null;
                        correctedBase = null;
                        if ((useCoreCorrections || useCuttingCorrections) && Math.abs(sample.getDepth() - this.well.getDepth(sample, useCoreCorrections, useCuttingCorrections)) > (double)0.0029f) {
                            correctedTop = sample.getTopDepth() != null ? Double.valueOf(this.well.getCorrectedDepth(sample.getTopDepth())) : null;
                            correctedBase = sample.getBaseDepth() != null ? Double.valueOf(this.well.getCorrectedDepth(sample.getBaseDepth())) : null;
                        }
                        baseSampleString = sample.toString(this.units, false, false, false, true, correctedTop, correctedBase);
                    }
                    gb.append(new Object[]{this.well.getWellCode(), comment.getDiscipline().getNoun()});
                    Matcher m = p.matcher(topSampleString);
                    if (m.find()) {
                        gb.append(new Object[]{topSampleString});
                    } else {
                        gb.appendFormatted(DEPTH_FORMAT, new Object[]{Double.valueOf(topSampleString)});
                    }
                    if (comment.getBaseSample() != null) {
                        m = p.matcher(baseSampleString);
                        if (m.find()) {
                            gb.append(new Object[]{baseSampleString});
                        } else {
                            gb.appendFormatted(DEPTH_FORMAT, new Object[]{Double.valueOf(baseSampleString)});
                        }
                    } else {
                        gb.append(new Object[]{""});
                    }
                    gb.append(new Object[]{comment.getAnalystString(), comment.getText().replace('\n', ' '), comment.getSource() != null ? comment.getSource() : ""});
                    gb.addRow();
                }
                gw.write(file, gb.getDataArray());
            }
            JOptionPane.showMessageDialog(this, "File written ");
            Lastval.putString(this.sbdb, "JBCFILE", fileName);
        }
        catch (IOException | SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonAddFaultActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            Sample sample = this.parentPanel.getSelectedSample();
            DialogFault dialog = new DialogFault(this.parentFrame, true, null, this.well, this.units, wellInterp, this.sbdb, sample);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error opening dialog", (Exception)e, this.sbdb);
        }
    }

    private void jButtonEditFaultActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        int nRows = this.jTableFaults.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select a fault from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        Fault selectedFault = (Fault)this.tableModelFaults.getItem(this.jTableFaults.convertRowIndexToModel(this.jTableFaults.getSelectedRow()));
        try {
            DialogFault dialog = new DialogFault(this.parentFrame, true, selectedFault, this.well, this.units, wellInterp, this.sbdb, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.tableModelFaults.fireTableDataChanged();
            }
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonDeleteFaultActionPerformed(ActionEvent evt) {
        this.deleteSelectedInterpItems(this.jTableFaults);
    }

    private void deleteSelectedInterpItems(JTable table) {
        String nounCap;
        int nRows = table.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select one or more rows", this.parentFrame.getTitle(), 2);
            return;
        }
        InterpItemTableModel model = (InterpItemTableModel)table.getModel();
        LinkedList toKill = new LinkedList();
        for (int row : table.getSelectedRows()) {
            toKill.add(model.getItem(table.convertRowIndexToModel(row)));
        }
        String noun = ((InterpItem)toKill.get(0)).getItemDesc();
        Object msg = "Really delete ";
        msg = nRows == 1 ? (String)msg + "this " + noun : (String)msg + "these " + nRows + " " + ((InterpItem)toKill.get(0)).getItemDescPlural();
        if (JOptionPane.showConfirmDialog(this, msg = (String)msg + "?", "Delete " + (nounCap = noun.substring(0, 1).toUpperCase() + noun.substring(1)), 0, 3) != 0) {
            return;
        }
        try {
            this.getInterp().delete(toKill, this.well.getWellID());
            this.sbdb.commit();
            table.clearSelection();
            this.getInterp().notifyObservers(model.getTypeParameterClass());
            model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException ex) {
            this.sbdb.doRollback();
            SbugsExceptionHandler.showStackError("Error deleting " + noun, ex);
        }
    }

    private void jTableFaultsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditFaultActionPerformed(null);
        }
    }

    private void jTableFaultsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteFaultActionPerformed(null);
        }
    }

    private void jButtonCreateSamplesActionPerformed(ActionEvent evt) {
        if (this.tableModelLOC.getLOC() == null) {
            JOptionPane.showMessageDialog(this.parentFrame, "No depth/age curve defined.", this.parentFrame.getTitle(), 1);
            return;
        }
        boolean hasUnconf = false;
        LOC loc = this.tableModelLOC.getLOC();
        Iterator<LOCNode> it = loc.getNodeIterator();
        while (it.hasNext()) {
            LOCNode node = it.next();
            if (node.getBnd() != 4) continue;
            hasUnconf = true;
            break;
        }
        if (!hasUnconf) {
            JOptionPane.showMessageDialog(this.parentFrame, "No LOG samples created - no disconformities defined.", this.parentFrame.getTitle(), 1);
            return;
        }
        if (JOptionPane.showConfirmDialog(this.parentFrame, "This option creates a LOG pick sample at each disconformity on the depth/age curve, to allow the disconformity to be picked as at a surface or boundary.\nContinue?", this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        it = loc.getNodeIterator();
        int nAdded = 0;
        try {
            Sample lastSample = null;
            while (it.hasNext()) {
                LOCNode node = it.next();
                if (node.getBnd() != 4 || this.well.getSample(node.getDepth(), "LOG", false) != null) continue;
                lastSample = this.well.addSample(node.getDepth(), SampleType.LOG, null);
                ++nAdded;
            }
            if (nAdded > 0) {
                this.sbdb.commit();
                JOptionPane.showMessageDialog(this.parentFrame, nAdded + " Samples added.", this.parentFrame.getTitle(), 1);
                this.well.notifyObservers(lastSample);
            } else {
                JOptionPane.showMessageDialog(this.parentFrame, "No samples needed to be added.", this.parentFrame.getTitle(), 1);
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "Create Samples", 2);
        }
        catch (SQLException | SampleInsertException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonShowChronoSchemeActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            List<IGDScheme> schemes = wellInterp.getIGDSchemes(3);
            for (IGDScheme scheme : schemes) {
                this.parentFrame.addChartScheme(scheme);
            }
        }
        catch (SQLException | SBException ex) {
            FrameJsbugs.showStackError("Error showing scheme", (Exception)ex, this.sbdb);
        }
    }

    private void jButtonShowSchemeBiozoneActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDScheme scheme = (IGDScheme)this.jComboBoxSchemeBio.getSelectedItem();
        if (scheme == null) {
            JOptionPane.showMessageDialog(this, "Select a Scheme", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            this.parentFrame.addChartScheme(scheme);
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void jButtonShowLstratSchemeActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            List<IGDScheme> schemes = wellInterp.getIGDSchemes(2);
            for (IGDScheme scheme : schemes) {
                this.parentFrame.addChartScheme(scheme);
            }
        }
        catch (SQLException | SBException ex) {
            FrameJsbugs.showStackError("Error", (Exception)ex, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonShowSQschemetSchemeActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            List<IGDScheme> schemes = wellInterp.getIGDSchemes(10);
            for (IGDScheme scheme : schemes) {
                this.parentFrame.addChartScheme(scheme);
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void jButtonCopyEventsActionPerformed(ActionEvent evt) {
        this.copyEvents(false);
    }

    private void jButtonSaveAsLOCActionPerformed(ActionEvent evt) {
        if (!this.canExport()) {
            return;
        }
        LOC loc = this.getInterp().getLOC();
        if (loc == null) {
            JOptionPane.showMessageDialog(this, "No LOC to save", "Save LOC", 2);
            return;
        }
        if (loc.getSize() == 0) {
            JOptionPane.showMessageDialog(this, "LOC is empty", "Save LOC", 2);
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("las");
        filter.setDescription("LAS files");
        fileChooser.setFileFilter((FileFilter)filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "WINLASFILE", "UNXLASFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            fileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileChooser.showSaveDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (!file.getName().toLowerCase().endsWith("las")) {
                String rootName = file.getName();
                file = new File(file.getPath() + ".las");
            } else {
                String rootName = file.getName().substring(0, file.getName().length() - 4);
            }
            try {
                Lastval.putString(this.sbdb, "WINLASFILE", "UNXLASFILE", file.getPath());
                this.sbdb.commit();
                String fileName = file.getPath();
                Object UWI = this.parentPanel.well.getWellName();
                if (((String)UWI).indexOf("_SUMLOG") > 0) {
                    UWI = ((String)UWI).substring(0, ((String)UWI).indexOf("_SUMLOG"));
                }
                if (((String)UWI).charAt(4) == '/') {
                    if (((String)UWI).charAt(5) == '0') {
                        UWI = ((String)UWI).replaceAll("/0", "/");
                    }
                    if (((String)UWI).substring(4).indexOf("-0") > 0) {
                        UWI = ((String)UWI).substring(0, ((String)UWI).indexOf("-0")) + "-" + ((String)UWI).substring(((String)UWI).indexOf("-0") + 2);
                    }
                }
                if (this.parentPanel.well.getHeader().getCountry().startsWith("NO")) {
                    UWI = "NO " + (String)UWI;
                }
                if ((UWI = JOptionPane.showInputDialog(this, "Enter Unique Well Identifier (UWI) to embed in file header: ", UWI)) == null) {
                    return;
                }
                new LASFile(fileName, this.sbdb, this.getInterp().getLOC(), this.parentPanel.well, this.units, (String)UWI);
                JOptionPane.showMessageDialog(this, "File : '" + file.getPath() + "' written", "Write LAS", 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void jButtonEventCommentsActionPerformed(ActionEvent evt) {
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select event(s)", this.parentFrame.getTitle(), 2);
            return;
        }
        LinkedList<WellEvent> events = new LinkedList<WellEvent>();
        for (int row : this.jTableEvents.getSelectedRows()) {
            events.add(this.tableModelEvents.events.get(this.jTableEvents.convertRowIndexToModel(row)));
        }
        this.generateCommentsFromEvents(events);
    }

    private void jButtonSaveAsPalActionPerformed(ActionEvent evt) {
        if (!this.canExport()) {
            return;
        }
        if (this.tableModelEnv.envs.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No data to save", "IGD", 1);
            return;
        }
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "JIGDEFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = System.getProperty("os.name").equals("SunOS") ? new File("~/") : new File("\\My Documents");
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        String FULLCSV = "CSV files, all columns";
        filter.setDescription("CSV files, all columns");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        filter = new SbugsFileFilter();
        filter.addExtension("csv");
        String PAIRCSV = "CSV files, pair of numerical columns";
        filter.setDescription("CSV files, pair of numerical columns");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        filter = new SbugsFileFilter();
        filter.addExtension("txt");
        String TABBED = "TAB delmited text files, all columns";
        filter.setDescription("TAB delmited text files, all columns");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                Object fileName = jFileChooser1.getSelectedFile().getPath();
                String filterString = jFileChooser1.getFileFilter().getDescription();
                char delim = '\t';
                if (jFileChooser1.getFileFilter().accept(new File("1.csv"))) {
                    if (!((String)fileName).toLowerCase().contains(".csv")) {
                        fileName = (String)fileName + ".csv";
                    }
                    delim = ',';
                } else if (!((String)fileName).toLowerCase().contains(".txt")) {
                    fileName = (String)fileName + ".txt";
                }
                DecimalFormat nFormat = new DecimalFormat("#####0.0##");
                FileWriter out = new FileWriter((String)fileName);
                Iterator<IGDIntervalEnv> en = this.tableModelEnv.envs.iterator();
                int lastDepth = -99999;
                while (en.hasNext()) {
                    IGDIntervalEnv zone = en.next();
                    if (filterString.startsWith("CSV files, pair of numerical columns")) {
                        int intDepth = (int)zone.getTopSample().getDepth(this.units) * 100;
                        if (intDepth != lastDepth) {
                            out.write(this.well.getWellCode() + delim + nFormat.format(zone.getTopSample().getDepth(this.units)) + delim + zone.getUp() + delim + zone.getUd() + "\r\n");
                            lastDepth = intDepth;
                        }
                        if ((intDepth = (int)zone.getBaseSample().getDepth(this.units) * 100) == lastDepth) continue;
                        out.write(this.well.getWellCode() + delim + nFormat.format(zone.getBaseSample().getDepth(this.units)) + delim + zone.getLp() + delim + zone.getLd() + "\r\n");
                        lastDepth = intDepth;
                        continue;
                    }
                    out.write(this.well.getWellCode() + delim + nFormat.format(zone.getTopSample().getDepth(this.units)) + delim + zone.getTopSample().getType().getAbr() + delim + nFormat.format(zone.getBaseSample().getDepth(this.units)) + delim + zone.getBaseSample().getType().getAbr() + delim + zone.toString() + delim + String.valueOf(zone.getModifier() > 0 ? this.sbdb.getUser(zone.getModifier()) : "") + delim + (zone.getModified() != null ? df.format(zone.getModified()) : "") + delim + "\r\n");
                }
                out.close();
                JOptionPane.showMessageDialog(this, "File written ");
                Lastval.putString(this.sbdb, "JIGDEFILE", (String)fileName);
                this.sbdb.commit();
            }
            catch (IOException | RuntimeException | SQLException ex) {
                SbugsExceptionHandler.showStackError(ex);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonCopyIntComActionPerformed(ActionEvent evt) {
        this.copyIntcoms(false);
    }

    private void jButtonMoveIntComActionPerformed(ActionEvent evt) {
        this.copyIntcoms(true);
    }

    private void jButtonSaveAsChronoActionPerformed(ActionEvent evt) {
        this.saveOW(3);
    }

    private void jButtonSaveAsBioActionPerformed(ActionEvent evt) {
        this.saveOW(4);
    }

    private void jButtonSaveAsLithActionPerformed(ActionEvent evt) {
        this.saveOW(2);
    }

    private void jButtonSaveAsSQPickActionPerformed(ActionEvent evt) {
        this.saveOWSQPicks();
    }

    private void jButtonCopySQPicksActionPerformed(ActionEvent evt) {
        this.copySQPicks(false);
    }

    private void jRadioButtonAgeFormatMAActionPerformed(ActionEvent evt) {
        TableCellEditor editor = this.jTableLOC.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        this.setAgeFormatTable(AgeFormat.MA);
    }

    private void jRadioButtonAgeFormatKaActionPerformed(ActionEvent evt) {
        TableCellEditor editor = this.jTableLOC.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        this.setAgeFormatTable(AgeFormat.KA);
    }

    private void jButtonIGDHdrsActionPerformed(ActionEvent evt) {
        if (this.getInterp() == null) {
            JOptionPane.showMessageDialog(this.parentFrame, "No version selected");
            return;
        }
        try {
            DialogIGDHdrs dialog = new DialogIGDHdrs((Frame)this.parentFrame, true, this.well, this.getInterp());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException ex) {
            FrameJsbugs.showStackError("Error", (Exception)ex, this.sbdb);
        }
    }

    private void jButtonLOCCommentActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        LOC loc = wellInterp.getLOC();
        if (loc == null) {
            JOptionPane.showMessageDialog(this, "No LOC exists in current version.", this.parentFrame.getTitle(), 1);
            return;
        }
        this.jTextAreaLOCComments.setText(loc.getComment());
        this.jDialogLOCComment.setLocationRelativeTo(this.jButtonLOCComment);
        this.jDialogLOCComment.setSize(this.jDialogLOCComment.getPreferredSize());
        this.jDialogLOCComment.setVisible(true);
    }

    private void jButtonLOCCommentsCancelActionPerformed(ActionEvent evt) {
        this.jDialogLOCComment.setVisible(false);
    }

    private void jTextAreaLOCCommentsKeyTyped(KeyEvent evt) {
        if (!SB.lenField((JTextArea)this.jTextAreaLOCComments, (int)255, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonLOCCommentsOKActionPerformed(ActionEvent evt) {
        try {
            this.getSelectedVersion().getLOC().updateComment(this.jTextAreaLOCComments.getText(), this.well.getWellID(), this.getSelectedVersion().getHeader().getInterpID());
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error updating comment", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.jDialogLOCComment.setVisible(false);
    }

    private void jButtonLOCWeightActionPerformed(ActionEvent evt) {
        if (this.tableModelLOC.getLOC() != null) {
            Object[] values = new Object[]{"Light (0.5 mm)", "Medium (1 mm)", "Heavy (1.5 mm)"};
            Object value = values[1];
            if (this.tableModelLOC.getLOC().getLineWidth() < 1.0f) {
                value = values[0];
            } else if (this.tableModelLOC.getLOC().getLineWidth() > 1.0f) {
                value = values[2];
            }
            value = JOptionPane.showInputDialog(this, "Select weight:", "Depth/Age Curve Weight", 2, null, values, value);
            if (value == null) {
                return;
            }
            float weight = 1.0f;
            float[] weights = new float[]{0.5f, 1.0f, 1.5f};
            for (int i = 0; i < values.length; ++i) {
                if (!value.equals(values[i])) continue;
                weight = weights[i];
            }
            try {
                this.tableModelLOC.getLOC().setWeight(weight, this.well.getWellID(), this.getSelectedVersion().getHeader().getInterpID());
                this.sbdb.commit();
                this.jLabelLOCWeight.setText("" + this.tableModelLOC.getLOC().getLineWidth());
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jButtonChronoCommentsActionPerformed(ActionEvent evt) {
        this.showIntcoms(3);
    }

    private void jButtonBiozoneCommentsActionPerformed(ActionEvent evt) {
        this.showIntcoms(4);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showIntcoms(2);
    }

    private void jButtonEnvCommentsActionPerformed(ActionEvent evt) {
        this.showIntcoms(5);
    }

    private void jButtonEventTxGroupActionPerformed(ActionEvent evt) {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            JOptionPane.showMessageDialog(this, SBRestrictable.getDeniedReason(true), this.parentFrame.getTitle(), 2);
            return;
        }
        if (this.jTableEvents.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select event(s)", this.parentFrame.getTitle(), 2);
            return;
        }
        HashSet<Taxon> taxa = new HashSet<Taxon>();
        for (int row : this.jTableEvents.getSelectedRows()) {
            WellEvent event = this.tableModelEvents.events.get(this.jTableEvents.convertRowIndexToModel(row));
            if (event.getEvent().getTaxon() == null) continue;
            taxa.add(event.getEvent().getTaxon());
        }
        try {
            DialogSelectGroup dialog = new DialogSelectGroup(this.parentFrame, true, this.sbdb, null, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                int opt;
                TxGroup group = dialog.selection;
                if (!group.canWrite(this.sbdb, null)) {
                    JOptionPane.showMessageDialog(this, group.getDeniedReason(this.sbdb, "add taxa", "group", false), this.parentFrame.getTitle(), 2);
                    return;
                }
                int initialSize = group.getSize();
                if (initialSize > 0 && (opt = JOptionPane.showConfirmDialog(this, "Really add " + taxa.size() + "taxa to this group\nwhich already contains " + initialSize + " taxa?", this.parentFrame.getTitle(), 0)) != 0) {
                    return;
                }
                group.addTaxa(new ArrayList<Taxon>(taxa));
                int newSize = group.getSize();
                if (initialSize == newSize) {
                    JOptionPane.showMessageDialog(this, "All taxa were already in the group!", this.parentFrame.getTitle(), 1);
                } else {
                    assert (newSize > initialSize);
                    JOptionPane.showMessageDialog(this, newSize - initialSize + " taxa added.", this.parentFrame.getTitle(), 1);
                }
                this.sbdb.commit();
            }
        }
        catch (SQLException | SBPermissionException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
    }

    private void showIntcoms(int igdType) {
        try {
            DialogIntcoms dialog = new DialogIntcoms(this.parentFrame, true, this.well, this.getInterp().getHeader().getInterpID(), igdType, this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
    }

    private void jButtonCommentEventsActionPerformed(ActionEvent evt) {
        try {
            int opt;
            WellInterp interp = this.getInterp();
            if (interp.getComments().isEmpty()) {
                JOptionPane.showMessageDialog(this, "No comments to parse!", "Parse Events", 2);
                return;
            }
            LinkedList<Biocom> use = new LinkedList<Biocom>();
            if (this.jTableComments.getSelectedRowCount() > 0 && (opt = JOptionPane.showConfirmDialog(this, "Use selected comments only?", "Parse Events", 0)) == 0) {
                for (int row : this.jTableComments.getSelectedRows()) {
                    use.add(this.tableModelBiocom.comments.get(this.jTableComments.convertRowIndexToModel(row)));
                }
            }
            if (use.isEmpty()) {
                use.addAll(this.getInterp().getComments());
            }
            DialogSelectCmpStd dialog = new DialogSelectCmpStd((Frame)this.parentFrame, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            int nEvents = interp.getEvents().size();
            interp.generateEventsFromComments(use, dialog.selection, this.well);
            int nNew = interp.getEvents().size() - nEvents;
            if (nNew > 0) {
                JOptionPane.showMessageDialog(this, nNew + " event" + (nNew > 1 ? "s" : "") + " parsed.", "Parse Events", 1);
            } else {
                JOptionPane.showMessageDialog(this, "No new events parsed.", "Parse Events", 1);
            }
            this.sbdb.commit();
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), "Error", 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jButtonIPSBathyActionPerformed(ActionEvent evt) {
        try {
            DialogIPSBathy dialog = new DialogIPSBathy(this.parentFrame, true, this.sbdb, this.well, this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError(sqle.getMessage(), sqle, this.sbdb);
        }
    }

    private void jButtonMoveToSampleActionPerformed(ActionEvent evt) {
        try {
            for (int row : this.jTableLOC.getSelectedRows()) {
                double depth;
                Sample closest;
                SampleDistance distance = (SampleDistance)this.tableModelLOC.getValueAt(row, 4);
                List<Sample> samples = this.well.getSamples();
                if (!distance.SingleSampleFound() || !(Math.abs(distance.getDistance()) > 0.001) || (closest = SampleUtils.findNearestSample(depth = Double.parseDouble(this.tableModelLOC.getValueAt(row, 0).toString()), samples)) == null) continue;
                this.tableModelLOC.setValueAt(closest.getDepth(), row, 0);
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jButtonSnapToEventActionPerformed(ActionEvent evt) {
        if (this.getInterp() == null) {
            return;
        }
        DialogSnapToEvent dlg = new DialogSnapToEvent((JFrame)this.getRootPane().getParent(), true, this.units, this.tableModelLOC.getAgeFormat(), this.sbdb, this.getInterp(), this.tableModelLOC.getLOC());
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        if (dlg.isOK()) {
            for (LOCNodeShiftRequest request : dlg.getNodeShiftRequests()) {
                for (int row = 0; row < this.tableModelLOC.getRowCount(); ++row) {
                    LOCNode node = this.tableModelLOC.getLOC().getNode(row);
                    if (node.getAge() != request.getAge() || node.getDepth() != request.getDepth() || node.getBnd() != request.getBoundary()) continue;
                    this.tableModelLOC.setValueAt(request.getNewAge(), row, 1);
                    this.tableModelLOC.setValueAt(request.getNewDepth(), row, 0);
                }
            }
        }
    }

    private void jButtonEventDepthErrorActionPerformed(ActionEvent evt) {
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select event(s)", this.parentFrame.getTitle(), 2);
            return;
        }
        LinkedList<WellEvent> toProcess = new LinkedList<WellEvent>();
        for (int row : this.jTableEvents.getSelectedRows()) {
            toProcess.add(this.tableModelEvents.events.get(this.jTableEvents.convertRowIndexToModel(row)));
        }
        DialogEditWellEventError dialog = new DialogEditWellEventError(this.parentFrame, true, this.well, this.getInterp(), toProcess, this.units);
        dialog.setLocationRelativeTo(this.jButtonEventDepthError);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.tableModelEvents.fireTableDataChanged();
        }
    }

    private void jButtonEditSelectedComActionPerformed(ActionEvent evt) {
        int nRows = this.jTableComments.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select comment(s) to edit", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        LinkedList<Biocom> toEdit = new LinkedList<Biocom>();
        for (int row : this.jTableComments.getSelectedRows()) {
            toEdit.add(this.tableModelBiocom.comments.get(this.jTableComments.convertRowIndexToModel(row)));
        }
        try {
            DialogEditBiocoms dialog = new DialogEditBiocoms(this.parentFrame, true, this.well, wellInterp, toEdit);
            dialog.setLocationRelativeTo(this.jButtonEditSelectedCom);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.sbdb.commit();
                this.jTableComments.clearSelection();
            }
        }
        catch (SQLException | SBException ex) {
            StackError.showStackError((String)"Error loading biostrat comment editor", (Throwable)ex);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonMoveInterpActionPerformed(ActionEvent evt) {
        DialogMoveInterp dialog = new DialogMoveInterp(this.parentFrame, true, this.sbdb, this.well, this.getInterp(), this.units);
        dialog.setLocationRelativeTo(this.jButtonMoveInterp);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.jTableChrono.clearSelection();
            this.tableModelChrono.fireTableDataChanged();
            try {
                this.jTableBiozones.clearSelection();
                Iterator<IGDScheme> it = this.getInterp().getIGDSchemes(4).iterator();
                this.jComboBoxSchemeBio.removeAllItems();
                while (it.hasNext()) {
                    this.jComboBoxSchemeBio.addItem(it.next());
                }
                this.jComboBoxSchemeBio.repaint();
            }
            catch (SQLException ex) {
                StackError.showStackError((String)"Error refreshing Biozone schemes: ", (SQLException)ex);
            }
            this.jTableLStrat.clearSelection();
            this.tableModelLstrat.fireTableDataChanged();
            this.jTableComments.clearSelection();
            this.tableModelBiocom.fireTableDataChanged();
            this.jTableIntComments.clearSelection();
            this.tableModelIntervalComments.fireTableDataChanged();
            this.jTableEvents.clearSelection();
            this.tableModelEvents.fireTableDataChanged();
            this.jTableEnv.clearSelection();
            this.tableModelEnv.fireTableDataChanged();
            this.jTableSQPicks.clearSelection();
            this.tableModelSQPicks.fireTableDataChanged();
            this.jTableLOC.clearSelection();
            this.tableModelLOC.fireTableDataChanged();
            this.getInterp().notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadLOCActionPerformed(ActionEvent evt) {
        if (this.tableModelLOC.getLOC() != null) {
            JOptionPane.showMessageDialog(this, "Depth/Age curve already exists. Delete curve before importing or select a different version.", this.parentFrame.getTitle(), 1);
            return;
        }
        File file = null;
        try {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel or CSV file", "csv", "xls", "xlsx");
            file = FileChooserUtils.chooseReadableFile((Component)this, (FileNameExtensionFilter)filter, (File)new File(Lastval.getString(this.sbdb, "AGEDEPFILE")));
            if (file == null) {
                return;
            }
            try (GridReader in = GridReader.getGridReader((String)file.getPath(), null);){
                Lastval.putString(this.sbdb, "AGEDEPFILE", file.getPath());
                this.sbdb.commit();
                boolean firstRow = true;
                WellInterp interp = this.getInterp();
                AgeFormat af = this.tableModelLOC.getAgeFormat();
                Double firstDepth = null;
                Double firstAge = null;
                Double lastDepth = null;
                while (in.nextRow()) {
                    String cell = in.getNextCell(false);
                    if (firstRow) {
                        if (cell == null || cell.isEmpty()) continue;
                        try {
                            Double.parseDouble(cell);
                        }
                        catch (NumberFormatException ne) {
                            continue;
                        }
                        firstRow = false;
                    }
                    double depth = DepthUtils.convToM((double)DepthUtils.parseDepthString((String)cell, (char)this.units), (char)this.units, (char)this.well.getType());
                    cell = in.getNextCell(false);
                    if (cell == null || cell.isEmpty()) continue;
                    double age = Double.parseDouble(cell);
                    cell = in.getNextCell();
                    Integer lineStyle = null;
                    if (cell != null && !cell.isEmpty()) {
                        lineStyle = IGDIntervalZone.getBoundaryTypeFromString(cell);
                    }
                    age /= af.getMultiplyer();
                    if (interp.getLOC() == null) {
                        if (firstDepth == null) {
                            firstDepth = depth;
                            firstAge = age;
                            continue;
                        }
                        interp.addLOC(this.well, null, firstAge, firstDepth, age, depth);
                        lastDepth = depth;
                        continue;
                    }
                    Iterator<LOCNode> it = interp.getLOC().getNodeIterator();
                    while (it.hasNext()) {
                        LOCNode node = it.next();
                        if (node.getDepth() != depth || node.getAge() != age) continue;
                        System.out.println("Node: " + DepthUtils.convFromM((double)depth, (char)this.units) + " age: " + age + " already exists, skipping..");
                    }
                    interp.addLOCNode(lineStyle == null ? (Math.abs(lastDepth - depth) > (double)0.0029f ? 3 : 4) : lineStyle, depth, age, this.well.getWellID());
                    lastDepth = depth;
                }
                interp.getLOC().notifyObservers();
                interp.notifyObservers((Object)interp.getLOC());
            }
        }
        catch (SQLException | GridReaderException e) {
            StackError.showStackError((String)("An error occurred while opening the file " + (file == null ? "<no file>" : file.getName()) + "."), (Throwable)e);
        }
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableLOC.selectAll();
    }

    private void generateCommentsFromEvents(List<WellEvent> events) {
        DialogEventComments dialog = new DialogEventComments(this.parentFrame, true, this.sbdb);
        dialog.setLocationRelativeTo(this.parentFrame);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        Biocom newComm = null;
        WellInterp interp = this.getInterp();
        int nUpdated = 0;
        int nCreated = 0;
        for (WellEvent event : events) {
            Discipline discID = !DialogEventComments.override && event.getDiscipline() != null ? event.getDiscipline() : dialog.discID;
            assert (discID != null);
            String analyst = !DialogEventComments.override && event.getAnalystString() != null && !event.getAnalystString().isEmpty() ? event.getAnalystString() : dialog.analyst;
            try {
                Biocom found = null;
                List<Biocom> existing = interp.getComments(discID.getChar());
                for (Biocom biocom : existing) {
                    if (biocom.getTopID() != event.getSampID() || !biocom.getAnalystString().equals(analyst)) continue;
                    found = biocom;
                    break;
                }
                Object text = event.toString(false, DialogEventComments.includeQualifiers, false);
                if (DialogEventComments.includeComments && event.getComments() != null && !event.getComments().trim().isEmpty()) {
                    text = (String)text + " - " + event.getComments();
                }
                if (DialogEventComments.includeCompany && event.getSource() != null && !event.getSource().trim().isEmpty()) {
                    text = (String)text + " - Source: " + event.getSource();
                }
                if (DialogEventComments.includeCompany && event.getCompany() != null && !event.getCompany().trim().isEmpty()) {
                    text = (String)text + " - Company: " + event.getCompany();
                }
                if (DialogEventComments.includeConfidence) {
                    text = (String)text + " [" + event.getConfidence().toString() + "]";
                }
                if (found != null) {
                    newComm = interp.updateBiocom(found, this.well.getWellID(), discID, found.getTopSample(), found.getBaseSample(), found.getAnalystString(), found.getSource(), found.getText() + ", " + (String)text);
                    ++nUpdated;
                } else {
                    newComm = interp.addBiocom(new Biocom.Builder(this.sbdb, discID, this.sbdb.getUser(analyst).getUsrID(), event.getSample(), (String)text), this.well.getWellID()).getBiocom();
                    ++nCreated;
                }
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("Error adding comment", sql, this.sbdb);
                this.sbdb.doRollback();
            }
            catch (InvalidFieldException e) {
                JOptionPane.showMessageDialog(this, "Cannot insert comment: " + e.getMessage(), "Cannot insert comment", 2);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error adding comment", (Throwable)sbe);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
        if (newComm != null) {
            interp.notifyObservers(newComm);
        }
        Object msg = "";
        if (nCreated > 0) {
            msg = (String)msg + nCreated + " comments generated.";
        }
        if (nUpdated > 0) {
            if (!((String)msg).isEmpty()) {
                msg = (String)msg + "\n";
            }
            msg = (String)msg + nUpdated + " comments updated.";
        }
        if (!((String)msg).isEmpty()) {
            JOptionPane.showMessageDialog(this.parentPanel, msg, "Generate comments", 1);
        }
    }

    private void copyEvents(boolean move) {
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select event(s)", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            WellInterp wellInterp = this.getSelectedVersion();
            if (wellInterp == null) {
                return;
            }
            InterpHdr newInterp = this.getCopyVersion(wellInterp, move);
            if (newInterp == null) {
                return;
            }
            LinkedList<WellEvent> toProcess = new LinkedList<WellEvent>();
            for (int row : this.jTableEvents.getSelectedRows()) {
                toProcess.add(this.tableModelEvents.events.get(this.jTableEvents.convertRowIndexToModel(row)));
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            this.well.loadInterp(newWellInterp);
            for (WellEvent ev : toProcess) {
                try {
                    wellInterp.copyEvent(this.well, ev, newWellInterp, move);
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, "Cannot " + (move ? "move" : "copy") + " event: " + e.getMessage(), "Error copying", 2);
                    continue;
                }
                this.sbdb.commit();
            }
            this.jTableEvents.clearSelection();
            if (move) {
                this.tableModelEvents.fireTableDataChanged();
                wellInterp.notifyObservers(20);
            }
            this.checkVersionInCombo(wellInterp, newWellInterp);
            newWellInterp.notifyObservers(20);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error moving/copying events", ex, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error moving/copying events", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void copySQPicks(boolean move) {
        int nRows = this.jTableSQPicks.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select pick(s) to move", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        InterpHdr newInterp = this.getCopyVersion(wellInterp, move);
        if (newInterp == null) {
            return;
        }
        try {
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            this.well.loadInterp(newWellInterp);
            LinkedList<SQPick> toMove = new LinkedList<SQPick>();
            for (int row : this.jTableSQPicks.getSelectedRows()) {
                toMove.add((SQPick)this.tableModelSQPicks.getItems().get(this.jTableSQPicks.convertRowIndexToModel(row)));
            }
            Object object = toMove.iterator();
            while (object.hasNext()) {
                SQPick pick = (SQPick)object.next();
                try {
                    if (!move) {
                        wellInterp.copy(pick, this.well, newWellInterp);
                    } else {
                        wellInterp.move(pick, this.well, newWellInterp);
                    }
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot " + (move ? "move" : "copy"), 2);
                    continue;
                }
                this.sbdb.commit();
            }
            this.jTableSQPicks.clearSelection();
            this.checkVersionInCombo(wellInterp, newWellInterp);
            wellInterp.notifyObservers(21);
            newWellInterp.notifyObservers(21);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error moving/copying picks", ex, this.sbdb);
        }
        catch (SBException ex) {
            StackError.showStackError((String)"Error moving/copying picks", (Throwable)ex);
        }
    }

    private InterpHdr getCopyVersion(WellInterp current, boolean move) {
        DialogSelectVersion dialog;
        LinkedList<Well> list = new LinkedList<Well>();
        list.add(this.well);
        try {
            dialog = new DialogSelectVersion(this.parentFrame, true, this.sbdb, true, list.iterator());
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening Version dialog", e, this.sbdb);
            return null;
        }
        dialog.setLocationRelativeTo(this.parentFrame);
        dialog.setVisible(true);
        if (dialog.selection == null || dialog.selection.isEmpty()) {
            return null;
        }
        InterpHdr newInterp = dialog.selection.get(0);
        if (newInterp == current.getHeader()) {
            JOptionPane.showMessageDialog(this, "Cannot " + (move ? "move" : "copy") + " to the current version.", this.parentFrame.getTitle(), 2);
            return null;
        }
        return newInterp;
    }

    private void fillHierarchy(JTable jTable, ZonesTableModel tableModel) {
        if (jTable.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select at least one interval", this.parentFrame.getTitle(), 1);
            return;
        }
        LinkedList<IGDIntervalZone> list = new LinkedList<IGDIntervalZone>();
        int[] selectedRows = jTable.getSelectedRows();
        int schemeID = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            IGDIntervalZone zone = tableModel.getZones().get(jTable.convertRowIndexToModel(selectedRows[i]));
            if (schemeID == 0) {
                schemeID = zone.getSchID();
            } else if (zone.getSchID() != schemeID) {
                JOptionPane.showMessageDialog(this.parentFrame, "You must select intervals which belong to the same scheme", this.parentFrame.getTitle(), 1);
                return;
            }
            list.add(zone);
        }
        try {
            DialogFillHierarchy dialog = new DialogFillHierarchy(this.parentFrame, true, this.well, this.getInterp(), this.sbdb.getIGDScheme(schemeID), list);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.setSelectedZones(jTable, tableModel, dialog.toAdd);
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    private void setSelectedZones(JTable jTable, ZonesTableModel tableModel, List<IGDIntervalZone> list) {
        for (IGDIntervalZone newZone : list) {
            int index = -1;
            for (int i = 0; i < tableModel.getZones().size(); ++i) {
                IGDIntervalZone z = tableModel.getZones().get(i);
                if (!z.getUppInf().equals(newZone.getUppInf())) continue;
                index = i;
                break;
            }
            if (index < 0) continue;
            int sortedIndex = jTable.convertRowIndexToView(index);
            jTable.addRowSelectionInterval(sortedIndex, sortedIndex);
        }
    }

    private void copyPalenv(boolean toDelete) {
        int nRows = this.jTableEnv.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select interval(s) to move", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            WellInterp wellInterp = this.getInterp();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
                return;
            }
            InterpHdr newInterp = this.getCopyVersion(wellInterp, toDelete);
            if (newInterp == null) {
                return;
            }
            LinkedList<IGDIntervalEnv> toMove = new LinkedList<IGDIntervalEnv>();
            for (int row : this.jTableEnv.getSelectedRows()) {
                toMove.add(this.tableModelEnv.envs.get(this.jTableEnv.convertRowIndexToModel(row)));
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            List<IGDIntervalEnv> list = newWellInterp.getEnvs();
            for (IGDIntervalEnv zone : toMove) {
                for (IGDIntervalEnv newInterpZone : list) {
                    newWellInterp.checkOverlap(zone.getTopSample(), zone.getBaseSample(), newInterpZone);
                }
            }
            for (IGDIntervalEnv zone : toMove) {
                if (toDelete) {
                    wellInterp.moveEnv(this.well, zone, newWellInterp);
                } else {
                    wellInterp.copyEnv(this.well, zone, newWellInterp);
                }
                this.sbdb.commit();
            }
            this.jTableEnv.clearSelection();
            this.checkVersionInCombo(wellInterp, newWellInterp);
            wellInterp.notifyObservers(5);
            newWellInterp.notifyObservers(5);
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    private void copyBiocom(boolean deleteOriginal) {
        if (this.jTableComments.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            WellInterp wellInterp = this.getInterp();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
                return;
            }
            InterpHdr newInterp = this.getCopyVersion(wellInterp, deleteOriginal);
            if (newInterp == null) {
                return;
            }
            LinkedList<Biocom> toMove = new LinkedList<Biocom>();
            for (int row : this.jTableComments.getSelectedRows()) {
                toMove.add(this.tableModelBiocom.comments.get(this.jTableComments.convertRowIndexToModel(row)));
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            this.well.loadInterp(newWellInterp);
            List<Biocom> list = newWellInterp.getComments();
            for (Biocom biocom : toMove) {
                for (Biocom newInterpBiocom : list) {
                    if (biocom.getTopID() != newInterpBiocom.getTopID() || biocom.getDiscID() != newInterpBiocom.getDiscID() || biocom.getAnalyst() != newInterpBiocom.getAnalyst()) continue;
                    JOptionPane.showMessageDialog(this, "Cannot copy/move comment(s): a comment already exists at " + biocom.getTopSample().toString() + "/" + biocom.getAnalystString(), this.parentFrame.getTitle(), 1);
                    return;
                }
            }
            for (Biocom biocom : toMove) {
                if (deleteOriginal) {
                    wellInterp.moveBiocom(this.well, biocom, newWellInterp);
                } else {
                    wellInterp.copyBiocom(this.well, biocom, newWellInterp);
                }
                this.sbdb.commit();
            }
            this.jTableComments.clearSelection();
            this.checkVersionInCombo(wellInterp, newWellInterp);
            wellInterp.notifyObservers(toMove.get(0));
            newWellInterp.notifyObservers(toMove.get(0));
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    private void copyIntcoms(boolean move) {
        if (this.jTableIntComments.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.parentFrame.getTitle(), 1);
            return;
        }
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        InterpHdr newInterp = this.getCopyVersion(wellInterp, move);
        if (newInterp == null) {
            return;
        }
        LinkedList<Intcom> toMove = new LinkedList<Intcom>();
        for (int row : this.jTableIntComments.getSelectedRows()) {
            toMove.add(this.tableModelIntervalComments.comments.get(this.jTableIntComments.convertRowIndexToModel(row)));
        }
        if (toMove.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            this.well.loadInterp(newWellInterp);
            for (Intcom intcom : toMove) {
                try {
                    wellInterp.copyIntcom(this.well, intcom, newWellInterp, move);
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot " + (move ? "move" : "copy"), 2);
                    continue;
                }
                this.sbdb.commit();
            }
            this.jTableIntComments.clearSelection();
            this.checkVersionInCombo(wellInterp, newWellInterp);
            wellInterp.notifyObservers(toMove.get(0));
            newWellInterp.notifyObservers(toMove.get(0));
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error copying/moving interval comment", ex, this.sbdb);
        }
        catch (SBException e) {
            StackError.showStackError((String)"Error moving copying/interval comment", (Throwable)e);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void copyLOC(boolean deleteOriginal) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            LOC original = wellInterp.getLOC();
            if (original == null) {
                JOptionPane.showMessageDialog(this, "No depth/age curve exists in the current version.", this.parentFrame.getTitle(), 1);
                return;
            }
            InterpHdr newInterp = this.getCopyVersion(wellInterp, deleteOriginal);
            if (newInterp == null) {
                return;
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            if (newWellInterp.getLOC() == null && this.jTableLOC.getSelectedRows().length == 1) {
                JOptionPane.showMessageDialog(this, "You need to select at least 2 nodes to copy.", "Depth/age copy", 2);
                return;
            }
            if (this.jTableLOC.getSelectedRows().length == 0) {
                if (JOptionPane.showConfirmDialog(this, "No nodes selected, copy all?", "Depth/age copy", 0, 3) == 1) {
                    return;
                }
                this.jTableLOC.selectAll();
            }
            LinkedList<LOCNode> toMove = new LinkedList<LOCNode>();
            for (int row : this.jTableLOC.getSelectedRows()) {
                toMove.add(this.tableModelLOC.getLOC().getNode(this.jTableLOC.convertRowIndexToModel(row)));
            }
            if (newWellInterp.getLOC() != null && newWellInterp.getLOC().getSize() > 0) {
                Object object = toMove.iterator();
                while (object.hasNext()) {
                    LOCNode node = (LOCNode)object.next();
                    LOC loc = newWellInterp.getLOC();
                    Iterator<LOCNode> it = loc.getNodeIterator();
                    while (it.hasNext()) {
                        LOCNode n = it.next();
                        if (n.compareTo((Object)node) != 0) continue;
                        JOptionPane.showMessageDialog(this, "A depth/age curve node: " + DepthUtils.convFromM((double)node.getDepth(), (char)this.units) + "/" + node.getAge() + " already exists in the selected version.\nDelete all or part of this depth/age curve first.", this.parentFrame.getTitle(), 1);
                        return;
                    }
                }
            }
            if (newWellInterp.getLOC() == null) {
                newWellInterp.addLOC(this.well, this.sbdb.getCompositeStandard(original.getStdIDPref()), ((LOCNode)toMove.getFirst()).getAge(), ((LOCNode)toMove.getFirst()).getDepth(), ((LOCNode)toMove.getLast()).getAge(), ((LOCNode)toMove.getLast()).getDepth(), false);
            }
            LOC loc = newWellInterp.getLOC();
            Iterator<LOCNode> it = wellInterp.getLOC().getNodeIterator();
            for (LOCNode node : toMove) {
                try {
                    newWellInterp.addLOCNode(node.getBnd(), node.getDepth(), node.getAge(), this.well.getWellID());
                }
                catch (InvalidFieldException e) {
                    LOGGER.log(Level.FINE, "Invalid node found while trying to insert node: " + String.valueOf(node), e);
                }
            }
            if (deleteOriginal) {
                wellInterp.deleteLOC(this.well.getWellID());
                wellInterp.notifyObservers((Object)original);
            }
            this.sbdb.commit();
            this.checkVersionInCombo(wellInterp, newWellInterp);
            newWellInterp.notifyObservers((Object)newWellInterp.getLOC());
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error copying/moving LOC", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error copying/moving LOC", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void showColMap(int igdType) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            DialogIGDColmap dialog = new DialogIGDColmap(this.parentFrame, true, this.sbdb, this.well, wellInterp, igdType);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error opening Column Mapping dialog", sqle, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void saveOW(int igdType) {
        if (!this.canExport()) {
            return;
        }
        LinkedList<IGDIntervalZone> zones = new LinkedList();
        switch (igdType) {
            case 3: {
                zones = this.tableModelChrono.getZones();
                break;
            }
            case 2: {
                zones = this.tableModelLstrat.getZones();
                break;
            }
            case 4: {
                zones = this.tableModelBiozones.getZones();
            }
        }
        if (zones.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No data to save", "Save intervals", 1);
            return;
        }
        File file = FileChooserUtils.saveAsGridDataDialog((Component)this, (String)Lastval.tryGetString(this.sbdb, "WINOWCSV2", "UNXOWCSV2"), (String)SB.makeFileName((String)(this.well.getWellCode() + "_" + IGDInterval.getIGDName(igdType).toLowerCase())));
        if (file == null) {
            return;
        }
        DialogIGDZoneExportOptions dlg = new DialogIGDZoneExportOptions((Frame)((JFrame)this.getRootPane().getParent()), true, file);
        if (dlg.showDialog(this) == DialogIGDZoneExportOptions.Response.Export) {
            GridBuilderIGDZones builder = new GridBuilderIGDZones();
            builder.setUseCoreSampleCorrections(dlg.getUseCoreSampleCorrections());
            builder.setUseCuttingSampleCorrections(dlg.getUseCuttingSampleCorrections());
            Object[][] data = switch (dlg.getSelectedFormat()) {
                case DialogIGDZoneExportOptions.Format.ExtendedOpenWorksGrid -> builder.exportZonesToExtendedOpenWorksStyleGrid(this.well, zones, this.units);
                case DialogIGDZoneExportOptions.Format.OpenWorksGrid -> builder.exportZonesToOpenWorksStyleGrid(this.well, zones, this.units);
                default -> builder.exportZonesToStandardGrid(this.well, zones, this.units);
            };
            GridWriter gw = new GridWriter();
            gw.setCSVOptions(dlg.getCSVExportOptions());
            gw.getXLSOptions().setSheetName(this.well.getWellName());
            gw.getXLSOptions().setAuthorName(this.sbdb.getUser().getName());
            File f = dlg.getSelectedFile();
            if (!FileOverwriteCheck.checkForGridFileOverwriting((JFrame)this.getRootPane().getParent(), (Component)this, f, gw)) {
                return;
            }
            try {
                gw.write(f, data);
            }
            catch (IOException ex) {
                StackError.showStackError((String)("Error writing IGD Zones to file: " + f.getName()), (Throwable)ex);
            }
            Lastval.tryPutString(this.sbdb, "WINOWCSV2", "UNXOWCSV2", f.getPath());
            JOptionPane.showMessageDialog(this, "File '" + file.getName() + "' saved.", "Export Zones", 1);
        }
        dlg.dispose();
    }

    private void saveOWSQPicks() {
        if (!this.canExport()) {
            return;
        }
        List picks = this.tableModelSQPicks.getItems();
        if (picks.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No picks to save", "Save picks", 2);
            return;
        }
        String fileName = SB.makeFileName((String)(this.well.getWellCode() + "_picks"));
        File file = FrameJsbugs.chooseFile(this.sbdb, this.parentFrame, "WINOWPICKS", "UNXOWPICKS", new String[]{"csv"}, new String[]{"CSV"}, fileName);
        if (file == null) {
            return;
        }
        String delim = ",";
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            FileWriter out = new FileWriter(file.getPath());
            boolean useCoreCorrections = false;
            boolean useCuttingCorrections = false;
            boolean askCores = false;
            boolean askCuttings = false;
            for (SQPick pick : picks) {
                if (pick.getSample().getType() == SampleType.CO && !askCores) {
                    askCores = true;
                    option = JOptionPane.showConfirmDialog(this, "Do you want to output core-corrected depths for core samples?", "Save Picks", 0, 3);
                    if (option == 0) {
                        useCoreCorrections = true;
                    }
                } else if (pick.getSample().getType() == SampleType.CU && !askCuttings) {
                    askCuttings = true;
                    option = JOptionPane.showConfirmDialog(this, "Do you want to output core-corrected depths for cuttings?", "Save Picks", 0, 3);
                    if (option == 0) {
                        useCuttingCorrections = true;
                    }
                }
                out.write(pick.getQualifier() + pick.getInfName() + delim + pick.getSurface().toString() + delim + SB.floatString((double)this.well.getDepth(pick.getSample(), this.units, useCoreCorrections, useCuttingCorrections), (int)2) + delim + pick.getSample().getTypeString() + delim + pick.getBnd() + "\n");
            }
            out.close();
            JOptionPane.showMessageDialog(this, "File written.", "Save Picks", 1);
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error writing file", (Throwable)e);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private boolean canExport() {
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", "Export Data", 2);
            return false;
        }
        return true;
    }

    void putTableColumnWidthsAndOrder() throws SQLException {
        for (TablePair pair : this.getAllTablePairs()) {
            pair.model.putTableColumnWidths(this.sbdb, pair.table);
            pair.model.putTableColumnOrder(this.sbdb, pair.table);
        }
    }

    private void moveZones(JTable table, ZonesTableModel model, boolean toDelete) {
        int nRows = table.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select interval(s) to " + (toDelete ? "move" : "copy"), this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getInterp();
        InterpHdr newInterp = this.getCopyVersion(wellInterp, toDelete);
        if (newInterp == null) {
            return;
        }
        try {
            int igdType;
            LinkedList<IGDIntervalZone> toMove = new LinkedList<IGDIntervalZone>();
            for (int row : table.getSelectedRows()) {
                toMove.add(model.getZones().get(table.convertRowIndexToModel(row)));
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            List<IGDIntervalZone> list = newWellInterp.getIGDList(igdType, (igdType = ((IGDIntervalZone)toMove.get(0)).getIGDType()) == 4 ? ((IGDIntervalZone)toMove.get(0)).getSchID() : 0);
            for (IGDIntervalZone zone : toMove) {
                for (IGDIntervalZone newInterpZone : list) {
                    newWellInterp.checkOverlap(IGDIntervalZone.Builder.copyOf(zone), newInterpZone, true);
                }
            }
            for (IGDIntervalZone zone : toMove) {
                igdType = zone.getIGDType();
                if (toDelete) {
                    wellInterp.moveZone(this.well, zone, newWellInterp);
                } else {
                    wellInterp.copyZone(this.well.getWellID(), zone, newWellInterp);
                }
                this.sbdb.commit();
            }
            table.clearSelection();
            this.checkVersionInCombo(wellInterp, newWellInterp);
            wellInterp.notifyObservers(igdType);
            newWellInterp.notifyObservers(igdType);
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), (toDelete ? "Move" : "Copy") + " Intervals", 2);
            ife.printStackTrace();
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    void checkVersionInCombo(WellInterp selectedWellInterp, WellInterp wellInterp) {
        boolean found = false;
        for (int i = 0; i < this.jComboBoxVersion.getItemCount(); ++i) {
            if (!(this.jComboBoxVersion.getItemAt(i) instanceof WellInterp) || wellInterp != this.jComboBoxVersion.getItemAt(i)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.well.fillInterpCombo(this.jComboBoxVersion);
            if (selectedWellInterp != null) {
                this.jComboBoxVersion.setSelectedItem(selectedWellInterp);
            }
        }
    }

    void setVersion(InterpHdr header, boolean force) {
        int start;
        if (!force && this.jComboBoxVersion.getSelectedIndex() != 0) {
            return;
        }
        for (int i = start = this.jComboBoxVersion.getItemAt(0).equals(SELECT_STRING) ? 1 : 0; i < this.jComboBoxVersion.getItemCount(); ++i) {
            WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getItemAt(i);
            if (wellInterp.getHeader() != header) continue;
            LOGGER.log(Level.CONFIG, "In JPanelWellInterp.setVersion: Set interp for well: " + String.valueOf(this.well));
            this.jComboBoxVersion.setSelectedItem(wellInterp);
            break;
        }
    }

    private void setTableSelection(Object arg, JTable table, List list) {
        int index = list.indexOf(arg);
        if (index >= 0) {
            int viewIndex = table.convertRowIndexToView(index);
            table.setRowSelectionInterval(viewIndex, viewIndex);
            table.scrollRectToVisible(table.getCellRect(viewIndex, 0, true));
        }
    }

    TableModelSB getSelectedTable() {
        Component c = this.jTabbedPaneInterpretations.getSelectedComponent();
        if (c == this.jPanelChrono) {
            return this.tableModelChrono;
        }
        if (c == this.jPanelLStrat) {
            return this.tableModelLstrat;
        }
        if (c == this.jPanelBiozones) {
            return this.tableModelBiozones;
        }
        if (c == this.jPanelComments) {
            return this.tableModelBiocom;
        }
        if (c == this.jPanelEvents) {
            return this.tableModelEvents;
        }
        if (c == this.jPanelIntComments) {
            return this.tableModelIntervalComments;
        }
        if (c == this.jPanelSQPick) {
            return this.tableModelSQPicks;
        }
        if (c == this.jPanelEnv) {
            return this.tableModelEnv;
        }
        if (c == this.jPanelLOC) {
            return this.tableModelLOC;
        }
        if (c == this.jPanelFaults) {
            return this.tableModelFaults;
        }
        if (c == this.panelInterpSampleAge) {
            return this.panelInterpSampleAge.getTableModel();
        }
        return null;
    }

    private List<TablePair> getAllTablePairs() {
        List<TablePair> allPairs = Arrays.asList(new TablePair(this.tableModelChrono, this.jTableChrono), new TablePair(this.tableModelLstrat, this.jTableLStrat), new TablePair(this.tableModelBiozones, this.jTableBiozones), new TablePair(this.tableModelBiocom, this.jTableComments), new TablePair(this.tableModelEvents, this.jTableEvents), new TablePair(this.tableModelIntervalComments, this.jTableIntComments), new TablePair(this.tableModelEnv, this.jTableEnv), new TablePair(this.tableModelSQPicks, this.jTableSQPicks), new TablePair(this.tableModelLOC, this.jTableLOC), new TablePair(this.tableModelFaults, this.jTableFaults), new TablePair(this.panelInterpSampleAge.getTableModel(), this.panelInterpSampleAge.getTable()));
        return allPairs;
    }

    LinkedList<TablePair> getTablePair(TableModelSB model) {
        LinkedList<TablePair> tables = new LinkedList<TablePair>();
        for (TablePair pair : this.getAllTablePairs()) {
            if (!pair.model.equals(model)) continue;
            tables.add(pair);
        }
        return tables;
    }

    private void setAgeFormatTable(AgeFormat af) {
        if (this.tableModelLOC.getAgeFormat() != af) {
            this.tableModelLOC.setAgeFormat(af);
            this.tableModelLOC.updateCellEditors(this.jTableLOC);
            this.tableModelLOC.fireTableDataChanged();
        }
    }

    private void setAgeFormatButton(AgeFormat af) {
        switch (af) {
            case MA: {
                this.jRadioButtonAgeFormatMA.setSelected(true);
                break;
            }
            case KA: {
                this.jRadioButtonAgeFormatKa.setSelected(true);
            }
        }
    }

    public void setDisplayCuttingCorrections(boolean value) {
        if (this.tableModelBiozones instanceof ZonesTableModelWithCorrected) {
            ((ZonesTableModelWithCorrected)this.tableModelBiozones).setDisplayCuttingCorrections(value);
        }
        if (this.tableModelChrono instanceof ZonesTableModelWithCorrected) {
            ((ZonesTableModelWithCorrected)this.tableModelChrono).setDisplayCuttingCorrections(value);
        }
        if (this.tableModelLstrat instanceof ZonesTableModelWithCorrected) {
            ((ZonesTableModelWithCorrected)this.tableModelLstrat).setDisplayCuttingCorrections(value);
        }
        if (this.tableModelEvents instanceof EventsTableModelWithCorrection) {
            ((EventsTableModelWithCorrection)this.tableModelEvents).setDisplayCuttingCorrections(value);
        }
        if (this.tableModelBiocom instanceof BiocomTableModelWithCorrection) {
            ((BiocomTableModelWithCorrection)this.tableModelBiocom).setDisplayCuttingCorrections(value);
        }
        if (this.tableModelSQPicks instanceof SQPickTableModelWithCorrections) {
            ((SQPickTableModelWithCorrections)this.tableModelSQPicks).setDisplayCuttingCorrections(value);
        }
    }

    int getSelectedTabDataType() {
        Component c = this.jTabbedPaneInterpretations.getSelectedComponent();
        if (c == this.jPanelChrono) {
            return 10;
        }
        if (c == this.jPanelLStrat) {
            return 12;
        }
        if (c == this.jPanelBiozones) {
            return 11;
        }
        if (c == this.jPanelComments) {
            return 3;
        }
        if (c == this.jPanelEvents) {
            return 16;
        }
        if (c == this.jPanelIntComments) {
            return 18;
        }
        if (c == this.jPanelSQPick) {
            return 14;
        }
        if (c == this.jPanelEnv) {
            return 15;
        }
        if (c == this.jPanelLOC) {
            return 17;
        }
        if (c == this.jPanelFaults) {
            return 27;
        }
        if (c == this.panelInterpSampleAge) {
            return 29;
        }
        throw new IllegalStateException("Unknown panel selection");
    }

    void setSelectedTab(int dataType) {
        JPanel c = null;
        switch (dataType) {
            case 10: {
                c = this.jPanelChrono;
                break;
            }
            case 12: {
                c = this.jPanelLStrat;
                break;
            }
            case 11: {
                c = this.jPanelBiozones;
                break;
            }
            case 3: {
                c = this.jPanelComments;
                break;
            }
            case 16: {
                c = this.jPanelEvents;
                break;
            }
            case 18: {
                c = this.jPanelIntComments;
                break;
            }
            case 14: {
                c = this.jPanelSQPick;
                break;
            }
            case 15: {
                c = this.jPanelEnv;
                break;
            }
            case 17: {
                c = this.jPanelLOC;
                break;
            }
            case 27: {
                c = this.jPanelFaults;
                break;
            }
            case 29: {
                c = this.panelInterpSampleAge;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown panel selection");
            }
        }
        this.jTabbedPaneInterpretations.setSelectedComponent(c);
    }

    private class EventsPanel
    extends JPanel
    implements TaxonDropTarget,
    Observer {
        Sample sample;
        final /* synthetic */ JPanelWellInterp this$0;

        private EventsPanel(JPanelWellInterp jPanelWellInterp) {
            JPanelWellInterp jPanelWellInterp2 = jPanelWellInterp;
            Objects.requireNonNull(jPanelWellInterp2);
            this.this$0 = jPanelWellInterp2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptTransfer(Transferable transferable) {
            block18: {
                try {
                    this.this$0.getInterp().addObserver(this);
                    this.sample = this.this$0.parentPanel.getSelectedSample();
                    if (transferable.isDataFlavorSupported(TaxonTransferHandler.eventFlavour)) {
                        Collection events = (Collection)transferable.getTransferData(TaxonTransferHandler.eventFlavour);
                        for (SBEvent event : events) {
                            if (this.importEvent(event)) continue;
                            return;
                        }
                        break block18;
                    }
                    Collection taxa = (Collection)transferable.getTransferData(TaxonTransferHandler.taxonFlavour);
                    if (taxa.size() > 1 && JOptionPane.showConfirmDialog(this.this$0, "You have selected " + taxa.size() + " taxa.\nContinue importing?", "Create Events", 0) != 0) {
                        return;
                    }
                    for (Taxon taxon : taxa) {
                        SBEvent event;
                        List<SBEvent> events = this.this$0.sbdb.getSBEvents(taxon.getSpecID());
                        if (events.isEmpty()) {
                            dialog = new DialogEvent(this.this$0.parentFrame, true, this.this$0.sbdb, null, taxon);
                            dialog.setLocationRelativeTo((Component)this);
                            dialog.setVisible(true);
                            if (dialog.sbEvent == null) {
                                return;
                            }
                            event = dialog.sbEvent;
                        } else if (events.size() == 1) {
                            event = events.get(0);
                        } else {
                            dialog = new DialogSelectEvent((Frame)this.this$0.parentFrame, true, this.this$0.sbdb, events);
                            dialog.setLocationRelativeTo((Component)this.this$0.parentFrame);
                            dialog.setVisible(true);
                            if (dialog.selection == null) continue;
                            event = dialog.selection;
                        }
                        if (this.importEvent(event)) continue;
                        return;
                    }
                }
                catch (UnsupportedFlavorException | IOException | SQLException | SBException e) {
                    FrameJsbugs.showStackError("Error", (Exception)e, this.this$0.sbdb);
                }
                finally {
                    this.this$0.getInterp().deleteObserver(this);
                    this.sample = null;
                }
            }
        }

        private boolean importEvent(SBEvent event) throws SQLException, SBException {
            String msg = this.this$0.getInterp().checkEventPicked(event);
            if (msg != null && JOptionPane.showConfirmDialog(this.this$0.parentPanel, msg + "\nAdd this event?\n", "Pick Event", 0) != 0) {
                return true;
            }
            DialogWellEvent dialog = new DialogWellEvent(this.this$0.parentFrame, true, this.this$0.sbdb, this.this$0.parentPanel.well, this.this$0.getInterp(), this.this$0.parentPanel.well.getWellUnits(), null, this.sample, event, null);
            dialog.setLocationRelativeTo(this.this$0.parentFrame);
            dialog.setVisible(true);
            return dialog.isOK();
        }

        @Override
        public void update(Observable o, Object arg) {
            if (o == this.this$0.getInterp() && arg instanceof WellEvent) {
                this.sample = ((WellEvent)arg).getSample();
            }
        }
    }
}

