/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import javax.activation.MimetypesFileTypeMap;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class OrganiserTransferHandler
extends TransferHandler {
    static final MimetypesFileTypeMap mtftp = new MimetypesFileTypeMap();
    private final FileImportAction doImportAction;

    public OrganiserTransferHandler(FileImportAction doImportAction) {
        this.doImportAction = doImportAction;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        for (DataFlavor flavor : info.getDataFlavors()) {
            if (!flavor.equals(DataFlavor.javaFileListFlavor) || !info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) continue;
            try {
                Iterable list = (Iterable)info.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    String mimetype = mtftp.getContentType(file);
                    if (!mimetype.equals("sbugsfile")) continue;
                    return true;
                }
            }
            catch (InvalidDnDOperationException dnde) {
                System.out.println("Ignoring DnD exception");
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        if (!info.isDrop()) {
            return false;
        }
        if (!this.canImport(info)) {
            info.getComponent().getToolkit().beep();
            return false;
        }
        if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                Iterable list = (Iterable)info.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    String mimetype = mtftp.getContentType(file);
                    if (!mimetype.equals("sbugsfile")) continue;
                    this.doImportAction.importFile(file);
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000000;
    }

    static {
        mtftp.addMimeTypes("sbugsfile sbg dex");
    }

    public static abstract class FileImportAction {
        public abstract void importFile(File var1);
    }
}

