/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.image.ImageSet;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.sound.sampled.Clip;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.FrameSamples;
import jsbugs.JPanelWell;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Overlay;
import model3.SBdb;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import util.ImageUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class OverlayWebServer
extends Thread {
    private int port;
    private String clientString = null;
    FrameSamples parent;
    JPanelWell wellPanel;
    Overlay overlay;
    SBdb sbdb;
    boolean needsRefresh = false;
    int tableTextSize;
    boolean useSounds;
    String[] controlLabels = new String[]{"Marker", "Caved", "Reworked", "Questionable", "OutsideCount"};
    boolean[] controlOption = new boolean[]{false, false, false, false, false};
    String subjAbund = null;
    final int MKR = 0;
    final int CV = 1;
    final int RW = 2;
    final int QUESTION = 3;
    final int OUTSIDECOUNT = 4;
    ServerSocket serversocket = null;
    int counts = 0;
    private Clip soundClip;
    private boolean deleteEntry = false;
    private boolean sampleTotalMessage = false;
    private boolean showImages = false;
    private boolean showTotals = false;
    private UndoableEditSupport undoSupport = new UndoableEditSupport();

    public OverlayWebServer(int listen_port, int tableTextSize, boolean useSounds, SBdb sbdb, FrameSamples parent, JPanelWell wellPanel, Overlay overlay) {
        this.port = listen_port;
        this.tableTextSize = tableTextSize;
        this.useSounds = useSounds;
        this.sbdb = sbdb;
        this.overlay = overlay;
        this.parent = parent;
        this.wellPanel = wellPanel;
        this.start();
    }

    private void s(String s2) {
        System.out.print(s2);
    }

    void setWellPanel(JPanelWell jpanelWell) {
        this.wellPanel = jpanelWell;
    }

    public void close() {
        if (this.serversocket != null) {
            try {
                this.s("\nClosing server socket...");
                this.serversocket.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        try {
            this.s("Trying to bind to localhost on port " + Integer.toString(this.port) + "...");
            this.serversocket = new ServerSocket(this.port);
        }
        catch (Exception e) {
            this.s("\nFatal Error:" + e.getMessage());
            e.printStackTrace();
            return;
        }
        this.s("OK!\n");
        while (true) {
            try {
                while (true) {
                    this.s("\nWaiting for accept..");
                    Socket connectionsocket = this.serversocket.accept();
                    InetAddress client = connectionsocket.getInetAddress();
                    if (this.clientString == null) {
                        this.clientString = client.getHostAddress();
                    }
                    this.s("\nConnected to server.");
                    BufferedReader input = new BufferedReader(new InputStreamReader(connectionsocket.getInputStream()));
                    DataOutputStream output = new DataOutputStream(connectionsocket.getOutputStream());
                    boolean rejectRequest = false;
                    if (!this.clientString.equalsIgnoreCase(client.getHostAddress())) {
                        this.s("\nWARNING: Rejecting client request from device: " + client.getHostName());
                        rejectRequest = true;
                    }
                    this.http_handler(input, output, rejectRequest);
                }
            }
            catch (SocketException se) {
                this.s("\nSocket closed - exiting read loop");
            }
            catch (Exception e) {
                this.s("\nError:" + e.getMessage());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void http_handler(BufferedReader input, DataOutputStream output, boolean rejectRequest) {
        int method = 0;
        String request = new String();
        try {
            if (rejectRequest) {
                try {
                    output.writeBytes(this.construct_http_header(403, 0));
                    output.close();
                    return;
                }
                catch (Exception e3) {
                    this.s("error: " + e3.getMessage());
                }
            }
            if (input != null) {
                String tmp;
                String tmp2 = tmp = input.readLine();
                this.s("\nRequest received is: " + tmp2);
                if (tmp2 == null) {
                    return;
                }
                if (tmp.startsWith("GET")) {
                    method = 1;
                }
                if (tmp.startsWith("HEAD")) {
                    method = 0;
                }
                if (tmp.startsWith("POST")) {
                    method = 2;
                }
                if (method == 0) {
                    try {
                        output.writeBytes(this.construct_http_header(501, 0));
                        output.close();
                        return;
                    }
                    catch (Exception e3) {
                        this.s("\nerror: " + e3.getMessage());
                    }
                }
                int start = 0;
                int end = 0;
                for (int a = 0; a < tmp2.length(); ++a) {
                    if (tmp2.charAt(a) == ' ' && start != 0) {
                        end = a;
                        break;
                    }
                    if (tmp2.charAt(a) != ' ' || start != 0) continue;
                    start = a;
                }
                request = tmp2.substring(start + 2, end);
            }
        }
        catch (Exception e) {
            this.s("\nException in httphandler: " + e.toString());
            e.printStackTrace();
        }
        try {
            if (request == null || request.isEmpty() || request.equals("?")) {
                int b;
                output.writeBytes(this.construct_http_header(200, 4));
                InputStream headerFile = this.getClass().getResourceAsStream("/resources/html/OverlayHeader.html");
                while ((b = headerFile.read()) != -1) {
                    output.write(b);
                }
                headerFile.close();
                this.writeOverlayHTML(output);
                output.writeBytes("</html>");
                this.needsRefresh = false;
                output.close();
                return;
            }
            this.s("\nClient requested:" + request + "\n");
            if (!this.needsRefresh) {
                switch (method) {
                    case 2: {
                        this.s("\nWriting post request to server");
                        output.writeBytes(this.construct_http_header(200, 5));
                        this.s("\nWritten header");
                        if (request.equals("NextSmpdtl")) {
                            this.s("\nNext sample requested");
                            if (this.wellPanel == null) break;
                            try {
                                this.wellPanel.nextOcc(true);
                                this.sampleTotalMessage = false;
                                output.writeBytes("OK");
                            }
                            catch (SBException ex) {
                                output.writeBytes(ex.getMessage());
                            }
                            break;
                        }
                        if (request.equals("PreviousSmpdtl")) {
                            this.s("\nPrevious sample requested");
                            if (this.wellPanel == null) break;
                            try {
                                this.wellPanel.nextOcc(false);
                                this.sampleTotalMessage = false;
                                output.writeBytes("OK");
                            }
                            catch (SBException ex) {
                                output.writeBytes(ex.getMessage());
                            }
                            break;
                        }
                        if (request.equals("DeleteEntry")) {
                            this.deleteEntry = true;
                            break;
                        }
                        if (request.equals("ToggleImages")) {
                            this.showImages = !this.showImages;
                            break;
                        }
                        if (request.equals("ToggleTotals")) {
                            this.showTotals = !this.showTotals;
                            break;
                        }
                        if (request.startsWith("ABN-")) {
                            boolean wasAbn = false;
                            if (this.parent.isNumeric()) {
                                output.writeBytes("Press refresh");
                                break;
                            }
                            AbundanceScheme abnScheme = this.parent.getAbnScheme();
                            if (abnScheme != null) {
                                for (int i = 0; i < abnScheme.getEntryCount(); ++i) {
                                    if (!request.equals("ABN-" + String.valueOf(abnScheme.getEntry(i)))) continue;
                                    this.subjAbund = abnScheme.getEntry(i).abr();
                                    wasAbn = true;
                                    break;
                                }
                            }
                            if (wasAbn) break;
                        }
                        boolean wasControl = false;
                        for (int i = 0; i < this.controlLabels.length; ++i) {
                            if (!request.equals(this.controlLabels[i])) continue;
                            output.writeBytes(this.processControlClick(request, i));
                            wasControl = true;
                            break;
                        }
                        if (wasControl) break;
                        try {
                            this.counts = Integer.parseInt(request);
                        }
                        catch (NumberFormatException i) {
                            if (this.wellPanel == null || this.wellPanel.getSmpdtl() == null) break;
                            output.writeBytes(this.processCellClick(request));
                            this.s("\nWritten cell content");
                        }
                        break;
                    }
                    case 1: {
                        int typeImageSetID;
                        int specID;
                        if (!request.endsWith(".jpg") || (specID = Integer.parseInt(request.substring(0, request.indexOf(46)))) <= 0 || (typeImageSetID = this.sbdb.getTaxonImageService().getTypeImageSetID(specID)) <= 0) break;
                        this.s("Writing image");
                        ImageSet imageSet = new ImageSet(typeImageSetID);
                        Image image = imageSet.getFirstImage(this.sbdb.getImageRecordService(), this.sbdb.getImageLoader(), new Dimension(35, 35));
                        BufferedImage bi = ImageUtils.convertImageToBufferedImage((Image)image);
                        if (!ImageIO.write((RenderedImage)bi, "jpg", output)) {
                            throw new SBException("Error writing image");
                        }
                        output.writeBytes(this.construct_http_header(200, 2));
                        this.s("Written image");
                    }
                }
            } else {
                this.s("\nREFRESH REQUIRED");
                output.writeBytes(this.construct_http_header(200, 5));
                output.writeBytes("<font color=\"red\">REFRESH PAGE</font>");
            }
            output.close();
        }
        catch (Exception e) {
            StackError.showStackError((String)e.toString(), (Throwable)e);
            this.s("\nError in request body: " + e.toString());
            e.printStackTrace();
        }
    }

    private String construct_http_header(int return_code, int file_type) {
        Object s = "HTTP/1.1 ";
        switch (return_code) {
            case 200: {
                s = (String)s + "200 OK";
                break;
            }
            case 400: {
                s = (String)s + "400 Bad Request";
                break;
            }
            case 403: {
                s = (String)s + "403 Connection rejected. There is already a connection to this overlay server.";
                break;
            }
            case 404: {
                s = (String)s + "404 Not Found";
                break;
            }
            case 500: {
                s = (String)s + "500 Internal Server Error";
                break;
            }
            case 501: {
                s = (String)s + "501 Not Implemented";
            }
        }
        s = (String)s + "\r\n";
        s = (String)s + "Access-Control-Allow-Origin: *\r\n";
        s = (String)s + "Cache-Control: no-cache\r\n";
        s = (String)s + "Connection: close\r\n";
        s = (String)s + "Server: StrataBugsOverlay v0\r\n";
        switch (file_type) {
            case 0: {
                break;
            }
            case 1: {
                s = (String)s + "Content-Type: image/jpeg\r\n";
                break;
            }
            case 2: {
                s = (String)s + "Content-Type: image/gif\r\n";
            }
            case 3: {
                s = (String)s + "Content-Type: application/x-zip-compressed\r\n";
            }
            default: {
                s = (String)s + "Content-Type: text/html\r\n";
            }
        }
        s = (String)s + "\r\n";
        return s;
    }

    private void writeOverlayHTML(DataOutputStream output) throws IOException, SQLException, SBException {
        output.writeBytes("$(document).ready(function(){");
        for (int i = 0; i < this.controlLabels.length; ++i) {
            String strg = "$('#" + this.controlLabels[i] + "').click(function() {$.post('" + this.controlLabels[i] + "', function(data) {$('#" + this.controlLabels[i] + "').html(data);});})\n";
            output.writeBytes(strg);
        }
        output.writeBytes("\n});");
        output.writeBytes("</script>");
        output.writeBytes("</head><body>");
        output.writeBytes("<h3>" + this.overlay.getName() + "</h3>");
        output.writeBytes("<table>");
        for (int row = 0; row < this.overlay.getRows(); ++row) {
            output.writeBytes("<tr>");
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                output.writeBytes("<td");
                if (this.overlay.getSpecID(row, col) > 0) {
                    String id = "r" + row + "c" + col;
                    if (this.showImages && this.sbdb.getTaxonImageService().hasTypeImage(this.overlay.getTaxon(row, col).getSpecID())) {
                        output.writeBytes(" style=\"background:url('" + this.overlay.getTaxon(row, col).getSpecID() + ".jpg') no-repeat;\"");
                    }
                    output.writeBytes(" class=\"taxon-button\" id='" + id + "'>" + this.getCellContents(this.overlay.getTaxon(row, col)));
                } else {
                    output.writeBytes(">");
                }
                output.writeBytes("</td>");
            }
            output.writeBytes("</tr>");
        }
        output.writeBytes("</table>");
        if (this.parent.isNumeric()) {
            output.writeBytes("<br><form>Add count :<input type='number' id='countsField' onchange='counts()' onclick=\"this.value='';\"></form>");
        } else {
            output.writeBytes("<br>Abundance :<select id='semiQuant' onchange='semiQuant()'> ");
            AbundanceScheme abnScheme = this.parent.getAbnScheme();
            if (abnScheme != null) {
                this.subjAbund = abnScheme.getEntry(0).abr();
                for (int i = 0; i < abnScheme.getEntryCount(); ++i) {
                    output.writeBytes("<option value=\"ABN-" + abnScheme.getEntry(i).abr() + "\">" + abnScheme.getEntry(i).entryName() + "</option>");
                }
            }
            output.writeBytes("</select>");
        }
        output.writeBytes("<button onclick='deleteEntry()'>Delete Entry</button><br>");
        this.writeControlBarTable(output);
        output.writeBytes("<button onclick='refresh()'>Refresh</button>");
        output.writeBytes("<button onclick='next(\"PreviousSmpdtl\")'>Previous Sample</button>");
        output.writeBytes("<button onclick='next(\"NextSmpdtl\")'>Next Sample</button>");
        output.writeBytes("<br><button onclick='toggleImages()'>Toggle Images</button>");
        output.writeBytes("<button onclick='toggleTotals()'>Toggle Totals</button>");
        if (this.wellPanel.getWell() != null) {
            output.writeBytes("<title>StrataBugs Input: " + this.wellPanel.getWell().getWellName());
            if (this.wellPanel.getSmpdtl() != null) {
                output.writeBytes(", " + this.wellPanel.getSmpdtl().getSample().toString());
            }
            output.writeBytes("</title>");
            if (this.wellPanel.getSmpdtl() != null) {
                output.writeBytes("<h3>Sample contents: " + this.wellPanel.getWell().getWellName() + " " + this.wellPanel.getSmpdtl().getSample().toString() + " " + this.wellPanel.getSmpdtl().getAnalystAbr() + "</h3><br>");
                if (this.wellPanel.getSmpdtl().getBarren()) {
                    output.writeBytes("<h3>Barren</h3><br>");
                } else {
                    output.writeBytes("<table>");
                    List<TaxonOcc> occs = this.wellPanel.getSmpdtl().getOccurSorted(Smpdtl.SortOrder.SORT_GENUS);
                    HashMap<String, Integer> totalLabels = new HashMap<String, Integer>();
                    AbundanceScheme scheme = null;
                    try {
                        scheme = this.sbdb.getAbundanceSchemeService().findAbundanceScheme(this.wellPanel.getSmpdtl().getHeader().getAbnSchID()).orElse(null);
                    }
                    catch (RuntimeException sql) {
                        SbugsExceptionHandler.showStackError("Error setting total labels", sql);
                    }
                    for (TaxonOcc taxonOcc : occs) {
                        output.writeBytes("<tr>");
                        output.writeBytes("<td>" + taxonOcc.getTaxon().getCatMnem() + "</td>");
                        output.writeBytes("<td>" + taxonOcc.getTaxon().toString(false, false) + "</td>");
                        output.writeBytes("<td>" + taxonOcc.toAbnString() + "</td>");
                        output.writeBytes("</tr>");
                        if (this.parent.getTotExRwCv() && (taxonOcc.getCaved() || taxonOcc.getReworked())) continue;
                        String mnem = taxonOcc.getTaxon().getCatMnem();
                        int count = taxonOcc.getTotalCount();
                        if (count == 0 && scheme != null) {
                            count += scheme.getCountBySubjAbund(taxonOcc.getSubAbund());
                        }
                        if (count <= 0) continue;
                        if (totalLabels.get(mnem) != null) {
                            count += ((Integer)totalLabels.get(mnem)).intValue();
                        }
                        totalLabels.put(mnem, count);
                    }
                    output.writeBytes("</table>");
                    output.writeBytes("<h4>Category Totals (excl. Cv & Rw)</h4><br>");
                    output.writeBytes("<table>");
                    for (Map.Entry entry : totalLabels.entrySet()) {
                        output.writeBytes("<tr>");
                        output.writeBytes("<td>" + (String)entry.getKey() + "</td>");
                        output.writeBytes("<td>" + String.valueOf(entry.getValue()) + "</td>");
                        output.writeBytes("</tr>");
                    }
                    output.writeBytes("</table>");
                }
            }
        }
        output.writeBytes("</body>");
    }

    private String processControlClick(String request, int controlIndex) {
        this.s("\nIn process control click: request is: " + request);
        this.controlOption[controlIndex] = !this.controlOption[controlIndex];
        return "<font color='" + (this.controlOption[controlIndex] ? "red" : "black") + "'><b>" + request + "</b></font>";
    }

    private String processCellClick(String request) {
        try {
            int row = Integer.parseInt(request.substring(1, request.indexOf(99)));
            int col = Integer.parseInt(request.substring(request.indexOf(99) + 1));
            System.out.println("\nRow: " + row + " Column: " + col);
            Taxon taxon = this.overlay.getTaxon(row, col);
            Smpdtl smpdtl = this.wellPanel.getSmpdtl();
            int total = smpdtl.getTotalCount();
            Situation situation = this.controlOption[2] ? Situation.RW : (this.controlOption[1] ? Situation.CV : Situation.INSITU);
            TaxonOcc occ = smpdtl.getFss(taxon, situation, this.controlOption[3] ? (char)'?' : 'P', 0);
            if (this.deleteEntry) {
                if (occ == null) {
                    this.deleteEntry = false;
                    return this.getCellContents(taxon);
                }
                smpdtl.deleteOcc(this.wellPanel.getWell().getWellID(), occ);
            } else {
                int totaliser = this.parent.getPicklistTotaliser();
                if (this.parent.isNumeric()) {
                    if (this.controlOption[4] || totaliser > 0 && total >= totaliser) {
                        this.counts = 0;
                    } else if (this.counts == 0) {
                        this.counts = 1;
                    }
                }
                if (occ != null && this.subjAbund == null) {
                    if (totaliser > 0 && total >= totaliser) {
                        this.parent.getToolkit().beep();
                        if (!this.sampleTotalMessage) {
                            this.sampleTotalMessage = true;
                            this.s("Sending outside count alert");
                            return this.getCellContents(taxon) + "<br><font strong color=\"red\">Outside count reached</font>";
                        }
                        return this.getCellContents(taxon);
                    }
                    this.undoSupport.postEdit(smpdtl.incrementOcc(this.wellPanel.getWell().getWellID(), this.wellPanel.getSmpdtl().getSample().getSampID(), occ, 2, this.counts, true));
                } else if (occ == null) {
                    TaxonOcc.Builder builder = new TaxonOcc.Builder(this.sbdb, taxon, situation, this.controlOption[3], 0);
                    builder.count(this.counts).subjAbund(this.subjAbund).marker(this.controlOption[0]);
                    Smpdtl.OccAddDelete edit = smpdtl.insertOccurrence(builder, this.wellPanel.getWell().getWellID());
                    this.undoSupport.postEdit((UndoableEdit)((Object)edit));
                    occ = edit.getOccurrence();
                } else {
                    return this.getCellContents(taxon);
                }
            }
            if (this.useSounds) {
                this.playSound();
            }
            this.deleteEntry = false;
            this.counts = 0;
            this.sbdb.commit();
            smpdtl.notifyObservers();
            this.parent.getWellPanel().setSelectedTaxonOcc(occ);
            return this.getCellContents(taxon);
        }
        catch (NumberFormatException ne) {
            ne.printStackTrace();
            return "Bad request: " + request;
        }
        catch (Exception ex) {
            this.sbdb.doRollback();
            ex.printStackTrace();
            return "Error: " + ex.toString();
        }
    }

    private void playSound() {
        this.soundClip = SB.playSound((Frame)this.parent, (Clip)this.soundClip, (String)"/resources/wav/Swat.wav", (String)"win.sound.exclamation");
    }

    private String getCellContents(Taxon taxon) {
        Situation situation;
        TaxonOcc occ;
        Object retString = taxon.toString(false, false);
        Smpdtl dtl = this.wellPanel.getSmpdtl();
        if (dtl != null && (occ = dtl.getFss(taxon, situation = this.controlOption[2] ? Situation.RW : (this.controlOption[1] ? Situation.CV : Situation.INSITU), this.controlOption[3] ? (char)'?' : 'P', 0)) != null) {
            retString = (String)retString + "<br><font strong color=\"blue\">" + occ.toAbnString() + "</font>";
            if (this.showTotals) {
                int nCat = 0;
                int nTot = 0;
                for (TaxonOcc o : dtl.getOccurUnsorted()) {
                    int c = o.getDerivedCount(null);
                    nTot += c;
                    if (!o.getTaxon().getCatMnem().equalsIgnoreCase(occ.getTaxon().getCatMnem())) continue;
                    nCat += c;
                }
                if (nCat > 0) {
                    Color colour = Color.red;
                    try {
                        colour = this.sbdb.getCategory(occ.getTaxon().getCatMnem()).getColour();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    retString = (String)retString + "<font strong color=\"";
                    retString = (String)retString + "#" + Integer.toHexString(colour.getRGB()).substring(2);
                    retString = (String)retString + "\">  " + occ.getTaxon().getCatMnem() + ":" + nCat + "</font>";
                }
                if (nTot > 0) {
                    retString = (String)retString + "<font strong color=\"black\">  Tot:" + nTot + "</font>";
                }
            }
        }
        return retString;
    }

    private void writeControlBarTable(DataOutputStream output) throws IOException {
        output.writeBytes("<br><table cellpadding='8' bgcolor='#DCFFFF'><tr>");
        int width = 100 / this.controlLabels.length;
        for (int i = 0; i < this.controlLabels.length; ++i) {
            output.writeBytes("<td width=" + width + "% id=" + this.controlLabels[i] + "><font color='" + (this.controlOption[i] ? "red" : "black") + "'><b>" + this.controlLabels[i] + "</b></td>");
        }
        output.writeBytes("</tr></table><br>");
    }

    UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }
}

