/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontTextDrawer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import jsbchart.graphics.DimensionF;
import jsbugs.FontMatchManager;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.xmlgraphics.util.UnitConv;

public class PDFExporter
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(PDFExporter.class.getName());
    private final DimensionF documentSizeInMM;
    private final boolean embedFonts;
    private PDDocument document;
    private PdfBoxGraphics2DFontTextDrawer textDrawer;
    private List<Font> fontList = null;
    private FontMatchManager fontMatchManager = new FontMatchManager();

    public PDFExporter(DimensionF documentSizeInMM, List<Font> fontList, boolean embedFonts) {
        this.documentSizeInMM = documentSizeInMM;
        this.embedFonts = embedFonts;
        this.fontList = fontList;
    }

    public void drawPage(Consumer<Graphics2D> drawingFunction) throws IOException {
        if (this.document == null) {
            this.setupDocument();
        }
        int widthPt = (int)Math.round(UnitConv.mm2pt((double)this.documentSizeInMM.getWidth()));
        int heightPt = (int)Math.round(UnitConv.mm2pt((double)this.documentSizeInMM.getHeight()));
        PDPage page = new PDPage(new PDRectangle((float)widthPt, (float)heightPt));
        this.document.addPage(page);
        PdfBoxGraphics2D pdfBoxGraphics2D = new PdfBoxGraphics2D(this.document, this.documentSizeInMM.getWidth() * 2.8346457f, this.documentSizeInMM.getHeight() * 2.8346457f);
        if (this.embedFonts && this.textDrawer != null) {
            pdfBoxGraphics2D.setFontTextDrawer((IPdfBoxGraphics2DFontTextDrawer)this.textDrawer);
        }
        pdfBoxGraphics2D.setColor(Color.BLACK);
        pdfBoxGraphics2D.setStroke((Stroke)new BasicStroke());
        drawingFunction.accept((Graphics2D)pdfBoxGraphics2D);
        pdfBoxGraphics2D.dispose();
        PDFormXObject pdFormXObject = pdfBoxGraphics2D.getXFormObject();
        PDPageContentStream contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.OVERWRITE, false);
        contentStream.drawForm(pdFormXObject);
        contentStream.close();
    }

    private void setupDocument() {
        this.document = new PDDocument();
        if (this.embedFonts) {
            this.textDrawer = new PdfBoxGraphics2DFontTextDrawer();
            if (this.fontList == null) {
                this.loadAllFonts();
            } else {
                this.loadFontList();
            }
        }
    }

    private void loadAllFonts() {
        FontFileFinder fontFinder = new FontFileFinder();
        List fontURIs = fontFinder.find();
        for (URI uri : fontURIs) {
            File font = new File(uri);
            this.textDrawer.registerFont(font);
        }
    }

    private void loadFontList() {
        if (this.fontList == null) {
            return;
        }
        List<AbstractMap.SimpleEntry<Font, File>> fontMatches = this.fontMatchManager.getFontMatches(this.fontList, false);
        for (AbstractMap.SimpleEntry<Font, File> entry : fontMatches) {
            this.textDrawer.registerFont(entry.getKey().getFontName(), entry.getValue());
        }
    }

    public void save(File file) throws IOException {
        this.document.save(file);
    }

    @Override
    public void close() throws IOException {
        if (this.textDrawer != null) {
            this.textDrawer.close();
        }
        if (this.document != null) {
            this.document.close();
        }
    }

    public boolean canFindFont(Font f) {
        List<AbstractMap.SimpleEntry<Font, File>> result = this.fontMatchManager.getFontMatches(Arrays.asList(f), false);
        return result.size() > 0;
    }
}

