/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateInfo;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.WellBlockOrder;
import jsbchart.correlation.CorrStdOcc;
import jsbchart.correlation.CorrTemplateOcc;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationStandard;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelZonesProperties;
import jsbugs.DialogChartBlockImport;
import jsbugs.DialogCheckList;
import jsbugs.DialogList;
import jsbugs.DialogSelectVersion;
import jsbugs.FrameChart;
import jsbugs.SBChartTransfer;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import model3.project.Project;
import model3.project.WellList;
import org.apache.commons.lang3.StringUtils;
import util.SBException;

public class SBChartTransferHandler
extends TransferHandler {
    static final String paneltemplateMimeType = "application/x-java-jvm-local-objectref;class=jsbchart.core.PanelTemplate";
    static final String blocktemplateMimeType = "application/x-java-jvm-local-objectref;class=jsbchart.core.BlockTemplate";
    static final String corrtemplateMimeType = "application/x-java-jvm-local-objectref;class=jsbchart.correlation.CorrelationTemplate";
    static final String corrStdMimeType = "application/x-java-jvm-local-objectref;class=jsbchart.correlation.CorrelationStandard";
    private final DataFlavor panelFlavour;
    private final DataFlavor blockFlavour;
    private final DataFlavor corrFlavour;
    private final DataFlavor corrStdFlavour;
    private final SBdb sbdb;
    private final ChartManager chartManager;
    private final FrameChart parent;

    SBChartTransferHandler(FrameChart parent, SBdb sbdb, ChartManager chartManager) throws SBException {
        this.parent = parent;
        this.sbdb = sbdb;
        this.chartManager = chartManager;
        try {
            this.panelFlavour = new DataFlavor(paneltemplateMimeType);
            this.blockFlavour = new DataFlavor(blocktemplateMimeType);
            this.corrFlavour = new DataFlavor(corrtemplateMimeType);
            this.corrStdFlavour = new DataFlavor(corrStdMimeType);
        }
        catch (ClassNotFoundException e) {
            throw new SBException("Error initialising transfer handler: " + e.getMessage());
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTree) {
            JTree tree = (JTree)c;
            Object o = tree.getLastSelectedPathComponent();
            if (o instanceof BlockTemplateInfo) {
                o = this.chartManager.getBlockTemplateFromInfo((BlockTemplateInfo)o);
            }
            if (o instanceof PanelTemplate || o instanceof BlockTemplate || o instanceof CorrelationTemplate || o instanceof CorrelationStandard) {
                return new SBChartTransfer(o);
            }
        }
        return null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        Chart chart;
        if (info.getDataFlavors()[0].equals(this.panelFlavour)) {
            FrameChart.JScrollPaneChartTemplate scrollPane = this.getScrollPane(info);
            if (scrollPane == null || scrollPane.getMode() == null) {
                return false;
            }
            ChartTemplateBase template = scrollPane.getTemplate();
            try {
                if (template == null || !template.canWrite(this.sbdb, null)) {
                    return false;
                }
            }
            catch (SQLException e) {
                Logger.getLogger(SBChartTransferHandler.class.getName()).log(Level.WARNING, "Error loading template", e);
                return false;
            }
            return true;
        }
        if ((info.getDataFlavors()[0].equals(this.blockFlavour) || info.getDataFlavors()[0].equals(this.corrFlavour) || info.getDataFlavors()[0].equals(this.corrStdFlavour)) && (chart = this.getChart(info)) != null) {
            try {
                if (!chart.getTemplate().canWrite(this.sbdb, null)) {
                    return false;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(final TransferHandler.TransferSupport info) {
        try {
            if (info.getDataFlavors()[0].equals(this.panelFlavour)) {
                FrameChart.JScrollPaneChartTemplate scrollPane = this.getScrollPane(info);
                ChartBlockBase block = scrollPane.getActiveBlock();
                if (block == null) {
                    System.out.println("block was null");
                    return false;
                }
                PanelTemplate temp = (PanelTemplate)info.getTransferable().getTransferData(this.panelFlavour);
                if (!(block instanceof SchemeBlock) && (info.getDropAction() != 1 && temp.getProjID() == 0 || info.getDropAction() == 1 && temp.getProjID() > 0)) {
                    String descr = "Local to " + block.getBlockType().getShortDescr() + " block template [" + block.getTemplate().getName() + "]";
                    temp = this.chartManager.addPanelTemplate("", descr, block.getTemplate().getProjID(), temp, false);
                }
                PanelOcc occ = null;
                if (PanelType.isBiozonePanel(temp.getType())) {
                    ArrayList<IGDScheme> l = new ArrayList<IGDScheme>(this.sbdb.getBiozoneSchemes(((PanelZonesProperties)temp.getProperties()).getDisc()));
                    Collections.sort(l);
                    l.add(0, (IGDScheme)((Object)((PanelZonesProperties)temp.getEditableProp()).getForEachString(false)));
                    DialogList<IGDScheme> dialog = new DialogList<IGDScheme>(this.parent, true, "Select Biozone Scheme", null, l, true, false);
                    dialog.setLocationRelativeTo(this.getScrollPane(info));
                    dialog.setVisible(true);
                    if (dialog.getSelection() == null) {
                        return false;
                    }
                    int schID = dialog.getSelection() instanceof String ? 0 : dialog.getSelection().getID();
                    occ = new PanelOcc(temp.getID());
                    occ.setProperty(5, schID);
                }
                ChartPanel panel = PanelFactory.createPanel(block, temp, occ);
                if (temp.isEditing()) {
                    panel.setProperties(temp.getEditableProp());
                }
                if (panel.getPanelType().captionPreference) {
                    String preferredCaption = Lastval.getString(this.sbdb, "CAP_" + panel.getPanelType().ordinal());
                    panel.setPanelOccProperty(0, CaptionTemplate.getDisplayString(preferredCaption));
                    String preferredCaptionOrientationString = Lastval.getString(this.sbdb, "CAPOR_" + panel.getPanelType().ordinal());
                    if (!StringUtils.isBlank((CharSequence)preferredCaptionOrientationString) && panel.getPanelType().allowCaptionOrientationChange) {
                        BlockTemplate.CaptionOrientation preferredCaptionOrientation = BlockTemplate.CaptionOrientation.valueOf(preferredCaptionOrientationString);
                        panel.setPanelOccProperty(2, (Object)preferredCaptionOrientation);
                    }
                }
                block.addMember(panel);
                if (block instanceof SchemeBlock && scrollPane.getChart().getTemplate() == null) {
                    ((SchemeBlock)block).setTemplateProperties();
                }
                this.parent.fireChartComponentAdded(panel);
                block.notifyListeners();
                this.getScrollPane(info).refreshView();
                this.getScrollPane(info).repaint();
                return true;
            }
            if (info.getDataFlavors()[0].equals(this.blockFlavour)) {
                WellBlockOrder order;
                Object o;
                final Chart chart = this.getChart(info);
                if (chart == null) {
                    return false;
                }
                final BlockTemplate templ = (BlockTemplate)info.getTransferable().getTransferData(this.blockFlavour);
                FrameChart.JScrollPaneChartTemplate scrollPane = this.getScrollPane(info);
                switch (templ.getType()) {
                    case WELL: 
                    case PROJECT: 
                    case MAP: {
                        Project chartProject = chart.getTemplate().getProjID() > 0 ? this.sbdb.getProject(chart.getTemplate().getProjID()) : null;
                        WellList chartDefaultWellList = chart.getTemplate().getWellListID() > 0 ? (WellList)this.sbdb.getWellListService().getWellList(chart.getTemplate().getWellListID()) : null;
                        DialogChartBlockImport dialog = new DialogChartBlockImport(this.parent, true, this.sbdb, templ.getType(), chartProject, chartDefaultWellList, true);
                        dialog.setLocationRelativeTo(scrollPane);
                        dialog.setVisible(true);
                        if (!dialog.isOK()) {
                            return false;
                        }
                        o = dialog.getObject(templ.getType());
                        order = dialog.getOrder();
                        break;
                    }
                    default: {
                        o = null;
                        order = null;
                    }
                }
                if (templ.getType() == BlockType.WELL && o == null) {
                    for (ChartBlockBase b : chart.getBlocks()) {
                        if (!(b instanceof WellBlock) || b.getWell() != null) continue;
                        JOptionPane.showMessageDialog(this.parent, "Chart can only contain one template block.", "Add Block", 2);
                        return false;
                    }
                }
                SwingWorker<Void, Object> worker = new SwingWorker<Void, Object>(this){
                    final /* synthetic */ SBChartTransferHandler this$0;
                    {
                        SBChartTransferHandler sBChartTransferHandler = this$0;
                        Objects.requireNonNull(sBChartTransferHandler);
                        this.this$0 = sBChartTransferHandler;
                    }

                    @Override
                    protected Void doInBackground() throws Exception {
                        this.publish(o);
                        LinkedList<ChartTemplate.BlockOcc> blockOccs = new LinkedList<ChartTemplate.BlockOcc>();
                        if (o instanceof List) {
                            List list = (List)o;
                            if (list.size() == 1) {
                                Well well = (Well)list.get(0);
                                blockOccs.add(new ChartTemplate.BlockOcc(templ.getID(), well.getWellID(), 0, 0, null, null));
                            } else {
                                list.stream().forEach(w -> blockOccs.add(new ChartTemplate.BlockOcc(templ.getID(), ((Well)w).getWellID(), 0, 0, null, null)));
                            }
                        } else if (o instanceof WellList) {
                            WellList wellList = (WellList)((Object)o);
                            blockOccs.add(new ChartTemplate.BlockOcc(templ.getID(), 0, wellList.getID(), 0, null, null));
                        } else {
                            blockOccs.add(null);
                        }
                        LinkedList<ChartBlockBase> blocks = new LinkedList<ChartBlockBase>();
                        blockOccs.forEach(occ -> {
                            try {
                                blocks.add(ChartFactory.createBlock(this.this$0.sbdb, templ, occ, chart));
                            }
                            catch (RuntimeException | SQLException | SBException e) {
                                Logger.getLogger(SBChartTransferHandler.class.getName()).log(Level.WARNING, "Error adding block: {0}", e.getMessage());
                            }
                        });
                        if (order != null) {
                            WellBlockOrder.sortList(blocks, order);
                        }
                        blocks.forEach(block -> chart.addBlock((ChartBlockBase)block));
                        this.this$0.parent.fireChartComponentAdded(blocks.size() == 1 ? blocks.get(0) : templ);
                        return null;
                    }

                    @Override
                    protected void process(List<Object> chunks) {
                        this.this$0.parent.setProcessLabel("Processing: " + String.valueOf(chunks.get(chunks.size() - 1)) + "...");
                    }

                    @Override
                    public void done() {
                        this.this$0.parent.setProcessLabel("Setting chart data...");
                        try {
                            chart.setData();
                            this.this$0.parent.setProcessLabel(null);
                        }
                        catch (Exception e) {
                            this.this$0.parent.setProcessLabel(e.getMessage());
                        }
                        this.this$0.getScrollPane(info).refreshView();
                        this.this$0.getScrollPane(info).repaint();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                1 v0 = this$1;
                                Objects.requireNonNull(v0);
                                this.this$1 = v0;
                            }

                            @Override
                            public void run() {
                                this.this$1.this$0.getScrollPane(info).scrollMaxRight();
                            }
                        });
                    }
                };
                worker.execute();
                return true;
            }
            if (info.getDataFlavors()[0].equals(this.corrFlavour) || info.getDataFlavors()[0].equals(this.corrStdFlavour)) {
                Chart chart = this.getChart(info);
                if (chart == null) {
                    return false;
                }
                Object o = info.getTransferable().getTransferData(info.getDataFlavors()[0]);
                Correlation corr = null;
                if (o instanceof CorrelationTemplate) {
                    CorrelationTemplate templ = (CorrelationTemplate)o;
                    corr = Correlation.createCorrelation(templ, new CorrTemplateOcc(templ.getID(), 0, false, null, null, 100, true, false));
                } else {
                    CorrelationStandard std = (CorrelationStandard)o;
                    int hier = 0;
                    int schID = 0;
                    int interpID = 0;
                    if (CorrelationType.isUnitType(std.type)) {
                        HashSet<Integer> interpIDs = new HashSet<Integer>();
                        for (ChartBlockBase chartBlockBase : chart.getBlocks()) {
                            interpIDs.add(chartBlockBase.getInterpID());
                        }
                        if (interpIDs.size() == 1) {
                            interpID = (Integer)interpIDs.toArray()[0];
                        } else {
                            LinkedList<Well> wells = new LinkedList<Well>();
                            for (ChartBlockBase block : chart.getBlocks()) {
                                if (block.getWell() == null) continue;
                                wells.add(block.getWell());
                            }
                            if (!wells.isEmpty()) {
                                DialogSelectVersion dialogSelectVersion = new DialogSelectVersion((Frame)this.parent, true, this.sbdb, wells);
                                dialogSelectVersion.setLocationRelativeTo(this.getScrollPane(info));
                                dialogSelectVersion.setVisible(true);
                                if (dialogSelectVersion.selection == null || dialogSelectVersion.selection.isEmpty()) {
                                    return false;
                                }
                                interpID = dialogSelectVersion.selection.get(0).getInterpID();
                            }
                        }
                        int igdType = DataType.getIGDType(std.type.getDataType());
                        HashSet<IGDScheme> hashSet = chart.getIGDSchemes(igdType, interpID, false, this.sbdb);
                        if (hashSet.isEmpty()) {
                            JOptionPane.showMessageDialog(this.parent, "No schemes available in this version", "Correlation", 2);
                            return false;
                        }
                        if (hashSet.size() > 1) {
                            DialogList<IGDScheme> dList = new DialogList<IGDScheme>(this.parent, true, "Select Scheme", null, new ArrayList<IGDScheme>(hashSet), true, false);
                            dList.setLocationRelativeTo(this.getScrollPane(info));
                            dList.setVisible(true);
                            if (dList.getSelection() == null) {
                                return false;
                            }
                            schID = dList.getSelection().getID();
                        } else {
                            schID = ((IGDScheme)hashSet.toArray()[0]).getID();
                        }
                        List<String> hiers = Arrays.asList(IGDIntervalZone.getHierNames(igdType));
                        DialogList<String> dList2 = new DialogList<String>(this.parent, true, "Select Hierarchy Level", null, hiers, true, false);
                        dList2.setLocationRelativeTo(this.getScrollPane(info));
                        dList2.setVisible(true);
                        if (dList2.getSelection() == null) {
                            return false;
                        }
                        hier = IGDIntervalZone.getHierNumber(igdType, dList2.getSelection(), true);
                    }
                    EnumSet typeSet = CorrelationType.getDataTypes(std.type);
                    Object[] types = typeSet.toArray();
                    boolean[] blArray = new boolean[types.length];
                    for (int i = 0; i < blArray.length; ++i) {
                        blArray[i] = true;
                    }
                    DialogCheckList dialog = new DialogCheckList(this.parent, true, "Data types", types, blArray);
                    dialog.setLocationRelativeTo(this.getScrollPane(info));
                    dialog.setVisible(true);
                    if (dialog.isOK()) {
                        for (int i = 0; i < blArray.length; ++i) {
                            if (blArray[i]) continue;
                            typeSet.remove(types[i]);
                        }
                        corr = Correlation.createCorrelation(new CorrStdOcc(std.type, std.scope, typeSet, false, null, interpID, schID, hier, 100, true, false), this.sbdb);
                    }
                }
                if (corr == null) {
                    return false;
                }
                if (chart.hasCorrelation(corr)) {
                    JOptionPane.showMessageDialog(this.parent, "Chart already has this template", "Apply Correlation", 2);
                    return false;
                }
                chart.addCorrelation(corr);
                chart.setData(corr);
                this.parent.fireChartComponentAdded(corr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private Chart getChart(TransferHandler.TransferSupport info) {
        FrameChart.JScrollPaneChartTemplate scrollPane = this.getScrollPane(info);
        if (scrollPane != null) {
            return scrollPane.getChart();
        }
        return null;
    }

    private FrameChart.JScrollPaneChartTemplate getScrollPane(TransferHandler.TransferSupport info) {
        FrameChart.JTabbedPaneChart tPane;
        if (info.getComponent() instanceof FrameChart.JTabbedPaneChart && (tPane = (FrameChart.JTabbedPaneChart)info.getComponent()).getSelectedComponent() instanceof FrameChart.JScrollPaneChartTemplate) {
            return (FrameChart.JScrollPaneChartTemplate)tPane.getSelectedComponent();
        }
        return null;
    }

    private ChartBlock getSingleChartBlock(TransferHandler.TransferSupport info) {
        Chart chart = this.getChart(info);
        if (chart != null && chart.getBlocks().size() == 1) {
            return (ChartBlock)chart.getBlocks().get(0);
        }
        return null;
    }
}

