/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.image.ZipFileImageLoader;
import com.stratadata.model3.ws.reader.ParsedWorkspace;
import com.stratadata.model3.ws.reader.XmlReader;
import java.awt.Component;
import java.awt.Cursor;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbchart.core.ChartManager;
import jsbugs.SbugsMLdocument;
import model3.Lastval;
import model3.SBdb;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.xml.sax.SAXException;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class SbugsIO {
    public static final String SBG_DESCR = "StrataBugs SBG/XML";

    private SbugsIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSBGfile(SBdb db, ChartManager wsCM, SBdb ws, File zipFile, Component parentForMessages, Set<Integer> dataTypes, boolean includeReferences) throws IOException, SQLException, SBException, SBPermissionException {
        if (!db.isConnected()) {
            throw new IllegalArgumentException("Database is not connected");
        }
        if ((db.getUser().getPriv() & 0x4000) > 0) {
            throw new SBPermissionException("You are not allowed to export data.");
        }
        if (!zipFile.getName().toLowerCase().endsWith(".zip") && !zipFile.getName().toLowerCase().endsWith(".sbg")) {
            zipFile = new File(zipFile.getPath() + ".sbg");
        }
        String msgTitle = "Export SBG";
        String fileName = zipFile.getPath();
        try {
            parentForMessages.setCursor(Cursor.getPredefinedCursor(3));
            File tempXML = new File(fileName.substring(0, fileName.lastIndexOf(46)) + ".xml");
            if (tempXML.exists()) {
                if (JOptionPane.showConfirmDialog(parentForMessages, "'" + String.valueOf(tempXML) + "' will be overwritten.\nContinue?", "Export SBG", 0, 3) != 0) {
                    return;
                }
            } else {
                tempXML.createNewFile();
            }
            LinkedList<File> files = new LinkedList<File>();
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempXML), "UTF8"));){
                if (dataTypes == null) {
                    dataTypes = new HashSet<Integer>();
                }
                if (wsCM != null) {
                    ChartManager.writeXML(out, db, wsCM, files, dataTypes);
                } else {
                    ws.writeXML(out, dataTypes, db, files, true, includeReferences);
                }
            }
            files.add(tempXML);
            SbugsIO.writeZipFile(zipFile, files);
            try {
                SbugsMLdocument.getXmlDocument(tempXML);
            }
            catch (JDOMException | SAXException ex) {
                JOptionPane.showMessageDialog(parentForMessages, "File exported but XML is invalid.\nError is: " + ex.getMessage() + "\nPlease report, and send a copy of the file to StrataData for more information");
            }
            String msg = "File written: " + fileName;
            try {
                Files.delete(tempXML.toPath());
            }
            catch (IOException ioex) {
                msg = msg + "\n(Unable to delete temporary file '" + tempXML.getPath() + "')\n" + ioex.getMessage();
                ioex.printStackTrace();
            }
            JOptionPane.showMessageDialog(parentForMessages, msg, "Export SBG", 1);
            System.out.println("Created sbg/zip file, name: " + fileName);
        }
        finally {
            parentForMessages.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void writeZipFile(File file, List<File> files) throws FileNotFoundException, IOException {
        if (files == null || files.isEmpty()) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            byte[] buffer = new byte[1024];
            CRC32 crc = new CRC32();
            for (File entryFile : files) {
                int bytesRead;
                if (entryFile.getName().toLowerCase().endsWith("zip")) continue;
                if (entryFile.isDirectory() || !entryFile.canRead()) {
                    System.err.println("Skipping: " + entryFile.getName());
                    continue;
                }
                System.out.println("Buffering: " + entryFile.getName());
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(entryFile));){
                    crc.reset();
                    while ((bytesRead = bis.read(buffer)) != -1) {
                        crc.update(buffer, 0, bytesRead);
                    }
                }
                bis = new BufferedInputStream(new FileInputStream(entryFile));
                try {
                    ZipEntry entry = new ZipEntry(entryFile.getName());
                    if (entryFile.getName().toLowerCase().endsWith("jpg")) {
                        entry.setMethod(0);
                        entry.setCompressedSize(entryFile.length());
                    } else {
                        entry.setMethod(8);
                    }
                    entry.setSize(entryFile.length());
                    entry.setCrc(crc.getValue());
                    zos.putNextEntry(entry);
                    while ((bytesRead = bis.read(buffer)) != -1) {
                        zos.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    bis.close();
                }
            }
        }
    }

    public static ChartManager getWorkspace(SBdb db, Component parentForMessages, String lastValString, int projID, Set<Integer> dataTypes, List<SBException> exceptions, String description, String ... extensions) throws IOException, ParseException, SBException, SQLException {
        File chosenFile = SbugsIO.chooseFileToOpen(db, parentForMessages, lastValString, description, extensions);
        ChartManager cm = null;
        if (chosenFile != null) {
            cm = SbugsIO.parseFile(chosenFile, parentForMessages, new SBdb(db), projID, dataTypes, exceptions);
        }
        return cm;
    }

    public static File chooseFileToOpen(SBdb db, Component parentForMessages, String lastValString, String description, String ... extensions) {
        JFileChooser jFileChooser = new JFileChooser();
        if (extensions != null && extensions.length > 0) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter(description, extensions);
            jFileChooser.setFileFilter(filter);
            jFileChooser.setAcceptAllFileFilterUsed(false);
        }
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(db, lastValString));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        } else if (!setDir.exists()) {
            setDir = setDir.getParentFile();
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = null;
        if (jFileChooser.showOpenDialog(parentForMessages) == 0) {
            file = jFileChooser.getSelectedFile();
            String fileName = file.getPath();
            try {
                Lastval.putString(db, lastValString, fileName);
                db.commit();
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        return file;
    }

    private static File openZipArchive(ZipFile zipFile, Component parentForMessages) throws IOException {
        String rootName = zipFile.getName();
        rootName = rootName.substring(0, rootName.lastIndexOf(46));
        System.out.println("File root name: " + rootName);
        String entryName = rootName + ".xml";
        ZipEntry entry = null;
        ZipEntry anXMLentry = null;
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry e = en.nextElement();
            if (e.getName().equalsIgnoreCase(entryName)) {
                entry = e;
                break;
            }
            if (!e.getName().endsWith(".xml")) continue;
            if (anXMLentry == null) {
                anXMLentry = e;
                continue;
            }
            anXMLentry = null;
            break;
        }
        if (entry == null && anXMLentry != null) {
            entry = anXMLentry;
        }
        if (entry == null) {
            String msg = "sbg/zip file does not contain an XML file of the same name, or contains multiple files.\n\nExpected: " + entryName + "\nContents: ";
            Enumeration<? extends ZipEntry> z = zipFile.entries();
            while (z.hasMoreElements()) {
                msg = msg + z.nextElement().getName() + "\n";
            }
            JOptionPane.showMessageDialog(parentForMessages, msg, "Open File", 2);
            return null;
        }
        File tempXML = File.createTempFile("SBUGS", ".xml");
        try (FileOutputStream fos = new FileOutputStream(tempXML);
             InputStream fis = zipFile.getInputStream(entry);){
            int nBytes;
            byte[] bytes = new byte[Short.MAX_VALUE];
            while ((nBytes = fis.read(bytes, 0, bytes.length)) > 0) {
                fos.write(bytes, 0, nBytes);
            }
        }
        return tempXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ChartManager parseFile(File file, Component parentForMessages, SBdb ws, int projID, Set<Integer> dataTypes, List<SBException> exceptions) throws IOException, ParseException, SBException {
        assert (!ws.isConnected());
        String fileName = file.getPath();
        ChartManager wsCM = null;
        try (ZipFile zipFile = null;){
            switch (fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim()) {
                case "sbg": 
                case "zip": {
                    zipFile = new ZipFile(file);
                    file = SbugsIO.openZipArchive(zipFile, parentForMessages);
                    if (file == null) break;
                }
                case "xml": {
                    if (zipFile != null) {
                        ws.setImageLoader(new ZipFileImageLoader(zipFile.getName()));
                    }
                    wsCM = SbugsIO.parseXMLFile(file, zipFile, parentForMessages, ws, projID, dataTypes, exceptions);
                    break;
                }
                case "dex": 
                case "xls": 
                case "xlsx": {
                    assert (false);
                    break;
                }
            }
            String string = wsCM;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ParsedWorkspace getWorkspace(File file, Component parentForMessages) throws IOException {
        String fileName = file.getPath();
        try (ZipFile zipFile = null;){
            switch (fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim()) {
                case "sbg": 
                case "zip": {
                    zipFile = new ZipFile(file);
                    file = SbugsIO.openZipArchive(zipFile, parentForMessages);
                    if (file == null) {
                        return null;
                    }
                }
                case "xml": {
                    XmlReader reader;
                    Document xmlDocument = null;
                    try {
                        xmlDocument = SbugsMLdocument.getXmlDocument(file);
                    }
                    catch (JDOMException | SAXException e) {
                        throw new IOException(e);
                    }
                    XmlReader xmlReader = reader = new XmlReader(xmlDocument, zipFile);
                    return xmlReader;
                }
                case "dex": 
                case "xls": 
                case "xlsx": {
                    assert (false);
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ChartManager parseXMLFile(File file, ZipFile zipFile, Component parentForMessages, SBdb ws, int projID, Set<Integer> dTypes, List<SBException> exceptions) throws ParseException, SBException {
        assert (!ws.isConnected());
        try {
            parentForMessages.setCursor(Cursor.getPredefinedCursor(3));
            ChartManager wsCM = new ChartManager(ws);
            Document xmlDocument = SbugsMLdocument.getXmlDocument(file);
            dTypes.clear();
            wsCM.parseXMLDocument(xmlDocument, dTypes, zipFile, "", projID, exceptions);
            System.out.println("File read successful...");
            ChartManager chartManager = wsCM;
            return chartManager;
        }
        catch (SQLException sqle) {
            throw new SBException("Unexpected SQL Exception", (Throwable)sqle);
        }
        catch (JDOMException e) {
            JOptionPane.showMessageDialog(parentForMessages, String.valueOf(file) + " is not well-formed or invalid.\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(parentForMessages, "Error during XML parsing: " + ex.getMessage() + "\nCheck that file is a Stratabugs XML file, or send to StrataData for advice.", "Open File", 0);
            ex.printStackTrace();
        }
        catch (IOException e) {
            StackError.showStackError((String)"Error reading file", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(parentForMessages, "Cannot read file: Memory limit for application exceeded. Total available: " + Runtime.getRuntime().maxMemory() / 1024000L + "MB\nContact StrataData for workaround or reduce size of import file");
            e.printStackTrace();
        }
        finally {
            parentForMessages.setCursor(Cursor.getDefaultCursor());
        }
        return null;
    }
}

