/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.JDOMParseException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SbugsMLdocument {
    static boolean PARSE_EXECTION_THROWN = false;

    static Document getXmlDocument(final File xmlFile) throws JDOMException, IOException, SAXException {
        Document xmlDocument;
        block11: {
            final SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
            builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            xmlDocument = null;
            PARSE_EXECTION_THROWN = false;
            try {
                ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
                Future handler = executor.submit(new Callable(){

                    public Document call() throws JDOMException, IOException {
                        return builder.build(xmlFile);
                    }
                });
                System.out.println("Waiting for site xml validator request ...");
                xmlDocument = (Document)handler.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                System.out.println("Validation timed out - using local xsd file.");
                PARSE_EXECTION_THROWN = true;
            }
            catch (Exception ex) {
                if (!(ex instanceof JDOMParseException)) break block11;
                System.out.println("JDOM parseException. Using local xsd file because of..." + ex.getMessage());
                PARSE_EXECTION_THROWN = true;
            }
        }
        if (PARSE_EXECTION_THROWN) {
            System.out.println("Attempting validation");
            String schemaLang = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
            String dir = System.getProperty("user.dir");
            File root = new File(dir);
            while (root.getParentFile() != null) {
                root = root.getParentFile();
            }
            System.out.println("Creating validation schema...");
            boolean hasValidator = false;
            String[] XSD = new String[]{"SBugsML3-0.xsd", "SBugsML2-1.xsd", "SBugsML2-0.xsd"};
            for (int nValidator = 0; nValidator < XSD.length; ++nValidator) {
                File xsdFile = new File(dir + File.separator + XSD[nValidator]);
                if (!xsdFile.exists()) {
                    xsdFile = new File(String.valueOf(root.getAbsoluteFile()) + File.separator + "sbugs" + File.separator + "xml" + File.separator + XSD[nValidator]);
                }
                if (!xsdFile.exists()) {
                    hasValidator = false;
                    continue;
                }
                try {
                    Schema schema = factory.newSchema(new StreamSource(xsdFile));
                    System.out.println("Creating validator with " + xsdFile.getPath());
                    Validator validator = schema.newValidator();
                    hasValidator = true;
                    System.out.println("Validating...");
                    validator.validate(new StreamSource(xmlFile));
                    validator.reset();
                    System.out.println("XML Validation successful");
                    break;
                }
                catch (SAXParseException pex) {
                    System.out.println("Validation error: " + pex.getMessage() + "\nUsing: " + xsdFile.getName());
                    if (hasValidator && nValidator == XSD.length - 1) {
                        throw pex;
                    }
                    if (nValidator != XSD.length) continue;
                    System.out.println("Proceeding without validation...");
                }
            }
            SAXBuilder builder2 = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
            xmlDocument = builder2.build(xmlFile);
        }
        return xmlDocument;
    }
}

