/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.TemplateDescr;
import jsbugs.TableModelSB;
import jsbugs.table.DateRenderer;
import model3.SBdb;

public class TableModelBlockTemplates
extends TableModelSB {
    private static final int COL_DESCR = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_PROJECT = 2;
    private static final int COL_WELLIST = 3;
    private static final int COL_NMBRS = 4;
    private static final int COL_COMMENTS = 5;
    private static final int COL_MODIFIED = 6;
    private static final int COL_MODIFIER = 7;
    private final SBdb sbdb;
    private List<TemplateDescr> templs;
    private static final String[] colNames = new String[]{"Name", "Type", "Project", "Well List", "Members", "Comments", "Modified", "By"};
    private static final int[] colWidths = new int[]{80, 14, 20, 20, 15, 30, 20, 5};

    public TableModelBlockTemplates(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    @Override
    public int getRowCount() {
        if (this.templs == null) {
            return 0;
        }
        return this.templs.size();
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.templs == null) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                return Objects.toString(this.templs.get(rowIndex).getType(), "Chart");
            }
            case 0: {
                return this.templs.get(rowIndex).getName();
            }
            case 2: {
                try {
                    int projID = this.templs.get(rowIndex).getProjID();
                    if (projID > 0) {
                        return this.sbdb.getProject(projID);
                    }
                    return "Global";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            case 3: {
                int wellListID = this.templs.get(rowIndex).getWellListID();
                if (wellListID > 0) {
                    return this.sbdb.getWellListService().getWellList(wellListID);
                }
                return "";
            }
            case 4: {
                return this.templs.get(rowIndex).getnMbrs();
            }
            case 5: {
                return this.templs.get(rowIndex).getComments();
            }
            case 6: {
                return this.templs.get(rowIndex).getModified();
            }
            case 7: {
                int userID = this.templs.get(rowIndex).getModifier();
                if (userID > 0) {
                    try {
                        return this.sbdb.getUser(userID).getAbr();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public String getPrefString() {
        return "TMSELTMPL";
    }

    @Override
    public String getPrefOrderString() {
        return "TOSELTMPL";
    }

    @Override
    public String getAutoResizeString() {
        return "TARSELTMPL";
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return colWidths;
    }

    @Override
    public String[] getColumnTitles() {
        return colNames;
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        this.init(table, sbdb);
        for (int i = 0; i < colNames.length; ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(colNames[i]);
        }
        TableUtils.setTableHeaderBold((JTable)table);
        table.getColumnModel().getColumn(6).setCellRenderer(new DateRenderer());
        this.restoreColumnOrder(table);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return switch (col) {
            case 6 -> Date.class;
            case 4 -> Integer.class;
            default -> super.getColumnClass(col);
        };
    }

    public List<TemplateDescr> getTemplates() {
        return this.templs;
    }

    public void setTemplates(List<TemplateDescr> templates) {
        this.templs = templates;
    }

    public void setBlockTemplates(List<BlockTemplate> templates) {
        this.templs = new ArrayList<BlockTemplate>(templates);
    }

    public void removeTemplate(ChartTemplateBase template) {
        if (this.templs != null) {
            this.templs.remove(template);
        }
    }

    public void removeAll(Collection<BlockTemplateParent> templates) {
        if (this.templs != null) {
            this.templs.removeAll(templates);
        }
    }
}

