/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import model3.SBdb;
import model3.WellDocument;
import model3.WellDocumentService;
import org.apache.commons.io.FileUtils;

public class TableModelDocuments
extends AbstractTableModel {
    private static final String[] COL_NAMES = new String[]{"Name", "Version", "Primary Well", "Creator", "Created", "Size"};
    private static final int[] COL_WIDTHS = new int[]{100, 50, 50, 20, 20, 20};
    final int COL_NAME = 0;
    final int COL_VERSION = 1;
    final int COL_PRIMARY_WELL = 2;
    final int COL_CREATOR = 3;
    final int COL_CREATED = 4;
    final int COL_SIZE = 5;
    private int wellID;
    private List<WellDocument> data = null;

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return COL_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COL_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        WellDocument doc = this.data.get(rowIndex);
        return switch (columnIndex) {
            case 0 -> doc.getDescr();
            case 1 -> doc.getInterpDescr();
            case 2 -> doc.getPrimaryWellName();
            case 3 -> doc.getCreatorName();
            case 4 -> doc.getCreated();
            case 5 -> FileUtils.byteCountToDisplaySize((long)doc.getDocLength());
            default -> "";
        };
    }

    public WellDocument getDocumentAt(int rowIndex) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(rowIndex);
    }

    public void populateTable(int wellID, SBdb sbdb) {
        this.wellID = wellID;
        try {
            this.data = new WellDocumentService(sbdb).getDocumentList(wellID);
            for (WellDocument doc : this.data) {
                doc.setCreatorName(sbdb.getUser(doc.getCreator()).getAbr());
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TableModelDocuments.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void setupTable(JTable table) {
        table.setDefaultRenderer(String.class, new WellDocumentTableRenderer(this));
        table.setDefaultRenderer(Date.class, new WellDocumentTableRenderer(this));
        table.getColumnModel().getColumn(5).setCellRenderer(new BlobSizeRenderer(this));
        TableUtils.setTableHeaderBold((JTable)table);
        TableUtils.setPrefferedWidths((JTable)table, (int[])COL_WIDTHS);
    }

    private class WellDocumentTableRenderer
    extends DefaultTableCellRenderer {
        private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy");
        private static final Color CELL_COLOUR = new Color(220, 220, 220);
        final /* synthetic */ TableModelDocuments this$0;

        private WellDocumentTableRenderer(TableModelDocuments tableModelDocuments) {
            TableModelDocuments tableModelDocuments2 = tableModelDocuments;
            Objects.requireNonNull(tableModelDocuments2);
            this.this$0 = tableModelDocuments2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                if (this.this$0.data.get(row).getPrimaryWellID() != this.this$0.wellID) {
                    comp.setBackground(CELL_COLOUR);
                } else {
                    comp.setBackground(table.getBackground());
                }
            }
            return comp;
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            if (value != null && value instanceof Date) {
                this.setText(DATE_FORMAT.format((Date)value));
            }
        }
    }

    private class BlobSizeRenderer
    extends WellDocumentTableRenderer {
        final /* synthetic */ TableModelDocuments this$0;

        public BlobSizeRenderer(TableModelDocuments tableModelDocuments) {
            TableModelDocuments tableModelDocuments2 = tableModelDocuments;
            Objects.requireNonNull(tableModelDocuments2);
            this.this$0 = tableModelDocuments2;
            super(tableModelDocuments);
            this.setHorizontalAlignment(4);
        }
    }
}

