/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.table.DepthRenderer;
import model3.GrainSizeDepth;
import model3.GrainSizeList;
import util.DepthUtils;
import util.SB;

class TableModelGrainSize
extends AbstractTableModel {
    GrainSizeList grainSize = null;
    char units;
    final String[] colTitles = new String[]{"Depth", "Grain size"};
    final int COL_DEPTH = 0;
    final int COL_GRAINSIZE = 1;

    TableModelGrainSize() {
    }

    @Override
    public int getColumnCount() {
        return this.colTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.grainSize == null) {
            return 0;
        }
        return this.grainSize.size();
    }

    public void setSize(int i) {
    }

    @Override
    public Object getValueAt(int row, int col) {
        GrainSizeDepth gsDepth = (GrainSizeDepth)this.grainSize.get(row);
        if (gsDepth == null) {
            return "";
        }
        switch (col) {
            case 0: {
                return DepthUtils.convFromM((double)gsDepth.getDepth(), (char)this.units);
            }
            case 1: {
                return new Float(gsDepth.getGrainSize());
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        GrainSizeDepth gsDepth = (GrainSizeDepth)this.grainSize.get(row);
        if (gsDepth == null) {
            return;
        }
        switch (col) {
            case 0: {
                if (obj == null) {
                    gsDepth.setDepth(0.0);
                } else {
                    gsDepth.setDepth(DepthUtils.convToM((double)Double.parseDouble(obj.toString()), (char)this.units));
                }
                this.grainSize.setDirty();
                break;
            }
            case 1: {
                if (obj == null) {
                    gsDepth.setGrainSize(0.0f);
                } else {
                    gsDepth.setGrainSize(((Float)obj).floatValue());
                }
                this.grainSize.setDirty();
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 1) {
            return true;
        }
        return col == 0;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Double.class;
            }
            case 1: {
                return Float.class;
            }
        }
        return String.class;
    }

    void setupTable(JTable jTable) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(this.colTitles[i]);
        }
        jTable.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer(3));
    }
}

