/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SampleStatusRenderer;
import model3.IGDIntervalZone;
import model3.Sample;
import model3.WellInterp;
import model3.WsWell;
import util.MatchData;
import util.SB;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

class TableModelMatchIGDInterval
extends AbstractTableModel {
    static final int COL_WS_SAMPLE = 0;
    static final int COL_DONOR_BASE = 1;
    static final int COL_DONOR_SCHEME = 2;
    static final int COL_DONOR_LEVEL = 3;
    static final int COL_DONOR_ZONE = 4;
    static final int COL_CONFLICT = 5;
    static final int COL_ARROW = 6;
    static final int COL_HOST_TOP = 7;
    static final int COL_HOST_BASE = 8;
    static final int COL_HOST_SCHEME = 9;
    static final int COL_HOST_LEVEL = 10;
    static final int COL_HOST_ZONE = 11;
    static final String[] colTitles = new String[]{"Top", "Base", "Scheme", "Level", "Interval", "Conflict", "", "Top", "Base", "Scheme", "Level", "Interval"};
    static final int[] colWidths = new int[]{30, 30, 40, 30, 80, 80, 20, 30, 30, 40, 30, 80};
    char units = (char)77;
    WsWell wsWell;
    WellInterp wsInterp;
    WellInterp dbInterp;
    int igdType;
    MatchData<IGDIntervalZone> data = new MatchData();

    TableModelMatchIGDInterval() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        IGDIntervalZone ws = (IGDIntervalZone)pair.getWs();
        IGDIntervalZone db = (IGDIntervalZone)pair.getDb();
        if (ws != null) {
            ws.getTopSample().displayUnits = this.units;
            ws.getBaseSample().displayUnits = this.units;
        }
        if (db != null) {
            db.getTopSample().displayUnits = this.units;
            db.getBaseSample().displayUnits = this.units;
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return ws == null ? null : ws.getTopSample();
                }
                case 1: {
                    return ws == null ? null : ws.getBaseSample();
                }
                case 2: {
                    return ws == null ? null : new StringStatus(ws.getSchemeName(true, true), ws.getStatus());
                }
                case 4: {
                    return ws == null ? null : ws;
                }
                case 3: {
                    return ws == null ? null : new StringStatus(ws.getHierString(), ws.getStatus());
                }
                case 5: {
                    return ws == null ? null : new StringStatus(ws.getConflictReason(), ws.getStatus());
                }
                case 6: {
                    return ws != null && db != null && ws.getStatus() == Sample.STORED;
                }
                case 7: {
                    return db != null ? db.getTopSample() : null;
                }
                case 8: {
                    return db != null ? db.getBaseSample() : null;
                }
                case 9: {
                    return db != null ? db.getSchemeName() : null;
                }
                case 10: {
                    return db != null ? db.getHierString() : null;
                }
                case 11: {
                    return db == null ? null : db;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return Sample.class;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return StringStatus.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 7: 
            case 8: {
                return Sample.class;
            }
            default: {
                return String.class;
            }
            case 11: 
        }
        return IGDIntervalZone.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: 
        }
        return false;
    }

    void setUpTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(6).setMaxWidth(colWidths[6]);
        SampleStatusRenderer ssr = new SampleStatusRenderer(this.units);
        ssr.setShowUnits(true);
        ssr.setShowLabels(true);
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)ssr));
        columnModel.getColumn(1).setCellRenderer((TableCellRenderer)((Object)ssr));
        SampleRenderer sr = new SampleRenderer(this.units);
        sr.setShowUnits(true);
        sr.setShowLabels(true);
        columnModel.getColumn(7).setCellRenderer(sr);
        columnModel.getColumn(8).setCellRenderer(sr);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }
}

