/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import model3.Markers;
import model3.SeismicMarker;
import util.DepthUtils;
import util.MatchData;
import util.SBException;
import util.status.DoubleStatus;
import util.status.SbugsStatus;
import util.status.StringStatus;

class TableModelMatchMarkers
extends AbstractTableModel {
    static final int COL_WS_DEPTH = 0;
    static final int COL_WS_NAME = 1;
    static final int COL_WS_COLOUR = 2;
    static final int COL_ARROW = 3;
    static final int COL_DB_DEPTH = 4;
    static final int COL_DB_NAME = 5;
    static final int COL_DB_COLOUR = 6;
    static final String[] COL_TITLES = new String[]{"Depth", "Name", "Colour", "", "Depth", "Name", "Colour"};
    static final int[] COL_WIDTHS = new int[]{30, 40, 20, 20, 30, 40, 20};
    char units;
    MatchData data = new MatchData();

    TableModelMatchMarkers() {
    }

    void init(Markers ws, Markers db) throws SBException, SQLException {
        this.data.init(ws.getList(), db != null ? db.getList() : null);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return COL_TITLES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        SeismicMarker ws = (SeismicMarker)pair.getWs();
        SeismicMarker db = (SeismicMarker)pair.getDb();
        switch (columnIndex) {
            case 0: {
                return ws != null ? new DoubleStatus(Double.valueOf(DepthUtils.convFromM((double)ws.getDepth(), (char)this.units)), ws.getStatus()) : null;
            }
            case 1: {
                return ws != null ? ws : null;
            }
            case 2: {
                return ws != null ? ws.getColour() : null;
            }
            case 3: {
                return ws != null && db != null && ws.getStatus() == SbugsStatus.STORED;
            }
            case 4: {
                return db != null ? Double.valueOf(DepthUtils.convFromM((double)db.getDepth(), (char)this.units)) : null;
            }
            case 5: {
                return db != null ? db : null;
            }
            case 6: {
                return db != null ? db.getColour() : null;
            }
        }
        return "";
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return DoubleStatus.class;
            }
            case 1: {
                return StringStatus.class;
            }
            case 4: {
                return Double.class;
            }
            case 5: {
                return StringStatus.class;
            }
            default: {
                return SeismicMarker.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 2: 
            case 6: 
        }
        return Color.class;
    }
}

