/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.project.WellList;
import com.stratadata.util.ui.table.TableUtils;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import model3.SBdb;
import model3.Well;
import model3.project.Project;
import util.SBException;

public class TableModelProjectMembership
extends AbstractTableModel {
    private final SBdb sbdb;
    private final List<Well> wells;
    private List<model3.project.WellList> wellLists;

    public TableModelProjectMembership(List<Well> wells, SBdb sbdb) throws SQLException, SBException {
        this.wells = wells;
        this.sbdb = sbdb;
        this.init();
    }

    private void init() {
        TreeMap<Integer, model3.project.WellList> wellListMap = new TreeMap<Integer, model3.project.WellList>();
        for (Well well : this.wells) {
            for (Integer wellListID : well.getHeader().getWellListIDs()) {
                wellListMap.putIfAbsent(wellListID, (model3.project.WellList)this.sbdb.getWellListService().getWellList(wellListID.intValue()));
            }
        }
        Comparator<model3.project.WellList> sortByProjectID = Comparator.comparing(WellList::getProjID);
        Comparator<model3.project.WellList> sortByWellListName = Comparator.comparing(WellList::getName);
        this.wellLists = wellListMap.values().stream().sorted(sortByProjectID.thenComparing(sortByWellListName)).toList();
    }

    @Override
    public int getRowCount() {
        return this.wells.size();
    }

    @Override
    public int getColumnCount() {
        return this.wellLists.size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.wells.get(rowIndex).toString();
        }
        int wellListID = this.wellLists.get(columnIndex - 1).getID();
        try {
            return this.wells.get(rowIndex).getHeader().getWellListIDs().contains(wellListID);
        }
        catch (RuntimeException ex) {
            return ex.getMessage();
        }
    }

    void setupTable(JTable table) throws SQLException {
        table.getColumnModel().getColumn(0).setHeaderValue("Well");
        int index = 0;
        for (model3.project.WellList wellList : this.wellLists) {
            ++index;
            Project project = this.sbdb.getProject(wellList.getProjID());
            Object columnName = wellList.getName();
            if (this.sbdb.getWellListService().getWellLists(project.getID()).size() > 1) {
                columnName = (String)columnName + " [" + project.getName() + "]";
            }
            table.getColumnModel().getColumn(index).setHeaderValue(columnName);
        }
        TableUtils.setTableHeaderBold((JTable)table);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
        }
        return Boolean.class;
    }
}

