/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import model3.Lastval;
import model3.SBdb;

public abstract class TableModelSB
extends AbstractTableModel {
    private int[] columnWidths;
    private int[] columnOrder;
    static Boolean linked = true;
    static Boolean unlinked = false;
    private static final Logger LOGGER = Logger.getLogger(TableModelSB.class.getName());

    public abstract String getPrefString();

    public abstract String getPrefOrderString();

    public abstract String getAutoResizeString();

    public abstract int[] getDefaultColumnWidths();

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public abstract String[] getColumnTitles();

    String[] getColumnTitles(JTable table) {
        return this.getColumnTitles();
    }

    @Override
    public String getColumnName(int col) {
        return this.getColumnTitles()[col];
    }

    public void init(JTable table, SBdb sbdb) {
        this.columnWidths = new int[this.getDefaultColumnWidths().length];
        this.columnOrder = new int[this.getDefaultColumnWidths().length];
        TableUtils.setTableHeaderBold((JTable)table);
        this.setDefaultColumnWidths();
        int autoResize = -1;
        if (sbdb != null) {
            try {
                this.setColumnValues(this.columnWidths, sbdb, this.getPrefString());
                this.setColumnValues(this.columnOrder, sbdb, this.getPrefOrderString());
                autoResize = Lastval.getInt(sbdb, this.getAutoResizeString(), -1);
            }
            catch (SQLException sql) {
                System.out.println("Error getting preferences: " + this.getPrefString());
            }
        }
        this.setupColumns(table);
        if (autoResize >= 0) {
            table.setAutoResizeMode(autoResize);
        }
    }

    void setupColumns(JTable table) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int modelIndex = table.convertColumnIndexToModel(i);
            TableColumn column = table.getColumnModel().getColumn(i);
            column.setHeaderValue(this.getColumnName(modelIndex));
            int prefWidth = this.columnWidths[modelIndex];
            if (prefWidth == 0) {
                column.setMinWidth(0);
                column.setMaxWidth(0);
                continue;
            }
            int maxwidth = Integer.MAX_VALUE;
            int minWidth = 15;
            column.setMaxWidth(maxwidth);
            column.setMinWidth(minWidth);
            column.setPreferredWidth(this.columnWidths[modelIndex]);
        }
    }

    public void resetColumnOrder(JTable table) {
        int[] defaultOrder = new int[table.getColumnCount()];
        for (int i = 0; i < defaultOrder.length; ++i) {
            defaultOrder[i] = i;
        }
        this.setColumnOrder(table, defaultOrder);
    }

    public void restoreColumnOrder(JTable table) {
        HashSet<Integer> h = new HashSet<Integer>();
        for (int order : this.columnOrder) {
            if (h.add(order)) continue;
            LOGGER.log(Level.WARNING, "Table column mis-match in order, table pref is: {0}", this.getPrefOrderString());
            return;
        }
        if (this.columnOrder.length != this.getColumnCount()) {
            LOGGER.log(Level.WARNING, "Table column order no longer the same size as table, column order unset: {0}", this.getPrefOrderString());
            return;
        }
        this.setColumnOrder(table, this.columnOrder);
    }

    private void setColumnOrder(JTable table, int[] order) {
        int i;
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn[] columnsModelOrder = new TableColumn[table.getColumnCount()];
        if (columnsModelOrder.length != order.length) {
            return;
        }
        for (i = 0; i < columnsModelOrder.length; ++i) {
            columnsModelOrder[columnModel.getColumn((int)i).getModelIndex()] = columnModel.getColumn(i);
        }
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        for (i = 0; i < order.length; ++i) {
            columnModel.addColumn(columnsModelOrder[order[i]]);
        }
    }

    void setDefaultColumnWidths() {
        this.columnWidths = new int[this.getDefaultColumnWidths().length];
        System.arraycopy(this.getDefaultColumnWidths(), 0, this.columnWidths, 0, this.getDefaultColumnWidths().length);
    }

    public void putTableColumnWidths(SBdb sbdb, JTable table) throws SQLException {
        Object widths = "";
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int columnWidth = table.getColumnModel().getColumn(table.convertColumnIndexToView(i)).getWidth();
            widths = (String)widths + columnWidth + " ";
        }
        Lastval.putString(sbdb, this.getPrefString(), (String)widths);
        Lastval.putInt(sbdb, this.getAutoResizeString(), table.getAutoResizeMode());
    }

    public void putTableColumnOrder(SBdb sbdb, JTable table) throws SQLException {
        Object order = "";
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int columnOrder = table.convertColumnIndexToModel(i);
            order = (String)order + columnOrder + " ";
        }
        Lastval.putString(sbdb, this.getPrefOrderString(), (String)order);
    }

    private void setColumnValues(int[] values, SBdb sbdb, String prefString) throws SQLException {
        String widths = Lastval.getString(sbdb, prefString);
        if (widths != null && widths.length() > 0) {
            StringTokenizer tok = new StringTokenizer(widths);
            if (tok.countTokens() != this.getColumnCount()) {
                return;
            }
            int i = 0;
            while (tok.hasMoreTokens()) {
                values[i++] = Integer.parseInt(tok.nextToken());
            }
        }
    }

    public abstract void setupTable(JTable var1, SBdb var2);

    void setUnits(char units) {
    }
}

