/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import model3.Taxon;
import util.SB;

class TableModelSourceMatches
extends AbstractTableModel {
    static String[] colTitles = new String[]{"Donor", "Category", "Host", "Type"};
    static int[] colWidths = new int[]{100, 20, 80, 20};
    static final int COL_DONOR = 0;
    static final int COL_CAT = 1;
    static final int COL_HOST = 2;
    static final int COL_TYPE = 3;
    List<Taxon> taxa = new ArrayList<Taxon>();
    List<String> donor = new ArrayList<String>();

    TableModelSourceMatches() {
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        return this.taxa.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.taxa.size() == 0) {
            return "";
        }
        switch (col) {
            case 0: {
                return this.donor.get(row);
            }
            case 1: {
                return this.taxa.get(row).getCatMnem();
            }
            case 2: {
                return this.taxa.get(row).toString(false, false);
            }
            case 3: {
                return this.taxa.get(row).getDonorOccType();
            }
        }
        return "";
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
        }
        return Object.class;
    }

    void setupTable(JTable jTable) {
        SB.setTableHeaderBold((JTable)jTable);
        for (int i = 0; i < colTitles.length; ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
    }
}

