/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.HashSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import model3.IGDIntervalZone;
import model3.TSCreatorReader;
import util.SB;

class TableModelTSCreator
extends AbstractTableModel {
    TSCreatorReader.TSCScheme scheme;
    JComboBox comboBox = new JComboBox();
    static String[] titles = new String[]{"Block", "Scheme column type"};
    static int[] widths = new int[]{200, 30};
    static final int COL_BLOCK = 0;
    static final int COL_TYPE = 1;
    int igdType = 0;
    static String NO_SELECTION = "<not selected>";

    TableModelTSCreator() {
    }

    @Override
    public int getColumnCount() {
        return titles.length;
    }

    @Override
    public int getRowCount() {
        if (this.scheme == null) {
            return 0;
        }
        return this.scheme.getBlockCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.scheme.getBlock(row).toString();
            }
            case 1: {
                if (this.igdType <= 0) break;
                int hier = this.scheme.getBlock(row).getHier();
                if (hier > 0) {
                    return IGDIntervalZone.getHierName(this.igdType, hier);
                }
                return NO_SELECTION;
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 1: 
        }
        return this.igdType != 26;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        switch (col) {
            default: {
                break;
            }
            case 1: {
                TSCreatorReader.TSCBlockBase block = this.scheme.getBlock(row);
                String hierString = obj.toString();
                if (hierString.equals(NO_SELECTION)) {
                    block.setHier(0);
                    break;
                }
                block.setHier(IGDIntervalZone.getHierNumber(this.igdType, hierString, true));
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: 
        }
        return String.class;
    }

    public void load(TSCreatorReader.TSCScheme scheme, int igdType) {
        this.scheme = scheme;
        this.igdType = igdType;
        this.comboBox.removeAllItems();
        this.comboBox.addItem(NO_SELECTION);
        if (igdType > 0) {
            int nHier = IGDIntervalZone.getNHier(igdType, true);
            for (int i = 1; i <= nHier; ++i) {
                this.comboBox.addItem(IGDIntervalZone.getHierName(igdType, i));
            }
            HashSet<Integer> set = new HashSet<Integer>();
            block1: for (int i = 0; i < scheme.getBlockCount(); ++i) {
                TSCreatorReader.TSCBlockBase block = scheme.getBlock(i);
                for (int hier = IGDIntervalZone.getNHier(igdType, true); hier > 0; --hier) {
                    if (set.contains(hier)) continue;
                    if (igdType == 4 && block.toString().toLowerCase().contains(" subzone")) {
                        block.setHier(3);
                        continue;
                    }
                    if (!block.toString().toLowerCase().contains(IGDIntervalZone.getHierName(igdType, hier).toLowerCase())) continue;
                    block.setHier(hier);
                    set.add(hier);
                    continue block1;
                }
            }
        }
    }

    void setupTable(JTable jTable) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(titles[i]);
            jTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
        jTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboBox));
        SB.setTableHeaderBold((JTable)jTable);
        this.scheme = null;
    }
}

