/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.abnsch;

import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.validation.FieldLengthProperties;
import com.stratadata.model3.validation.SbugsValidator;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.abnsch.DialogAbnSchemeUsage;
import jsbugs.table.IntegerEditor;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;
import util.table.SbugsTable;

public class DialogAbnScheme
extends SBDialog {
    private static final int NAME_LEN = FieldLengthProperties.getFieldLength(AbundanceSchemeImpl.class, (String)"name", (int)25);
    private static final int COL_ABR = 0;
    private static final int COL_MIN = 1;
    private static final int COL_OUTPUT = 2;
    private static final int COL_DESC = 3;
    private static final String[] COL_TITLES = new String[]{"Abr.", "Minimum", "Output", "Description"};
    private static final int[] COL_WIDTHS = new int[]{60, 60, 60, 150};
    private final AbnSchemeTableModel model = new AbnSchemeTableModel(this);
    private final SBdb db;
    private AbundanceScheme originalScheme;
    private AbundanceSchemeImpl scheme;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JButton jButtonRemove;
    private JButton jButtonShowWells;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableAbn;
    private JTextField jTextFieldName;

    public static DialogAbnScheme toAddNewScheme(JDialog parent, SBdb db) {
        return new DialogAbnScheme(parent, true, db, null, new AbundanceSchemeImpl(0));
    }

    public static DialogAbnScheme toAddExistingScheme(JDialog parent, SBdb db, AbundanceScheme schemeToAdd) {
        AbundanceSchemeImpl newScheme = new AbundanceSchemeImpl(0, new AuditImpl(), schemeToAdd.getEntries());
        newScheme.setName(schemeToAdd.getName());
        return new DialogAbnScheme(parent, true, db, null, newScheme);
    }

    public static DialogAbnScheme toEditScheme(JDialog parent, SBdb db, AbundanceScheme schemeToEdit) {
        return new DialogAbnScheme(parent, true, db, schemeToEdit, new AbundanceSchemeImpl(schemeToEdit));
    }

    private DialogAbnScheme(JDialog parent, boolean modal, SBdb db, AbundanceScheme originalScheme, AbundanceSchemeImpl newScheme) {
        super((Window)parent, modal);
        this.initComponents();
        this.db = db;
        this.originalScheme = originalScheme;
        this.scheme = newScheme;
        this.init();
    }

    private void init() {
        TableUtils.setTableHeaderBold((JTable)this.jTableAbn);
        TableColumnModel columnModel = this.jTableAbn.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(COL_TITLES[i]);
            columnModel.getColumn(i).setWidth(COL_WIDTHS[i]);
        }
        this.jTableAbn.setDefaultEditor(Integer.class, new IntegerEditor(false));
        this.jTextFieldName.setText(this.scheme.getName());
        this.model.fireTableDataChanged();
        if (this.originalScheme != null) {
            this.setTitle("Abundance Scheme : Edit");
        } else {
            this.setTitle("Abundance Scheme : Add");
            this.jButtonShowWells.setEnabled(false);
        }
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = TextFieldUtils.buildLimitedLengthTextField(NAME_LEN);
        this.jScrollPane1 = new JScrollPane();
        this.jTableAbn = new SbugsTable((TableModel)this.model);
        this.jButtonAdd = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonShowWells = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.setModal(true);
        this.jLabel1.setText("Name :");
        this.jTableAbn.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableAbn);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnScheme this$0;
            {
                DialogAbnScheme dialogAbnScheme = this$0;
                Objects.requireNonNull(dialogAbnScheme);
                this.this$0 = dialogAbnScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert");
        this.jButtonInsert.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnScheme this$0;
            {
                DialogAbnScheme dialogAbnScheme = this$0;
                Objects.requireNonNull(dialogAbnScheme);
                this.this$0 = dialogAbnScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnScheme this$0;
            {
                DialogAbnScheme dialogAbnScheme = this$0;
                Objects.requireNonNull(dialogAbnScheme);
                this.this$0 = dialogAbnScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnScheme this$0;
            {
                DialogAbnScheme dialogAbnScheme = this$0;
                Objects.requireNonNull(dialogAbnScheme);
                this.this$0 = dialogAbnScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnScheme this$0;
            {
                DialogAbnScheme dialogAbnScheme = this$0;
                Objects.requireNonNull(dialogAbnScheme);
                this.this$0 = dialogAbnScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnScheme this$0;
            {
                DialogAbnScheme dialogAbnScheme = this$0;
                Objects.requireNonNull(dialogAbnScheme);
                this.this$0 = dialogAbnScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonShowWells.setText("Show wells...");
        this.jButtonShowWells.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowWells.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnScheme this$0;
            {
                DialogAbnScheme dialogAbnScheme = this$0;
                Objects.requireNonNull(dialogAbnScheme);
                this.this$0 = dialogAbnScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowWellsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldName, -1, 329, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 367, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonHelp, -2, 85, -2).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonInsert, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonRemove, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonShowWells).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonInsert).addPreferredGap(0).add((Component)this.jButtonRemove).add(18, 18, 18).add((Component)this.jButtonShowWells).addPreferredGap(0, 54, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 257, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableAbn.isEditing()) {
            this.jTableAbn.getCellEditor().stopCellEditing();
        }
        this.scheme.setName(this.jTextFieldName.getText());
        SbugsValidator validator = SbugsValidator.validate((Object)this.scheme, (SbugsValidator.ValidationStrategy)SbugsValidator.ValidationStrategy.IGNORE_ID);
        List validatorMessages = validator.getMessages();
        if (!validatorMessages.isEmpty()) {
            Object message = "Cannot save scheme:\n";
            message = (String)message + StringUtils.join((Iterable)validatorMessages, (String)"\n");
            JOptionPane.showMessageDialog((Component)((Object)this), message, this.getTitle(), 2);
            return;
        }
        try {
            if (this.originalScheme != null) {
                int occurrences = this.db.getAbundanceSchemeInformationService().countAnalystHeaderUsages(this.originalScheme.getAbnSchID());
                if (occurrences > 0 && JOptionPane.showConfirmDialog((Component)((Object)this), "This scheme is linked to " + occurrences + " analysis suites. Are you sure you want to edit it?", "Update Abundance Scheme", 0, 3) != 0) {
                    return;
                }
                HashMap<String, Integer> updatedClassOccurrences = this.db.getAbundanceSchemeInformationService().getUpdatedClassOccurrences(this.originalScheme, (AbundanceScheme)this.scheme);
                long updatedOccurrences = updatedClassOccurrences.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).count();
                if (updatedOccurrences > 0L) {
                    String message = "You cannot make these changes to abbreviations in the scheme because they are recorded in analyses:\n" + StringUtils.join(updatedClassOccurrences.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(e -> (String)e.getKey() + " (" + String.valueOf(e.getValue()) + " times)").toList(), (String)"\n") + "\nYou must reassign those analyses to a different scheme if you wish to change this scheme. Use 'Show wells' to explore these analyses and make changes.";
                    JOptionPane.showMessageDialog((Component)((Object)this), message, "Update Abundance Scheme", 2);
                    return;
                }
                this.db.getAbundanceSchemeService().updateAbundanceScheme(this.scheme);
            } else {
                this.scheme.sortEntries();
                this.originalScheme = this.db.getAbundanceSchemeService().addAbundanceScheme((AbundanceScheme)this.scheme);
            }
            this.setOK();
        }
        catch (RuntimeException | SQLException e2) {
            SbugsExceptionHandler.showStackError(e2, (Component)((Object)this));
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.scheme.getEntryCount() == 12) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You have reached the maximum number of classes.", this.getTitle(), 2);
            return;
        }
        if (this.jTableAbn.isEditing()) {
            this.jTableAbn.getCellEditor().stopCellEditing();
        }
        try {
            int item = this.scheme.getEntryCount();
            this.scheme.addEntry(new AbundanceScheme.AbundanceSchemeEntry("", "", 0, 0));
            this.model.fireTableDataChanged();
            this.jTableAbn.setRowSelectionInterval(item, item);
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re, (Component)((Object)this));
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        if (this.jTableAbn.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row to insert above", "Warning", 2);
            return;
        }
        if (this.scheme.getEntryCount() == 12) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You have reached the maximum number of classes.", this.getTitle(), 2);
            return;
        }
        if (this.jTableAbn.isEditing()) {
            this.jTableAbn.getCellEditor().stopCellEditing();
        }
        try {
            int index = this.jTableAbn.getSelectedRow();
            this.scheme.insertEntry(index, new AbundanceScheme.AbundanceSchemeEntry("", "", 0, 0));
            this.model.fireTableDataChanged();
            this.jTableAbn.setRowSelectionInterval(index, index);
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re, (Component)((Object)this));
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.jTableAbn.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a row", "Warning", 2);
            return;
        }
        try {
            Optional.ofNullable(this.jTableAbn.getCellEditor()).ifPresent(e -> e.stopCellEditing());
            int[] selection = this.jTableAbn.getSelectedRows();
            for (int i = selection.length - 1; i >= 0; --i) {
                this.scheme.removeEntry(selection[i]);
            }
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re, (Component)((Object)this));
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogabnscheme.html");
    }

    private void jButtonShowWellsActionPerformed(ActionEvent evt) {
        try {
            DialogAbnSchemeUsage dialog = new DialogAbnSchemeUsage((JDialog)((Object)this), true, this.db, this.originalScheme);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    public AbundanceScheme getScheme() {
        return this.originalScheme;
    }

    private class AbnSchemeTableModel
    extends AbstractTableModel {
        final /* synthetic */ DialogAbnScheme this$0;

        private AbnSchemeTableModel(DialogAbnScheme dialogAbnScheme) {
            DialogAbnScheme dialogAbnScheme2 = dialogAbnScheme;
            Objects.requireNonNull(dialogAbnScheme2);
            this.this$0 = dialogAbnScheme2;
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.scheme == null) {
                return 0;
            }
            return this.this$0.scheme.getEntryCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.this$0.scheme.getEntryCount()) {
                AbundanceScheme.AbundanceSchemeEntry entry = this.this$0.scheme.getEntry(row);
                return switch (col) {
                    case 0 -> entry.abr();
                    case 1 -> entry.lowBound();
                    case 2 -> entry.outputVal();
                    case 3 -> entry.entryName();
                    default -> "";
                };
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (obj == null) {
                return;
            }
            AbundanceScheme.AbundanceSchemeEntry existingEntry = this.this$0.scheme.getEntry(row);
            try {
                switch (col) {
                    case 0: {
                        String s = ((String)obj).toUpperCase();
                        if (s.length() > 4) {
                            s = s.substring(0, 4);
                            this.this$0.getToolkit().beep();
                        }
                        this.this$0.scheme.setEntry(row, new AbundanceScheme.AbundanceSchemeEntry(existingEntry.entryName(), s, existingEntry.lowBound(), existingEntry.outputVal()));
                        break;
                    }
                    case 1: {
                        int min = Integer.parseInt((String)obj);
                        this.this$0.scheme.setEntry(row, new AbundanceScheme.AbundanceSchemeEntry(existingEntry.entryName(), existingEntry.abr(), min, existingEntry.outputVal() > 0 ? existingEntry.outputVal() : min));
                        break;
                    }
                    case 2: {
                        this.this$0.scheme.setEntry(row, new AbundanceScheme.AbundanceSchemeEntry(existingEntry.entryName(), existingEntry.abr(), existingEntry.lowBound(), Integer.parseInt(obj.toString())));
                        break;
                    }
                    case 3: {
                        String s = (String)obj;
                        if (s.length() > 25) {
                            s = s.substring(0, 25);
                            this.this$0.getToolkit().beep();
                        }
                        this.this$0.scheme.setEntry(row, new AbundanceScheme.AbundanceSchemeEntry(s, existingEntry.abr(), existingEntry.lowBound(), existingEntry.outputVal()));
                        break;
                    }
                }
            }
            catch (RuntimeException pe) {
                pe.printStackTrace();
            }
        }

        public Class getColumnClass(int c) {
            return switch (c) {
                case 0, 3 -> String.class;
                case 1, 2 -> Integer.class;
                default -> Object.class;
            };
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
}

