/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jsbugs.chart.ChartBlockSummary;

public class ChartBlockListItem
extends JPanel {
    private JLabel jLabelBlockName;
    private JLabel jLabelBlockTarget;
    private JLabel jLabelCaption;

    public ChartBlockListItem() {
        this.initComponents();
    }

    public int measureTargetText(String target) {
        return this.getFontMetrics(this.jLabelBlockTarget.getFont()).stringWidth(target);
    }

    public void setSummaryData(ChartBlockSummary summary) {
        this.jLabelBlockTarget.setIcon(summary.getTypeIcon());
        this.jLabelBlockTarget.setText(summary.getTarget());
        this.jLabelBlockName.setIcon(summary.getProjectIcon());
        this.jLabelBlockName.setText(summary.getTemplateName());
        this.jLabelCaption.setText(summary.getCaption());
    }

    public void setCaptionWidth(int width) {
        int height = this.jLabelCaption.getPreferredSize().height;
        this.jLabelCaption.setMaximumSize(new Dimension(width, height));
        this.jLabelCaption.setMinimumSize(new Dimension(width, height));
        this.jLabelCaption.setPreferredSize(new Dimension(width, height));
    }

    public void setTargetWidth(int width) {
        int height = this.jLabelBlockTarget.getPreferredSize().height;
        this.jLabelBlockTarget.setMaximumSize(new Dimension(width, height));
        this.jLabelBlockTarget.setMinimumSize(new Dimension(width, height));
        this.jLabelBlockTarget.setPreferredSize(new Dimension(width, height));
    }

    public void setNameWidth(int width) {
        int height = this.jLabelBlockTarget.getPreferredSize().height;
        this.jLabelBlockName.setMaximumSize(new Dimension(width, height));
        this.jLabelBlockName.setMinimumSize(new Dimension(width, height));
        this.jLabelBlockName.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.jLabelBlockName != null) {
            this.jLabelBlockName.setForeground(fg);
        }
        if (this.jLabelBlockTarget != null) {
            this.jLabelBlockTarget.setForeground(fg);
        }
        if (this.jLabelCaption != null) {
            this.jLabelCaption.setForeground(fg);
        }
    }

    private void initComponents() {
        this.jLabelCaption = new JLabel();
        this.jLabelBlockName = new JLabel();
        this.jLabelBlockTarget = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BoxLayout(this, 0));
        this.jLabelCaption.setFont(new Font("Tahoma", 1, 11));
        this.jLabelCaption.setText("Well 1");
        this.add(this.jLabelCaption);
        this.jLabelBlockName.setHorizontalAlignment(2);
        this.jLabelBlockName.setText("New Block Template");
        this.add(this.jLabelBlockName);
        this.jLabelBlockTarget.setText("Well 1");
        this.add(this.jLabelBlockTarget);
    }
}

