/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jsbugs.chart.ChartBlockListItem;
import jsbugs.chart.ChartBlockSummary;

public class ChartBlockListRenderer
implements ListCellRenderer {
    private int targetWidth = 30;
    private int nameWidth = 30;
    private int captionWidth = 30;
    private Color selectedBackground = new Color(0, 120, 215);

    public void setSelectionBackground(Color c) {
        this.selectedBackground = c;
    }

    public void setTargetWidth(int width) {
        this.targetWidth = width;
    }

    public void setNameWidth(int width) {
        this.nameWidth = width;
    }

    public void setCaptionWidth(int width) {
        this.captionWidth = width;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null && value instanceof ChartBlockSummary) {
            ChartBlockSummary summary = (ChartBlockSummary)value;
            ChartBlockListItem item = new ChartBlockListItem();
            item.setSummaryData(summary);
            item.setTargetWidth(this.targetWidth);
            item.setNameWidth(this.nameWidth);
            item.setCaptionWidth(this.captionWidth);
            if (isSelected) {
                item.setBackground(this.selectedBackground);
                item.setForeground(Color.white);
            } else {
                item.setBackground(Color.white);
                item.setForeground(Color.black);
            }
            return item;
        }
        return null;
    }
}

