/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlockBase;
import jsbchart.core.ChartProperties;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsSession;
import model3.InterpHdr;

public class ChartBlockSummary {
    private static final Logger LOGGER = Logger.getLogger(ChartBlockSummary.class.getName());
    private final ChartBlockBase block;
    private final ChartProperties cp;

    public ChartBlockSummary(ChartBlockBase block, ChartProperties cp) {
        this.block = block;
        this.cp = cp;
    }

    public BlockType getType() {
        return this.block.getBlockType();
    }

    public String getTarget() {
        String target = "";
        if (this.getType() == BlockType.WELL && this.block.getWell() != null) {
            target = this.block.getWell().getWellName();
        } else if (this.getType() == BlockType.PROJECT && this.block.getWellList() != null) {
            target = this.block.getWellList().getName();
        }
        return target;
    }

    public String getCaption() {
        return this.block.getTemplatedCaption(this.cp);
    }

    public String getTemplateName() {
        return this.block.getTemplate().getName();
    }

    public boolean isGlobalProject() {
        return this.block.getTemplate().getProjID() == 0;
    }

    public String getProjectName() {
        String projectName = "Global";
        if (!this.isGlobalProject()) {
            try {
                projectName = SbugsSession.getDb().getProject(this.block.getTemplate().getProjID()).getName();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Error while retriving project name for project id: " + this.block.getTemplate().getProjID(), ex);
                projectName = ex.getMessage();
            }
        }
        return projectName;
    }

    public String getVersion() {
        String version = "?";
        try {
            InterpHdr hdr = SbugsSession.getDb().getInterp(this.block.getInterpID());
            version = hdr.toString();
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return version;
    }

    public ChartBlockBase getBlock() {
        return this.block;
    }

    Icon getTypeIcon() {
        return this.getType().getIcon();
    }

    Icon getProjectIcon() {
        String name = "panelProjectUnlocked.png";
        if (this.isGlobalProject()) {
            name = "panelGlobalUnlocked.png";
        }
        return IconFactory.getIcon(name);
    }
}

