/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbchart.util.colour.ColourScale;
import jsbugs.table.ColourButtonRenderer;
import jsbugs.table.ColourChooserEditor;
import jsbugs.table.FloatEditor;

public class DialogColourScale
extends SBDialog {
    private final TableModelDataCoverageScale model = new TableModelDataCoverageScale(this);
    private List<ColourScale.ValueColour> scale;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DialogColourScale(Frame parent, boolean modal, ColourScale dataCoverageScale) {
        super(parent, modal);
        this.scale = dataCoverageScale.getScale();
        this.initComponents();
        this.init(dataCoverageScale);
    }

    private void init(ColourScale dataCoverageScale) {
        this.setTitle("Data Coverage Scale : Edit");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        TableColumnModel columnModel = this.jTable1.getTableHeader().getColumnModel();
        columnModel.getColumn(0).setHeaderValue("Items per m/ft");
        columnModel.getColumn(1).setHeaderValue("Colour");
        TableUtils.setTableHeaderBold((JTable)this.jTable1);
        this.jTable1.setDefaultEditor(Double.class, new FloatEditor(false));
        this.jTable1.setDefaultEditor(Color.class, new ColourChooserEditor());
        this.jTable1.setDefaultRenderer(Color.class, new ColourButtonRenderer());
    }

    private void refresh() {
        Collections.sort(this.scale);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTable1.setModel(this.model);
        this.jTable1.setSelectionMode(0);
        this.jTable1.setShowGrid(true);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogColourScale this$0;
            {
                DialogColourScale dialogColourScale = this$0;
                Objects.requireNonNull(dialogColourScale);
                this.this$0 = dialogColourScale;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogColourScale this$0;
            {
                DialogColourScale dialogColourScale = this$0;
                Objects.requireNonNull(dialogColourScale);
                this.this$0 = dialogColourScale;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogColourScale this$0;
            {
                DialogColourScale dialogColourScale = this$0;
                Objects.requireNonNull(dialogColourScale);
                this.this$0 = dialogColourScale;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogColourScale this$0;
            {
                DialogColourScale dialogColourScale = this$0;
                Objects.requireNonNull(dialogColourScale);
                this.this$0 = dialogColourScale;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 202, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonDelete, -1, 93, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 170, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        int row = this.jTable1.getSelectedRow();
        if (row >= 0) {
            this.scale.add(row, new ColourScale.ValueColour(0.0, Color.RED));
        }
        this.refresh();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int row = this.jTable1.getSelectedRow();
        if (row < 0 || row == this.scale.size() - 1) {
            return;
        }
        this.scale.remove(this.jTable1.getSelectedRow());
        this.refresh();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setOK();
    }

    public ColourScale getScale() {
        return new ColourScale(this.scale);
    }

    private class TableModelDataCoverageScale
    extends AbstractTableModel {
        final /* synthetic */ DialogColourScale this$0;

        private TableModelDataCoverageScale(DialogColourScale dialogColourScale) {
            DialogColourScale dialogColourScale2 = dialogColourScale;
            Objects.requireNonNull(dialogColourScale2);
            this.this$0 = dialogColourScale2;
        }

        @Override
        public int getRowCount() {
            return this.this$0.scale.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ColourScale.ValueColour valueColour = this.this$0.scale.get(rowIndex);
            return switch (columnIndex) {
                case 0 -> {
                    if (valueColour.maxValue() == null) {
                        if (rowIndex == 0) {
                            yield "max";
                        }
                        yield "> " + this.this$0.scale.get(rowIndex - 1).maxValue();
                    }
                    yield valueColour.maxValue();
                }
                case 1 -> valueColour.colour();
                default -> null;
            };
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ColourScale.ValueColour valueColour = this.this$0.scale.get(rowIndex);
            Double value = valueColour.maxValue();
            Color colour = valueColour.colour();
            switch (columnIndex) {
                case 0: {
                    value = Double.valueOf((String)aValue);
                    break;
                }
                case 1: {
                    colour = (Color)aValue;
                }
            }
            this.this$0.scale.set(rowIndex, new ColourScale.ValueColour(value, colour));
            this.this$0.refresh();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> String.class;
                case 1 -> Color.class;
                default -> Object.class;
            };
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0 || rowIndex != this.this$0.scale.size() - 1;
        }
    }
}

