/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.util.ui.SBDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelType;
import jsbchart.panel.spatial.LayerShape;
import jsbchart.panel.spatial.SBShapeStore;
import jsbugs.chart.StretchyMapBlockPanel;
import jsbugs.chart.properties.PanelPropertiesTableModel;
import jsbugs.chart.properties.PropertiesTable;
import jsbugs.table.ColourRenderer;
import jsbugs.userconnect.SbugsSession;
import model3.SBdb;
import util.SBException;

public class DialogLayerShapeList
extends SBDialog {
    private static Logger LOGGER = Logger.getLogger(DialogLayerShapeList.class.getName());
    private final ChartManager cm;
    private final JFrame parent;
    private final SBdb sbdb;
    private PanelPropertiesTableModel propTableModel;
    private final DefaultListModel<PanelTemplate> templateListModel = new DefaultListModel();
    private JList<PanelTemplate> panelList;
    private PropertiesTable propertiesTable;
    private StretchyMapBlockPanel previewMap;
    private MapBlock previewBlock;

    public DialogLayerShapeList(JFrame parent, boolean modal) {
        this(parent, modal, SbugsSession.getSession().getChartManager(), SbugsSession.getSession().getDB());
    }

    public DialogLayerShapeList(JFrame parent, boolean modal, ChartManager cm, SBdb sbdb) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.sbdb = sbdb;
        this.cm = cm;
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(1);
        this.setTitle("Select LayerShape panel");
        this.setLayout(new BorderLayout());
        this.setupPanelList();
        this.setupPreviewMap();
        this.setupPreviewPropertiesTable();
        JPanel listPanel = this.buildListPanel();
        JPanel mapPreviewPanel = this.buildMapPreviewPanel();
        JPanel buttonPanel = this.buildButtonPanel();
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.3);
        splitPane.setBorder(new EmptyBorder(5, 5, 0, 5));
        splitPane.setLeftComponent(listPanel);
        splitPane.setRightComponent(mapPreviewPanel);
        this.add(splitPane, "Center");
        this.add(buttonPanel, "South");
        this.pack();
        this.setSize(new Dimension(600, 600));
    }

    private void setupPanelList() {
        List<PanelTemplate> templates = null;
        try {
            templates = this.cm.getPanels(PanelType.SHAPE, 0, true);
        }
        catch (SQLException | SBException e2) {
            LOGGER.log(Level.SEVERE, "Exception while populating template list.", e2);
        }
        templates.sort(Comparator.comparing(PanelTemplate::toString));
        this.templateListModel.addAll(templates);
        this.panelList = new JList();
        this.panelList.setModel(this.templateListModel);
        this.panelList.setSelectionMode(0);
        this.panelList.addListSelectionListener(e -> this.onListChange(e));
    }

    private void setupPreviewMap() {
        this.previewMap = new StretchyMapBlockPanel();
        this.previewMap.setBackground(Color.white);
        this.previewMap.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.previewBlock = new MapBlock(this.sbdb, null, null);
        this.previewBlock.getProp().setLegendOrientation(MapBlockProperties.LegendOrientation.NONE);
        try {
            this.previewMap.setMapBlock(this.previewBlock);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error setting up layer shape preview", e);
        }
    }

    private void setupPreviewPropertiesTable() {
        this.propertiesTable = new PropertiesTable();
        this.propTableModel = new PanelPropertiesTableModel(this.parent, this.cm, this.sbdb);
        this.propTableModel.setEditable(false);
        this.propTableModel.setCellRenderer((Class)Color.class, (TableCellRenderer)new ColourRenderer(true));
        this.propTableModel.setCellRenderer((Class)SBShapeStore.class, (TableCellRenderer)new DefaultTableCellRenderer());
        this.propertiesTable.setModel(this.propTableModel);
    }

    private JPanel buildListPanel() {
        JPanel listPanel = new JPanel(new BorderLayout());
        JScrollPane listScrollPane = new JScrollPane();
        listScrollPane.setViewportView(this.panelList);
        listPanel.add((Component)listScrollPane, "Center");
        return listPanel;
    }

    private JPanel buildMapPreviewPanel() {
        JPanel previewPanel = new JPanel(new BorderLayout());
        JScrollPane propertiesTableScrollPane = new JScrollPane();
        this.propertiesTable.setPreferredScrollableViewportSize(this.propertiesTable.getPreferredSize());
        propertiesTableScrollPane.setViewportView(this.propertiesTable);
        propertiesTableScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        previewPanel.add((Component)this.previewMap, "Center");
        previewPanel.add((Component)propertiesTableScrollPane, "South");
        return previewPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(2);
        buttonPanel.setLayout(fl);
        JButton okJButton = new JButton("OK");
        okJButton.addActionListener(e -> this.onOKPress());
        JButton cancelJButton = new JButton("Cancel");
        cancelJButton.addActionListener(e -> this.onCancelPress());
        buttonPanel.add(okJButton);
        buttonPanel.add(cancelJButton);
        return buttonPanel;
    }

    private void onListChange(ListSelectionEvent e) {
        PanelTemplate pt = this.panelList.getSelectedValue();
        this.propTableModel.setTemplate(pt, null);
        this.propTableModel.fireTableDataChanged();
        this.propertiesTable.setPreferredScrollableViewportSize(this.propertiesTable.getPreferredSize());
        if (pt.getType() == PanelType.SHAPE) {
            this.previewBlock.clearMembers();
            PanelOcc p = new PanelOcc(-1);
            LayerShape ls = new LayerShape(pt, p, this.previewBlock);
            this.previewBlock.addMember(ls);
            try {
                this.previewBlock.setData(this.previewMap.getChartProperties());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error updating preview map.", e);
            }
        }
        this.setPreferredSize(this.getSize());
        this.pack();
        this.setPreferredSize(null);
        this.repaint();
    }

    public PanelTemplate getSelectedTemplate() {
        return this.panelList.getSelectedValue();
    }

    private void onOKPress() {
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void onCancelPress() {
        this.setIsOK(false);
        this.setVisible(false);
    }

    public void setSelectedTemplate(Integer id) {
        Integer selectIndex = null;
        for (int i = 0; i < this.templateListModel.getSize(); ++i) {
            if (this.templateListModel.get(i) == null || this.templateListModel.get(i).getID() != id.intValue()) continue;
            selectIndex = i;
            break;
        }
        if (selectIndex != null) {
            this.panelList.setSelectedIndex(selectIndex);
        }
    }
}

