/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableRowSorter;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.core.TemplateDescr;
import jsbchart.graphics.map.WellEnvelopeHelper;
import jsbchart.panel.spatial.LayerWellLocation;
import jsbchart.panel.spatial.LayerWellLocationWithSelection;
import jsbugs.TableModelBlockTemplates;
import jsbugs.chart.StretchyMapBlockPanel;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.uiutil.GlassPaneTimer;
import jsbugs.uiutil.GlassPaneWrapper;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.SBdb;
import model3.Well;
import model3.project.Project;
import org.geotools.geometry.jts.ReferencedEnvelope;
import util.SBException;

public class DialogMapBlockSelect
extends SBDialog {
    private static Logger LOGGER = Logger.getLogger(DialogMapBlockSelect.class.getName());
    private final ChartManager cm;
    private final JFrame parent;
    private final SBdb sbdb;
    private TableModelBlockTemplates tableModelBlockTemplates;
    private JTable jTableBlockTemplates = new JTable();
    private StretchyMapBlockPanel previewMap;
    private GlassPaneWrapper controlPanelGlass;
    private MapBlock previewBlock;
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private JComboBox jComboBoxProject = new JComboBox();
    private JTextField jTextFieldName = new JTextField("%");
    private Supplier<List<Well>> chartWellSupplier = null;
    private SwingWorker updatePreviewMapWorker = null;
    boolean paused = false;

    public DialogMapBlockSelect(JFrame parent, boolean modal) {
        this(parent, modal, SbugsSession.getSession().getChartManager(), SbugsSession.getSession().getDB());
    }

    public DialogMapBlockSelect(JFrame parent, boolean modal, ChartManager cm, SBdb sbdb) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.sbdb = sbdb;
        this.cm = cm;
        this.init();
    }

    private void init() {
        this.tableModelBlockTemplates = new TableModelBlockTemplates(this.sbdb);
        this.jTableBlockTemplates.setModel(this.tableModelBlockTemplates);
        this.tableModelBlockTemplates.setupTable(this.jTableBlockTemplates, this.sbdb);
        this.jTableBlockTemplates.setRowSorter(new TableRowSorter<TableModelBlockTemplates>(this.tableModelBlockTemplates));
        new ColumnSortResetHandler(this.jTableBlockTemplates).attach();
        this.jTableBlockTemplates.setSelectionMode(0);
        this.jTableBlockTemplates.setRowSelectionAllowed(true);
        this.jTableBlockTemplates.getSelectionModel().addListSelectionListener(e -> this.onTableSelectionChanged(e));
        this.setDefaultCloseOperation(1);
        this.setTitle("Select map block template");
        this.setLayout(new BorderLayout());
        this.initProjectCombo();
        this.setupPreviewMap();
        JPanel controlPanel = new JPanel(new BorderLayout());
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.setBackground(Color.blue);
        JPanel filterControls = this.buildFilterControlPanel();
        filterPanel.add((Component)filterControls, "Center");
        filterPanel.add((Component)this.buildSearchButtonPanel(), "South");
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)filterPanel, "North");
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.jTableBlockTemplates);
        tablePanel.add((Component)jsp, "Center");
        JPanel buttonPanel = this.buildButtonPanel();
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.8);
        splitPane.setBorder(new EmptyBorder(5, 5, 0, 5));
        splitPane.setLeftComponent(tablePanel);
        splitPane.setRightComponent(this.previewMap);
        controlPanel.add((Component)splitPane, "Center");
        this.controlPanelGlass = new GlassPaneWrapper(controlPanel);
        this.add(this.controlPanelGlass, "Center");
        this.add(buttonPanel, "South");
        this.pack();
        this.setSize(new Dimension(800, 600));
    }

    public void setWellSupplier(Supplier<List<Well>> wellSupplier) {
        this.chartWellSupplier = wellSupplier;
        if (this.previewMap.getMapBlock() != null) {
            this.previewMap.getMapBlock().setChartWellsSupplier(wellSupplier);
        }
    }

    private void initProjectCombo() {
        this.projectModel.addElement("All");
        this.projectModel.addElement("Global");
        ProjectUtils.loadProjectCombo(this.sbdb, this.projectModel, false);
        this.jComboBoxProject.setModel(this.projectModel);
    }

    private JPanel buildFilterControlPanel() {
        JPanel filterControls = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 22;
        c.gridx = 0;
        c.gridy = 0;
        JLabel nameLabel = new JLabel("Name:");
        filterControls.add((Component)nameLabel, c);
        c.weightx = 0.0;
        c.gridx = 1;
        c.gridy = 0;
        filterControls.add(Box.createHorizontalStrut(4), c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 10;
        filterControls.add((Component)this.jTextFieldName, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        filterControls.add(Box.createVerticalStrut(4), c);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 22;
        JLabel projectLabel = new JLabel("Project:");
        filterControls.add((Component)projectLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 10;
        filterControls.add((Component)this.jComboBoxProject, c);
        return filterControls;
    }

    private void onTableSelectionChanged(ListSelectionEvent e) {
        BlockTemplate selectedTemplate;
        if (!e.getValueIsAdjusting() && (selectedTemplate = this.getSelectedTemplate()) != null) {
            this.showPreview(selectedTemplate);
        }
    }

    private void showPreview(final BlockTemplate selectedTemplate) {
        LOGGER.log(Level.CONFIG, "Showing preview for {0}", new Object[]{selectedTemplate});
        final long start = System.currentTimeMillis();
        if (this.updatePreviewMapWorker != null) {
            this.updatePreviewMapWorker.cancel(true);
        }
        final GlassPaneTimer waitTimer = new GlassPaneTimer(this.controlPanelGlass);
        this.jTableBlockTemplates.setEnabled(false);
        this.previewMap.pauseMapUpdates();
        this.updatePreviewMapWorker = new SwingWorker(this){
            final /* synthetic */ DialogMapBlockSelect this$0;
            {
                DialogMapBlockSelect dialogMapBlockSelect = this$0;
                Objects.requireNonNull(dialogMapBlockSelect);
                this.this$0 = dialogMapBlockSelect;
            }

            protected Object doInBackground() throws Exception {
                try {
                    this.this$0.updatePreviewMap(selectedTemplate);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error showing preview of map block template {" + selectedTemplate.getName() + "} (" + selectedTemplate.getID() + ")", e);
                }
                return null;
            }

            @Override
            protected void done() {
                LOGGER.log(Level.CONFIG, "loaded preview in {0}ms", new Object[]{System.currentTimeMillis() - start});
                this.this$0.previewMap.resumeMapUpdates();
                this.this$0.previewMap.repaint();
                this.this$0.jTableBlockTemplates.setEnabled(true);
                waitTimer.hideGlassPane();
            }
        };
        waitTimer.showGlassPaneDelayed();
        this.updatePreviewMapWorker.execute();
    }

    private void updatePreviewMap(BlockTemplate selectedTemplate) throws SQLException, SBException, IOException {
        ChartBlockBase block = ChartFactory.createBlock(this.sbdb, selectedTemplate, null);
        if (block instanceof MapBlock) {
            ((MapBlock)block).setPropLegendOrientation(MapBlockProperties.LegendOrientation.NONE);
            this.previewMap.setMapBlock((MapBlock)block);
            this.previewMap.getMapBlock().clearDataLayers();
            this.previewMap.getMapBlock().disableWellDataPreload();
            Optional<LayerWellLocation> locLayer = this.previewMap.getMapBlock().getLayers().stream().filter(l -> l instanceof LayerWellLocation).map(l -> (LayerWellLocation)l).findFirst();
            if (!locLayer.isPresent()) {
                PanelOcc panelOcc = new PanelOcc(-1);
                LayerWellLocationWithSelection defaultLocLayer = new LayerWellLocationWithSelection(null, panelOcc, this.previewMap.getMapBlock());
                defaultLocLayer.getProperties().setPinColour(Color.red);
                defaultLocLayer.getProperties().setCorrelation(false);
                this.previewMap.getMapBlock().addMember(defaultLocLayer);
            } else {
                locLayer.get().getProperties().setShowCorrelation(false);
            }
            if (this.chartWellSupplier != null) {
                this.previewMap.getMapBlock().setChartWellsSupplier(this.chartWellSupplier);
                ReferencedEnvelope wellEnvelope = WellEnvelopeHelper.getWellEnvelope((Collection<Well>)this.chartWellSupplier.get());
                this.previewMap.getMapBlock().setMapExtent(wellEnvelope);
                this.previewMap.getMapBlock().notifyListeners();
            }
        }
    }

    private void setupPreviewMap() {
        this.previewMap = new StretchyMapBlockPanel();
        this.previewMap.setBackground(Color.white);
        this.previewMap.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.previewBlock = new MapBlock(this.sbdb, null, null);
        this.previewBlock.getProp().setLegendOrientation(MapBlockProperties.LegendOrientation.NONE);
        try {
            this.previewMap.setMapBlock(this.previewBlock);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error setting up layer shape preview", e);
        }
    }

    private JPanel buildSearchButtonPanel() {
        JPanel buttonPanel = new JPanel();
        FlowLayout fl = new FlowLayout(2, 0, 5);
        buttonPanel.setLayout(fl);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> this.onResetPress());
        JButton SearchButton = new JButton("Search");
        SearchButton.addActionListener(e -> this.onSearchPress());
        buttonPanel.add(resetButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(SearchButton);
        return buttonPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        FlowLayout fl = new FlowLayout(2);
        buttonPanel.setLayout(fl);
        JButton okJButton = new JButton("OK");
        okJButton.addActionListener(e -> this.onOKPress());
        JButton cancelJButton = new JButton("Cancel");
        cancelJButton.addActionListener(e -> this.onCancelPress());
        buttonPanel.add(okJButton);
        buttonPanel.add(cancelJButton);
        return buttonPanel;
    }

    public BlockTemplate getSelectedTemplate() {
        if (this.jTableBlockTemplates.getSelectedRowCount() == 0) {
            return null;
        }
        TemplateDescr selected = this.tableModelBlockTemplates.getTemplates().get(this.jTableBlockTemplates.convertRowIndexToModel(this.jTableBlockTemplates.getSelectedRow()));
        if (selected instanceof BlockTemplate) {
            return (BlockTemplate)selected;
        }
        return null;
    }

    private void onOKPress() {
        if (this.jTableBlockTemplates.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a block template", this.getTitle(), 2);
            return;
        }
        this.setIsOK(true);
        this.setVisible(false);
    }

    private void onCancelPress() {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private void onSearchPress() {
        Object pItem = this.jComboBoxProject.getSelectedItem();
        Integer projID = null;
        if (pItem instanceof Project) {
            Project project = (Project)((Object)pItem);
            projID = project.getID();
        } else if (pItem == "Global") {
            projID = 0;
        }
        LinkedList<TemplateDescr> l = new LinkedList<TemplateDescr>();
        try {
            l.addAll(this.cm.searchBlocks(BlockType.MAP, this.jTextFieldName.getText(), projID, null, null, null));
            Collections.sort(l);
            this.tableModelBlockTemplates.setTemplates(l);
            this.tableModelBlockTemplates.fireTableDataChanged();
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError("Error from search", e, (Component)((Object)this));
        }
        this.previewMap.resumeMapUpdates();
    }

    private void onResetPress() {
        this.jTextFieldName.setText("%");
        this.jComboBoxProject.setSelectedItem("All");
    }

    public void setSelectedMapBlock(Integer id) {
    }
}

