/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import jsbchart.core.IZoomManager;
import jsbchart.graphics.SBGraphicsConverter;
import jsbugs.chart.ZoomListener;
import jsbugs.chart.ZoomPanel;

public class ZoomManager
implements IZoomManager {
    private static final Logger LOGGER = Logger.getLogger(ZoomManager.class.getName());
    private static final float ZOOM_MAX = 26.0f;
    private static final float ZOOM_MIN = 0.04f;
    private static final float ZOOM_INCREMENT = 1.25f;
    private final SBGraphicsConverter converter;
    private final ZoomPanel panel;
    private float zoom = 1.0f;
    private List<ZoomListener> zoomListeners = new LinkedList<ZoomListener>();

    public ZoomManager(ZoomPanel panel, double transformationFactor) {
        this.panel = panel;
        this.converter = new SBGraphicsConverter(transformationFactor);
    }

    @Override
    public float getZoom() {
        return this.zoom;
    }

    public void addZoomListener(ZoomListener l) {
        this.zoomListeners.add(l);
    }

    private void notifyZoomListeners() {
        this.zoomListeners.stream().forEach(l -> l.zoomChanged(this.zoom));
    }

    @Override
    public void zoomIn() {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.panel.getComponent());
        if (viewport == null) {
            this.updateZoom(this.zoom * 1.25f);
        } else {
            Rectangle rect = viewport.getViewRect();
            int centreX = rect.x + (int)((double)rect.width / 2.0);
            int centreY = rect.y + (int)((double)rect.height / 2.0);
            this.zoomInAt(centreX, centreY);
        }
        this.notifyZoomListeners();
    }

    @Override
    public void zoomOut() {
        JViewport viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.panel.getComponent());
        if (viewPort == null) {
            this.updateZoom(this.zoom / 1.25f);
        } else {
            Rectangle rect = viewPort.getViewRect();
            int centreX = rect.x + (int)((double)rect.width / 2.0);
            int centreY = rect.y + (int)((double)rect.height / 2.0);
            this.zoomOutAt(centreX, centreY);
        }
    }

    @Override
    public void resetZoom() {
        JViewport viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.panel.getComponent());
        if (viewPort == null) {
            this.updateZoom(1.0f);
            this.notifyZoomListeners();
        } else {
            Rectangle rect = viewPort.getViewRect();
            int centreX = rect.x + (int)((double)rect.width / 2.0);
            int centreY = rect.y + (int)((double)rect.height / 2.0);
            this.zoomAtPoint(1.0f, centreX, centreY);
        }
    }

    @Override
    public void setZoom(float newZoom) {
        this.zoom = newZoom;
        this.converter.setZoom(newZoom);
    }

    private void updateZoom(float newZoom) {
        if (newZoom > 26.0f || newZoom < 0.04f) {
            return;
        }
        this.zoom = newZoom;
        this.converter.setZoom(newZoom);
        this.panel.setSize();
        this.panel.revalidate();
        this.panel.repaint();
    }

    @Override
    public void zoomInAt(int x, int y) {
        float newZoom = this.zoom * 1.25f;
        this.zoomAtPoint(newZoom, x, y);
    }

    @Override
    public void zoomOutAt(int x, int y) {
        float newZoom = this.zoom / 1.25f;
        this.zoomAtPoint(newZoom, x, y);
    }

    private void zoomAtPoint(float newZoom, int x, int y) {
        if (newZoom > 26.0f || newZoom < 0.04f) {
            return;
        }
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.panel.getComponent());
        if (viewport == null) {
            this.updateZoom(newZoom);
        } else {
            float xmm = (float)x / (2.8346457f * this.zoom);
            float ymm = (float)y / (2.8346457f * this.zoom);
            Rectangle r = viewport.getViewRect();
            int dx = x - r.x;
            int dy = y - r.y;
            this.zoom = newZoom;
            this.converter.setZoom(this.zoom);
            this.panel.setSize();
            viewport.setViewSize(this.panel.getPreferredSize());
            int newX = (int)(xmm * 2.8346457f * this.zoom);
            int newY = (int)(ymm * 2.8346457f * this.zoom);
            int posX = newX - dx;
            int posY = newY - dy;
            if (posX < 0) {
                posX = 0;
            }
            if (posY < 0) {
                posY = 0;
            }
            viewport.setViewPosition(new Point(posX, posY));
            this.panel.revalidate();
            this.panel.repaint();
        }
        this.notifyZoomListeners();
    }

    public void zoomToRect(Rectangle2D.Float rect) {
        if (rect.getWidth() < 2.0 && rect.getHeight() < 2.0) {
            return;
        }
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.panel.getComponent());
        if (viewport != null) {
            Dimension s = viewport.getSize();
            float idealWzoom = (float)s.width / (rect.width * 2.8346457f);
            float idealHzoom = (float)s.height / (rect.height * 2.8346457f);
            for (float newZoom = this.zoom; newZoom < 26.0f && newZoom < idealWzoom && newZoom < idealHzoom; newZoom *= 1.25f) {
            }
            this.zoom = newZoom /= 1.25f;
            this.panel.setSize();
            viewport.setViewSize(this.panel.getPreferredSize());
            int newX = (int)(rect.getCenterX() * 2.8346457481384277 * (double)this.zoom);
            int newY = (int)(rect.getCenterY() * 2.8346457481384277 * (double)this.zoom);
            int posX = newX - (int)((double)viewport.getWidth() * 0.5);
            int posY = newY - (int)((double)viewport.getHeight() * 0.5);
            viewport.setViewPosition(new Point(posX, posY));
            this.panel.revalidate();
            this.panel.repaint();
            this.notifyZoomListeners();
        }
    }

    public void fitToScreen(Dimension screenSize, float chartWidth, float chartHeight) {
        float newZoom = 26.0f;
        int width = (int)(chartWidth * 2.8346457f * newZoom);
        int height = (int)(chartHeight * 2.8346457f * newZoom);
        while (newZoom >= 0.04f && (width >= screenSize.width || height >= screenSize.height)) {
            width = (int)(chartWidth * 2.8346457f * (newZoom /= 1.25f));
            height = (int)(chartHeight * 2.8346457f * newZoom);
        }
        this.updateZoom(newZoom);
        this.notifyZoomListeners();
    }

    @Override
    public float scalePixels(int pixels) {
        return this.converter.convertUnscaledPixelsToFloat(pixels);
    }

    public double getAffineTransformFactor() {
        return this.converter.getTransformFactor();
    }
}

