/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Timer;
import jsbugs.ChartJPanel;
import jsbugs.JScrollPaneChart;
import jsbugs.chart.component.JScrollPaneChartBase;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.positioners.LeftBelowPositioner;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.EdgedBalloonStyle;

public final class ChartToolTipUtils {
    private ChartToolTipUtils() {
    }

    public static BalloonTip initChartToolTip(JScrollPaneChartBase scrollPaneToMagnify) {
        ChartJPanel mag = new ChartJPanel(scrollPaneToMagnify.getChart());
        JScrollPaneChartBase magPane = new JScrollPaneChartBase(mag);
        magPane.setHorizontalScrollBarPolicy(31);
        magPane.setVerticalScrollBarPolicy(21);
        magPane.setPreferredSize(new Dimension(300, 300));
        magPane.zoom(true);
        magPane.zoom(true);
        magPane.refreshView();
        BalloonTip bT = new BalloonTip((JComponent)scrollPaneToMagnify, (JComponent)magPane, (BalloonTipStyle)new EdgedBalloonStyle(Color.WHITE, Color.BLACK), (BalloonTipPositioner)new ChartTipPositioner(), null);
        bT.setVisible(false);
        ToolTipController tTC = new ToolTipController(bT);
        scrollPaneToMagnify.addJPanelMouseListener(tTC);
        scrollPaneToMagnify.addJPanelMouseMotionListener(tTC);
        return bT;
    }

    public static void removeListeners(JComponent component) {
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (!(mouseListener instanceof ToolTipController)) continue;
            component.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : component.getMouseMotionListeners()) {
            if (!(eventListener instanceof ToolTipController)) continue;
            component.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    private static class ChartTipPositioner
    extends LeftBelowPositioner {
        final Point point = new Point(0, 0);

        ChartTipPositioner() {
            super(0, 0);
        }

        protected void determineLocation(Rectangle attached) {
            int balloonWidth = this.balloonTip.getPreferredSize().width;
            int balloonHeight = this.balloonTip.getPreferredSize().height;
            this.flipX = false;
            this.flipY = true;
            this.hOffset = this.preferredHorizontalOffset;
            this.x = attached.x + this.point.x;
            this.y = attached.y + this.point.y;
            if (this.orientationCorrection) {
                if (this.y + balloonHeight > this.balloonTip.getTopLevelContainer().getHeight()) {
                    this.flipY = false;
                    this.y = this.balloonTip.getTopLevelContainer().getHeight() - balloonHeight;
                }
                if (this.x < 0) {
                    this.flipX = true;
                    this.x = attached.x + attached.width - balloonWidth;
                    this.hOffset = balloonWidth - this.hOffset;
                }
            }
            if (this.offsetCorrection) {
                this.applyOffsetCorrection();
            }
        }
    }

    private static class ToolTipController
    extends MouseAdapter
    implements MouseMotionListener {
        private final BalloonTip balloonTip;
        private final Timer sinceLastDrawTimer;
        boolean doRedraw = true;

        public ToolTipController(final BalloonTip balloonTip) {
            this.balloonTip = balloonTip;
            this.sinceLastDrawTimer = new Timer(1000, new ActionListener(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JScrollPaneChartBase)balloonTip.getContents()).setShowCentre(false);
                    balloonTip.repaint();
                }
            });
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.balloonTip.setVisible(true);
            this.sinceLastDrawTimer.start();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.doRedraw) {
                JViewport viewport;
                JScrollPaneChartBase scrollPane = (JScrollPaneChartBase)this.balloonTip.getAttachedComponent();
                if (!scrollPane.pointIsInChart(e.getPoint())) {
                    this.balloonTip.setVisible(false);
                    return;
                }
                this.balloonTip.setVisible(true);
                ((JScrollPaneChartBase)this.balloonTip.getContents()).setShowCentre(true);
                ChartTipPositioner tipPositioner = (ChartTipPositioner)this.balloonTip.getPositioner();
                if (e.getComponent() == scrollPane.view) {
                    viewport = scrollPane.getViewport();
                } else if (scrollPane.getRowHeader() != null && e.getComponent() == scrollPane.getRowHeader().getView()) {
                    viewport = scrollPane.getRowHeader();
                } else if (scrollPane.getColumnHeader() != null && e.getComponent() == scrollPane.getColumnHeader().getView()) {
                    viewport = scrollPane.getColumnHeader();
                } else {
                    return;
                }
                tipPositioner.point.x = e.getX() - viewport.getViewPosition().x + 12;
                tipPositioner.point.y = e.getY() - viewport.getViewPosition().y + 12;
                if (scrollPane instanceof JScrollPaneChart) {
                    JScrollPaneChart scrollPaneChart = (JScrollPaneChart)scrollPane;
                    if (scrollPaneChart.hasRowHeader() && e.getComponent() != scrollPane.getRowHeader().getView()) {
                        tipPositioner.point.x += scrollPane.getRowHeader().getWidth();
                    }
                    if (scrollPaneChart.hasHeader() && e.getComponent() != scrollPane.getColumnHeader().getView()) {
                        tipPositioner.point.y += scrollPane.getColumnHeader().getHeight();
                    }
                }
                this.balloonTip.refreshLocation();
                this.sinceLastDrawTimer.restart();
                JScrollPaneChartBase tipPane = (JScrollPaneChartBase)this.balloonTip.getContents();
                int xpos = (int)((float)e.getX() / scrollPane.getZoom() * tipPane.getZoom());
                int ypos = (int)((float)e.getY() / scrollPane.getZoom() * tipPane.getZoom());
                if (scrollPane instanceof JScrollPaneChart) {
                    JScrollPaneChart scrollPaneChart = (JScrollPaneChart)scrollPane;
                    if (scrollPaneChart.hasHeader() && e.getComponent() != scrollPane.getColumnHeader().getView()) {
                        float mmHeight = scrollPane.getChart().getHeaderHeight();
                        float pixHeight = mmHeight * 2.8346457f * tipPane.getZoom();
                        ypos = (int)((float)ypos + pixHeight);
                    }
                    if (scrollPaneChart.hasRowHeader() && e.getComponent() != scrollPane.getRowHeader().getView()) {
                        float mmWidth = scrollPane.getChart().getRowHeaderWidth();
                        float pixWidth = mmWidth * 2.8346457f * tipPane.getZoom();
                        xpos = (int)((float)xpos + pixWidth);
                    }
                }
                tipPane.centreViewOnPoint(xpos, ypos);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.balloonTip.setVisible(false);
            this.sinceLastDrawTimer.stop();
        }
    }
}

