/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.mouse;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jsbchart.block.MapBlock;
import jsbugs.ChartJPanel;
import jsbugs.chart.KeyboardStatusMonitor;
import jsbugs.chart.mouse.MouseBehaviourAdapter;
import util.MoveableRect;
import util.SB;

public class MapBlockMoveResizeBehaviour
extends MouseBehaviourAdapter {
    private MapBlock target;
    private int actionCursor = 0;
    private Point2D.Float origin;
    private Rectangle2D.Float initialBlockBounds;
    private final KeyboardStatusMonitor keyboardStatusMonitor;

    public MapBlockMoveResizeBehaviour(ChartJPanel panel, KeyboardStatusMonitor keyboardStatusMonitor) {
        super(panel);
        this.keyboardStatusMonitor = keyboardStatusMonitor;
    }

    @Override
    public boolean isActiveForSelection(Object selection) {
        return selection instanceof MapBlock;
    }

    @Override
    public boolean activeAt(Point p) {
        MapBlock b = this.getSelectedMapBlock();
        if (b == null) {
            return false;
        }
        Point2D.Float mmPoint = this.panel.getPoint(p);
        Object o = this.panel.chart.getTagOrBlock(mmPoint);
        return o == b && !this.keyboardStatusMonitor.isAltPressed();
    }

    @Override
    public boolean isCurrent() {
        return this.target != null;
    }

    @Override
    public Cursor getCursor(Point p) {
        Integer style = this.getCursorStyle(p);
        if (style != null && style > 0) {
            return new Cursor(style);
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.target = this.getSelectedMapBlock();
        Integer cursorStyle = this.getCursorStyle(e.getPoint());
        if (cursorStyle != null) {
            this.actionCursor = cursorStyle;
        }
        this.origin = this.panel.getPoint(e.getPoint());
        if (this.target != null) {
            this.initialBlockBounds = this.panel.chart.getBlockBounds(this.target);
            this.target.panOrResizeMapStart(this.origin);
        }
        this.panel.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        boolean needToNotify = true;
        if (this.target != null) {
            switch (this.actionCursor) {
                case 11: {
                    this.resizeTargetE(p);
                    break;
                }
                case 10: {
                    this.resizeTargetW(p);
                    break;
                }
                case 9: {
                    this.resizeTargetS(p);
                    break;
                }
                case 8: {
                    this.resizeTargetN(p);
                    break;
                }
                case 7: {
                    this.resizeTargetN(p);
                    this.resizeTargetE(p);
                    break;
                }
                case 6: {
                    this.resizeTargetN(p);
                    this.resizeTargetW(p);
                    break;
                }
                case 5: {
                    this.resizeTargetS(p);
                    this.resizeTargetE(p);
                    break;
                }
                case 4: {
                    this.resizeTargetS(p);
                    this.resizeTargetW(p);
                    break;
                }
                case 13: {
                    this.target.panMap(this.origin, p);
                    this.origin = p;
                    needToNotify = false;
                    break;
                }
            }
            if (needToNotify) {
                this.target.notifyListeners();
            }
            this.panel.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.target != null) {
            this.target.panOrResizeMapEnd();
        }
        this.target = null;
        this.origin = null;
        this.initialBlockBounds = null;
        this.notifyChartChange();
        this.panel.repaint();
    }

    private MapBlock getSelectedMapBlock() {
        return this.panel.chart.getSelectedBlock().filter(b -> b instanceof MapBlock).map(b -> (MapBlock)b).orElse(null);
    }

    private void resizeTargetN(Point2D.Float p) {
        float newH = this.initialBlockBounds.height + (this.origin.y - p.y);
        long roundedH = this.getRoundedDimension(newH);
        this.target.setPropDimension(false, roundedH);
    }

    private void resizeTargetS(Point2D.Float p) {
        float newH = this.initialBlockBounds.height + (p.y - this.origin.y);
        long roundedH = this.getRoundedDimension(newH);
        this.target.setPropDimension(false, roundedH);
    }

    private void resizeTargetE(Point2D.Float p) {
        float newW = this.initialBlockBounds.width + (p.x - this.origin.x);
        long roundedW = this.getRoundedDimension(newW);
        this.target.setPropDimension(true, roundedW);
    }

    private void resizeTargetW(Point2D.Float p) {
        float newW = this.initialBlockBounds.width + (this.origin.x - p.x);
        long roundedW = this.getRoundedDimension(newW);
        this.target.setPropDimension(true, roundedW);
    }

    private long getRoundedDimension(float newD) {
        if (newD < 20.0f) {
            newD = 20.0f;
        }
        return Math.round(newD);
    }

    private double getRoundedMapExtent(double d) {
        return SB.round((double)d, (int)4);
    }

    private Integer getCursorStyle(Point p) {
        Point2D.Float mmPoint = this.panel.getPoint(p);
        MapBlock b = this.getSelectedMapBlock();
        if (b == null) {
            return null;
        }
        MoveableRect r = new MoveableRect(this.panel.chart.getBlockBounds(b));
        return r.getCursorStyle(mmPoint);
    }

    private float getZoom() {
        return this.panel.getZoom();
    }

    private Rectangle2D.Float getBounds() {
        return new Rectangle2D.Float(0.0f, 0.0f, this.getContainerWidth(), this.getContainerHeight());
    }

    private float getContainerHeight() {
        return (float)this.panel.getHeight() / (this.getZoom() * 2.8346457f);
    }

    private float getContainerWidth() {
        return (float)this.panel.getWidth() / (this.getZoom() * 2.8346457f);
    }
}

