/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.mouse;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import java.util.logging.Logger;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbugs.ChartJPanel;
import jsbugs.chart.KeyboardStatusMonitor;
import jsbugs.chart.mouse.MouseBehaviourAdapter;
import jsbugs.uiutil.CursorFactory;

public class MapBlockZoomBehaviour
extends MouseBehaviourAdapter
implements MouseWheelListener {
    private static final Logger LOGGER = Logger.getLogger(MapBlockZoomBehaviour.class.getName());
    private final KeyboardStatusMonitor keyboardStatusMonitor;
    private final Cursor mapZoomCursor;
    private Point2D.Float origin;

    public MapBlockZoomBehaviour(ChartJPanel panel, KeyboardStatusMonitor keyboardStatusMonitor) {
        super(panel);
        this.keyboardStatusMonitor = keyboardStatusMonitor;
        this.mapZoomCursor = CursorFactory.getZoomCursor();
    }

    @Override
    public boolean isActiveForSelection(Object selection) {
        return selection != null && selection instanceof MapBlock;
    }

    @Override
    public Cursor getCursor(Point p) {
        return this.mapZoomCursor;
    }

    @Override
    public boolean activeAt(Point p) {
        Point2D.Float point = this.panel.getPoint(p);
        Optional<MapBlock> map = this.getOverlappingSelectedMap(point);
        return map.isPresent() && !this.keyboardStatusMonitor.isAltPressed() && this.keyboardStatusMonitor.isCtrlPressed() && !this.keyboardStatusMonitor.isShiftPressed();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        Optional<MapBlock> map = this.getOverlappingSelectedMap(p);
        if (map.isPresent()) {
            if (e.getButton() > 1) {
                map.get().zoomInAt(p, this.panel.chart.getBlockBounds(map.get()));
            } else {
                map.get().zoomOutAt(p, this.panel.chart.getBlockBounds(map.get()));
            }
            this.notifyChartChange();
            this.panel.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        Optional<MapBlock> map = this.getOverlappingSelectedMap(p);
        if (map.isPresent()) {
            if (e.getWheelRotation() > 0) {
                map.get().zoomInAt(p, this.panel.chart.getBlockBounds(map.get()));
            } else if (e.getWheelRotation() < 0) {
                map.get().zoomOutAt(p, this.panel.chart.getBlockBounds(map.get()));
            }
            this.notifyChartChange();
            this.panel.repaint();
        }
    }

    private Optional<MapBlock> getOverlappingSelectedMap(Point2D.Float point) {
        return this.panel.chart.getSelectedBlock().filter(b -> b instanceof MapBlock).filter(b -> {
            Rectangle2D.Float blockBounds = this.panel.chart.getBlockBounds((ChartBlockBase)b);
            return blockBounds != null && blockBounds.contains(point);
        }).map(b -> (MapBlock)b);
    }
}

