/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import jsbchart.block.MapBlock;
import jsbchart.graphics.map.CrsCode;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.ComboRenderer;
import jsbugs.table.EnumEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowCRS
extends LinkedBlockPropertyRow {
    public BlockPropertyRowCRS(LinkRenderer titleRenderer, LinkEditor linkEditor, ComboRenderer valueRenderer, EnumEditor valueEditor) {
        super(titleRenderer, linkEditor, valueRenderer, valueEditor);
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.crsEqual();
        }
        return newLink;
    }

    private boolean crsEqual() {
        return this.blocksOfType().map(b -> (MapBlock)b).allMatch(b -> b.getProp().getCrsCode() == ((MapBlock)this.block).getProp().getCrsCode());
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        CrsCode crsCode = (CrsCode)((Object)value);
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (MapBlock)b).forEach(b -> b.setPropCrs(crsCode));
            return;
        }
        ((MapBlock)this.block).setPropCrs(crsCode);
    }

    @Override
    String getTitle() {
        return "Projection";
    }

    @Override
    Object getValue() {
        return ((MapBlock)this.block).getProp().getCrsCode();
    }
}

