/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;

class BlockPropertyRowDataRangeExclude
extends LinkedBlockPropertyRow {
    BlockPropertyRowDataRangeExclude(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer renderer, CheckBoxEditor valueEditor) {
        super(titleRenderer, linkEditor, renderer, valueEditor);
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.valueEqual();
        }
        return newLink;
    }

    private boolean valueEqual() {
        return this.blocksOfType().map(b -> (MapBlock)b).allMatch(b -> b.getProp().isExcludeWellsOutsideDataRange() == ((MapBlock)this.block).getProp().isExcludeWellsOutsideDataRange());
    }

    @Override
    String getTitle() {
        return "Filter wells";
    }

    @Override
    String getToolTip() {
        return "Exclude wells outside data range";
    }

    @Override
    Object getValue() {
        return ((MapBlock)this.block).getProp().isExcludeWellsOutsideDataRange();
    }

    @Override
    void setValue(Object value, SBdb sbdb) {
        boolean boolVal = (Boolean)value;
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (MapBlock)b).forEach(b -> b.setPropDataRangeExclude(boolVal));
            return;
        }
        ((MapBlock)this.block).setPropDataRangeExclude(boolVal);
    }
}

