/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;

class BlockPropertyRowDeriveChronoAge
extends LinkedBlockPropertyRow {
    BlockPropertyRowDeriveChronoAge(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer renderer, CheckBoxEditor valueEditor) {
        super(titleRenderer, linkEditor, renderer, valueEditor);
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.valueEqual();
        }
        return newLink;
    }

    private boolean valueEqual() {
        return this.blocksOfType().map(b -> (MapBlock)b).allMatch(b -> b.getProp().isDeriveChronoAge() == ((MapBlock)this.block).getProp().isDeriveChronoAge());
    }

    @Override
    String getTitle() {
        return "Derive depth/age curve";
    }

    @Override
    String getToolTip() {
        return "Attempt to derive missing depth/age curves from chronostratigraphy (not stored in database)";
    }

    @Override
    Object getValue() {
        return ((MapBlock)this.block).getProp().isDeriveChronoAge();
    }

    @Override
    void setValue(Object value, SBdb sbdb) {
        boolean boolVal = (Boolean)value;
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (MapBlock)b).forEach(b -> b.setDeriveChronoAge(boolVal));
            return;
        }
        ((MapBlock)this.block).setDeriveChronoAge(boolVal);
    }
}

