/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.FloatEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowMapBounds
extends LinkedBlockPropertyRow {
    private final int boundsIndex;

    BlockPropertyRowMapBounds(int boundsIndex, LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer valueRenderer, FloatEditor valueEditor) {
        super(titleRenderer, linkEditor, valueRenderer, valueEditor);
        if (boundsIndex < 0 || boundsIndex > 3) {
            throw new IllegalArgumentException("Illegal bounds index: " + boundsIndex);
        }
        this.boundsIndex = boundsIndex;
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.extentEqual();
        }
        return newLink;
    }

    private boolean extentEqual() {
        return this.blocksOfType().map(b -> (MapBlock)b).allMatch(b -> b.getProp().getMapExtent(this.boundsIndex) == ((MapBlock)this.block).getProp().getMapExtent(this.boundsIndex));
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        Double d = Double.parseDouble(value.toString());
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (MapBlock)b).forEach(b -> {
                b.setPropMapExtent(this.boundsIndex, d);
                b.notifyListeners();
            });
            return;
        }
        MapBlock mb = (MapBlock)this.block;
        mb.setPropMapExtent(this.boundsIndex, d);
        mb.notifyListeners();
    }

    @Override
    String getTitle() {
        switch (this.boundsIndex) {
            case 0: {
                return "Min longitude";
            }
            case 1: {
                return "Max longitude";
            }
            case 2: {
                return "Min Latitude";
            }
        }
        return "Max Latitude";
    }

    @Override
    Object getValue() {
        return ((MapBlock)this.block).getProp().getMapExtent(this.boundsIndex);
    }
}

