/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.FloatEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowMapDimension
extends LinkedBlockPropertyRow {
    private final boolean isWidth;

    static BlockPropertyRowMapDimension widthRow(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer valueRenderer, FloatEditor valueEditor) {
        return new BlockPropertyRowMapDimension(true, titleRenderer, linkEditor, valueRenderer, valueEditor);
    }

    static BlockPropertyRowMapDimension heightRow(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer valueRenderer, FloatEditor valueEditor) {
        return new BlockPropertyRowMapDimension(false, titleRenderer, linkEditor, valueRenderer, valueEditor);
    }

    private BlockPropertyRowMapDimension(boolean width, LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer valueRenderer, FloatEditor valueEditor) {
        super(titleRenderer, linkEditor, valueRenderer, valueEditor);
        this.isWidth = width;
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.dimensionEqual();
        }
        return newLink;
    }

    private boolean dimensionEqual() {
        return this.blocksOfType().map(b -> (MapBlock)b).allMatch(b -> b.getProp().getDimension(this.isWidth) == ((MapBlock)this.block).getProp().getDimension(this.isWidth));
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        Float f = Float.valueOf(Float.parseFloat(value.toString()));
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (MapBlock)b).forEach(b -> {
                b.setPropDimension(this.isWidth, f.floatValue());
                b.notifyListeners();
            });
            return;
        }
        MapBlock mb = (MapBlock)this.block;
        mb.setPropDimension(this.isWidth, f.floatValue());
        mb.notifyListeners();
    }

    @Override
    String getTitle() {
        return this.isWidth ? "Width" : "Height";
    }

    @Override
    Object getValue() {
        return Float.valueOf(((MapBlock)this.block).getProp().getDimension(this.isWidth));
    }
}

