/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import jsbugs.table.ScaleEditor;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowScale
extends LinkedBlockPropertyRow {
    private final ScaleEditor valueEditor;
    private final SBdb sbdb;

    public BlockPropertyRowScale(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer ComboRenderer2, ScaleEditor valueEditor, SBdb sbdb) {
        super(titleRenderer, linkEditor, ComboRenderer2, valueEditor);
        this.valueEditor = valueEditor;
        this.sbdb = sbdb;
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.scaleEqual();
        }
        return newLink;
    }

    private boolean scaleEqual() {
        BlockProperties thisBp = ((ChartBlock)this.block).getProp();
        return this.blocksOfType().map(b -> (ChartBlock)b).allMatch(b -> Math.abs(b.getProp().getScale(b.getProp().getLongestSection()) - thisBp.getScale(thisBp.getLongestSection())) < 1.0f);
    }

    @Override
    String getTitle() {
        return "   Scale";
    }

    @Override
    Object getValue() {
        return Float.valueOf(((ChartBlock)this.block).getProp().getScale());
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        float scale = ((Float)value).floatValue();
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (ChartBlock)b).forEachOrdered(b -> b.setScale(scale, b.getProp().getLongestSection()));
            return;
        }
        BlockProperties thisBp = ((ChartBlock)this.block).getProp();
        ((ChartBlock)this.block).setScale(scale, thisBp.getLongestSection());
    }

    @Override
    TableCellEditor getCellEditor(int column) {
        if (column == 1) {
            BlockProperties bp = ((ChartBlock)this.block).getProp();
            try {
                this.valueEditor.setScale(bp.getScale(bp.getLongestSection()), this.sbdb, bp.getScaleType());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return super.getCellEditor(column);
    }
}

