/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockTypeHelper;
import jsbchart.block.ChartBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.EnumEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowScaleType
extends LinkedBlockPropertyRow {
    private final ActionListener warningAction;

    public BlockPropertyRowScaleType(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer ComboRenderer2, EnumEditor valueEditor, ActionListener warningAction) {
        super(titleRenderer, linkEditor, ComboRenderer2, valueEditor);
        this.warningAction = warningAction;
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && BlockTypeHelper.canLinkScaleType(this.block.getBlockType()) && this.blocksOfType().count() > 1L) {
            newLink = this.scaleTypeEqual();
        }
        return newLink;
    }

    private boolean scaleTypeEqual() {
        return this.blocksOfType().allMatch(b -> b.getProp().getScaleType() == this.block.getProp().getScaleType());
    }

    @Override
    String getTitle() {
        return "Scale type";
    }

    @Override
    Object getValue() {
        return this.block.getProp().getScaleType();
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        BlockProperties.ScaleType scaleType = (BlockProperties.ScaleType)((Object)value);
        if (this.warningAction != null) {
            this.warningAction.actionPerformed(new ActionEvent(this, 0, scaleType.name()));
        }
        if (this.chart != null && this.isLinked()) {
            if (scaleType == BlockProperties.ScaleType.AGE) {
                this.chart.loadLOCForBlocks(this.block.getBlockType());
            }
            this.blocksOfType().map(b -> (ChartBlock)b).forEachOrdered(b -> b.setScaleType(scaleType));
            return;
        }
        this.block.setScaleType(scaleType);
    }
}

