/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelType;
import jsbugs.FrameOrganiser;
import jsbugs.chart.properties.PanelPropertiesTableModel;
import jsbugs.chart.properties.PanelPropertiesTableModelBase;
import jsbugs.chart.properties.PropertiesTable;
import jsbugs.chart.properties.taxon.PanelTaxonPropertiesPanel;
import model3.SBdb;

public class DialogPanelProperties
extends JDialog {
    private final PanelTemplate templ;
    private final PanelPropertiesTableModel model;
    private final PropertiesTable table;
    private JButton jButtonCancelClose;
    private JButton jButtonOK;
    private JPanel jPanel1;

    public DialogPanelProperties(JFrame parent, boolean modal, SBdb sbdb, PanelTemplate templ, ChartPanel panel) {
        super((Frame)parent, modal);
        this.templ = templ;
        this.initComponents();
        this.model = new PanelPropertiesTableModel(parent, sbdb);
        this.model.setTemplate(templ, panel);
        if (templ != null && templ.isTaxonPanelTemplate() || panel != null && PanelType.isTaxonPanel(panel.getProperties().getPanelType())) {
            final PanelTaxonPropertiesPanel panelTaxonPropertiesPanel = new PanelTaxonPropertiesPanel(parent, sbdb);
            if (templ != null) {
                panelTaxonPropertiesPanel.setModelTemplate(this.model, templ);
                if (!templ.isEditing()) {
                    this.jButtonCancelClose.addActionListener(new ActionListener(){
                        final /* synthetic */ DialogPanelProperties this$0;
                        {
                            DialogPanelProperties dialogPanelProperties = this$0;
                            Objects.requireNonNull(dialogPanelProperties);
                            this.this$0 = dialogPanelProperties;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (this.this$0.templ.isEditing()) {
                                panelTaxonPropertiesPanel.restoreProperties();
                            }
                        }
                    });
                }
            } else {
                panelTaxonPropertiesPanel.setPanel(this.model, (PanelTaxonGroup)panel);
            }
            this.table = panelTaxonPropertiesPanel.getTable();
            this.jPanel1.add((Component)panelTaxonPropertiesPanel, "Center");
            panelTaxonPropertiesPanel.update();
        } else {
            this.table = new PropertiesTable();
            this.table.setModel(this.model);
            JScrollPane jScrollPane1 = new JScrollPane();
            jScrollPane1.setViewportView(this.table);
            this.jPanel1.add((Component)jScrollPane1, "Center");
        }
        if (panel != null || parent instanceof FrameOrganiser) {
            this.jButtonOK.setVisible(false);
            this.jButtonCancelClose.setText("Close");
        }
        this.init((String)(templ != null ? "Properties : " + templ.getName() : (panel != null ? panel.toString() : "Local Panel Properties")));
    }

    public DialogPanelProperties(JDialog parent, SBdb sbdb, List<PanelTemplate> panels) {
        super((Dialog)parent, true);
        this.initComponents();
        this.table = new PropertiesTable();
        this.table.setModel(new PanelPropertiesTableModelBase(sbdb, panels));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportView(this.table);
        this.jPanel1.add((Component)jScrollPane1, "Center");
        this.jButtonOK.setVisible(false);
        this.jButtonCancelClose.setText("Close");
        this.templ = null;
        this.model = null;
        this.init("Panel Properties Comparison");
    }

    private void init(String title) {
        this.setTitle(title);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jButtonCancelClose = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(200, 200));
        this.jButtonCancelClose.setText("Cancel");
        this.jButtonCancelClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelProperties this$0;
            {
                DialogPanelProperties dialogPanelProperties = this$0;
                Objects.requireNonNull(dialogPanelProperties);
                this.this$0 = dialogPanelProperties;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelCloseActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelProperties this$0;
            {
                DialogPanelProperties dialogPanelProperties = this$0;
                Objects.requireNonNull(dialogPanelProperties);
                this.this$0 = dialogPanelProperties;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setPreferredSize(new Dimension(260, 380));
        this.jPanel1.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancelClose))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancelClose, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 382, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancelClose).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelCloseActionPerformed(ActionEvent evt) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (this.jPanel1.getComponent(0) instanceof PanelTaxonPropertiesPanel) {
            ((PanelTaxonPropertiesPanel)this.jPanel1.getComponent(0)).stopCellEditing();
        }
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
            this.getToolkit().beep();
            return;
        }
        if (this.jPanel1.getComponent(0) instanceof PanelTaxonPropertiesPanel) {
            ((PanelTaxonPropertiesPanel)this.jPanel1.getComponent(0)).stopCellEditing();
        }
        if (this.model != null && this.templ != null && this.templ.isEditing()) {
            this.model.saveTemplate();
        }
        this.dispose();
    }
}

